<?php
class AdminSigepPro5EnviosController extends ModuleAdminController
{
	public function __construct() {
        $this->bootstrap = true;
		parent::__construct();
	}
	
	public function initPageHeaderToolbar(){
        parent::initPageHeaderToolbar();
		if (empty($this->display)) {
			$this->page_header_toolbar_btn['sigep_add_pacote'] = array(
				'class' => 'fix_icons',
                'href' => 'javascript:sigep_add_pacote()',
                'desc' => $this->l('Criar Envio Avulso', null, null, false),
                'icon' => 'fa fa-plus'
            );
			$this->page_header_toolbar_btn['sigep_criar_envios'] = array(
				'class' => 'fix_icons',
                'href' => 'javascript:sigep_criar_objetos()',
                'desc' => $this->l('Criar Objetos', null, null, false),
                'icon' => 'fa fa-check'
            );
			$this->page_header_toolbar_btn['sigep_fechar_plps'] = array(
				'class' => 'fix_icons',
                'href' => 'javascript:sigep_fechar_plps()',
                'desc' => $this->l('Fechar PLP', null, null, false),
                'icon' => 'fa fa-cubes'
            );
			$this->page_header_toolbar_btn['sigep_status_conta'] = array(
				'class' => 'fix_icons',
                'href' => 'javascript:sigep_status_conta()',
                'desc' => $this->l('Status Sigep', null, null, false),
                'icon' => 'fa fa-globe'
            );
        }
    }
	
	public function createTemplate($tpl_name){
        if (file_exists($this->getTemplatePath() . $tpl_name) && $this->viewAccess())
                return $this->context->smarty->createTemplate($this->getTemplatePath() . $tpl_name, $this->context->smarty);
            return parent::createTemplate($tpl_name);
    }
	
	public function initContent() {
        parent::initContent();
		$acao = isset($_REQUEST['acao'])?$_REQUEST['acao']:'pedidos_pendentes';
		if($acao=='atualizar_servicos'){
			return $this->atualizar_servicos();
		}elseif($acao=='pedidos_pendentes'){
			return $this->pedidos_pendentes();
		}elseif($acao=='editar_envios'){
			return $this->editar_envios();
		}elseif($acao=='salvar_editar_pacote'){
			return $this->salvar_editar_pacote();
		}elseif($acao=='remover_envio'){
			return $this->remover_envio();
		}elseif($acao=='adicionar_envios'){
			return $this->adicionar_envios();
		}elseif($acao=='frete_rapido'){
			return $this->frete_rapido();
		}elseif($acao=='salvar_dados_pacote'){
			return $this->salvar_dados_pacote();
		}elseif($acao=='criar_objetos'){
			return $this->criar_objetos();
		}elseif($acao=='fechar_plps'){
			return $this->fechar_plps();
		}elseif($acao=='criar_pedido_loja'){
			return $this->criar_pedido_loja();
		}
    }

	private function criar_pedido_loja(){
		if(isset($_GET['pedido'])){
			$this->module->hookActionOrderStatusUpdate(array('id_order'=>(int)$_GET['pedido'],'forcar_criar'=>true));
		}
		Tools::redirectAdmin($this->context->link->getAdminLink('AdminSigepPro5Envios', true));
		exit;
	}
	
	private function fechar_plps(){
		if(!isset($_GET['envios'])){
			exit;
		}
		$json = array();
		$plps = $this->module->array_plps();
		$phpSigep = new PhpSigep\Services\SoapClient\Real();
		try { 
			//resultado 
			$result = $phpSigep->fechaPlpVariosServicos($plps);
			//fecha a plp de varios serviços
			if (!$result->hasError()) {
				
				//id plp 
				$id_plp_correios = $result->getResult()->getIdPlp();
				$xml             = $result->getResult()->getXMLPlp();
				
				//log 
				$this->module->salvar_log('PLP '.$id_plp_correios.' criada com sucesso!');
				
				//cria a lista de plps fechadas
				$sql = "INSERT INTO `" . _DB_PREFIX_ . "sigep5_plps` (`id_plp`, `uniq_id_plp`, `ids_pacotes`, `data_fechamento`, `status_plp`, `xml`) VALUES (NULL, '".$id_plp_correios."', '".pSQL($_GET['envios'])."', NOW(), 'Pendente', '".pSQL($xml)."');";
				Db::getInstance()->execute( $sql );
				
				//atualiza os envios para fechados
				$envios = explode(',',$_GET['envios']);
				foreach($envios AS $envio){
					
					//atualiza a plp no banco de dados
					Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "sigep5_pacotes` SET pacote_fechado = 1, id_plp = '".$id_plp_correios."' WHERE id_pacote = '".(int)$envio."'");

					//cria um historico no pedido e o atualiza
					$dados_pacote = $this->module->dados_pacote((int)$envio);
					
					//se atrelado a um pedido valido 
					if($dados_pacote['id_pedido_pacote'] > 0){
						$order = new Order($dados_pacote['id_pedido_pacote']);
						if($order){
							//status a fechar plps 
							$status_fechar = (int)Configuration::get('SIGEPPRO5_STATUS_FECHAR');
							if($status_fechar > 0){
								//variaveis a enviar no email 
								$vars_email = array();
								$vars_email['{link_rastreamento}'] = Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/sigeppro5/sro.php?objeto='.$dados_pacote['cod_rastreio_pacote_dv'].'';
								$vars_email['{objeto_correios}'] = $dados_pacote['cod_rastreio_pacote_dv'];
								$vars_email['{id_plp}'] = $id_plp_correios;
								//atualiza o pedido
								if($order->getCurrentState()!=$status_fechar){
									$history = new OrderHistory();
									$history->id_order = (int)$order->id;
									$history->id_order_state = (int)$status_fechar;
									$history->addWithemail(true,$vars_email);
									$order->current_state = $history->id_order_state;
									$order->shipping_number = $dados_pacote['cod_rastreio_pacote_dv'];
									$order->update();
								}else{
									$order->shipping_number = $dados_pacote['cod_rastreio_pacote_dv'];
									$order->update();
								}
								//atualiza o order carrier
								$envio_pedido = $this->module->envio_do_pedido($order);
								if($envio_pedido){
									$order_carrier = new OrderCarrier($envio_pedido['id_order_carrier']);
									$order_carrier->tracking_number = $dados_pacote['cod_rastreio_pacote_dv'];
									$order_carrier->update();
								}
								//cria um log para o pedido
								$msglog = 'Envio Correios com PLP Fechada: '.$id_plp_correios.' e Objeto: '.$dados_pacote['cod_rastreio_pacote_dv'].' em '.date('d/m/Y H:i').'';
								$msg = new Message();
								$message = strip_tags($msglog, '<br>');
								if (($message)){
									$msg->message = $message;
									$msg->id_order = intval($order->id);
									$msg->private = 1;
									$msg->add();
								}
								//atualiza no banco de dados
								$status_pedido = $order->getCurrentState();
								$sql = "UPDATE `" . _DB_PREFIX_ . "sigep5_pedidos` SET `status_pedido_loja` = '".$status_pedido."' WHERE id_pedido_loja = '".$dados_pacote['id_pedido_pacote']."';";
								Db::getInstance()->execute($sql);
							}
						}
					}
				}
				
				//logs
				$json = array('erro'=>false,'id_plp'=>$id_plp_correios,'log'=>'PLP #'.$id_plp_correios.' criada com sucesso!');
				
			} else {
				//logs
				$json = array('erro'=>true,'log'=>'Erro ao criar PLP: '.$result->getErrorMsg());
			}
		} catch (\Exception $ex) { 
			//logs
			$json = array('erro'=>true,'log'=>'Excessao ao fechar PLP: '.$ex->getMessage());
		}
		
		//log
		if($json['erro']==true){
			$this->module->salvar_log('[Sigep Fechar PLP] '.$json['log']);
		}
		
		//debug
		if(Configuration::get('SIGEPPRO5_STATUS_DEBUG')){
			$this->module->salvar_log('Debug Fechar PLPs em '.date('d/m/Y H:i:s').':');
			$this->module->salvar_log( http_build_query($json) );
		}
		
		//retorna o json
		die(json_encode($json));
		exit;
	}
	
	private function criar_objetos(){
		if(!isset($_POST['ids'])){
			die('acesso negado!');
		}
		$json = array();
		
		//processa as etiquetas
		foreach($_POST['ids'] as $k=>$v){
			
			//se pedido existir na loja
			$id_unico = $v['id'];
			$pacotes_pedido = $this->module->dados_pacote($id_unico);
			
			//se pedido loja
			$pedido_loja = (int)$pacotes_pedido['id_pedido_loja'];
			if($pedido_loja > 0){
				$order = new Order($pedido_loja);
				if($order){
					$status_pedido = $order->getCurrentState();
					$sql = "UPDATE `" . _DB_PREFIX_ . "sigep5_pedidos` SET `status_pedido_loja` = '".$status_pedido."' WHERE id_pedido_loja = '".$pedido_loja."';";
					Db::getInstance()->execute($sql);
				}
			}else{
				$order = null;	
			}

			//se pacote ainda aberto
			if($pacotes_pedido['pacote_fechado']==0){

				//solicitar etiquetas se servico ativo e valido
				$servico_ativo = $this->module->verificar_servico_ativo($pacotes_pedido['id_servico_pacote']);
				if(isset($servico_ativo['status_servico']) && $servico_ativo['status_servico']==1){
					
					//solicita a etiqueta
					$accessData = $this->module->login_sigep();
					try {
						$params = new \PhpSigep\Model\SolicitaEtiquetas();
						$params->setQtdEtiquetas(1);
						$params->setServicoDePostagem($pacotes_pedido['id_servico_pacote']);
						$params->setAccessData($accessData);
						$phpSigep = new PhpSigep\Services\SoapClient\Real();
						$result = $phpSigep->solicitaEtiquetas($params);
						if (!$result->hasError()) {
							//resultado
							$etiquetas = $result->getResult();
							
							//atualiza o sql
							$sql = "UPDATE `" . _DB_PREFIX_ . "sigep5_pacotes` SET `cod_rastreio_pacote` = '".$etiquetas[0]->getEtiquetaSemDv()."', `cod_rastreio_pacote_dv` = '".$etiquetas[0]->getEtiquetaComDv()."', `dv_rastreio_pacote` = '".$etiquetas[0]->getDv()."', `status_pacote` = 1 WHERE id_pacote = ".(int)$pacotes_pedido['id_pacote'].";";
							Db::getInstance()->execute($sql);
							
							//log
							$this->module->salvar_log('[Sigep Criar Objetos] '.$id_unico.' - Etiqueta alocada com sucesso: '.$etiquetas[0]->getEtiquetaComDv().'');
							
							//json
							$json[$k] = array('erro'=>false,'log'=>$id_unico.' - Etiqueta alocada com sucesso: '.$etiquetas[0]->getEtiquetaComDv().'');
							
						} else {
							//erro
							$erro = $result->getErrorMsg();
							$erro .= ' Verifique se os dados de contrato e ambiente estão corretos e se o serviço selecionado esta disponivel ao mesmo!';
							
							//log
							$this->module->salvar_log('[Sigep Criar Objetos] '.$id_unico.' - Ocorreu um problema ao alocar a etiqueta: '.$erro.'');
							
							//json
							$json[$k] = array('erro'=>true,'log'=>$id_unico.' - Ocorreu um problema ao alocar a etiqueta: '.$erro.'');
						
						}
					} catch (\Exception $ex) {
						//erro
						$erro = $ex->getMessage();
						
						//log
						$this->module->salvar_log('[Sigep Criar Objetos] '.$id_unico.' - Ocorreu um problema ao alocar a etiqueta: '.$erro.'');
						
						//json
						$json[$k] = array('erro'=>true,'log'=>$id_unico.' - Ocorreu um problema ao alocar a etiqueta: '.$erro.'');
					}
					
				}else{
					//erro
					$json[$k] = array('erro'=>true,'log'=>$id_unico.' - O serviço selecionado para este envio encontra-se inativo, edite ou substitua o metodo de envio!');
				}
			}else{
				//erro
				$json[$k] = array('erro'=>true,'log'=>$id_unico.' - Este pacote já encontra-se fechado!');
			}
		}
		
		//debug
		if(Configuration::get('SIGEPPRO5_STATUS_DEBUG')){
			$this->module->salvar_log('Debug Sigep Criar Objetos em '.date('d/m/Y H:i:s').':');
			$this->module->salvar_log( http_build_query($json) );
		}
		
		echo json_encode($json);
		exit;
	}
	
	private function salvar_dados_pacote(){
		$ids_envios = array();
		//regras de validacoes
		if(isset($_POST['extras']) && (in_array('019',$_POST['extras']))){
			if($_POST['valor'] < $this->module->total_minimo){
				die('Serviço VD ativado, informe o valor declarado de no minimo 19.50 !');
			}
		}
		if(!isset($_POST['peso']) || $_POST['peso'] > 30){
			die('O peso deverá ser informado e menor que 30kg!');
		}
		if(!isset($_POST['com']) || $_POST['com'] > 105){
			die('O comprimento deverá ser informado e menor que 105cm!');
		}
		if(!isset($_POST['alt']) || $_POST['alt'] > 105){
			die('A altura deverá ser informado e menor que 105cm!');
		}
		if(!isset($_POST['lar']) || $_POST['lar'] > 105){
			die('A largura deverá ser informado e menor que 105cm!');
		}
		if(($_POST['com']+$_POST['alt']+$_POST['lar']) > 200){
			die('A soma dos lados não pode ser maior que 200cm!');
		}
		$servicoMP = $servicoVD = $servicoAR = 0;
		if(isset($_POST['extras']) && (in_array('001',$_POST['extras']))){
			$servicoAR = 1;
		}
		if(isset($_POST['extras']) && (in_array('002',$_POST['extras']))){
			$servicoMP = 1;
		}
		if(isset($_POST['extras']) && (in_array('019',$_POST['extras']))){
			$servicoVD = 1;
		}
		//cria o pacote
		Db::getInstance()->execute("INSERT INTO `" . _DB_PREFIX_ . "sigep5_pacotes` SET id_servico_pacote = '".pSQL($_POST['servico'])."', id_pedido_pacote = '".pSQL($_POST['pedido'])."', nfe_pacote = '".pSQL($_POST['nota_fiscal'])."', com_pacote = '".pSQL($_POST['com'])."', alt_pacote = '".pSQL($_POST['alt'])."', lar_pacote = '".pSQL($_POST['lar'])."', peso_pacote = '".pSQL($_POST['peso'])."', total_pacote = '".pSQL($_POST['valor'])."', servico_MP_pacote = '".pSQL($servicoMP)."', servico_VD_pacote = '".pSQL($servicoVD)."', servico_AR_pacote = '".pSQL($servicoAR)."', data_pacote = NOW()");
		$id_pacote = Db::getInstance()->Insert_ID();
		//cria o pedido
		$ids_envios = array();
		$ids_envios[] = $id_pacote;
		Db::getInstance()->execute("INSERT INTO `" . _DB_PREFIX_ . "sigep5_pedidos` SET nome = '".pSQL($_POST['nome'])."', logradouro = '".pSQL($_POST['log'])."', numero = '".pSQL($_POST['numero'])."', complemento = '".pSQL($_POST['comp'])."', bairro = '".pSQL($_POST['bairro'])."', cidade = '".pSQL($_POST['cidade'])."', uf = '".pSQL($_POST['uf'])."', cep = '".preg_replace('/\D/', '', $_POST['cep'])."', telefone = '".pSQL($_POST['telefone'])."', ids_pacotes = '".implode(',',$ids_envios)."', data_pedido = NOW()");
		echo 'true';
		exit;
	}
	
	private function frete_rapido(){
		if(!isset($_POST)){
			die('acesso negado!');
		}
		$servicos = isset($_POST['extras'])?$_POST['extras']:array();
		if(!is_array($servicos)){
			$servicos = array();
		}
		$dados = array (
			'nCdEmpresa' => trim(Configuration::get('SIGEPPRO5_USUARIO')),
			'sDsSenha' => trim(Configuration::get('SIGEPPRO5_SENHA')),
			'nCdServico' => str_pad($_POST['servico'], 5, '0', STR_PAD_LEFT),
			'sCepOrigem' => preg_replace('/\D/', '', Configuration::get('SIGEPPRO5_CEP')),
			'sCepDestino' => preg_replace('/\D/', '', $_POST['cep']),
			'nVlPeso' => $_POST['peso'],
			'nCdFormato' => '1',
			'nVlComprimento' => $_POST['com'],
			'nVlAltura' => $_POST['alt'],
			'nVlLargura' => $_POST['lar'],
			'nVlDiametro' => '0',
			'sCdMaoPropria' => (in_array('002',$servicos)?'s':'n'),
			'nVlValorDeclarado' => (in_array('019',$servicos)?number_format((float)$_POST['valor'],2,'.',''):'0.00'),
			'sCdAvisoRecebimento' => (in_array('001',$servicos)?'s':'n'),
		);
		$frete = $this->module->ponte_frete($dados);
		//resultado
		if($frete['erro']==false && isset($frete['dados']['Servicos']['cServico']['PrazoEntrega']) && $frete['dados']['Servicos']['cServico']['PrazoEntrega'] > 0){
		?>
		O frete para o envio com dados acima informado &eacute; <b>R$<?php echo $frete['dados']['Servicos']['cServico']['Valor'];?></b> com prazo de <b><?php echo $frete['dados']['Servicos']['cServico']['PrazoEntrega'];?></b> dia(s).
		<?php
		}elseif(isset($frete['mensagem'])){
			echo $frete['mensagem'];	
		}elseif(isset($frete['dados']['Servicos']['cServico']['MsgErro'])){
			echo $frete['dados']['Servicos']['cServico']['MsgErro'];
		}else{
			echo 'Servidor dos correios offline ou com problemas!';
		}
		exit;
	}
	
	private function adicionar_envios(){
		//layout
        $tpl = $this->createTemplate('add_envios.tpl');
		$tpl->assign(array(
			'pacote' => null,
			'vd' => Configuration::get('SIGEPPRO5_VD'),
			'ar' => Configuration::get('SIGEPPRO5_AR'),
			'mp' => Configuration::get('SIGEPPRO5_MP'),
			'servicos_correios' => $this->module->servicos_cadastrados(),
			'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'/modules/sigeppro5',
		));
		die($tpl->fetch());
	}
	
	private function remover_envio(){
		if(isset($_POST['id'])){
			//remove
			Db::getInstance()->execute("DELETE FROM `" . _DB_PREFIX_ . "sigep5_pacotes` WHERE id_pacote = '".(int)$_POST['id']."'");
			Db::getInstance()->execute("DELETE FROM `" . _DB_PREFIX_ . "sigep5_pedidos` WHERE ".(int)$_POST['id']." IN(ids_pacotes)");
			//log 
			$this->module->salvar_log('Pacote '.(int)$_POST['id'].' removido manualmente por Admin em '.date('d/m/Y H:i').'!');
		}
		echo 'OK';
		exit;
	}
	
	private function salvar_editar_pacote(){
		$ids_envios = array();
		//regras de validacoes
		if(isset($_POST['extras']) && (in_array('019',$_POST['extras']))){
			if($_POST['valor'] < $this->module->total_minimo){
				die('Serviço VD ativado, informe o valor declarado de no minimo 19.50 !');
			}
		}
		if(!isset($_POST['peso']) || $_POST['peso'] > 30){
			die('O peso deverá ser informado e menor que 30kg!');
		}
		if(!isset($_POST['com']) || $_POST['com'] > 105){
			die('O comprimento deverá ser informado e menor que 105cm!');
		}
		if(!isset($_POST['alt']) || $_POST['alt'] > 105){
			die('A altura deverá ser informado e menor que 105cm!');
		}
		if(!isset($_POST['lar']) || $_POST['lar'] > 105){
			die('A largura deverá ser informado e menor que 105cm!');
		}
		if(($_POST['com']+$_POST['alt']+$_POST['lar']) > 200){
			die('A soma dos lados não pode ser maior que 200cm!');
		}
		$servicoMP = $servicoVD = $servicoAR = 0;
		if(isset($_POST['extras']) && (in_array('001',$_POST['extras']))){
			$servicoAR = 1;
		}
		if(isset($_POST['extras']) && (in_array('002',$_POST['extras']))){
			$servicoMP = 1;
		}
		if(isset($_POST['extras']) && (in_array('019',$_POST['extras']))){
			$servicoVD = 1;
		}
		//atualiza o pedido
		if(isset($_POST['id'])){
			Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "sigep5_pedidos` SET nome = '".pSQL($_POST['nome'])."', logradouro = '".pSQL($_POST['log'])."', numero = '".pSQL($_POST['numero'])."', complemento = '".pSQL($_POST['comp'])."', bairro = '".pSQL($_POST['bairro'])."', cidade = '".pSQL($_POST['cidade'])."', uf = '".pSQL($_POST['uf'])."', cep = '".preg_replace('/\D/', '', $_POST['cep'])."', telefone = '".pSQL($_POST['telefone'])."'  WHERE id_pedido = '".(int)$_POST['id']."' LIMIT 1");
		}
		//atualiza o pacote 
		if(isset($_POST['pacotes'])){
			Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "sigep5_pacotes` SET id_servico_pacote = '".pSQL($_POST['servico'])."', id_pedido_pacote = '".pSQL($_POST['pedido'])."', nfe_pacote = '".pSQL($_POST['nota_fiscal'])."', com_pacote = '".pSQL($_POST['com'])."', alt_pacote = '".pSQL($_POST['alt'])."', lar_pacote = '".pSQL($_POST['lar'])."', peso_pacote = '".pSQL($_POST['peso'])."', total_pacote = '".pSQL($_POST['valor'])."', servico_MP_pacote = '".pSQL($servicoMP)."', servico_VD_pacote = '".pSQL($servicoVD)."', servico_AR_pacote = '".pSQL($servicoAR)."' WHERE FIND_IN_SET(id_pacote,'".$_POST['pacotes']."') LIMIT 1");
		}
		echo 'true';
		exit;
	}
	
	private function editar_envios(){
		//registro
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "sigep5_pacotes` 
		LEFT JOIN `" . _DB_PREFIX_ . "sigep5_pedidos` ON(id_pacote IN(ids_pacotes))
		LEFT JOIN `" . _DB_PREFIX_ . "sigep5_servicos` ON(id_servico_pacote=cod_servico)
		WHERE pacote_fechado = 0 AND id_pacote = '".(int)$_GET['id']."'";
		$pacote = Db::getInstance()->getRow($sql);
		//layout
        $tpl = $this->createTemplate('editar_envios.tpl');
		$tpl->assign(array(
			'pacote' => $pacote,
			'servicos_correios' => $this->module->servicos_cadastrados(),
			'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'/modules/sigeppro5',
		));
		die($tpl->fetch());
	}
	
	private function pedidos_pendentes(){
		//acoes
		if(isset($_GET['limpar_rastreio'])){
			Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "sigep5_pacotes` SET cod_rastreio_pacote = '', cod_rastreio_pacote_dv = '', dv_rastreio_pacote = '', status_pacote = 0 WHERE id_pacote = ".(int)$_GET['limpar_rastreio'].";");
			Tools::redirectAdmin($this->context->link->getAdminLink('AdminSigepPro5Envios', true).'&pagina='.(int)$_GET['pagina'].'');
			exit;
		}
		//filto 
		$where = '';
		if(isset($_GET['pacote'])){
			$where .= ' AND id_pacote = '.(int)$_GET['pacote'].'';
		}
		//layout
        $tpl = $this->createTemplate('envios_pendentes.tpl');
		//qtd registros
		$sql = "SELECT COUNT(*) AS total FROM `" . _DB_PREFIX_ . "sigep5_pacotes` WHERE pacote_fechado = 0 $where ORDER BY id_pacote DESC";
        $row = Db::getInstance()->getRow($sql);
		$total_envios = $row['total'];
		//inicio paginacao 
		$pagina = (int)(isset($_GET['pagina'])?$_GET['pagina']:1);
		$registros = (int)Configuration::get('SIGEPPRO5_QTD_PAGINA');
		$registros = ($registros==0)?20:$registros;
		$inicio = ($registros*($pagina-1));
		$paginas = ceil( $total_envios / $registros );
		//registros
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "sigep5_pacotes` 
		LEFT JOIN `" . _DB_PREFIX_ . "sigep5_pedidos` ON(id_pacote IN(ids_pacotes))
		LEFT JOIN `" . _DB_PREFIX_ . "sigep5_servicos` ON(id_servico_pacote=cod_servico)
		WHERE pacote_fechado = 0 $where ORDER BY id_pacote DESC LIMIT $inicio,$registros";
		$envios_bd = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$envios = array();
		//envios
		foreach($envios_bd as $k=>$v){
			$envios[] = array_merge($v,array('endereco_valido'=>$this->module->validar_endereco($v)));
		}
		//status
		$nomes_status = array();
		foreach($this->module->status_nomes() as $k=>$v){
			$nomes_status[$v['id']]=$v['name'];
		}
		$tpl->assign(array(
			'envios' => $envios,
			'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/sigeppro5',
			'pagina' => $pagina,
			'total_envios' => $total_envios,
			'paginas' => $paginas,
			'lista_status_pagamentos' => $nomes_status,
			'extra'	=> '',
		));
		$this->context->smarty->assign(array('content' => $tpl->fetch()));
	}
	
	private function atualizar_servicos(){
		$accessData = $this->module->login_sigep();
		$json = array();
		try {
			$phpSigep = new PhpSigep\Services\SoapClient\Real();
			$result = $phpSigep->buscaCliente($accessData);
			if (!$result->hasError()) {
				Db::getInstance()->execute("DELETE FROM `" . _DB_PREFIX_ . "sigep5_servicos`");
				$buscaClienteResult = $result->getResult();
				$servicos = $buscaClienteResult->getContratos()->cartoesPostagem->servicos;
				$data_fim = $buscaClienteResult->getContratos()->cartoesPostagem->dataVigenciaFim;
				foreach ($servicos as &$servico) {
						$servico->servicoSigep->chancela->chancela = '';
						if(isset($servico->codigo)){
							$cod_servico = trim(str_pad($servico->codigo, 5, "0", STR_PAD_LEFT));
							Db::getInstance()->execute("INSERT INTO `" . _DB_PREFIX_ . "sigep5_servicos` SET cod_servico = '".$cod_servico."',  nome_servico = '".trim($servico->descricao)."', cod_sigep_servico = '".trim($servico->id)."', ultima_atualizacao_servico = '".trim($servico->dataAtualizacao)."', status_servico = 1, fim_contrato_servico = '".$data_fim."', chancela_servico = ''");
						}
				}
				$json = array('erro'=>false,'log'=>'Serviços do seu contrato foram atualizados com sucesso na loja!');
			} else {
				$erro = $result->getErrorMsg();
				$erro .= ' Verifique se os dados de contrato e ambiente estão corretos!';
				$this->module->salvar_log('[Sigep Consultar Contrato] '.$erro);
				$json = array('erro'=>true,'log'=>$erro);
			}
		} catch (\Exception $ex) {
			$erro = $ex->getMessage();	
			$this->module->salvar_log('[Sigep Consultar Contrato] '.$erro);
			$json = array('erro'=>true,'log'=>$erro);
		}
		
		//debug
		if(Configuration::get('SIGEPPRO5_STATUS_DEBUG')){
			$this->module->salvar_log('Debug Sigep Atualizar Serviços em '.date('d/m/Y H:i:s').':');
			$this->module->salvar_log( http_build_query($json) );
		}
		
		die(json_encode($json));
	}
}
?>