<?php
if (!defined('_PS_VERSION_'))
	exit;

//classes sigep 
include_once(dirname(__FILE__).'/api/vendor/autoload.php');

class SigepPro5 extends Module
{	
	public function __construct(){
		$this->name = 'sigeppro5';
		$this->fator = 6000;
		$this->total_minimo = 19.50;
		$this->tab = 'shipping_logistics';
		$this->version = '1.0';
		$this->author = 'Loja5.com.br';
		$this->need_instance = 0;
		$this->bootstrap = true;
		$this->diretorio = dirname(__FILE__);
		parent::__construct();	
		$this->displayName = $this->l('Sigep Correios PRO');
		$this->description = $this->l('Sistema de gerenciamento de envios e postagens Sigep Correios.');
	}
	
	public function hookdisplayAdminAfterHeader(){
		//exibe a mensagem sigep
        if(isset($_GET['controller']) && $_GET['controller']=='AdminDashboard'){
			//verifica a licença
			$key_string = Configuration::get('SIGEPPRO5_SERIAL');
			if(isset($key_string) && !empty($key_string)){
				$validas[] = trim($key_string);
				//curl
				$dados = json_encode($validas);
				$service_url = 'https://www.loja5.com.br/index.php?route=module/iono/buscar';
				$curl = curl_init($service_url);
				curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);  
				curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE); 
				curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 10);
				curl_setopt($curl, CURLOPT_HTTPHEADER, array(
					'Content-Type: application/json',
					'Content-Length: ' .strlen($dados))
				); 
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($curl, CURLOPT_POST, true);
				curl_setopt($curl, CURLOPT_POSTFIELDS, $dados);
				$json = json_decode(curl_exec($curl),true);
				$curlErrno     = curl_errno($curl);
				$curlErr       = curl_error($curl);
				curl_close($curl);
			}
			if(isset($json['atualizados'][0])){
				$up = $json['atualizados'][0];
				echo '<div class="alert alert-info"><span style="background: #03A9F4; color: #FFF; border-radius: 2px; padding: 3px;"><b>[CORREIOS PRO LOJA5]</b></span> O seu m&oacute;dulo <b>'.$up['modulo'].'</b> foi atualizado em <b>Loja5.com.br</b>, <a href="https://www.loja5.com.br/account/download.html" target="_blank">acesse sua conta > downloads</a> e baixe o mesmo at&eacute; <b>'.$up['validade'].'</b>, para instalar siga o guia de instala&ccedil;&atilde;o que encontra-se dentro do anexo baixado.</div>';
			}
        }
    }

	public function install(){
		//sql 
		include(dirname(__FILE__).'/sql/install.php');
		
		//menu principal 
		$parent_tab0 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab0->name[(int)$lang['id_lang']] = $this->l('Correios Sigep');
        }
		$parent_tab0->class_name = 'AdminSigepPro5Envios';
		$parent_tab0->id_parent = 0;
		$parent_tab0->module = $this->name;
		$parent_tab0->add();
		
		//menu 1
		$parent_tab1 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab1->name[(int)$lang['id_lang']] = $this->l('Envios Pendentes');
        }
		$parent_tab1->class_name = 'AdminSigepPro5Envios';
		$parent_tab1->id_parent = $parent_tab0->id;
		$parent_tab1->module = $this->name;
		$parent_tab1->add();
		
		//menu 2
		$parent_tab2 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab2->name[(int)$lang['id_lang']] = $this->l('Envios Finalizados');
        }
		$parent_tab2->class_name = 'AdminSigepPro5EnviosFinalizados';
		$parent_tab2->id_parent = $parent_tab0->id;
		$parent_tab2->module = $this->name;
		$parent_tab2->add();
		
		//menu 3
		$parent_tab3 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab3->name[(int)$lang['id_lang']] = $this->l('PLPs e Etiquetas');
        }
		$parent_tab3->class_name = 'AdminSigepPro5PLPs';
		$parent_tab3->id_parent = $parent_tab0->id;
		$parent_tab3->module = $this->name;
		$parent_tab3->add();
		
		//menu 4
		$parent_tab4 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab4->name[(int)$lang['id_lang']] = $this->l('Envios Bloqueados');
        }
		$parent_tab4->class_name = 'AdminSigepPro5EnviosBloqueados';
		$parent_tab4->id_parent = $parent_tab0->id;
		$parent_tab4->module = $this->name;
		$parent_tab4->add();
		
		//menu 5
		$parent_tab5 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab5->name[(int)$lang['id_lang']] = $this->l('Envios Entregues');
        }
		$parent_tab5->class_name = 'AdminSigepPro5EnviosEntregues';
		$parent_tab5->id_parent = $parent_tab0->id;
		$parent_tab5->module = $this->name;
		$parent_tab5->add();
		
		//menu 6
		$parent_tab6 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab6->name[(int)$lang['id_lang']] = $this->l('Configurar');
        }
		$parent_tab6->class_name = 'AdminSigepPro5Config';
		$parent_tab6->id_parent = $parent_tab0->id;
		$parent_tab6->module = $this->name;
		$parent_tab6->add();
		
		//ativa os hooks
		if (!parent::install() OR !$this->registerHook('displayAdminAfterHeader') OR !$this->registerHook('newOrder') OR !$this->registerHook('displayAdminOrderContentOrder') OR !$this->registerHook('actionPaymentConfirmation') OR !$this->registerHook('actionOrderStatusUpdate') OR !$this->registerHook('displayOrderDetail') OR !$this->registerHook('updateCarrier') OR !$this->registerHook('displayAdminOrder') OR !$this->registerHook('displayAdminAfterHeader') OR !$this->registerHook('displayAdminOrderTabOrder') OR !$this->registerHook('displayBackOfficeHeader')){
			return false;
		}
		
		return true;
	}
	
	public function uninstall(){
        // remove os menus
		$moduleTabs = Tab::getCollectionFromModule($this->name);
		if (!empty($moduleTabs)) {
			foreach ($moduleTabs as $moduleTab) {
				$moduleTab->delete();
			}
		}
        return parent::uninstall();
    }
	
	public function hookdisplayAdminAfterHeader(){
        //registros 
		$pacotes_sigep = Db::getInstance()->getRow("SELECT COUNT(*) AS total FROM `"._DB_PREFIX_."sigep5_pacotes` WHERE status_pacote =  0 AND data_pacote BETWEEN NOW() - INTERVAL 15 DAY AND NOW()");
		$plps_sigep = Db::getInstance()->getRow("SELECT COUNT(*) AS total FROM `"._DB_PREFIX_."sigep5_plps` WHERE status_plp =  'Pendente' AND data_fechamento BETWEEN NOW() - INTERVAL 15 DAY AND NOW()");
		//exibe a mensagem sigep
        if(isset($_GET['controller']) && $_GET['controller']=='AdminDashboard'){
            echo '<div class="alert alert-info"><span style="background: #03A9F4; color: #FFF; border-radius: 2px; padding: 3px;"><b>[SIGEP5]</b></span> Em sua loja atualmente possui <span  style="background: #ff9800; color: #FFF; border-radius: 2px; padding: 3px;">'.$pacotes_sigep['total'].'</span> <a href="'.$this->context->link->getAdminLink('AdminSigepPro5Envios', true).'">pacotes/pedidos</a> aguardando o processamento da PLP de postagem e <span style="background: #009688; color: #FFF; border-radius: 2px; padding: 3px;">'.$plps_sigep['total'].'</span> <a href="'.$this->context->link->getAdminLink('AdminSigepPro5PLPs', true).'">PLPs</a> com o status <span  style="background: #ff5722; color: #FFF; border-radius: 2px; padding: 3px;">Pendente</span> de processamento junto ao Correios nos &uacute;ltimos 15 dias.</div>';
        }
    }
	
	public function hookdisplayAdminOrderTabOrder($params){
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "sigep5_pacotes` 
		LEFT JOIN `" . _DB_PREFIX_ . "sigep5_pedidos` ON(id_pacote IN(ids_pacotes))
		LEFT JOIN `" . _DB_PREFIX_ . "sigep5_servicos` ON(id_servico_pacote=cod_servico)
		WHERE id_pedido_pacote= ".(int)$params['order']->id."";
        $pacotes_sigep = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$qtd_pacotes = count($pacotes_sigep);
		$this->context->smarty->assign(array(
				'qtd' => $qtd_pacotes,
				'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/sigeppro5',
				'pacotes' => $pacotes_sigep,
				'id_pedido' => $params['order']->id,
				'order' => $params['order'],
			)
		);
		return $this->context->smarty->fetch($this->local_path.'views/templates/admin/detalhes_sigep_tab.tpl');
    }
	
	public function hookDisplayAdminOrderContentOrder($params){
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "sigep5_pacotes` 
		LEFT JOIN `" . _DB_PREFIX_ . "sigep5_pedidos` ON(id_pacote IN(ids_pacotes))
		LEFT JOIN `" . _DB_PREFIX_ . "sigep5_servicos` ON(id_servico_pacote=cod_servico)
		WHERE id_pedido_pacote= ".(int)$params['order']->id."";
        $pacotes_sigep = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$qtd_pacotes = count($pacotes_sigep);
		$this->context->smarty->assign(array(
				'qtd' => $qtd_pacotes,
				'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/sigeppro5',
				'pacotes' => $pacotes_sigep,
				'id_pedido' => $params['order']->id,
				'order' => $params['order'],
			)
		);
		return $this->context->smarty->fetch($this->local_path.'views/templates/admin/detalhes_sigep_conteudo.tpl');
	}
	
	public function hookdisplayOrderDetail($params){
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "sigep5_pacotes` 
		LEFT JOIN `" . _DB_PREFIX_ . "sigep5_pedidos` ON(id_pacote IN(ids_pacotes))
		LEFT JOIN `" . _DB_PREFIX_ . "sigep5_servicos` ON(id_servico_pacote=cod_servico)
		WHERE id_pedido_pacote= ".(int)$params['order']->id."";
        $pacotes_sigep = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$qtd_pacotes = count($pacotes_sigep);
		$this->context->smarty->assign(array(
				'qtd' => $qtd_pacotes,
				'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/sigeppro5',
				'pacotes' => $pacotes_sigep,
				'id_pedido' => $params['order']->id,
				'order' => $params['order'],
			)
		);
		return $this->context->smarty->fetch($this->local_path.'views/templates/front/detalhes_rastreamento.tpl');
	}
	
	public function login_sigep(){
		$accessData = new \PhpSigep\Model\AccessData();
		$accessData->setUsuario(trim(Configuration::get('SIGEPPRO5_USUARIO')));
		$accessData->setSenha(trim(Configuration::get('SIGEPPRO5_SENHA')));
		$accessData->setCodAdministrativo(preg_replace('/\D/', '', trim(Configuration::get('SIGEPPRO5_COD_ADMIN'))));
		$accessData->setNumeroContrato(preg_replace('/\D/', '', trim(Configuration::get('SIGEPPRO5_CONTRATO'))));
		$accessData->setCartaoPostagem(preg_replace('/\D/', '', trim(Configuration::get('SIGEPPRO5_CARTAO'))));
		$accessData->setCnpjEmpresa(preg_replace('/\D/', '', trim(Configuration::get('SIGEPPRO5_CNPJ'))));
		$accessData->setDiretoria(new \PhpSigep\Model\Diretoria(trim(Configuration::get('SIGEPPRO5_DIRETORIA'))));
		$config = new \PhpSigep\Config();
		$config->setAccessData($accessData);
		if(Configuration::get('SIGEPPRO5_AMBIENTE')=='R'){
			$config->setEnv(\PhpSigep\Config::ENV_PRODUCTION);
		}else{
			$config->setEnv(\PhpSigep\Config::ENV_DEVELOPMENT);
		}
		$config->setCacheOptions(
			array(
				'storageOptions' => array(
					'enabled' => false,
					'ttl' => 10,
					'cacheDir' => sys_get_temp_dir(),
				),
			)
		);
		\PhpSigep\Bootstrap::start($config);
		return $accessData;		
	}
	
	public function hookdisplayBackOfficeHeader(){
		return '<style>
		.icon-AdminSigepPro5Envios:before {
			content: "\f1b2";
		}
		</style>';
	}
	
	public function hookupdateCarrier($params){
		if ((int)($params['id_carrier']) != (int)($params['carrier']->id)) {
			Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "sigep5_mapear` SET id_transportadora = ".(int)($params['carrier']->id)." WHERE id_transportadora = ".(int)$params['id_carrier'].";");
		}
	}
	
	public function hookActionOrderStatusUpdate($params) {
		//status do modulo
		$status_modulo = Configuration::get('SIGEPPRO5_STATUS');
		//status a criar pacotes
		$status_criar = array(Configuration::get('SIGEPPRO5_CRIAR_PACOTES_1'),Configuration::get('SIGEPPRO5_CRIAR_PACOTES_2'),Configuration::get('SIGEPPRO5_CRIAR_PACOTES_3'));
		//se ativado
		if($status_modulo && isset($params['id_order'])){
			//dados
			$id_order = $params['id_order'];
			//dados do pedido 
			$order = new Order($id_order);
			//se ja existe o pedido
			$sql = "SELECT COUNT(*) AS total FROM `" . _DB_PREFIX_ . "sigep5_pacotes` WHERE id_pedido_pacote = '".(int)$id_order."'";
			$row = Db::getInstance()->getRow($sql);
			//regra de criar 
			$criar = false;
			if(isset($params['newOrderStatus']->id)){
				$novo_status = $params['newOrderStatus']->id;
				if($novo_status > 0 && $row['total']==0 && in_array($novo_status,$status_criar)){
					$criar = true;
				}
			}elseif(isset($params['forcar_criar'])){
				$criar = true;
				$novo_status = $order->getCurrentState();
			}
			//se status > 0, pedido nao existe e status a criar pacote (criar pacote)
			if($criar){
				$endereco = new Address((int)($order->id_address_delivery));
				$estado = new State((int)($endereco->id_state));
				$cliente = new Customer((int)($endereco->id_customer));
				$array_end = array_merge((array)$cliente,(array)$endereco);
				//dados pacote produtos 
				$dados_produtos = $this->dados_produtos($order);
				//medidas do pacote e pesos 
				$com = ($dados_produtos['medidas']['com'] >= 16)?$dados_produtos['medidas']['com']:16;
				$alt = ($dados_produtos['medidas']['alt'] >= 2)?$dados_produtos['medidas']['alt']:2;
				$lar = ($dados_produtos['medidas']['lar'] >= 11)?$dados_produtos['medidas']['lar']:11;
				$peso_real = $dados_produtos['peso_real'];
				$peso_cubado = $dados_produtos['peso_cubado'];
				//peso base
				if($peso_cubado <= 5.00){
					$peso_base = ($peso_real > 0)?$peso_real:0.3;
				}else{
					$peso_base = ($peso_cubado > 0)?$peso_cubado:0.3;
				}
				//status do pedido 
				$status_pedido = $novo_status;
				//status alocar automaticamente 
				$auto_alocar = Configuration::get('SIGEPPRO5_AUTO_ALOCAR');
				$alocar = 0;
				if($auto_alocar){
					$alocar = 1;
				}
				//endereço 
				$nfe = '';
				$nome = $endereco->firstname;
				$sobrenome = $endereco->lastname;
				$logradouro = $endereco->address1;
				$bairro = $endereco->address2;
				$cidade = $endereco->city;
				$cep = preg_replace('/\D/', '', $endereco->postcode);
				$estado = $estado->iso_code;
				//complemento
				$complemento = '';
				$compl = explode('.',Configuration::get("SIGEPPRO5_ORIGEM_COMPLEMENTO"));
				$ccom = isset($compl[1])?$compl[1]:'complemento';
				if(isset($endereco->compl)){
					$complemento = $endereco->compl;
				}elseif(isset($endereco->complemento)){
					$complemento = $endereco->complemento;
				}elseif(isset($endereco->$ccom) && !empty($endereco->$ccom)){
					$complemento = $endereco->$ccom;
				}
				//captura o numero 
				$limpa_num = '';
				$numero = explode('.',Configuration::get("SIGEPPRO5_ORIGEM_NUMERO"));
				$cnum = isset($numero[1])?$numero[1]:'numero';
				if(isset($endereco->numend) && !empty($endereco->numend)){
					$limpa_num = $endereco->numend;
				}elseif(isset($endereco->numero) && !empty($endereco->numero)){
					$limpa_num = $endereco->numero;
				}elseif(isset($endereco->number) && !empty($endereco->number)){
					$limpa_num = $endereco->number;
				}elseif(isset($endereco->$cnum) && !empty($endereco->$cnum)){
					$limpa_num = $endereco->$cnum;
				}else{
					$partes = explode(',',$endereco->address1);
					if(count($partes)==3){
						$logradouro = isset($partes[0])?$partes[0]:$endereco->address1;
						$limpa_num = isset($partes[1])?$partes[1]:'';
						$complemento = isset($partes[2])?$partes[2]:$complemento;
					}elseif(count($partes)==2){
						$logradouro = isset($partes[0])?$partes[0]:$endereco->address1;
						$limpa_num = isset($partes[1])?$partes[1]:'';
					}
				}
				//valida os tamanhos 
				$limpa_num = (strlen($limpa_num) <= 5)?$limpa_num:'';
				$complemento = substr($complemento,0,30);
				//cod de servico correios 
				$cod_servico = $this->cod_metodo($order->id_carrier);
				if(empty($cod_servico)){
					$this->salvar_log('Pacote #'.$id_order.' não criado de forma automatica pois não foi feito via um serviço correios mapeado.');
					return false;
				}
				//cria o pacote 
				$sql = "INSERT INTO `" . _DB_PREFIX_ . "sigep5_pacotes` (`id_pacote`, `num_pacote`, `id_servico_pacote`, `id_pedido_pacote`, `nfe_pacote`, `com_pacote`, `lar_pacote`, `alt_pacote`, `peso_pacote`, `total_pacote`, `cod_rastreio_pacote`, `cod_rastreio_pacote_dv`, `dv_rastreio_pacote`, `servico_MP_pacote`, `servico_VD_pacote`, `servico_AR_pacote`, `pacote_fechado`, `data_pacote`, `status_pacote`, `alocar_cron`) VALUES (NULL, '0', '".$cod_servico."', '".(int)$id_order."', '".$nfe."', '".$com."', '".$lar."', '".$alt."', '".$peso_base."', '".$order->getTotalProductsWithoutTaxes()."', '', '', '', '".Configuration::get("SIGEPPRO5_MP")."', '".Configuration::get("SIGEPPRO5_VD")."', '".Configuration::get("SIGEPPRO5_AR")."', '0', NOW(), '0', '".$alocar."');";
				Db::getInstance()->execute( $sql );
				$id_pacote = Db::getInstance()->Insert_ID();
				$ids_envios = array();
				if($id_pacote){
					//pega o id do pacote 
					$ids_envios[] = $id_pacote;
					//cadastra o endereço de entrega
					$telefone = !empty($endereco->phone)?$endereco->phone:$endereco->phone_mobile;
					$sql = "INSERT INTO `" . _DB_PREFIX_ . "sigep5_pedidos` (`id_pedido`, `status_pedido_loja`, `id_pedido_loja`, `ids_pacotes`, `nome`, `logradouro`, `numero`, `complemento`, `bairro`, `cidade`, `uf`, `cep`, `telefone`, `email`, `processado`, `data_pedido`) VALUES (NULL, '".$status_pedido."', '".(int)$id_order."', '".implode(',',$ids_envios)."', '".$nome." ".$sobrenome."', '".$logradouro."', '".$limpa_num."', '".$complemento."', '".$bairro."', '".$cidade."', '".$estado."', '".preg_replace('/\D/', '', $cep)."', '".$telefone."', '".$cliente->email."', '0', NOW());";
					Db::getInstance()->execute( $sql );
					//log 
					$this->salvar_log('Pacote Criado Automaticamente para o pedido #'.$id_order.' ('.$status_pedido.') / Alocar: '.$alocar.'');
					// Inserido debug
					if(Configuration::get('SIGEPPRO5_STATUS_DEBUG')){
						$this->salvar_log('Detalhes Pacote #'.$id_order.'');
						$this->salvar_log(print_r($dados_produtos,true));
					}
				}
			}else{
				$this->salvar_log('Pacote #'.$id_order.' não criado de forma automatica pois não esta atrelado a nenhuma regra de automação.');
			}
		}
	}
	
	public function envio_do_pedido($order){
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "order_carrier` 
		WHERE id_order= ".(int)$order->id." AND id_carrier = ".(int)$order->id_carrier."";
        $row = Db::getInstance()->getRow($sql);
		return $row;
	}
	
	public function verificar_servico_ativo($id){
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "sigep5_servicos` WHERE cod_servico= '".str_pad($id, 5, 0, STR_PAD_LEFT)."'";
        $row = Db::getInstance()->getRow($sql);
		return $row;
	}
	
	public function dados_pacote($id){
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "sigep5_pacotes` 
		LEFT JOIN `" . _DB_PREFIX_ . "sigep5_pedidos` ON(id_pacote IN(ids_pacotes))
		WHERE id_pacote= ".(int)$id."";
        $row = Db::getInstance()->getRow($sql);
		return $row;
	}
	
	public function dados_pacote_pedido($id){
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "sigep5_pacotes` 
		LEFT JOIN `" . _DB_PREFIX_ . "sigep5_pedidos` ON(id_pacote IN(ids_pacotes))
		WHERE id_pedido_pacote= ".(int)$id."";
        $row = Db::getInstance()->getRow($sql);
		return $row;
	}
	
	public function dados_pacote_objeto($objeto){
		return Db::getInstance()->getRow("SELECT * FROM `" . _DB_PREFIX_ . "sigep5_pacotes` AS a
		LEFT JOIN `" . _DB_PREFIX_ . "sigep5_pedidos` AS b ON(a.id_pacote IN(b.ids_pacotes)) 
		WHERE a.cod_rastreio_pacote_dv = '".$objeto."'");
	}
	
	private function cod_metodo($id_carrier){
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "sigep5_mapear` WHERE id_transportadora= ".(int)$id_carrier."";
        $row = Db::getInstance()->getRow($sql);
		return isset($row['cod_servico'])?$row['cod_servico']:'';
	}
	
	protected function renderForm(){
        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'setGlobalConfiguration';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );
        return $helper->generateForm(array($this->getConfigForm()));
    }
	
	public function getContent(){
		$output = '';
		if (Tools::isSubmit('setGlobalConfiguration')){
			$this->postProcess();
			$output .= $this->displayConfirmation('Dados salvos com sucesso!');
		}
		if(!is_writable(dirname(__FILE__ ))) {
			$output .= $this->displayError($this->l('O diretorio do módulo "modules/'.$this->name.'/" não possui permissão de escrita, caso tenha problema ao ativar o serial de registro do mesmo aplique permissão ao mesmo compativel com sua hospedagem, lembre-se de aplicar apenas na pasta do módulo e não aplicar permissão nos arquivos do mesmo!'));
		}
		$this->context->smarty->assign('link', $this->context->link);
        $this->context->smarty->assign('module_dir', $this->_path);
		$this->context->smarty->assign('url_envios', $this->context->link->getAdminLink('AdminSigepPro5Envios', true));
        $output .= $this->context->smarty->fetch($this->local_path.'views/templates/admin/configure.tpl');
		$rodape = $this->context->smarty->fetch($this->local_path.'views/templates/admin/rodape.tpl');
		if(!file_exists(dirname(__FILE__).'/include/licenciamento.php')){
			$file_lic = $this->displayError('<p><strong>Ops:</strong> Existe um problema no arquivo de li&ccedil;enciamento ('.dirname(__FILE__).'/include/licenciamento.php) do seu m&oacute;dulo em sua loja, aparentemente o mesmo n&atilde;o foi enviado ou esta sendo removido por sua hospedagem, <a href="https://loja5.zendesk.com/hc/pt-br/articles/5147862975117-Problema-de-Alerta-de-Arquivos-com-Eval-Base64-no-Wordfence-Sucuri-Cpanel-CPGuard-e-Outros" target="_blank">clique aqui</a> e siga as instru&ccedil;&otilde;es!</p>');
			return $output.$file_lic;
		}else{
			return $output.$this->renderForm().$rodape;
		}
	}

	protected function getConfigForm(){
		if(file_exists(dirname(__FILE__).'/include/licenciamento.php')){
			include_once(dirname(__FILE__).'/include/licenciamento.php');
			return config_sigep5_form($this);
		}else{
			return array();
		}
    }

    protected function getConfigFormValues(){
        $inputs = array();
        $form   = $this->getConfigForm();
		if(isset($form['form']['input'])){
			foreach ($form['form']['input'] as $v) {
				$chave          = $v['name'];
				$inputs[$chave] = Configuration::get($chave, '');
			}
		}
        return $inputs;
    }

    protected function postProcess(){
        $form_values = $this->getConfigFormValues();
        foreach (array_keys($form_values) as $key) {
			Configuration::updateValue($key, Tools::getValue($key));
        }
		//salva os relacionamentos
		if(isset($_POST['SIGEPPRO5_MAPEAR_TRANSPORTADORAS'])){
			//limpa
			Db::getInstance()->execute("DELETE FROM `" . _DB_PREFIX_ . "sigep5_mapear`");
			//cadastra novamente
			foreach($_POST['SIGEPPRO5_MAPEAR_TRANSPORTADORAS'] as $k=>$v){
				Db::getInstance()->execute("INSERT INTO `" . _DB_PREFIX_ . "sigep5_mapear` SET id_transportadora = '".$k."',  cod_servico = '".trim($v)."'");
			}
		}
		//salva a logomarca 
		if(isset($_FILES['SIGEPPRO5_LOGO']['name'])){
			$file = Tools::fileAttachment('SIGEPPRO5_LOGO');
			if(isset($file['name'])){
				$extensao = pathinfo($file['name'], PATHINFO_EXTENSION);
				$mimeTypeAceitos = array('image/png', 'image/x-png', 'image/jpeg', 'image/jpg');
				if (in_array($file['mime'], $mimeTypeAceitos)){
					$novo_nome = time().md5($file['name']).'.'.$extensao;
					if(move_uploaded_file($file['tmp_name'], _PS_IMG_DIR_ . $novo_nome)){
						Configuration::updateValue('SIGEPPRO5_LOGOMARCA', $novo_nome);
					}
				}
			}
		}
    }
	
	public function exibir_imagem_logo(){
		$logo = Configuration::get('SIGEPPRO5_LOGOMARCA');
		if(!empty($logo)){
			$url = Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'img/'.$logo.'';
			return '<img class="img-responsive" src="'.$url.'" style="width:80px;height:80px;">';
		}else{
			return '';
		}
	}
	
	public function array_plps(){
		//dados 
		$plps = array();
		$envios = explode(',',$_GET['envios']);
		$encomenda = array();
		$id_plp = date('dmYHi');
		
		//remetente 
		$remetente = new \PhpSigep\Model\Remetente();
		$remetente->setNome(trim(Configuration::get('SIGEPPRO5_NOME')));
		$remetente->setLogradouro(trim(Configuration::get('SIGEPPRO5_LOGRADOURO')));
		$remetente->setNumero(trim(Configuration::get('SIGEPPRO5_NUMERO')));
		$remetente->setComplemento(trim(Configuration::get('SIGEPPRO5_COMPLEMENTO')));
		$remetente->setBairro(trim(Configuration::get('SIGEPPRO5_BAIRRO')));
		$remetente->setCep(trim(Configuration::get('SIGEPPRO5_CEP')));
		$remetente->setUf(trim(Configuration::get('SIGEPPRO5_UF')));
		$remetente->setCidade(trim(Configuration::get('SIGEPPRO5_CIDADE')));
		$remetente->setTelefone('');
		
		//lista os envios 
		$lista_encomendas = array();
		foreach($envios AS $k=>$envioid){
			
			//dados do pacote
			$sql = "SELECT * FROM `" . _DB_PREFIX_ . "sigep5_pacotes` 
			LEFT JOIN `" . _DB_PREFIX_ . "sigep5_pedidos` ON(id_pacote IN(ids_pacotes))
			LEFT JOIN `" . _DB_PREFIX_ . "sigep5_servicos` ON(id_servico_pacote=cod_servico)
			WHERE id_pacote = ".(int)$envioid."";
			$enviorow = Db::getInstance()->getRow($sql);
			
			//ok
			if(isset($enviorow['status_pacote']) && $enviorow['status_pacote']==1){
				$envio = $enviorow;
				//pacote 
				$dimensao = new \PhpSigep\Model\Dimensao();
				$dimensao->setAltura(number_format($envio['alt_pacote'], 2, ',', ''));
				$dimensao->setLargura(number_format($envio['lar_pacote'], 2, ',', ''));
				$dimensao->setComprimento(number_format($envio['com_pacote'], 2, ',', ''));
				$dimensao->setDiametro(0);
				$dimensao->setTipo(\PhpSigep\Model\Dimensao::TIPO_PACOTE_CAIXA);
				$destinatario = new \PhpSigep\Model\Destinatario();
				$destinatario->setNome($envio['nome']);
				$destinatario->setLogradouro($envio['logradouro']);
				$destinatario->setNumero($envio['numero']);
				$destinatario->setComplemento($envio['complemento']);
				$destinatario->setEmail($envio['email']);
				$destinatario->setTelefone($envio['telefone']);
				$destinatario->setIsCliqueRetire((bool)$envio['clique_retira']);
				$destino = new \PhpSigep\Model\DestinoNacional();
				$destino->setBairro($envio['bairro']);
				$destino->setCep($envio['cep']);
				$destino->setCidade($envio['cidade']);
				$destino->setUf($envio['uf']);
				$destino->setNumeroPedido($envio['id_pedido_pacote']);
				$destino->setNumeroNotaFiscal($envio['nfe_pacote']);
				//etiqueta 
				$etiqueta = new \PhpSigep\Model\Etiqueta();
				$etiqueta->setEtiquetaSemDv($envio['cod_rastreio_pacote']);
				//servicos adicionais 
				$servicos_adicionais = array();
				if($envio['servico_AR_pacote']){
					$servicoAdicional = new \PhpSigep\Model\ServicoAdicional();
					$servicoAdicional->setCodigoServicoAdicional(\PhpSigep\Model\ServicoAdicional::SERVICE_AVISO_DE_RECEBIMENTO);
					$servicoAdicional->setValorDeclarado(number_format($envio['total_pacote'], 2, ',', ''));
					$servicos_adicionais[] = $servicoAdicional;
				}
				if($envio['servico_MP_pacote']){
					$servicoAdicional = new \PhpSigep\Model\ServicoAdicional();
					$servicoAdicional->setCodigoServicoAdicional(\PhpSigep\Model\ServicoAdicional::SERVICE_MAO_PROPRIA);
					$servicoAdicional->setValorDeclarado(number_format($envio['total_pacote'], 2, ',', ''));
					$servicos_adicionais[] = $servicoAdicional;
				}
				if($envio['servico_VD_pacote']){
					$servicoAdicional = new \PhpSigep\Model\ServicoAdicional();
					$servicoAdicional->setCodigoServicoAdicional(\PhpSigep\Model\ServicoAdicional::SERVICE_VALOR_DECLARADO_SEDEX);
					$servicoAdicional->setValorDeclarado(number_format($envio['total_pacote'], 2, ',', ''));
					$servicos_adicionais[] = $servicoAdicional;
				}
				//encomenda
				$encomenda = new \PhpSigep\Model\ObjetoPostal();
				$encomenda->setServicosAdicionais($servicos_adicionais);
				$encomenda->setDestinatario($destinatario);
				$encomenda->setDestino($destino);
				$encomenda->setDimensao($dimensao);
				$encomenda->setEtiqueta($etiqueta);
				if($envio['peso_pacote']==0){
					$envio['peso_pacote'] = 300;
				}
				$encomenda->setPeso(number_format($envio['peso_pacote'], 2, '.', ''));//gramas
				$encomenda->setServicoDePostagem(new \PhpSigep\Model\ServicoDePostagem($envio['id_servico_pacote']));
				$lista_encomendas[] = $encomenda;
			}
		}
		
		//plp
		$plp = new \PhpSigep\Model\PreListaDePostagem();
		$plp->setAccessData($this->login_sigep());
		$plp->setEncomendas($lista_encomendas);
		$plp->setRemetente($remetente);
		
		return $plp;
	}
	
	private function dados_produtos($params){
		$carrinho = new Cart($params->id_cart);
		$i  = 0;
		$alt = array();
		$com  = array();
		$lar = array();
		$peso = array();
		$total = 0;
		foreach ( $carrinho->getProducts() as $k => $prod ) {
			//custom 
			$profundidade = round((isset($prod['length'])?$prod['length']:$prod['depth']),2);
			$largura = round($prod['width'],2);
			$altura = round($prod['height'],2);
			$pesos = round($prod['weight'],2);
			$quantidade = isset($prod['qtd'])?$prod['qtd']:$prod['quantity'];
			$total += $prod['total'];
			//dados
			$w	 = ($largura > 0)?$largura:16;
  			$h   = ($altura > 0)?$altura:2;
  			$l   = ($profundidade > 0)?$profundidade:11;
			$p   = ($pesos > 0)?$pesos:0.1;
			$qtd = $quantidade;
			//produtos que tenha frete
			if ( $qtd > 0 && $prod['is_virtual']==0 ) {
				//se mais de um produto
				if ( $qtd > 1 ) {
					$n = $i;
					for ( $j = 0; $j < $qtd; $j++ ) {
						$alt[ $n ] = $h;
						$com[ $n ] = $w;
						$lar[ $n ] = $l;
						$peso[ $n ] = $p;
						$n++;
					}
					$i = $n;
				}else{
					//se um produto
					$alt[ $i ]  = $h;
					$com[ $i ]  = $w;
					$lar[ $i ]  = $l;
					$peso[ $i ] = $p;
				}
				$i++;
			}
		}
		$produtos_cubados = array( 'alt' => array_values( $alt ), 'com' => array_values( $com ), 'lar'  => array_values( $lar ), 'peso' => array_sum( $peso ) );
		$medidas = $this->cubagem( $produtos_cubados['alt'], $produtos_cubados['com'], $produtos_cubados['lar'] );
		$peso = $this->peso_cubado( $medidas );
		return array('medidas' => $medidas, 'total' => $total, 'peso_real' => round($produtos_cubados['peso'],2),'peso_cubado'=>round($peso,2));
	}

	private function raiz_cubica( $alt, $com, $lar, $maximos ){
		$cubagem_total = 0;
		$total_items = count( $alt );
		for ( $i = 0; $i < $total_items; $i++ ) {
			$cubagem_total += $alt[ $i ] * $com[ $i ] * $lar[ $i ];
		}
		$raiz = 0;
		$maior = max( $maximos );
		if ( 0 !== $cubagem_total && 0 < $maior ) {
			$fator = $cubagem_total / $maior;
			$raiz = round( sqrt( $fator ), 1 );
		}
		return $raiz;
	}
	
	private function cubagem( $alt, $com, $lar ){
		$cubagem     = array();
		$maximos     = array('alt' => max( $alt ), 'com'  => max( $com ), 'lar' => max( $lar ));
		$raiz        = $this->raiz_cubica( $alt, $com, $lar, $maximos );
		$maior       = array_search( max( $maximos ), $maximos, true );
		switch ( $maior ) {
			case 'alt' :
			$cubagem = array(
				'alt' => max( $alt ),
				'com'  => $raiz,
				'lar' => $raiz,
			);
			break;
			case 'com' :
			$cubagem = array(
				'alt' => $raiz,
				'com'  => max( $com ),
				'lar' => $raiz,
			);
			break;
			case 'lar' :
			$cubagem = array(
				'alt' => $raiz,
				'com'  => $raiz,
				'lar' => max( $lar ),
			);
			break;
			default :
			$cubagem = array(
				'alt' => 0,
				'com'  => 0,
				'lar' => 0,
			);
			break;
		}
		return $cubagem;
	}
	
	private function peso_cubado( $cubagem ){
		return round( ($cubagem['alt'] * $cubagem['com'] * $cubagem['lar']) / $this->fator , 2);
	}
	
	public function salvar_log($dados_log){
		if(!empty($dados_log)){
			$dados_log = is_array($dados_log)?print_r($dados_log,true):$dados_log;
			PrestaShopLogger::addLog($dados_log, 1, $this->name);
		}
		return true;
	}
		
	public function servicos_cadastrados() {
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "sigep5_servicos` 
		WHERE status_servico = 1
		ORDER BY nome_servico ASC";
		$servicos = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		return $servicos;
	}
	
	public function transportadoras_ativadas() {
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "carrier` 
		LEFT JOIN `" . _DB_PREFIX_ . "sigep5_mapear` ON(id_transportadora=id_carrier)
		WHERE deleted = 0 AND active = 1
		ORDER BY name ASC";
		$servicos = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		return $servicos;
	}
	
	public function mapear_transportadoras(){
		$servicos = $this->servicos_cadastrados();
		$transportadoras = $this->transportadoras_ativadas();
		$html = '<div class="alert alert-info"><i class="fa fa-info"></i> Selecione o servi&ccedil;o de entrega Correios correspondente a modalidade de entrega da transportadora em sua loja, feito todo o relacionamento salve as configura&ccedil;&otilde;es e lembre-se que sempre que instalar um novo m&oacute;dulo de entrega ou atualizar ou editar qualquer transportadora na loja revisar este relacionamento!</div>';
		$html .= '<table style="border: 1px solid #CCC !important;" class="table table-striped">';
		$html .= '<thead><tr><th>Transportadora</th><th>Servi&ccedil;o Correios Correspondente</th></tr></thead>';
		$html .= '<tbody>';
		if(count($transportadoras)==0){
			$html .= '<tr><td colspan="4">Nenhuma transportadora ativada foi encontrada em sua loja, verifique se existe algum m&oacute;dulo de entrega cadastrado!</td></tr>';
		}else{
			foreach($transportadoras as $k=>$v){
				$html .= '<tr><td>'.$v['name'].' '.(!empty($v['external_module_name'])?'('.$v['external_module_name'].')':'').'</td><td><select name="SIGEPPRO5_MAPEAR_TRANSPORTADORAS['.$v['id_carrier'].']">';
				$html .= '<option value="0">Nenhuma transportadora relacionada</option>';
				foreach($servicos as $kk=>$vv){
					if($v['cod_servico']==$vv['cod_servico']){
						$html .= '<option value="'.$vv['cod_servico'].'" selected>'.$vv['cod_servico'].' - '.$vv['nome_servico'].'</option>';
					}else{
						$html .= '<option value="'.$vv['cod_servico'].'">'.$vv['cod_servico'].' - '.$vv['nome_servico'].'</option>';
					}						
				}
				$html .= '</select></td></tr>';
			}
		}
		$html .= '</tbody>';
		$html .= '</table>';
		return $html;
	}
	
	public function lista_servicos_correios(){
		$servicos = $this->servicos_cadastrados();
		$html = '<div class="alert alert-info"><i class="fa fa-info"></i> Lembre-se que sempre que atualizar de ambiente entre homologa&ccedil;&atilde;o e produ&ccedil;&atilde;o os servi&ccedil;os devem ser atualizados novamente, para isso <a onclick="atualizar_servicos_sigep()">clique aqui</a>!</div>';
		$html .= '<table style="border: 1px solid #CCC !important;" class="table table-striped">';
		$html .= '<thead><tr><th>Cod. Servi&ccedil;o</th><th>Servi&ccedil;o</th><th>Vigencia</th></tr></thead>';
		$html .= '<tbody>';
		if(count($servicos)==0){
			$html .= '<tr><td colspan="4">Nenhum servi&ccedil;o Correios SIGEP cadastrado, caso j&aacute; tenha configurado os dados de seu contrato <a onclick="atualizar_servicos_sigep()">clique aqui</a> para atualizar!</td></tr>';
		}else{
			foreach($servicos as $k=>$v){
				$html .= '<tr><td>'.$v['cod_servico'].'</td> <td>'.$v['nome_servico'].'</td> <td>'.$v['fim_contrato_servico'].'</td> </tr>';
			}
		}
		$html .= '</tbody>';
		$html .= '</table>';
		return $html;
	}
	
	public function status_nomes() {
		global $cookie;
		$resultado = Db::getInstance()->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'order_state` AS a,`'._DB_PREFIX_.'order_state_lang` AS b WHERE b.id_lang = "'.$cookie->id_lang.'" AND a.deleted = "0" AND a.id_order_state=b.id_order_state');
		$status = array();
		$i=1;
		$status[0]['id'] = 0;
		$status[0]['name'] = 'Nenhum (desativado)';
		foreach($resultado as $k=>$v){
			$status[$i]['id'] = $v['id_order_state'];
			$status[$i]['name'] = $v['name'];
			$i++;
		}
		return $status;
	}
	
	public function diretorias() {
		//diretorias
		$diretorias = array();
		$diretorias['ADMINISTRACAO_CENTRAL'] = 1;
		$diretorias['ACRE']                  = 3;
		$diretorias['ALAGOAS']               = 4;
		$diretorias['AMAZONAS']              = 6;
		$diretorias['AMAPA']                 = 5;
		$diretorias['BAHIA']                 = 8;
		$diretorias['BRASILIA']              = 10;
		$diretorias['CEARA']                 = 12;
		$diretorias['ESPIRITO_SANTO']        = 14;
		$diretorias['GOIAS']                 = 16;
		$diretorias['MARANHAO']              = 18;
		$diretorias['MINAS_GERAIS']          = 20;
		$diretorias['MATO_GROSSO_DO_SUL']    = 22;
		$diretorias['MATO_GROSSO']           = 24;
		$diretorias['PARA']                  = 28;
		$diretorias['PARAIBA']               = 30;
		$diretorias['PERNAMBUCO']            = 32;
		$diretorias['PIAUI']                 = 34;
		$diretorias['PARANA']                = 36;
		$diretorias['RIO_DE_JANEIRO']        = 50;
		$diretorias['RIO_GRANDE_DO_NORTE']   = 60;
		$diretorias['RONDONIA']              = 26;
		$diretorias['RORAIMA']               = 65;
		$diretorias['RIO_GRANDE_DO_SUL']     = 64;
		$diretorias['SANTA_CATARINA']        = 68;
		$diretorias['SERGIPE']               = 70;
		$diretorias['SAO_PAULO_INTERIOR']    = 74;
		$diretorias['SAO_PAULO']             = 72;
		$diretorias['TOCANTINS']             = 75;
        foreach($diretorias AS $k=>$v){
            $campos[] = array('id'=>$v,'campo'=>$v.' - '.str_replace('_',' ',$k));
        }
        return $campos;
    }
	
	public function campos_extras(){
        //querys
        $campos[] = array('id'=>'','campo'=>'Campo Padr&atilde;o');
        $clientes = Db::getInstance()->executeS("SHOW COLUMNS FROM `" . _DB_PREFIX_ . "customer`");	
        foreach($clientes AS $k=>$v){
            $input = _DB_PREFIX_.'customer.'.$v['Field'].'';
            $campos[] = array('id'=>$input,'campo'=>$input);
        }
        $enderecos = Db::getInstance()->executeS("SHOW COLUMNS FROM `" . _DB_PREFIX_ . "address`");
        foreach($enderecos AS $k=>$v){
            $input = _DB_PREFIX_.'address.'.$v['Field'].'';
            $campos[] = array('id'=>$input,'campo'=>$input);
        }
        return $campos;
    }
	
	public function xml_plp($plp){
		$dados = array(
			'idPlpMaster' => (int)($plp),
			'usuario' => trim(Configuration::get('SIGEPPRO5_USUARIO')),
			'senha' => trim(Configuration::get('SIGEPPRO5_SENHA')),
		);
		return $this->ponte('solicitaXmlPlp',$dados);
	}
	
	public function status_sigep(){
		//sleep
		sleep(3);
		//dados
		$dados = array(
			'idContrato' => trim(Configuration::get('SIGEPPRO5_CONTRATO')),
			'idCartaoPostagem' => trim(Configuration::get('SIGEPPRO5_CARTAO')),
			'usuario' => trim(Configuration::get('SIGEPPRO5_USUARIO')),
			'senha' => trim(Configuration::get('SIGEPPRO5_SENHA')),
		);
		//consultar
		$resultado = $this->ponte('buscaCliente',$dados,false);
		//resultado
		if($resultado['erro']==false){
			$servicos = $resultado['dados']->contratos->cartoesPostagem->servicos;
			$lista_servicos = array();
			foreach ($servicos as $k=>$servico) {
				$lista_servicos[] = $servico->descricao;
			}
			echo '<center>';
			echo '<h1 style="color:green">Acesso Sigep OK</h1>';
			echo '<p><b>Servicos:</b> <i>'.implode(', ',$lista_servicos).'</i></p>';
			echo '<p><b>Header:</b> <i>'.print_r($resultado['soap_response'],true).'</i></p>';
			echo '<center>';
		}else{
			echo '<center>';
			echo '<h1 style="color:red">Erro de Acesso Sigep</h1>';
			echo '<p><b>Erro:</b> '.$resultado['mensagem'].'</p>';
			echo '<p><b>Aten&ccedil;&atilde;o:</b> <i>Caso o erro reportado seja relacionado a credenciais Sigep acesse as configura&ccedil;&otilde;es do modulo e as corrija, caso seja de conectividade tente novamente mais tarde!</i></p>';
			echo '<p><b>Header:</b> <i>'.print_r($resultado['soap_response'],true).'</i></p>';
			echo '<center>';
		}
		exit;
	}
	
	public function paraarray($dados){
		return json_decode(json_encode($dados),true);
	}
	
	public function validar_endereco($dados){
		if(empty($dados['nome'])){
			return false;
		}elseif(empty($dados['logradouro'])){
			return false;
		}elseif(empty($dados['numero'])){
			return false;
		}elseif(empty($dados['bairro'])){
			return false;
		}elseif(empty($dados['cidade'])){
			return false;
		}elseif(empty($dados['uf'])){
			return false;
		}elseif(empty($dados['cep'])){
			return false;
		}elseif(empty($dados['id_servico_pacote'])){
			return false;
		}else{
			return true;
		}
	}
	
	public function ponte($funcao,$dados,$debug=true){
		//define a url
		$modo = Configuration::get('SIGEPPRO5_AMBIENTE');
		if($modo=='H'){
			$url_sigep = 'https://apphom.correios.com.br/SigepMasterJPA/AtendeClienteService/AtendeCliente?wsdl';
		}else{
			$url_sigep = 'https://apps.correios.com.br/SigepMasterJPA/AtendeClienteService/AtendeCliente?wsdl';	
		}
		$opts = array(
			'ssl' => array(
				//'ciphers'           =>'RC4-SHA', // comentado o parâmetro ciphers devido ao erro que ocorre quando usado dados de ambiente de produção em um servidor local conforme issue https://github.com/stavarengo/php-sigep/issues/35#issuecomment-290081903
				'verify_peer'       =>false,
				'verify_peer_name'  =>false
			),
			'http' => array(
				'protocol_version'=>'1.1',
				'header' => 'Connection: Close'
			)
		);
		// SOAP 1.1 client
		$params = array (
			'verifypeer'            => false, 
			'verifyhost'            => false, 
			'soap_version'          => SOAP_1_1, 
			'trace'                 => true,
			'exceptions'            => true,
			"connection_timeout"    => 20, 
			'stream_context'        => stream_context_create($opts) 
		);
		$soapClient = new SoapClient($url_sigep,$params);	
		$xml = array();
		try { 
			$info = $soapClient->__call($funcao, array($dados)); 
			$xml['erro']=false;
			$xml['dados']=$info->return;
			$xml['funcao'] = $funcao;
			$xml['original'] = http_build_query($dados);
			$xml['soap_response'] = $soapClient->__getLastResponseHeaders();
		} catch (SoapFault $fault) { 
			$xml['erro']=true;
			$xml['mensagem']=$fault->getMessage();
			$xml['funcao'] = $funcao;
			$xml['original'] = http_build_query($dados);
			$xml['mensagem_tipo']='fault';
			$xml['soap_response'] = $soapClient->__getLastResponseHeaders();
		} catch (Exception $e) { 
			$xml['erro']=true;
			$xml['mensagem']=$e->getMessage();
			$xml['funcao'] = $funcao;
			$xml['original'] = http_build_query($dados);
			$xml['mensagem_tipo']='exception';
			$xml['soap_response'] = $soapClient->__getLastResponseHeaders();
		}
		
		//debug
		if(Configuration::get('SIGEPPRO5_STATUS_DEBUG')){
			$this->salvar_log('Debug Sigep ['.$funcao.'] em '.date('d/m/Y H:i:s').'');
			$this->salvar_log( http_build_query($xml) );
		}
			
		return $xml;
	}
	
	public function ponte_frete($dados){	
		//define a url
		$url = 'http://ws.correios.com.br/calculador/CalcPrecoPrazo.asmx?wsdl';
		$opts = array(
			'ssl' => array(
				//'ciphers'           =>'RC4-SHA', // comentado o parâmetro ciphers devido ao erro que ocorre quando usado dados de ambiente de produção em um servidor local conforme issue https://github.com/stavarengo/php-sigep/issues/35#issuecomment-290081903
				'verify_peer'       =>false,
				'verify_peer_name'  =>false
			),
			'http' => array(
				'protocol_version'=>'1.1',
				'header' => 'Connection: Close'
			)
		);
		// SOAP 1.1 client
		$params = array (
			'verifypeer'            => false, 
			'verifyhost'            => false, 
			'soap_version'          => SOAP_1_1, 
			'trace'                 => true,
			'exceptions'            => true,
			"connection_timeout"    => 20, 
			'stream_context'        => stream_context_create($opts) 
		);
		$soapClient = new SoapClient($url,$params);		
		$xml = array();
		try { 
			$info = $soapClient->__call('CalcPrecoPrazo', array($dados)); 
			$xml['erro']=false;
			$xml['dados']=json_decode(json_encode($info->CalcPrecoPrazoResult),true);
			$xml['soap_response'] = $soapClient->__getLastResponseHeaders();
		} catch (SoapFault $fault) { 
			$xml['erro']=true;
			$xml['mensagem']=$fault->getMessage();
			$xml['mensagem_tipo']='fault';
			$xml['soap_response'] = $soapClient->__getLastResponseHeaders();
		} catch (Exception $e) { 
			$xml['erro']=true;
			$xml['mensagem']=$e->getMessage();
			$xml['mensagem_tipo']='exception';
			$xml['soap_response'] = $soapClient->__getLastResponseHeaders();
		}
		//debug
		if(Configuration::get('SIGEPPRO5_STATUS_DEBUG')){
			$this->salvar_log('Debug Frete Sigep em '.date('d/m/Y H:i:s').'');
			$this->salvar_log( http_build_query($xml) );
		}
		return $xml;
	}
}
?>