<?php
class AdminSigepPro5PLPsController extends ModuleAdminController
{
	public function __construct() {
        $this->bootstrap = true;
		parent::__construct();
	}
	
	public function initPageHeaderToolbar(){
        parent::initPageHeaderToolbar();
		if (empty($this->display)) {
			$this->page_header_toolbar_btn['sigep_status_conta'] = array(
				'class' => 'fix_icons',
                'href' => 'javascript:sigep_status_conta()',
                'desc' => $this->l('Status Sigep', null, null, false),
                'icon' => 'fa fa-globe'
            );
        }
    }
	
	public function createTemplate($tpl_name){
        if (file_exists($this->getTemplatePath() . $tpl_name) && $this->viewAccess())
                return $this->context->smarty->createTemplate($this->getTemplatePath() . $tpl_name, $this->context->smarty);
            return parent::createTemplate($tpl_name);
    }
	
	public function initContent() {
        parent::initContent();
		$acao = isset($_REQUEST['acao'])?$_REQUEST['acao']:'plps';
		if($acao=='plps'){
			return $this->plps();
		}elseif($acao=='cancelar_objeto_plp'){
			return $this->cancelar_objeto_plp();
		}elseif($acao=='imprimir_plp'){
			return $this->imprimir_plp();
		}elseif($acao=='imprimir_etiquetas'){
			return $this->imprimir_etiquetas();
		}elseif($acao=='imprimir_ar'){
			return $this->imprimir_ar();
		}elseif($acao=='ver_xml_plp'){
			return $this->ver_xml_plp();
		}elseif($acao=='status_sigep'){
			return $this->module->status_sigep();
		}elseif($acao=='detalhes_pedido'){
			return $this->detalhes_pedido();
		}
    }
	
	private function detalhes_pedido(){
		Tools::redirectAdmin($this->context->link->getAdminLink('AdminOrders', true).'&id_order='.(int)$_GET['id'].'&vieworder');
		exit;
	}
	
	private function ver_xml_plp(){
		$resultado = $this->module->xml_plp((int)$_GET['plp']);
		if($resultado['erro']==1){
			//log
			$this->module->salvar_log('Erro ao consultar XML PLP: '.(int)($_GET['plp']).'');
			die($resultado['mensagem']);
		}else{
			//processa o xml
			$xml = $resultado['dados'];
			echo 'XML da PLP '.(int)($_GET['plp']).' processado com sucesso junto aos Correios!<br>';
			echo '<textarea class="form-control" style="width:100%;min-height:200px !important;">'.utf8_encode($xml).'</textarea>';
			exit;
		}
		exit;
	}
	
	private function imprimir_ar(){
		$plps = $this->module->array_plps();
		$pdf = new \PhpSigep\Pdf\AvisoRecebimento($plps);
		$pdf->render('I');
		exit;		
	}
	
	private function imprimir_etiquetas(){
		$logo = Configuration::get('SIGEPPRO5_LOGOMARCA');
		if(!empty($logo) && file_exists(_PS_IMG_DIR_.$logo)){
			$logoFile = _PS_IMG_DIR_.$logo;
		}else{
			$logoFile = $this->module->diretorio.'logo.png';
		}
		$plps = $this->module->array_plps();
		if(Configuration::get('SIGEPPRO5_ETIQUETA')=='A1'){
			$pdf = new \PhpSigep\Pdf\CartaoDePostagem2018($plps, (int)$_GET['plp'], $logoFile, array());
			$pdf->render('I');
			exit;
		}else{
			$layoutChancela = array();
			$pdf = new \PhpSigep\Pdf\CartaoDePostagem2016($plps, (int)$_GET['plp'], $logoFile, $layoutChancela);
			$fileName = tempnam(sys_get_temp_dir(), 'phpsigep') . '.pdf';
			$pdf->render('F',$fileName);
			unset($pdf);
			$pdf = new \PhpSigep\PDF\ImprovedFPDF('P', 'mm', 'Letter' );
			$pageCount = $pdf->setSourceFile($fileName);
			$pdf->AddPage();
			$pdf->SetFillColor(0,0,0);
			$pdf->SetFont('Arial','B',16);
			for($i=1;$i<=$pageCount;$i++) {
				$tplIdx = $pdf->importPage($i, '/MediaBox');
				$mod = $i % 4;
				switch ($mod) {
					case 0:
						//A4: 210(x) × 297(y)
						//Letter: 216 (x) × 279 (y)
						$pdf->useTemplate($tplIdx, 110, 145, 105, 138, true);
						if ($i !== $pageCount) {
							$pdf->AddPage();
							$pdf->SetFillColor(0,0,0);
							$pdf->SetFont('Arial','B',16);
						}
						break;
					case 1:
						$pdf->useTemplate($tplIdx, 10, 10, 105, 138, true);
						break;
					case 2:
						$pdf->useTemplate($tplIdx, 110, 10, 105, 138, true);
						break;
					case 3:
						$pdf->useTemplate($tplIdx, 10, 145, 105, 138, true);
						break;
				}
			}
			$pdf->Output('teste.pdf', 'I');
			exit;
		}
	}
	
	private function imprimir_plp(){
		$logo = Configuration::get('SIGEPPRO5_LOGOMARCA');
		if(!empty($logo) && file_exists(_PS_IMG_DIR_.$logo)){
			$logoFile = _PS_IMG_DIR_.$logo;
		}else{
			$logoFile = $this->module->diretorio.'logo.png';
		}
		$plps = $this->module->array_plps();
		$pdf  = new \PhpSigep\Pdf\ListaDePostagem($plps, (int)$_GET['plp']);
		$pdf->render('I');
		exit;
	}
	
	private function cancelar_objeto_plp(){
		//dados 
		$objeto = isset($_POST['objeto'])?$_POST['objeto']:'';
		$plp = isset($_POST['plp'])?$_POST['plp']:'';
		$envio = isset($_POST['envio'])?$_POST['envio']:'';
		//consulta a plp 
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "sigep5_plps` 
		WHERE uniq_id_plp = '".(int)$plp."' AND status_plp = 'Pendente'";
        $row = Db::getInstance()->getRow($sql);
		if(!$row){
			$erro = array('erro'=>true,'log'=>'Ops, PLP não encontrada no banco de dados ou já encontra-se processada junto aos Correios!');
		}else{
			//cancelar objeto individual
			$atualizar_pagina = false;
			if(!empty($objeto) && $plp > 0 && $envio > 0){
				$dados = array(
					'idPlp' => $plp,
					'numeroEtiqueta' => trim($objeto),
					'usuario' => trim(Configuration::get('SIGEPPRO5_USUARIO')),
					'senha' => trim(Configuration::get('SIGEPPRO5_SENHA')),
				);
				$resultado = $this->module->ponte('cancelarObjeto',$dados);
				//trata o resultado
				if($resultado['erro']){
					//log
					$this->module->salvar_log('[Sigep Cancelar Objeto] Erro ao cancelar objeto da PLP '.$plp.' e Objeto '.$objeto.': '.$resultado['mensagem'].'');
					//erro
					$erro = array('erro'=>true,'log'=>$resultado['mensagem']);
				}elseif(isset($resultado['dados']) && $resultado['dados']==1){
					
					//remove o pacote da listagem
					$envios = explode(',',$row['ids_pacotes']);
					if (($key = array_search($envio, $envios)) !== false) {
						unset($envios[$key]);
					}
					
					//atualiza o envio 
					Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "sigep5_pacotes` SET cod_rastreio_pacote = '', cod_rastreio_pacote_dv = '', dv_rastreio_pacote = 0, pacote_fechado = 0, status_pacote = 0 WHERE cod_rastreio_pacote_dv = '".$objeto."'");
					Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "sigep5_plps` SET ids_pacotes = '".implode(',',$envios)."' WHERE uniq_id_plp = '".(int)$plp."'");
					
					//remove no banco de dados a plp
					if(count($envios)==0){
						$atualizar_pagina = true;
						Db::getInstance()->execute("DELETE FROM `" . _DB_PREFIX_ . "sigep5_plps` WHERE uniq_id_plp = '".(int)$plp."'");
					}
					
					//log
					$this->module->salvar_log('[Sigep Cancelar Objeto] Objeto da PLP '.$plp.' cancelado com sucesso: '.$objeto.'');
					
					//cria um historico no pedido e o atualiza
					$dados_pacote = $this->module->dados_pacote((int)$envio);
					
					//cria um log para o pedido
					if($dados_pacote['id_pedido_pacote'] > 0){
						$order = new Order($dados_pacote['id_pedido_pacote']);
						if($order){
							$msglog = 'Objeto Correios '.$objeto.' para a PLP: '.$plp.' foi cancelado e removido da mesma em '.date('d/m/Y H:i').'';
							$msg = new Message();
							$message = strip_tags($msglog, '<br>');
							if (($message)){
								$msg->message = $message;
								$msg->id_order = intval($order->id);
								$msg->private = 1;
								$msg->add();
							}
						}
					}
					
					//mensagem 
					$erro = array('erro'=>false,'atualizar'=>$atualizar_pagina,'log'=>'Objeto '.$objeto.' cancelado com sucesso na PLP selecionada!','objeto'=>$objeto);
				}else{
					//erro
					$erro = array('erro'=>true,'log'=>'Erro desconhecido ao cancelar objeto da PLP! Tente novamente.');
				}
			}elseif(empty($objeto) && $plp > 0 && empty($envio)){
				//cancela uma plp completa
					//um dia futuro
				//cancela uma plp completa
			}else{
				//erro
				$erro = array('erro'=>true,'log'=>'Ops, PLP não encontrada!');
			}
		}
		die(json_encode($erro));
		exit;
	}
	
	private function plps(){
		//layout
        $tpl = $this->createTemplate('plps.tpl');
		//filtra a plp 
		$where = '';
		if(isset($_GET['plp'])){
			$where .= ' AND uniq_id_plp = '.pSQL($_GET['plp']).'';
		}
		//qtd registros
		$sql = "SELECT COUNT(*) AS total FROM `" . _DB_PREFIX_ . "sigep5_plps` WHERE 1 = 1 $where ORDER BY id_plp DESC";
        $row = Db::getInstance()->getRow($sql);
		$total_envios = $row['total'];
		//inicio paginacao 
		$pagina = (int)(isset($_GET['pagina'])?$_GET['pagina']:1);
		$registros = (int)Configuration::get('SIGEPPRO5_QTD_PAGINA');
		$registros = ($registros==0)?20:$registros;
		$inicio = ($registros*($pagina-1));
		$paginas = ceil( $total_envios / $registros );
		//registros
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "sigep5_plps` 
		WHERE 1 = 1 $where ORDER BY id_plp DESC LIMIT $inicio,$registros";
		$plps_bd = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		//processa outros dados
		$plps = array();
		foreach($plps_bd as $k=>$v){
			//envios 
			$envios = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS("SELECT * FROM `" . _DB_PREFIX_ . "sigep5_pacotes`
			LEFT JOIN `" . _DB_PREFIX_ . "sigep5_pedidos` ON(id_pacote IN(ids_pacotes))
			LEFT JOIN `" . _DB_PREFIX_ . "sigep5_servicos` ON(id_servico_pacote=cod_servico)
			WHERE FIND_IN_SET(id_pacote,'".$v['ids_pacotes']."')");
			//plps
			$v = array_merge($v,array('envios'=>$envios,'envios_ar'=>$this->envios_com_ar($v['ids_pacotes'])));
			$plps[] = $v;
		}
		$tpl->assign(array(
			'plps' => $plps,
			'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/sigeppro5',
			'pagina' => $pagina,
			'total_plps' => $total_envios,
			'paginas' => $paginas,
			'extra'	=> '',
		));
		$this->context->smarty->assign(array('content' => $tpl->fetch()));
	}
	
	private function envios_com_ar($envios){
		$envios = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS("SELECT * FROM `" . _DB_PREFIX_ . "sigep5_pacotes` WHERE FIND_IN_SET(id_pacote,'".$envios."')");
		$pacotes = array();
		foreach($envios AS $envio){
			if($envio['servico_AR_pacote']){
				$pacotes[]=$envio['id_pacote'];
			}
		}
		return implode(',',$pacotes);
	}
}
?>