<?php
/**
* Cart Rule for First Order
*
* @author    Kijam
* @copyright 2017 Kijam
* @license   Commercial use allowed (Non-assignable & non-transferable), can modify source-code but cannot distribute
*            modifications (derivative works).
*/

if (!defined('_PS_VERSION_')) {
    exit;
}
class CartRuleFirstOrder extends Module
{
    public function __construct()
    {
        $this->name = 'cartrulefirstorder';
        $this->tab = 'front_office_features';
        $this->version = '1.0.2';
        $this->author = 'Kijam';
        //$this->module_key = '';

        parent::__construct();

        $this->displayName = $this->l('Cart Rule for First Order');
        $this->description = $this->l('This module enable in Cart Rule the featured "First Order"');
    }

    public function install()
    {
        if (version_compare(PHP_VERSION, '5.3') < 0) {
            $this->_errors[] = $this->l('This module only work on PHP 5.3 or later.');
            return false;
        }
        if (version_compare(_PS_VERSION_, '1.5.0.15') < 0) {
            $this->_errors[] = $this->l('This module only work on Prestashop 1.5.0.15 or later.');
            return false;
        }
        $db_created = Db::getInstance()->Execute('CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'kfirstorder` (
				`id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
				`id_shop` int(11) NOT NULL,
				`id_cart_rule` int(11) NOT NULL,
				INDEX(id_shop),
				INDEX(id_cart_rule),
                UNIQUE(id_shop, id_cart_rule)
				)');
        if (!$db_created) {
            $this->_errors[] = $this->l('Failed to create the table in the Database');
            return false;
        }
        return parent::install()
                && $this->registerHook('displayBackOfficeTop')
                && $this->registerHook('actionCustomerAccountAdd')
                && ($this->registerHook('actionCustomerAccountUpdate') || true)
                && $this->registerHook('actionAuthentication');
    }
    public function hookActionCustomerAccountAdd($params = array())
    {
        CartRule::autoRemoveFromCart(Context::getContext());
    }
    public function hookActionCustomerAccountUpdate($params = array())
    {
        CartRule::autoRemoveFromCart(Context::getContext());
    }
    public function hookActionAuthentication($params = array())
    {
        CartRule::autoRemoveFromCart(Context::getContext());
    }
    public function checkUpdate($id_cart_rule = false)
    {
        if ((int)$id_cart_rule > 0 && Tools::isSubmit('only_first_order')) {
            $id_shop = Context::getContext()->shop->id;
            if ((bool)Tools::getValue('only_first_order')) {
                Db::getInstance()->Execute('REPLACE INTO `'._DB_PREFIX_.'kfirstorder` (`id_shop`, `id_cart_rule`)
				            VALUES ('.(int)$id_shop.', '.(int)$id_cart_rule.')');
            } else {
                Db::getInstance()->Execute('DELETE FROM `'._DB_PREFIX_.'kfirstorder` WHERE
					id_shop = \''.(int)$id_shop.'\' AND
					id_cart_rule = '.(int)$id_cart_rule);
            }
        }
    }
    public function hookDisplayBackOfficeTop()
    {
        if (Tools::isSubmit('id_cart_rule') || Tools::isSubmit('addcart_rule')) {
            $id_shop = Context::getContext()->shop->id;
            $id_cart_rule = (int)Tools::getValue('id_cart_rule');
            $value = (int)Db::getInstance()->getValue('SELECT `id`
							FROM `'._DB_PREFIX_.'kfirstorder`
							WHERE id_shop = \''.(int)$id_shop.'\' AND
							id_cart_rule = \''.pSQL($id_cart_rule).'\'') > 0;
            return '
				<script type="text/javascript">
					$(function() {
                        $("#cart_rule_informations").append(
                            \'<div class="form-group">\'+
                                \'<label class="control-label col-lg-3">\'+
                                    \'<span class="label-tooltip" data-toggle="tooltip"\'+
                                    \'title="'.$this->l('Only new users or users with first order can apply this coupon.').'">\'+
                                    \''.$this->l('Only First Order').'\'+
                                    \'</span>\'+
                                \'</label>\'+
                                \'<div class="col-lg-9">\'+
                                    \'<span class="switch prestashop-switch fixed-width-lg">\'+
                                        \'<input type="radio" name="only_first_order" id="only_first_order_on" value="1"\'+
                                        \' '.($value?'checked="checked"':'').' />\'+
                                        \'<label class="t" for="only_first_order_on">Sí</label>\'+
                                        \'<input type="radio" name="only_first_order" id="only_first_order_off" value="0"\'+
                                        \' '.(!$value?'checked="checked"':'').'  />\'+
                                        \'<label class="t" for="only_first_order_off">No</label>\'+
                                        \'<a class="slide-button btn"></a>\'+
                                    \'</span>\'+
                                \'</div>\'+
                            \'</div>\'
                        );
                    });
                </script>
            ';
        }
        return '<!-- first order cart rule not detected -->';
    }
    public function uninstall()
    {
        Db::getInstance()->Execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'kfirstorder`');
        return parent::uninstall();
    }
    public function getErrorMessage()
    {
        return $this->l('Sorry, this voucher only work in the first order.');
    }
    public function numOrders($context, $id_customer)
    {
        $customer = new Customer($id_customer);
        $list_customers = Customer::getCustomersByEmail($customer->email);
        $total_orders = 0;
        foreach ($list_customers as $c) {
            $total_orders += count(Order::getCustomerOrders($c['id_customer'], false, $context));
        }
        return $total_orders;
    }
    public function checkCartRules($context = false, $id_cart_rule = false, $check_all = true, $display_error = false)
    {
        if (!$context) {
            $context = Context::getContext();
        }
        $id_shop = $context->shop->id;
        $check_ids = (int)$id_cart_rule > 0?array((int)$id_cart_rule):array();
        $otherCartRules = $context->cart->getCartRules();
        if ($check_all && count($otherCartRules)) {
            foreach ($otherCartRules as $otherCartRule) {
                if ($otherCartRule['id_cart_rule'] != $id_cart_rule) {
                    $check_ids[] = (int)$otherCartRule['id_cart_rule'];
                }
            }
        }
        foreach ($check_ids as $id_cart_rule) {
            $value = (int)Db::getInstance()->getValue('SELECT `id`
                            FROM `'._DB_PREFIX_.'kfirstorder`
                            WHERE id_shop = \''.(int)$id_shop.'\' AND
                            id_cart_rule = \''.pSQL($id_cart_rule).'\'') > 0;
            if ($value && $this->numOrders($context, $context->cart->id_customer) > 0) {
                if (!Order::getOrderByCartId($context->cart->id)) {
                    $context->cart->removeCartRule($id_cart_rule);
                }
                if (version_compare(_PS_VERSION_, '1.7.1.0') < 0) {
                    return (!$display_error) ? false : Tools::displayError($this->getErrorMessage());
                } else {
                    return (!$display_error) ? false : $this->trans(
                        $this->getErrorMessage(),
                        array(),
                        'Shop.Notifications.Error'
                    );
                }
            }
        }
        return 'KOK';
    }
    public function checkAddCartRule(
        $cart,
        $id_cart_rule
    ) {
        $context = Context::getContext();
        $id_shop = $context->shop->id;
        $value = (int)Db::getInstance()->getValue('SELECT `id`
                        FROM `'._DB_PREFIX_.'kfirstorder`
                        WHERE id_shop = \''.(int)$id_shop.'\' AND
                        id_cart_rule = \''.pSQL($id_cart_rule).'\'') > 0;
        return !$value || $this->numOrders($context, $cart->id_customer) == 0;
    }
    public function overrideCheckValidity(
        Context $context,
        $alreadyInCart = false,
        $display_error = true,
        $check_carrier = true,
        $id_cart_rule = 0,
        $original_result = null
    ) {
        static $is_recursive = false;
        if ($is_recursive) {
            return $original_result;
        }
        $is_recursive = true;
        if ($context->cart->id_customer) {
            $id_shop = $context->shop->id;
            $result = $this->checkCartRules($context, $id_cart_rule, true, $display_error);
            if ($result !== 'KOK') {
                $is_recursive = false;
                return $result;
            }
        }
        $is_recursive = false;
        return $original_result;
    }
}
