<?php
class CieloApiPro5Validar_DebitoModuleFrontController extends ModuleFrontController{

	public $ssl = true;
	
	public function aplicarDesconto($cart)
	{
		if(!$cart->id || $cart->id==0){
			return false;
		}
		$total = (float)abs(Configuration::get("CIELOAPIPRO5_DESC_DEB"));
		if($total > 0){
			if(CartRule::cartRuleExists('DESDEBT-'.$cart->id)){
				return false;
			}
			$rule = 'V0C'.(int)($cart->id_customer).'O'.(int)($cart->id);
			if(CartRule::cartRuleExists($rule)){
				return false;
			}
			$name='DESDEBT-'.$cart->id;
			$languages=Language::getLanguages();
			foreach ($languages as $key => $language) {
				$arrayName[$language['id_lang']]= $rule;
			}
			$voucher=new CartRule();
			$voucher->description = (string)($name);
			$voucher->reduction_amount = 0;
			$voucher->reduction_percent = $total;
			$voucher->name=$arrayName;
			$voucher->id_customer=(int)($cart->id_customer);
			$voucher->id_currency=(int)($cart->id_currency);
			$voucher->quantity=1;
			$voucher->quantity_per_user=1;
			$voucher->cumulable=0;
			$voucher->cumulable_reduction=0;
			$voucher->minimum_amount=0;
			$voucher->active=1;
			$now=time();
			$voucher->date_from=date("Y-m-d H:i:s",$now);
			$voucher->date_to=date("Y-m-d H:i:s",$now+(3600*24));
			$voucher->code='V'.(int)($voucher->id).'C'.(int)($cart->id_customer).'O'.$cart->id;
			if($voucher->add()){
				$cart->addCartRule((int)$voucher->id);
			}
		}
	}
    
    public function CartaoLoja5($bandeira,$tipo_parcela,$debito=false){
        $bandeira = strtoupper($bandeira);
        switch($bandeira){

        case 'VISA':
        $op = 'visa';
        $autorizar = 3;
        $parcela = $tipo_parcela;
        break;

        case 'ELECTRON':
        case 'VISAELECTRON':
        $op = 'visa';
        $autorizar = 2;
        $parcela = 'A';
        break;

        case 'ELODEBITO':
        $op = 'elo';
        $autorizar = 2;
        $parcela = 'A';
        break;

        case 'MASTERCARD':
        $op = 'mastercard';
        $autorizar = 3;
        $parcela = $tipo_parcela;
        break;

        case 'MAESTRO':
        $op = 'mastercard';
        $autorizar = 2;
        $parcela = 'A';
        break;

        case 'ELO':
        $op = 'elo';
        $autorizar = 3;
        $parcela = $tipo_parcela;
        break;

        case 'DINERS':
        $op = 'diners';
        $autorizar = 3;
        $parcela = $tipo_parcela;
        break;

        case 'DISCOVER':
        $op = 'discover';
        $autorizar = 3;
        $parcela = $tipo_parcela;
        break;

        case 'AMEX':
        $op = 'amex';
        $autorizar = 3;
        $parcela = $tipo_parcela;
        break;

        case 'AURA':
        $op = 'aura';
        $autorizar = 3;
        $parcela = $tipo_parcela;
        break;

        case 'JCB':
        $op = 'jcb';
        $autorizar = 3;
        $parcela = $tipo_parcela;
        break;

        }
        return array('cc'=>$op,'au'=>$autorizar,'tp'=>$parcela);
    }
	
	public function initContent() {
		
		$this->display_column_left = false;
		$this->display_column_higt = false;
		
		parent::initContent();
		
		//se bandeira vazia
		if(empty($_POST["bandeira"]) || $_POST["bandeira"]=='null'){
			die('Ops, bandeira vazia! volte e tente novamente.');
		}
		
		//valida o carrinho 
		if($this->context->cart->getOrderTotal(true, Cart::BOTH) <= 0){
			die('Ops, valor do carrinho invalido!');
		}
		
		//aplica o desconto caso tenha
		$this->aplicarDesconto($this->context->cart);
		
		//chama o carrinho
		$cart = new Cart($this->context->cart->id);
		$cliente = new Customer($cart->id_customer);
		$obj = $this->module;
        $qual_pedido = $cart->id;
        
        //url de ipn 
        $ipn = Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->module->name.'/ipn.php?cart_id='.$cart->id;
        
        //ambiente
        $MID = trim(Configuration::get('CIELOAPIPRO5_ID'));
        $KEY = trim(Configuration::get('CIELOAPIPRO5_SECRET'));
        if(Configuration::get('CIELOAPIPRO5_TESTE')){
            $_POST['numero_cc'] = '1234123412341231';
            $MID = 'daaec334-ac85-4c63-9564-f4a31be7b19b';
            $KEY = 'LTFYLLACRDYCIKMHTXBRVKGQYGDHOOVTCKGZUKRK';
            $provider = 'Simulado';
            $urlweb = "https://apisandbox.cieloecommerce.cielo.com.br/1/";
        }else{
            $provider = 'Cielo';
            $urlweb = "https://api.cieloecommerce.cielo.com.br/1/";
        }
        
        //trata a parcela
        $dados_parcela = explode('|',base64_decode($_POST['parcela']));
        $parcela = $dados_parcela[0];
        $tipo_parcela = $dados_parcela[1];
        $total = $dados_parcela[2];
        $bandeira = base64_decode($dados_parcela[3]);
        $regras_cc = $this->CartaoLoja5($bandeira,$tipo_parcela);
        
        //bandeira
        switch($bandeira){
			case 'electron':
			$bandeira = 'Visa';
			break;
			case 'maestro':
            case 'Mastercard':
            case 'mastercard':
			$bandeira = 'Master';
			break;
			default:
			$bandeira = ucfirst($bandeira);
		}
        
        //processo
        $objResposta = array();
        $headers = array(
            "Content-Type" => "application/json",
            "Accept" => "application/json",
            "MerchantId" => $MID,
            "MerchantKey" => $KEY,
            "RequestId" => "",
        );
        
        //dados a enviar
		$dados['MerchantOrderId'] = $cart->id;
        $dados['Customer'] = array(
            'Name' => $cliente->firstname.' '.$cliente->lastname,
            'Email' => $cliente->email,
        );
		$dados['Payment'] = array(
			'Type' => 'DebitCard',
			'Provider' => $provider,
			'Amount' => number_format($total, 2, '', ''),
            'ReturnUrl' => $ipn,
            'DebitCard' => array(  
				 "CardNumber" => preg_replace('/\D/', '', $_POST['numero_cc']),
				 "Holder" => trim($_POST['nome_cliente']),
				 "ExpirationDate" => trim($_POST['mes_cc'].'/'.$_POST['ano_cc']),
				 "SecurityCode" => trim($_POST['codigo_cc']),
				 "Brand" => $bandeira
			)
		);
		
		//print_r($dados);
		//exit;
        
        include_once(dirname(__FILE__).'/../../classes/restclient.php' );
        $api = new RestClient(array(
            'base_url' => $urlweb, 
            'headers' => $headers,           
        ));

        $response = $api->post("sales", json_encode($dados));
        $dados_pedido = @json_decode($response->response,true);
        
		$cod = $response->status;
        if(($response->status==200 || $response->status==201) && isset($dados_pedido['Payment']['Status'])){
            $objResposta['tid'] = $dados_pedido['Payment']['Tid'];
            $objResposta['status'] = $dados_pedido['Payment']['Status'];
            $objResposta['autorizacao']['lr'] = $dados_pedido['Payment']['ReturnCode'];
            $objResposta['pan'] = $dados_pedido['Payment']['PaymentId'];
            $hash = $objResposta['pan'];
        }
        
        //se a requisicao for com sucesso
        if(isset($objResposta['tid']) && !empty($objResposta['tid'])){
            $erro = false;
            
            //status
            switch($objResposta['status']){
                case 2:
                $status_mudar = Configuration::get('CIELOAPIPRO5_PAGO');
                break;
                case 1:
                $status_mudar = Configuration::get('CIELOAPIPRO5_AU');
                break;
                case 3:
                $status_mudar = Configuration::get('CIELOAPIPRO5_NAO_PAGA');
                break;
                case 10:
                case 13:
                $status_mudar = Configuration::get('CIELOAPIPRO5_CANCELADA');
                break;
                default:
                $status_mudar = Configuration::get('CIELOAPIPRO5_INICIADA');
            }
			
			//print_r($dados_pedido);
			//exit;
            
            //define o meio
            $meio = 'Cielo - '.ucfirst($_POST["bandeira"]).' Débito';
            
            //cria o pedido de acordo com o status moip
            $qual_pedido = $cart->id;
            $total_pedido = $this->context->cart->getOrderTotal(true, Cart::BOTH);
            $obj->validateOrder((int)$cart->id, $status_mudar, $total_pedido, $meio, null, array(), null, false, $cliente->secure_key);
            
            //se autenticada
            $requer_autenticar = false;
            if(isset($dados_pedido['Payment']['AuthenticationUrl'])){
                $requer_autenticar = true;
                $url_autenticar_cielo = $dados_pedido['Payment']['AuthenticationUrl'];
            }
			
			//log
			$msglog = '[API] Transação Cielo TID: '.$objResposta['tid'].' via Cartão de Débito '.ucfirst($_POST["bandeira"]).' no total de R$'.number_format($total, 2, '.', '').'';
			$msglog .= ' / CPF/CNPJ: '.preg_replace('/\D/', '', $_POST['cpf_cliente']).'';
			
			//cria um log para o pedido
			$order = new Order($obj->currentOrder);
			$msg = new Message();
			$message = strip_tags($msglog, '<br>');
			if (($message)){
				$msg->message = $message;
				$msg->id_order = intval($order->id);
				$msg->private = 1;
				$msg->add();
			}
            
            //sql dados cielo
            $ip = Tools::getRemoteAddr();
            $sql = "INSERT INTO `"._DB_PREFIX_."cielo_webservice` (`id`, `pedido`, `valor`, `parcela`, `produto`, `tid`, `nome`, `cpf`, `telefone`, `ip`, `lr`, `pan`, `cc`, `bin`) VALUES (NULL, '".$obj->currentOrder."', '".number_format($total, 2, '.', '')."', '".$parcela."', '".$_POST['tipo']."', '".$objResposta['tid']."', '".$_POST['nome_cliente']."', '".$_POST['cpf_cliente']."', '', '".$ip."', '".(isset($objResposta['autorizacao']['lr'])?$objResposta['autorizacao']['lr']:'')."', '".(isset($objResposta['pan'])?$objResposta['pan']:'')."', '".$regras_cc["cc"]."', '".substr($_POST['numero_cc'],0,6)."******".substr($_POST['numero_cc'],-4)."');";
            Db::getInstance()->Execute($sql);
            
            //se precisar autenticar no banco
            if($requer_autenticar){
                Tools::redirect($url_autenticar_cielo);
                exit;
            }else{
                Tools::redirect('index.php?controller=order-confirmation&id_cart='.(int)($qual_pedido).'&id_module='.(int)($obj->id).'&id_order='.$obj->currentOrder.'&key='.$cliente->secure_key.'&tid='.$objResposta['tid'].'&hash='.$hash.'');
                exit;
            }
            
        
        }elseif(isset($dados_pedido['ReturnMessage'])){
        
			$erro = true;
			$msg = "Erro no pedido cielo de cod: ".$dados_pedido['ReturnCode']." - ".$dados_pedido['ReturnMessage'];
			
		}elseif(isset($dados_pedido['Message'])){
        
			$erro = true;
			$msg = "Erro no pedido cielo de cod: ".$dados_pedido['Code']." - ".$dados_pedido['Message'];
			
		}elseif(isset($dados_pedido[0]['Message'])){
			
			$erro = true;
			$msg = "Erro no pedido cielo de cod: ".$dados_pedido[0]['Code']." - ".$dados_pedido[0]['Message'];
        
        }else{
            
			$erro = true;
			$msg = "Erro desconhecido cielo, verificar credenciais, ambiente e versao do curl do servidor!";
			$msg .= print_r($dados_pedido,true);
        
        }
        
        //se tem erro 
        if($erro==true){
			PrestaShopLogger::addLog($msg, 2);
            $this->context->smarty->assign(array(
                'msgerro' => $cod.' - '.$msg,
                'this_path' => $this->module->getPathUri(),
                'link_loja' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'/',
                'this_path_ssl' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->module->name.'/'
            ));
            $this->setTemplate('erro.tpl');
		}
	}
}
?>