<?php
class AdminCorreiosOffPro5EtiquetasController extends ModuleAdminController
{
	public function __construct()
	{
        $this->bootstrap = true;
		parent::__construct();
	}
	
	public function initPageHeaderToolbar()
    {
        parent::initPageHeaderToolbar();
        if (empty($this->display)) {
            $this->page_header_toolbar_btn['imprimir_etiquetas_correios_pro'] = array(
				'class' => 'fix_icons',
                'href' => 'javascript:imprimirEtiquetasCorreiosPro();',
                'desc' => $this->l('Imprimir Etiquetas', null, null, false),
                'icon' => 'icon-print'
            );
			$this->page_header_toolbar_btn['configurar_correios'] = array(
				'class' => 'fix_icons',
                'href' => $this->context->link->getAdminLink('AdminCorreiosOffPro5Config', true),
                'desc' => $this->l('Configurar', null, null, false),
                'icon' => 'icon-gear'
            );
        }
    }
    
    public function createTemplate($tpl_name) 
    {
        if (file_exists($this->getTemplatePath() . $tpl_name) && $this->viewAccess())
                return $this->context->smarty->createTemplate($this->getTemplatePath() . $tpl_name, $this->context->smarty);
            return parent::createTemplate($tpl_name);
    }

	public function initContent()
    {
        parent::initContent();
        $acao = isset($_GET['acao'])?$_GET['acao']:'';
        switch($acao){
			case 'etiquetas':
			$this->etiquetas();
			break;
            default:
            $this->index();
        }
    }

	public function etiquetas(){
		$tpl = $this->createTemplate('etiquetas.tpl');
		if(!isset($_GET['pedidos'])){
			die('Ops, acesso negado!');
		}else{
			$pedidos = explode(',',$_GET['pedidos']);
			$dcs = array();
			foreach($pedidos as $k=>$v){
				//dados
				$order = new Order((int)$v);
				$endereco = new Address((int)($order->id_address_delivery));
				$estado = new State((int)($endereco->id_state));
				$cliente = new Customer((int)($endereco->id_customer));
				$remetente = $this->module->getRemetente();
				$array_end = array_merge((array)$cliente,(array)$endereco);
				//captura o numero 
				$limpa_num = '';
				$numero = explode('.',Configuration::get("CORREIOSOFFPRO5_CNUMERO"));
				$cnum = isset($numero[1])?$numero[1]:'numero';
				if(isset($endereco->numend) && !empty($endereco->numend)){
					$limpa_num = $endereco->numend;
				}elseif(isset($endereco->numero) && !empty($endereco->numero)){
					$limpa_num = $endereco->numero;
				}elseif(isset($endereco->number) && !empty($endereco->number)){
					$limpa_num = $endereco->number;
				}elseif(isset($endereco->$cnum) && !empty($endereco->$cnum)){
					$limpa_num = $endereco->$cnum;
				}
				//complemento
				$compl = explode('.',Configuration::get("CORREIOSOFFPRO5_CCOM"));
				$ccom = isset($compl[1])?$compl[1]:'complemento';
				if(isset($endereco->compl)){
					$complemento = $endereco->compl;
				}elseif(isset($endereco->complemento)){
					$complemento = $endereco->complemento;
				}elseif(isset($endereco->$ccom) && !empty($endereco->$ccom)){
					$complemento = $endereco->$ccom;
				}else{
					$complemento = $endereco->other;
				}
				//define
				$etiquetas[] = array('pedido'=>$order,'endereco'=>$endereco,'estado'=>$estado,'remetente'=>$remetente,'custom_numero'=>$limpa_num,'custom_complemento'=>$complemento,'chancela'=>$this->module->chancela_servico((int)($order->id_carrier)));
			}
			//meses
			$mes_extenso = array(
				'Jan' => 'Janeiro',
				'Feb' => 'Fevereiro',
				'Mar' => 'Marco',
				'Apr' => 'Abril',
				'May' => 'Maio',
				'Jun' => 'Junho',
				'Jul' => 'Julho',
				'Aug' => 'Agosto',
				'Nov' => 'Novembro',
				'Sep' => 'Setembro',
				'Oct' => 'Outubro',
				'Dec' => 'Dezembro'
			);
			$tpl->assign(array(
				'url_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/correiosoffpro5/',
				'etiquetas' => $etiquetas,
				'meses' => $mes_extenso,
			));
			echo $tpl->fetch();
		}
	}
    
    public function index()
    {
        $tpl = $this->createTemplate('lista.tpl');
		$sql = 'SELECT a.id_order,a.reference,a.total_paid,a.total_shipping,a.date_add,c.firstname,c.lastname,osl.name AS status,carrier.name AS transportadora,os.color FROM `'._DB_PREFIX_.'orders` AS a';
		$sql .= '
		LEFT JOIN `'._DB_PREFIX_.'customer` c ON (c.`id_customer` = a.`id_customer`)
		LEFT JOIN `'._DB_PREFIX_.'address` address ON address.id_address = a.id_address_delivery
		LEFT JOIN `'._DB_PREFIX_.'carrier` carrier ON carrier.id_carrier = a.id_carrier
		LEFT JOIN `'._DB_PREFIX_.'country` country ON address.id_country = country.id_country
		LEFT JOIN `'._DB_PREFIX_.'country_lang` country_lang ON (country.`id_country` = country_lang.`id_country` AND country_lang.`id_lang` = '.(int)$this->context->language->id.')
		LEFT JOIN `'._DB_PREFIX_.'order_state` os ON (os.`id_order_state` = a.`current_state`)
		LEFT JOIN `'._DB_PREFIX_.'order_state_lang` osl ON (os.`id_order_state` = osl.`id_order_state` AND osl.`id_lang` = '.(int)$this->context->language->id.')';
		$sql .= ' ORDER BY id_order DESC LIMIT 500';
		$pedidos = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$tpl->assign(array(
			'pedidos' => $pedidos,
		));
		$this->context->smarty->assign(array('content' => $tpl->fetch()));
    }

}
