<?php
class AdminCorreiosOffPro5FaixasController extends ModuleAdminController
{
	public function __construct()
	{
        $this->bootstrap = true;
		parent::__construct();
	}
	
	public function initPageHeaderToolbar()
    {
        parent::initPageHeaderToolbar();
        if (empty($this->display)) {
            $this->page_header_toolbar_btn['adicionar_faixa'] = array(
				'class' => 'fix_icons',
                'href' => 'javascript:add_tabela_offline();',
                'desc' => $this->l('Adicionar Faixa', null, null, false),
                'icon' => 'process-icon-new'
            );
			$this->page_header_toolbar_btn['simular_frete'] = array(
				'class' => 'fix_icons',
                'href' => 'javascript:simulador_frete_offline();',
                'desc' => $this->l('Simular Frete', null, null, false),
                'icon' => 'process-icon-refresh'
            );
			$this->page_header_toolbar_btn['configurar_correios'] = array(
				'class' => 'fix_icons',
                'href' => $this->context->link->getAdminLink('AdminCorreiosOffPro5Config', true),
                'desc' => $this->l('Configurar', null, null, false),
                'icon' => 'icon-gear'
            );
        }
    }
	
	public function createTemplate($tpl_name) 
    {
        if (file_exists($this->getTemplatePath() . $tpl_name) && $this->viewAccess())
                return $this->context->smarty->createTemplate($this->getTemplatePath() . $tpl_name, $this->context->smarty);
            return parent::createTemplate($tpl_name);
    }
	
	public function initContent()
    {
        parent::initContent();
        $acao = isset($_GET['acao'])?$_GET['acao']:'';
        switch($acao){
			case 'simulador':
			$this->simulador();
			break;
			case 'simular':
			$this->simular();
			break;
			case 'ver':
			$this->ver();
			break;
			case 'salvar_editar':
			$this->salvar_editar();
			break;
			case 'editar':
			$this->editar();
			break;
			case 'add':
			$this->add();
			break;
			case 'remover':
			$this->remover();
			break;
			case 'salvar_faixa':
			$this->salvar_faixa();
			break;
            default:
            $this->index();
        }
    }
	
	public function frete_offline($peso,$cep,$servico)
	{
		$peso = number_format($peso, 2, '.', '');
        $cep = substr($cep, 0, 5);
        $sql = "SELECT * FROM `" . _DB_PREFIX_ . "correios_offline5_cotacoes` WHERE id_servico = '".$servico."' AND erro = 0 AND peso = ".$peso." AND (".(int)$cep." BETWEEN `cep_inicio` AND `cep_fim`)";
        $row = Db::getInstance()->getRow($sql);
        if(isset($row['erro']) && $row['erro'] == 0){
            return array('acao'=>'ok','frete'=>$row['valor'],'prazo'=>$row['prazo'],'erro'=>$row['erro']);
        }else{
            return array('acao'=>'indisponivel');
        }
    } 
	
	public function conectar_curl($url) 
	{
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FAILONERROR, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, Configuration::get('CORREIOSOFFPRO5_TIME_OUT'));
        $result = curl_exec($ch);
        curl_close($ch);
        libxml_use_internal_errors(true);
        $xml = @simplexml_load_string($result);
        if(!$xml){
            return false;
        }
        if(!is_object($xml)) {
            return false;
        }
        return json_decode(json_encode($xml),true);
    }
	
	public function calcular($para,$peso,$meio)
	{
		$meio = str_pad($meio, 5, "0", STR_PAD_LEFT);
        $de = preg_replace('/\D/', '', Configuration::get('CORREIOSOFFPRO5_CEP'));
        $para = preg_replace('/\D/', '', $para);
        $lados = round(sqrt($peso),2);
        $alt = ($lados>=2)?$lados:2;
        $larg = ($lados>=11)?$lados:11;
        $comp = ($lados>=16)?$lados:16;
        $url = "http://ws.correios.com.br/calculador/CalcPrecoPrazo.aspx?";
        $url .=	"nCdEmpresa=".trim(Configuration::get('CORREIOSOFFPRO5_LOGIN'));
        $url .=	"&sDsSenha=".trim(Configuration::get('CORREIOSOFFPRO5_SENHA'));
        $url .=	"&sCepOrigem=".$de;
        $url .=	"&sCepDestino=".$para;
        $url .=	"&nVlPeso=".number_format($peso, 2, ',', '');
        $url .=	"&nCdFormato=1";
        $url .=	"&nVlComprimento=".number_format($comp, 2, ',', '');
        $url .=	"&nVlLargura=".number_format($larg, 2, ',', '');
        $url .=	"&nVlAltura=".number_format($alt, 2, ',', '');
        $url .=	"&sCdMaoPropria=n";
        $url .=	"&nVlValorDeclarado=0";
        $url .=	"&sCdAvisoRecebimento=n";
        $url .=	"&nCdServico=".$meio;
        $url .=	"&nVlDiametro=0";
        $url .=	"&StrRetorno=xml";
        return $this->conectar_curl($url);
    }
	
	public function simular()
	{
        $cep = $_GET['cep'];
        $peso = (float)$_GET['peso'];
		if($peso <= 0.30){
			$peso = 0.30;
		}elseif($peso <= 1.00){
			$peso = 1.00;
		}else{
			$peso = number_format(round($peso), 2, '.', '');
		}
        $sql = "SELECT * FROM `" . _DB_PREFIX_ . "correios_offline5_servicos_cadastrados` AS a 
        JOIN `" . _DB_PREFIX_ . "correios_offline5_servicos` AS b ON(a.id_servico=b.id_servico)
        WHERE status > 0 AND a.removidos = 0";
		$linhas = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		echo '<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/css/bootstrap.min.css" />';
        echo '<table class="table table-bordered">';
        echo '<thead><tr><th>Servi&ccedil;o</th><th>Offline</th> <th>Online</th></tr></thead>';
        foreach($linhas as $linha){
            echo '<tr>';
            echo '<td>'.$linha['nome'].'</td>';
            //offline
            $cotacao = $this->frete_offline($peso,$cep,$linha['id_servico']);
            if($cotacao['acao']=='ok'){
                echo '<td>R$'.$cotacao['frete'].' em '.$cotacao['prazo'].' dia(s)</td>';    
            }else{
                echo '<td>indispon&iacute;vel offline</td>';    
            }
            //online
			$api = trim(Configuration::get('CORREIOSOFFPRO5_API'));
			if($api=='webservice'){
				$resultado = $this->calcular($cep,$peso,$linha['id_servico']); 
			}else{
				$resultado = $this->calcular_rest($cep,$peso,$linha['id_servico']); 
			}
            if(isset($resultado['cServico']['Valor']) && !empty($resultado['cServico']['Valor'])){
               $cod_erro = $resultado['cServico']['Erro'];
               $frete = str_replace(',', '.', str_replace('.', '', $resultado['cServico']['Valor']));
               $prazo = $resultado['cServico']['PrazoEntrega'];
               echo '<td>R$'.$frete.' em '.$prazo.' dia(s)</td>';  
            }else{
                echo '<td>indispon&iacute;vel online</td>';     
            }
            echo '</tr>';
        }
        echo '</table>';
		echo '<br><div class="alert alert-info">Lembrando que calculos offline &eacute; apenas uma estimativa, valores podem divergir do real, recomendado apenas para uso em emergencia.</div>';
    }
	
	public function calcular_rest($para,$peso,$meio)
	{
		//token nao ok
		$token_api = $this->module->token_de_acesso_correios();
		if(!isset($token_api['dados']['token'])){
			return array('erro'=>true,'log'=>$token_api);
		}else{
			//dados 
			$meio = str_pad($meio, 5, "0", STR_PAD_LEFT);
			$para = preg_replace('/\D/', '', $para);
			$lados = round(sqrt($peso),2);
			$alt = ($lados>=2)?$lados:2;
			$larg = ($lados>=11)?$lados:11;
			$comp = ($lados>=16)?$lados:16;
			//token rest
			$token = trim($token_api['dados']['token']);
			$codServico = $meio;
			//dados a calcular 
			$dados = array();
			$dados['psObjeto']=$peso*1000;
			$dados['cepOrigem']=preg_replace('/\D/', '', Configuration::get('CORREIOSOFFPRO5_CEP'));
			$dados['cepDestino']=$para;
			$dados['VlDeclarado']=0.00;
			$dados['tpObjeto']=2;
			$dados['comprimento']=$comp;
			$dados['largura']=$larg;
			$dados['altura']=$alt;
			$resultado = $this->module->get_frete_correios($codServico,$dados,$token);
			$resultado_prazo = $this->module->get_prazo_correios($codServico,$dados,$token);
			if(isset($resultado['dados']['pcFinal'])){
				return array(
					'cServico' => array(
						'Erro' => 0,
						'PrazoEntrega' => (isset($resultado_prazo['dados']['prazoEntrega'])?$resultado_prazo['dados']['prazoEntrega']:10),
						'MsgErro' => '',
						'Valor' => $resultado['dados']['pcFinal']
					)
				);
			}else{
				return array('erro'=>true,'calculo'=>array_merge(array('original'=>$dados),array('preco'=>$resultado),array('prazo'=>$resultado_prazo)));
			}
		}
    }
	
	public function simulador()
	{
		echo '<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/css/bootstrap.min.css" />';
		echo '<div class="row">
		<div class="col-lg-12">
		<div class="alert alert-info">Informe um CEP de destino abaixo para simular cota&ccedil;&otilde;es baseada nas tabelas de entrega Correios offline cadastradas, lembrando que calculos offline &eacute; apenas uma estimativa recomendado apenas para uso em emergencia.</div>
		<p><select style="display:inline;" class="form-control" id="peso-simulador">';
		echo '<option value="0.3">0.3kg(s)</option>';
		for($i=1;$i<=30;$i++){
			echo '<option value="'.$i.'">'.$i.'kg(s)</option>';
		}
		echo '</select></p>
		<p><div class="input-group">
		<input type="text" onkeyup="if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,\'\')" maxlength="8" id="cep-simular" class="form-control" placeholder="00000000">
		<span class="input-group-btn">
		<button class="btn btn-info" onclick="simular()" type="button">Simular</button>
		</span>
		</div></p>
		</div>
		</div>';
	}
	
	public function ver()
	{
		echo '<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/css/bootstrap.min.css" />';
		//pega o cep
        $cep = preg_replace('/\D/', '', $_GET['cep']);
		$cep = str_pad($cep, 8, "0", STR_PAD_LEFT);
        //tabelas
        $sql = "SELECT *,(SELECT COUNT(*) FROM `" . _DB_PREFIX_ . "correios_offline5_cotacoes` AS c
        WHERE c.id_servico = a.id_servico) AS registros FROM `" . _DB_PREFIX_ . "correios_offline5_servicos_cadastrados` AS a 
        JOIN `" . _DB_PREFIX_ . "correios_offline5_servicos` AS b ON(a.id_servico=b.id_servico) 
		WHERE a.status > 0 AND a.removidos = 0
        ORDER BY a.id_servico ASC";
		$tabelas = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
        //cria as abas da tab
        echo '<ul id="tabs-fretes-prazos" class="nav nav-tabs" role="tablist">';
        $i=0;
        foreach($tabelas as $tabela){
            echo '<li class="'.(($i==0)?'active':'').'" role="presentation"><a href="#tab-'.$tabela['id_servico'].'" aria-controls="tab-'.$tabela['nome'].'" role="tab" data-toggle="tab">'.$tabela['id_servico'].' - '.$tabela['nome'].'</a></li>';
            $i++;
        }
        echo '</ul>';
        //cria as tabelas 
        echo '<div class="tab-content">';
        $i=0;
        foreach($tabelas as $tabela){
            echo '<div role="tabpanel"  style="max-height: 300px; overflow-y: scroll" class="tab-pane '.(($i==0)?'active':'').'" id="tab-'.$tabela['id_servico'].'">';
            echo '<table class="table table-bordered">';
            echo '<tr>';
            echo '<th>Peso</th>';
            echo '<th>Frete R$</th>';
            echo '<th>Prazo</th>';
            echo '<th>Erro</th>';
            echo '</tr>';
            echo '<tbody>';
            //cotacaoes
            $sql = "SELECT * FROM `" . _DB_PREFIX_ . "correios_offline5_cotacoes` WHERE cep_base = '".$cep."' AND id_servico = '".$tabela['id_servico']."' ORDER BY peso ASC";
            $cotacoes = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
			foreach($cotacoes as $cota){
				echo '<tr>';
				echo '<td>'.$cota['peso'].'kg</td>';
				echo '<td>R$'.$cota['valor'].'</td>';
				echo '<td>'.$cota['prazo'].' dias</td>';
				echo '<td>'.$cota['erro'].'</td>';
				echo '<tr>';
			}
			if(count($cotacoes)==0){
				echo '<tr>';
				echo '<td colspan="4">Nenhum valor cadastrado, atualize a tabela <a href="'.$this->context->link->getAdminLink('AdminCorreiosOffPro5Tabelas', true).'&acao=atualizar&id_servico='.$tabela['id_servico'].'">clicando aqui</a>!</td>';
				echo '<tr>';
			}
            echo '</tbody>';
            echo '</table>';
            echo '</div>'; 
            $i++;
        }
        echo '</div>';
	}
	
	public function salvar_editar()
	{
		if(isset($_POST['id'])){
            $sql = "UPDATE `" . _DB_PREFIX_ . "correios_offline5_base` SET inicio = '".(int)$_POST['cep_inicio']."', fim = '".(int)$_POST['cep_final']."', base_cep = '".(int)$_POST['cep_base']."' WHERE id = '".(int)$_POST['id']."' LIMIT 1";
            Db::getInstance()->execute($sql);
        }
		$this->index();
	}
	
	public function editar()
	{
		$tpl = $this->createTemplate('atualizar_faixa.tpl');
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "correios_offline5_base` WHERE id = '".(int)$_GET['id']."'";
		$faixa = Db::getInstance()->getRow($sql);
		$tpl->assign(array(
			'faixa' => $faixa,
			'url' => $this->context->link->getAdminLink('AdminCorreiosOffPro5Faixas', true),
		));
		echo $tpl->fetch();
	}
	
	public function remover()
	{
		if(isset($_GET['id'])){
			$sql = "DELETE FROM `" . _DB_PREFIX_ . "correios_offline5_base` WHERE id = '".(int)$_GET['id']."' AND custom = '1' LIMIT 1";
			Db::getInstance()->execute($sql);
		}
		$this->index();
	}
	
	public function salvar_faixa()
	{
		if(isset($_POST['cep_inicio'])){
            $sql = "INSERT INTO `" . _DB_PREFIX_ . "correios_offline5_base` SET uf = '".strtoupper($_POST['uf'])."', detalhes = '".$_POST['detalhes']."', inicio = '".(int)$_POST['cep_inicio']."', fim = '".(int)$_POST['cep_final']."', base_cep = '".(int)$_POST['cep_base']."', custom = '1'";
            Db::getInstance()->execute($sql);
        }
		$this->index();
	}
	
	public function add()
	{
		$tpl = $this->createTemplate('add_faixa.tpl');
		$tpl->assign(array(
			'url' => $this->context->link->getAdminLink('AdminCorreiosOffPro5Faixas', true),
		));
		echo $tpl->fetch();
	}
	
	public function index()
    {
        $tpl = $this->createTemplate('faixas.tpl');
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "correios_offline5_base` ORDER BY base_cep ASC, custom DESC";
		$faixas = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$tpl->assign(array(
			'faixas' => $faixas,
			'url' => $this->context->link->getAdminLink('AdminCorreiosOffPro5Faixas', true),
		));
		$this->context->smarty->assign(array('content' => $tpl->fetch()));
    }
	
}
?>