<?php
class AdminCorreiosOffPro5ServicosController extends ModuleAdminController
{
	public function __construct()
	{
        $this->bootstrap = true;
		parent::__construct();
	}
	
	public function initPageHeaderToolbar()
    {
        parent::initPageHeaderToolbar();
		if (empty($this->display)) {
			$cache = $this->context->link->getAdminLink('AdminCorreiosOffPro5Servicos', true).'&acao=limpar_cache';
			$this->page_header_toolbar_btn['configurar_correios'] = array(
				'class' => 'fix_icons',
                'href' => $this->context->link->getAdminLink('AdminCorreiosOffPro5Config', true),
                'desc' => $this->l('Configurar', null, null, false),
                'icon' => 'icon-gear'
            );
			$this->page_header_toolbar_btn['limpar_cache_correios'] = array(
				'class' => 'fix_icons',
                'href' => 'javascript:if(confirm(\'Confirma limpar o cache?\')){location.href=\''.$cache.'\';}',
                'desc' => $this->l('Limpar Cache', null, null, false),
                'icon' => 'icon-rotate-right'
            );
        }
    }
	
	public function createTemplate($tpl_name) 
    {
        if (file_exists($this->getTemplatePath() . $tpl_name) && $this->viewAccess())
                return $this->context->smarty->createTemplate($this->getTemplatePath() . $tpl_name, $this->context->smarty);
            return parent::createTemplate($tpl_name);
    }
	
	public function initContent()
    {
        parent::initContent();
        $acao = isset($_GET['acao'])?$_GET['acao']:'';
        switch($acao){
			case 'limpar_cache':
			$this->limpar_cache();
			break;
			case 'salvar_editar':
			$this->salvar_editar();
			break;
			case 'editar':
			$this->editar();
			break;
			case 'status':
			$this->status();
			break;
			case 'regra':
			$this->regra();
			break;
            default:
            $this->index();
        }
    }
	
	public function limpar_cache()
	{
		Db::getInstance()->execute("DELETE FROM `" . _DB_PREFIX_ . "correios_offline5_cache`");
		$this->index();
	}
	
	public function index()
    {
		//lista os servicos cadastrados
        $tpl = $this->createTemplate('servicos_cadastrados.tpl');
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "correios_offline5_servicos_cadastrados` AS a
		JOIN `" . _DB_PREFIX_ . "correios_offline5_servicos` AS b ON(a.id_servico=b.id_servico) 
		WHERE a.removidos = '0'
		ORDER BY a.titulo ASC";
		$servicos = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$tpl->assign(array(
			'servicos' => $servicos,
			'url' => $this->context->link->getAdminLink('AdminCorreiosOffPro5Servicos', true),
		));
		$this->context->smarty->assign(array('content' => $tpl->fetch()));
    }
	
	public function regra()
	{
		//ativa e desativa o servico
		if(isset($_GET['id_carrier']) && isset($_GET['valor'])){
			//atualiza o servico 
			$sql = "UPDATE `" . _DB_PREFIX_ . "correios_offline5_servicos_cadastrados` SET status = '".(int)$_GET['valor']."' WHERE id_carrier = '".(int)$_GET['id_carrier']."'";
			Db::getInstance()->execute($sql);
			//atualiza o carrier
			if($_GET['valor']==0){
				$sql = "UPDATE `" . _DB_PREFIX_ . "carrier` SET active = '0' WHERE id_carrier = '".(int)$_GET['id_carrier']."'";
				Db::getInstance()->execute($sql);
			}else{
				$sql = "UPDATE `" . _DB_PREFIX_ . "carrier` SET active = '1' WHERE id_carrier = '".(int)$_GET['id_carrier']."'";
				Db::getInstance()->execute($sql);
			}
		}
		echo 'OK';
	}
	
	public function editar()
	{
		//edita um servico
		$tpl = $this->createTemplate('atualizar_servico.tpl');
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "correios_offline5_servicos_cadastrados` WHERE id_carrier = '".(int)$_GET['id_carrier']."'";
		$servico = Db::getInstance()->getRow($sql);
		$tpl->assign(array(
			'servico' => $servico,
			'titulo' => (isset($this->module->correios_exibir[$servico['id_servico']])?$this->module->correios_exibir[$servico['id_servico']]:''),
			'url' => $this->context->link->getAdminLink('AdminCorreiosOffPro5Servicos', true),
		));
		echo $tpl->fetch();
	}
	
	public function salvar_editar()
	{
		//salva o editar
		if(isset($_POST['id_carrier'])){
			//servicos
            $sql = "UPDATE `" . _DB_PREFIX_ . "correios_offline5_servicos_cadastrados` SET titulo = '".$_POST['titulo']."', prazo_extra = '".(int)$_POST['prazo_extra']."', valor_extra = '".$_POST['valor_extra']."', real_porcentagem = '".$_POST['real_porcentagem']."', total_minimo = '".$_POST['total_minimo']."', total_minimo_frete = '".$_POST['total_minimo_frete']."', ceps = '".$_POST['ceps']."', ceps_excluir = '".$_POST['ceps_excluir']."', valor_declarado = '".(int)$_POST['valor_declarado']."' WHERE id_carrier = '".(int)$_POST['id_carrier']."' LIMIT 1";
            Db::getInstance()->execute($sql);
			//carrier
			$sql = "UPDATE `" . _DB_PREFIX_ . "carrier` SET name = '".$_POST['titulo']."' WHERE id_carrier = '".(int)$_POST['id_carrier']."' LIMIT 1";
            Db::getInstance()->execute($sql);
        }
		$this->index();
	}
}
?>