<?php
if (!defined('_PS_VERSION_'))
	exit;

class CorreiosOffPro5 extends Module
{
	protected $context;
	public $correios_exibir = array(
		'03085'				 => 'PAC',
		'03050'				 => 'Sedex',
		'03298'				 => 'PAC',
		'03220'				 => 'Sedex',
		'03140'				 => 'Sedex 12',
		'03158'				 => 'Sedex 10',
		'03204'				 => 'Sedex Hoje',
		'04227'				 => 'Pac Mini',
		'04367'				 => 'PAC',
		'04154'				 => 'Sedex',
		'41106'				 => 'PAC',
		'40010'				 => 'Sedex',
        '04510'				 => 'PAC',
		'04014'				 => 'Sedex',
        '04669'				 => 'PAC',
		'04553'				 => 'Sedex',
        '04596'				 => 'PAC',
		'04162'				 => 'Sedex',
		'40045'				 => 'Sedex a Cobrar',
		'40126'				 => 'Sedex a Cobrar',
		'40215'				 => 'Sedex 10',
		'40169'				 => 'Sedex 12',
		'40290'				 => 'Sedex Hoje',
		'04235'              => 'PAC Mini',
		'04391'              => 'PAC Mini',
		'03662'              => 'Sedex Hoje',
	);
	public $correios_vd = array(
		'03085'				 => '064',
		'03050'				 => '019',
		'03298'				 => '064',
		'03220'				 => '019',
		'03140'				 => '019',
		'03158'				 => '019',
		'03204'				 => '019',
		'04227'				 => '065',
		'04367'				 => '064',
		'04154'				 => '019',
		'41106'				 => '064',
		'40010'				 => '019',
        '04510'				 => '064',
		'04014'				 => '019',
        '04669'				 => '064',
		'04553'				 => '019',
        '04596'				 => '064',
		'04162'				 => '019',
		'40045'				 => '019',
		'40126'				 => '019',
		'40215'				 => '019',
		'40169'				 => '019',
		'40290'				 => '019',
		'04235'              => '065',
		'04391'              => '065',
		'03662'				 => '019',
	);
	public  $id_carrier;
	public  $prazos;
	public  $prazos_hook;
	public  $alertas;
	private $valor_declarado_max = 10000;
	private $cubagem_max = 296207.4163;
	private $peso_max = 30;
	private $fator = 6000;
	private $lados_max = 105;
		
	public function __construct()
	{
		$this->initContext();
		$this->name = 'correiosoffpro5';
		$this->tab = 'shipping_logistics';
		$this->version = '3.0.0';
		$this->author = 'Loja5.com.br';
		$this->need_instance = 0;
		$this->bootstrap = true;
		parent::__construct();	
		$this->displayName = $this->l('Correios PRO');
		$this->description = $this->l('Sistema de calculo de frete online e offline para Correios.');
	}
	
	private function initContext() 
	{
        $this->ajax    = true;
        $this->context = Context::getContext();
    }
	
	public function hookdisplayAdminAfterHeader(){
		//exibe a mensagem sigep
        if(isset($_GET['controller']) && $_GET['controller']=='AdminDashboard'){
			//verifica a licença
			$key_string = Configuration::get('CORREIOSOFFPRO5_SERIAL');
			if(isset($key_string) && !empty($key_string)){
				$validas[] = trim($key_string);
				//curl
				$dados = json_encode($validas);
				$service_url = 'https://www.loja5.com.br/index.php?route=module/iono/buscar';
				$curl = curl_init($service_url);
				curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);  
				curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE); 
				curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 10);
				curl_setopt($curl, CURLOPT_HTTPHEADER, array(
					'Content-Type: application/json',
					'Content-Length: ' .strlen($dados))
				); 
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($curl, CURLOPT_POST, true);
				curl_setopt($curl, CURLOPT_POSTFIELDS, $dados);
				$json = json_decode(curl_exec($curl),true);
				$curlErrno     = curl_errno($curl);
				$curlErr       = curl_error($curl);
				curl_close($curl);
			}
			if(isset($json['atualizados'][0])){
				$up = $json['atualizados'][0];
				echo '<div class="alert alert-info"><span style="background: #03A9F4; color: #FFF; border-radius: 2px; padding: 3px;"><b>[CORREIOS PRO LOJA5]</b></span> O seu m&oacute;dulo <b>'.$up['modulo'].'</b> foi atualizado em <b>Loja5.com.br</b>, <a href="https://www.loja5.com.br/account/download.html" target="_blank">acesse sua conta > downloads</a> e baixe o mesmo at&eacute; <b>'.$up['validade'].'</b>, para instalar siga o guia de instala&ccedil;&atilde;o que encontra-se dentro do anexo baixado.</div>';
			}
        }
    }

	public function install()
	{
		//sql 
		include(dirname(__FILE__).'/sql/install.php');

		//cria as transportadoras na loja
		$url_rastreio = Tools::getShopDomainSsl(true, true).__PS_BASE_URI__."index.php?fc=module&module=correiosoffpro5&controller=rastrear&obj=@";
		//auto ativados por padrao 
		$ativados = array('04510','04014');
		//consulta os servicos
		$servicos = Db::getInstance()->executeS("SELECT * FROM `" . _DB_PREFIX_ . "correios_offline5_servicos`");
		foreach($servicos as $k => $v){
			//verifica se é sedex ou pac 
			if (strpos($v['nome'], 'SEDEX') !== false) {
				$grade = 8;
				$frase_frete = 'Entrega de 2 a 4 dias úteis';
			}else{
				$grade = 1;
				$frase_frete = 'Entrega de 10 a 15 dias úteis';
			}
			//dados da transportadora a criar 
			$config = array(
				'name' => $v['nome'].' - '.$v['id_servico'],
				'id_tax_rules_group' => 0,
				'active' => (in_array($v['id_servico'], $ativados)) ? true : false,
				'deleted' => 0,
				'url' => $url_rastreio,
				'shipping_handling' => false,
				'max_width' => 105.00,
				'max_height' => 105.00,
				'max_depth' => 105.00,
				'max_weight' => 30.00,
				'range_behavior' => 0,
				'delay' => $frase_frete,
				'id_zone' => 1,
				'is_module' => true,
				'shipping_external' => true,
				'shipping_method' => 0,
				'id_servico' => $v['id_servico'],
				'grade' => $grade,
				'external_module_name' => $this->name,
				'need_range' => true
			);
			//cria a transportadora 
			$id_carrier = $this->criar_transportadora($config);
			//atrela a transportadora ao servico 
			if($id_carrier){
				Db::getInstance()->execute("INSERT INTO `" . _DB_PREFIX_ . "correios_offline5_servicos_cadastrados` SET id_carrier = ".$id_carrier.", id_servico = '".$v['id_servico']."', titulo = '".$v['nome']."', status = '".$config['active']."';");
			}
		}
		
		//ativa os hooks
		if (!parent::install() OR !$this->registerHook('displayAdminAfterHeader') OR !$this->registerHook('displayCompareExtraInformation') OR !$this->registerHook('displayRightColumnProduct') OR !$this->registerHook('shoppingCart') OR !$this->registerHook('adminOrder') OR !$this->registerHook('updateCarrier') OR !$this->registerHook('productActions') OR !$this->registerHook('displayAfterCarrier') OR !$this->registerHook('displayLeftColumnProduct') OR !$this->registerHook('displayBeforeCarrier') OR !$this->registerHook('displayBackOfficeHeader')){
			return false;
		}
		
		//menus
		$this->criarMenus();
		
		return true;
	}
	
	public function uninstall()
    {
		//desativa os registros de frete 
		Db::getInstance()->execute("UPDATE `"._DB_PREFIX_."carrier` SET  `active` =  '0', `deleted` =  '1' WHERE  external_module_name = 'correiosoffpro5'");
		return parent::uninstall();
    }
	
	public function criarMenus()
	{
		// remove os menus
		$moduleTabs = Tab::getCollectionFromModule($this->name);
		if (!empty($moduleTabs)) {
			foreach ($moduleTabs as $moduleTab) {
				$moduleTab->delete();
			}
		}	
		//menu principal 
		$parent_tab0 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab0->name[(int)$lang['id_lang']] = $this->l('Configurações Correios Pro');
        }
		$parent_tab0->class_name = 'AdminCorreiosOffPro5Principal';
		$parent_tab0->id_parent = 0;
		$parent_tab0->module = $this->name;
		$parent_tab0->add();
		
		//menu 1
		$parent_tab1 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab1->name[(int)$lang['id_lang']] = $this->l('Serviços Cadastrados');
        }
		$parent_tab1->class_name = 'AdminCorreiosOffPro5Servicos';
		$parent_tab1->id_parent = $parent_tab0->id;
		$parent_tab1->module = $this->name;
		$parent_tab1->add();
		
		//menu 2
		$parent_tab2 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab2->name[(int)$lang['id_lang']] = $this->l('Tabelas Offline');
        }
		$parent_tab2->class_name = 'AdminCorreiosOffPro5Tabelas';
		$parent_tab2->id_parent = $parent_tab0->id;
		$parent_tab2->module = $this->name;
		$parent_tab2->add();
		
		//menu 3
		$parent_tab3 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab3->name[(int)$lang['id_lang']] = $this->l('Faixas de CEPs');
        }
		$parent_tab3->class_name = 'AdminCorreiosOffPro5Faixas';
		$parent_tab3->id_parent = $parent_tab0->id;
		$parent_tab3->module = $this->name;
		$parent_tab3->add();
		
		//menu 4
		$parent_tab4 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab4->name[(int)$lang['id_lang']] = $this->l('Imprimir Etiquetas');
        }
		$parent_tab4->class_name = 'AdminCorreiosOffPro5Etiquetas';
		$parent_tab4->id_parent = $parent_tab0->id;
		$parent_tab4->module = $this->name;
		$parent_tab4->add();
		
		//menu 5
		$parent_tab5 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab5->name[(int)$lang['id_lang']] = $this->l('Configurar');
        }
		$parent_tab5->class_name = 'AdminCorreiosOffPro5Config';
		$parent_tab5->id_parent = $parent_tab0->id;
		$parent_tab5->module = $this->name;
		$parent_tab5->add();
		
		return true;
	}
	
	public function hookdisplayBackOfficeHeader()
	{
		return '<style>
		.icon-AdminCorreiosOffPro5Servicos:before {
			content: "\f1b3";
		}
		</style>';
	}
	
	public static function criar_transportadora($config) 
	{
		$carrier = new Carrier();
		$carrier->name = $config['name'];
		$carrier->url = $config['url'];
		$carrier->id_tax_rules_group = $config['id_tax_rules_group'];
		$carrier->id_zone = $config['id_zone'];
		$carrier->active = $config['active'];
		$carrier->deleted = $config['deleted'];
		$carrier->grade = $config['grade'];
		$carrier->max_width = $config['max_width'];
		$carrier->max_height = $config['max_height'];
		$carrier->max_depth = $config['max_depth'];
		$carrier->max_weight = $config['max_weight'];
		$carrier->shipping_handling = $config['shipping_handling'];
		$carrier->range_behavior = $config['range_behavior'];
		$carrier->is_module = $config['is_module'];
		$carrier->shipping_method = $config['shipping_method'];
		$carrier->shipping_external = $config['shipping_external'];
		$carrier->external_module_name = $config['external_module_name'];
		$carrier->need_range = $config['need_range'];
		$languages = Language::getLanguages(true);
		foreach ($languages as $language) {
			$carrier->delay[(int)$language['id_lang']] = $config['delay'];
		}
		$carrier->add();
		if (isset($carrier->id) && $carrier->id > 0) {
			//grupos
			$carrier = new Carrier($carrier->id);
			$groups_ids = array();
			$groups = Group::getGroups(Context::getContext()->language->id);
			foreach ($groups as $group){
				$groups_ids[] = $group['id_group'];
			}
			$carrier->setGroups($groups_ids);
            //ranges precos
			$carrier = new Carrier($carrier->id);
			$range_price = new RangePrice();
			$range_price->id_carrier = $carrier->id;
			$range_price->delimiter1 = '0';
			$range_price->delimiter2 = '10000';
			$range_price->add();
			//ranges valores 
			$carrier = new Carrier($carrier->id);
			$range_weight = new RangeWeight();
			$range_weight->id_carrier = $carrier->id;
			$range_weight->delimiter1 = '0';
			$range_weight->delimiter2 = '30';
			$range_weight->add();
			//zonas 
			$carrier = new Carrier($carrier->id);
			$zones = Zone::getZones();
			foreach ($zones as $zone){
				$carrier->addZone($zone['id_zone']);
			}
			//logomarca
			if(file_exists(dirname(__FILE__).'/views/img/'.$config['id_servico'].'.gif')){
				if (!copy(dirname(__FILE__).'/views/img/'.$config['id_servico'].'.gif', _PS_SHIP_IMG_DIR_.'/'.(int)$carrier->id.'.gif')){
				}
			}else{
				if (!copy(dirname(__FILE__).'/views/img/logo.png', _PS_SHIP_IMG_DIR_.'/'.(int)$carrier->id.'.png')){
				}
			}
			//retorna o id
			return (int)($carrier->id);
		}
		return false;
	}
	
	public function hookupdateCarrier($params) 
	{
		//atualiza o servico ao atualizar uma transportadora
		if ((int)($params['id_carrier']) != (int)($params['carrier']->id)) {
			Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "correios_offline5_servicos_cadastrados` SET id_carrier = ".(int)($params['carrier']->id).",  titulo = '".$params['carrier']->name."' WHERE id_carrier = ".(int)$params['id_carrier'].";");
		}
	}
	
	protected function renderForm()
    {
        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'setGlobalConfiguration';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm(array($this->getConfigForm()));
    }
	
	public function getContent()
	{
		$output = '';
		if (Tools::isSubmit('setGlobalConfiguration')){
			$this->postProcess();
			$output .= $this->displayConfirmation('Dados salvos com sucesso!');
		}
		if(!is_writable(dirname(__FILE__ ))) {
			$output .= $this->displayError($this->l('O diretorio do módulo "modules/'.$this->name.'/" não possui permissão de escrita, caso tenha problema ao ativar o serial de registro do mesmo aplique permissão ao mesmo compativel com sua hospedagem, lembre-se de aplicar apenas na pasta do módulo e não aplicar permissão nos arquivos do mesmo!'));
		}
		$this->context->smarty->assign('link', $this->context->link);
        $this->context->smarty->assign('module_dir', $this->_path);
		$this->context->smarty->assign('url_servicos', $this->context->link->getAdminLink('AdminCorreiosOffPro5Servicos', true));
		$this->context->smarty->assign('url_tabelas', $this->context->link->getAdminLink('AdminCorreiosOffPro5Tabelas', true));
		$this->context->smarty->assign('url_faixas', $this->context->link->getAdminLink('AdminCorreiosOffPro5Faixas', true));
		$this->context->smarty->assign('url_etiquetas', $this->context->link->getAdminLink('AdminCorreiosOffPro5Etiquetas', true));
        $output .= $this->context->smarty->fetch($this->local_path.'views/templates/admin/configure.tpl');
		if(!file_exists(dirname(__FILE__).'/include/licenciamento.php')){
			$file_lic = $this->displayError('<p><strong>Ops:</strong> Existe um problema no arquivo de li&ccedil;enciamento ('.dirname(__FILE__).'/include/licenciamento.php) do seu m&oacute;dulo em sua loja, aparentemente o mesmo n&atilde;o foi enviado ou esta sendo removido por sua hospedagem, <a href="https://loja5.zendesk.com/hc/pt-br/articles/5147862975117-Problema-de-Alerta-de-Arquivos-com-Eval-Base64-no-Wordfence-Sucuri-Cpanel-CPGuard-e-Outros" target="_blank">clique aqui</a> e siga as instru&ccedil;&otilde;es!</p>');
			return $output.$file_lic;
		}else{
			return $output.$this->renderForm();
		}
	}

	protected function getConfigForm()
    {
		if(file_exists(dirname(__FILE__).'/include/licenciamento.php')){
			include_once(dirname(__FILE__).'/include/licenciamento.php');
			return form_config_loja5_correiosoffpro5($this);
		}else{
			return array();
		}
    }

    protected function getConfigFormValues()
    {
        $inputs = array();
        $form   = $this->getConfigForm();
		if(isset($form['form']['input'])){
			foreach ($form['form']['input'] as $v) {
				$chave          = $v['name'];
				$inputs[$chave] = Configuration::get($chave, '');
			}
		}
        return $inputs;
    }

    protected function postProcess()
    {
        $form_values = $this->getConfigFormValues();
        foreach (array_keys($form_values) as $key) {
            Configuration::updateValue($key, Tools::getValue($key));
        }
    }
	
	private function dados_produtos($params) 
	{
		$i  = 0;
		$alt = array();
		$com  = array();
		$lar = array();
		$peso = array();
		foreach ( $params->getProducts() as $k => $prod ) {
			//custom 
			if(Configuration::get('CORREIOSOFFPRO5_FIXAR_MEDIDAS')==0){
				$profundidade = round((isset($prod['length'])?$prod['length']:$prod['depth']),2);
				$largura = round($prod['width'],2);
				$altura = round($prod['height'],2);
			}else{
				$profundidade = round((float)Configuration::get('CORREIOSOFFPRO5_COM'),2);
				$largura = round((float)Configuration::get('CORREIOSOFFPRO5_LAR'),2);
				$altura = round((float)Configuration::get('CORREIOSOFFPRO5_ALT'),2);
			}
			$pesos = number_format($prod['weight'],2,'.','');
			$quantidade = isset($prod['qtd'])?$prod['qtd']:$prod['quantity'];
			//ordena as medidas 
			$numbers = array($largura,$altura,$profundidade);
			sort($numbers);
			$altura = isset($numbers[0])?$numbers[0]:$altura;
			$largura = isset($numbers[1])?$numbers[1]:$largura;
			$profundidade = isset($numbers[2])?$numbers[2]:$profundidade;
			//dados
			$w	 = ($largura > 0)?$largura:10.00;
  			$h   = ($altura > 0)?$altura:1.00;
  			$l   = ($profundidade > 0)?$profundidade:15.00;
			$p   = ($pesos > 0)?$pesos:0.01;
			$qtd = $quantidade;
			//produtos que tenha frete
			if ( $qtd > 0 && $prod['is_virtual']==0 ) {
				//se mais de um produto
				if ( $qtd > 1 ) {
					$n = $i;
					for ( $j = 0; $j < $qtd; $j++ ) {
						$alt[ $n ] = $h;
						$com[ $n ] = $w;
						$lar[ $n ] = $l;
						$peso[ $n ] = $p;
						$n++;
					}
					$i = $n;
				}else{
					//se um produto
					$alt[ $i ]  = $h;
					$com[ $i ]  = $w;
					$lar[ $i ]  = $l;
					$peso[ $i ] = $p;
				}
				$i++;
			}
		}
		return array( 'alt' => array_values( $alt ), 'com' => array_values( $com ), 'lar'  => array_values( $lar ), 'peso' => array_sum( $peso ) );
	}

	private function raiz_cubica( $alt, $com, $lar, $maximos ) 
	{
		$cubagem_total = 0;
		$total_items = count( $alt );
		for ( $i = 0; $i < $total_items; $i++ ) {
			$cubagem_total += $alt[ $i ] * $com[ $i ] * $lar[ $i ];
		}
		$raiz = 0;
		$maior = max( $maximos );
		if ( 0 !== $cubagem_total && 0 < $maior ) {
			$fator = $cubagem_total / $maior;
			$raiz = round( sqrt( $fator ), 1 );
		}
		return $raiz;
	}
	
	private function cubagem( $alt, $com, $lar ) {
		if(count($alt) > 1){
			$cubagem     = array();
			$maximos     = array('alt' => max( $alt ), 'com'  => max( $com ), 'lar' => max( $lar ));
			$raiz        = $this->raiz_cubica( $alt, $com, $lar, $maximos );
			$maior       = array_search( max( $maximos ), $maximos, true );
			switch ( $maior ) {
				case 'alt' :
				$cubagem = array(
					'alt' => max( $alt ),
					'com'  => $raiz,
					'lar' => $raiz,
					'itens'=> count($alt)
				);
				break;
				case 'com' :
				$cubagem = array(
					'alt' => $raiz,
					'com'  => max( $com ),
					'lar' => $raiz,
					'itens'=> count($alt)
				);
				break;
				case 'lar' :
				$cubagem = array(
					'alt' => $raiz,
					'com'  => $raiz,
					'lar' => max( $lar ),
					'itens'=> count($alt)
				);
				break;
				default :
				$cubagem = array(
					'alt' => 0,
					'com'  => 0,
					'lar' => 0,
					'itens'=> count($alt)
				);
				break;
			}
		}else{
			$cubagem = array('alt' => max( $alt ), 'com'  => max( $com ), 'lar' => max( $lar ), 'itens'=>1);
		}
		return $cubagem;
	}
	
	private function peso_cubado( $cubagem )
	{
		$peso = round( ($cubagem['alt'] * $cubagem['com'] * $cubagem['lar']) / $this->fator , 2);
		return ($peso > 0)?$peso:0.1;
	}
	
	private function salvar_log($dados_log)
	{
		if(!empty($dados_log)){
			$dados_log = is_array($dados_log)?print_r($dados_log,true):$dados_log;
			PrestaShopLogger::addLog($dados_log);
		}
		return true;
	}
	
	public function lojasCadastradas()
	{
		$ativados = array();
		$ativados[] = array('id'=>0,'campo'=>'Padrao');
		return $ativados;
	}
	
	public function getRemetente()
	{
		$loja = array();
		$loja['name'] = Configuration::get('PS_SHOP_NAME');
		$loja['address1'] = Configuration::get('PS_SHOP_ADDR1');
		$loja['address2'] = Configuration::get('PS_SHOP_ADDR2');
		$loja['city'] = Configuration::get('PS_SHOP_CITY');
		$loja['postcode'] = Configuration::get('PS_SHOP_CODE');
		$estado = new State((int)Configuration::get('PS_SHOP_STATE_ID'));
		return array_merge($loja,array('estado'=>$estado));
	}
	
	private function validar_pacote($pacote,$peso)
	{
		$cubagem = (float)$pacote['alt'] * (float)$pacote['com'] * (float)$pacote['lar'];
		if(!$peso || $peso > $this->peso_max || !$cubagem || $cubagem > $this->cubagem_max){
			$this->salvar_log('Ops, o peso ou cubagem fora dos limites!');
			$this->salvar_log('Peso: '.$peso.' / '.$this->peso_max);
			$this->salvar_log('Peso: '.$cubagem.' / '.$this->cubagem_max);
			return false;
		}else if(($pacote['alt'] > $this->lados_max) || ($pacote['com'] > $this->lados_max) || ($pacote['lar'] > $this->lados_max)){
			$this->salvar_log('Ops, medidas de lados fora dos limites (+'.$this->lados_max.'cm)!');
			$this->salvar_log($pacote['alt'].'x'.$pacote['com'].'x'.$pacote['lar']);
			return false;
		}else if(($pacote['alt']+$pacote['com']+$pacote['lar']) > 200){
			$this->salvar_log('Ops, medidas de lados fora dos limites (+200cm)!');
			$this->salvar_log(($pacote['alt']+$pacote['com']+$pacote['lar']));
			return false;
		}
  		return true;
  	}
	
	public function campos_extras()
    {
        //querys
        $campos[] = array('id'=>'','campo'=>'Junto ao Logradouro');
        $clientes = Db::getInstance()->executeS("SHOW COLUMNS FROM `" . _DB_PREFIX_ . "customer`");	
        foreach($clientes AS $k=>$v){
            $input = _DB_PREFIX_.'customer.'.$v['Field'].'';
            $campos[] = array('id'=>$input,'campo'=>$input);
        }
        $enderecos = Db::getInstance()->executeS("SHOW COLUMNS FROM `" . _DB_PREFIX_ . "address`");
        foreach($enderecos AS $k=>$v){
            $input = _DB_PREFIX_.'address.'.$v['Field'].'';
            $campos[] = array('id'=>$input,'campo'=>$input);
        }
        return $campos;
    }
	
	public function dados_servico($cod)
	{
		$sql = "SELECT * FROM  `" . _DB_PREFIX_ . "correios_offline5_servicos_cadastrados` WHERE id_servico = '".str_pad($cod, 5, "0", STR_PAD_LEFT)."' AND removidos = '0'";
		return Db::getInstance()->getRow($sql);
	}
	
	public function chancela_servico($id)
	{
		$sql = "SELECT * FROM  `" . _DB_PREFIX_ . "correios_offline5_servicos_cadastrados` WHERE id_carrier = '".(int)$id."'";
		$linha = Db::getInstance()->getRow($sql);
		if(isset($linha['id_servico'])){
			if(file_exists(dirname(__FILE__).'/views/chancelas/'.$linha['id_servico'].'.png')){
				return Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/correiosoffpro5/views/chancelas/'.$linha['id_servico'].'.png';
			}else{
				return '';
			}
		}else{
			return '';
		}
	}
	
	public function totalProdutos($params)
	{
		$produtos = $params->getProducts();
		$total = 0;
		foreach($produtos AS $key=>$item){
			$total += $item['quantity']*$item['price_wt'];
		}
		return round($total,2);
	}
	
	public function token_de_acesso_correios(){
		//timeout
		$timeut_correios = (int)Configuration::get('CORREIOSOFFPRO5_TIME_OUT');
		if($timeut_correios==0){
			$timeut_correios = 15;
		}
		//verifica se existe token já cadastrado 
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "correios_offline5_tokens` WHERE atualizado > NOW() ORDER BY atualizado DESC";
		$token_offline = Db::getInstance()->getRow($sql);
		if(isset($token_offline['token'])){
			return array('status'=>200,'dados'=>array('token'=>$token_offline['token']),'url'=>'token retornado de base de dados!');
		}
		//dados e ambiente
		$login = trim(Configuration::get('CORREIOSOFFPRO5_LOGIN'));
		$senha = trim(Configuration::get('CORREIOSOFFPRO5_SENHA'));
		$cartao = trim(Configuration::get('CORREIOSOFFPRO5_CARTAO'));
		//header
		$headers = array(
			"Accept: application/json",
			"Content-Type: application/json",
			"Authorization: Basic ".base64_encode(trim($login).':'.trim($senha))."",
		);
		//gera o token
		$dados = array();
		//endpoint
		if(!empty($cartao)){
			$dados['numero'] = $cartao;
			$urlweb = "https://api.correios.com.br/token/v1/autentica/cartaopostagem";
		}else{
			$urlweb = "https://api.correios.com.br/token/v1/autentica";
		}
		//curl
		$sessao_curl = curl_init($urlweb);
		curl_setopt($sessao_curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($sessao_curl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($sessao_curl, CURLOPT_POST, true);
		curl_setopt($sessao_curl, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($sessao_curl, CURLOPT_POSTFIELDS, json_encode($dados) );
		curl_setopt($sessao_curl, CURLOPT_CONNECTTIMEOUT, $timeut_correios);
		curl_setopt($sessao_curl, CURLOPT_TIMEOUT, 40);
		curl_setopt($sessao_curl, CURLOPT_RETURNTRANSFER, true);
		$resultado = curl_exec($sessao_curl);
		$status    = curl_getinfo($sessao_curl, CURLINFO_HTTP_CODE);
		curl_close($sessao_curl);
		$token = json_decode($resultado,true);
		//cria o token no bd
		if(isset($token['token'])){		
			$sql = "INSERT INTO `" . _DB_PREFIX_ . "correios_offline5_tokens` (`token`, `atualizado`) VALUES ('".$token['token']."', '".$token['expiraEm']."');";
			Db::getInstance()->execute($sql);
		}
		return array('status'=>$status,'dados'=>$token,'url'=>$urlweb);
	}
	
	public function get_frete_correios($servico,$dados,$token){
		//timeout
		$timeut_correios = (int)Configuration::get('CORREIOSOFFPRO5_TIME_OUT');
		if($timeut_correios==0){
			$timeut_correios = 15;
		}
		//url 
		$urlweb = 'https://api.correios.com.br/preco/v1/nacional/'.$servico.'?'.http_build_query($dados);
		//header
		$headers = array(
			"Authorization: Bearer ".trim($token)."",
			"Content-Type: application/json",
		);
		//curl
		$sessao_curl2 = curl_init();
		curl_setopt($sessao_curl2, CURLOPT_URL, $urlweb);
		curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($sessao_curl2, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($sessao_curl2, CURLOPT_POST, false);
		curl_setopt($sessao_curl2, CURLOPT_CONNECTTIMEOUT, $timeut_correios);
		curl_setopt($sessao_curl2, CURLOPT_TIMEOUT, 20);
		curl_setopt($sessao_curl2, CURLOPT_RETURNTRANSFER, true);
		$resultado = curl_exec($sessao_curl2);
		$resultado = @json_decode($resultado,true);
		$status    = curl_getinfo($sessao_curl2, CURLINFO_HTTP_CODE);
		curl_close($sessao_curl2);
		return array('status'=>$status,'dados'=>$resultado,'uri'=>$urlweb);
	}
	
	public function get_prazo_correios($servico,$dados,$token){
		//timeout
		$timeut_correios = (int)Configuration::get('CORREIOSOFFPRO5_TIME_OUT');
		if($timeut_correios==0){
			$timeut_correios = 15;
		}
		//verifica se existe prazo cadastrado 
		$cep_origem = $dados['cepOrigem'];
		$cep_destino = $dados['cepDestino'];
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "correios_offline5_prazos` WHERE id_servico = '".(int)$servico."' AND cep_origem = '".$cep_origem."' AND cep_fim = '".$cep_destino."' AND DATEDIFF(NOW(),data) <= 30 ORDER BY data DESC";
		$prazo_offline = Db::getInstance()->getRow($sql);
		if(isset($prazo_offline['prazo'])){
			return array('status'=>200,'dados'=>array('prazoEntrega'=>$prazo_offline['prazo']),'url'=>'token retornado de base de dados!');
		}
		//url 
		$urlweb = 'https://api.correios.com.br/prazo/v1/nacional/'.$servico.'?'.http_build_query($dados);
		//header
		$headers = array(
			"Authorization: Bearer ".trim($token)."",
			"Content-Type: application/json",
		);
		//curl
		$sessao_curl2 = curl_init();
		curl_setopt($sessao_curl2, CURLOPT_URL, $urlweb);
		curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($sessao_curl2, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($sessao_curl2, CURLOPT_POST, false);
		curl_setopt($sessao_curl2, CURLOPT_CONNECTTIMEOUT, $timeut_correios);
		curl_setopt($sessao_curl2, CURLOPT_TIMEOUT, 20);
		curl_setopt($sessao_curl2, CURLOPT_RETURNTRANSFER, true);
		$resultado = curl_exec($sessao_curl2);
		$resultado = @json_decode($resultado,true);
		$status    = curl_getinfo($sessao_curl2, CURLINFO_HTTP_CODE);
		curl_close($sessao_curl2);
		//cria o prazo no bd
		if(isset($resultado['prazoEntrega'])){		
			$sql = "INSERT INTO `" . _DB_PREFIX_ . "correios_offline5_prazos` (`id_servico`, `prazo`, `cep_origem`, `cep_fim`, `data`) VALUES ('".(int)$servico."', '".$resultado['prazoEntrega']."', '".$cep_origem."', '".$cep_destino."', NOW());";
			Db::getInstance()->execute($sql);
		}
		return array('status'=>$status,'dados'=>$resultado,'uri'=>$urlweb);
	}
	
	public function calcular_frete_online($vars_correios)
	{
		//dados contrato 
		$cod = trim(Configuration::get('CORREIOSOFFPRO5_LOGIN'));
		$senha = trim(Configuration::get('CORREIOSOFFPRO5_SENHA'));
		$cartao = trim(Configuration::get('CORREIOSOFFPRO5_CARTAO'));
		$api = trim(Configuration::get('CORREIOSOFFPRO5_API'));
		
		//dados do servico ativado
		$ativado = Db::getInstance()->getRow("SELECT * FROM `" . _DB_PREFIX_ . "correios_offline5_servicos_cadastrados` WHERE id_carrier = '".(int)($this->id_carrier)."' AND status > 0 AND removidos = '0'");
		$id_servico = $ativado['id_servico'];
		$titulo = $ativado['titulo'];
		$valor_declarado = (bool)isset($ativado['valor_declarado'])?$ativado['valor_declarado']:false;
		
		//timeout
		$timeut_correios = (int)Configuration::get('CORREIOSOFFPRO5_TIME_OUT');
		if($timeut_correios==0){
			$timeut_correios = 15;
		}
		
		//remove caches antigos 
		$tempodecache = (int)Configuration::get('CORREIOSOFFPRO5_CACHE');
		$sql = "DELETE FROM `" . _DB_PREFIX_ . "correios_offline5_cache` WHERE DATEDIFF(atualizado,NOW()) > ".(int)$tempodecache."";
		Db::getInstance()->execute($sql);

		//faz o verificador de cache
		$checksum = md5(json_encode($vars_correios));
		
		//monta a url de calculo 
		if($api=='rest'){
			$url = 'via nova rest api em cache!';
		}else{
			$url = 'http://ws.correios.com.br/calculador/CalcPrecoPrazo.aspx?';
			$url .= http_build_query($vars_correios);
		}
		
		//consulta o cache 1
		$sql = "SELECT * FROM  `" . _DB_PREFIX_ . "correios_offline5_cache` WHERE hash = '".$checksum."' AND DATEDIFF(atualizado,NOW()) <= ".(int)$tempodecache." ORDER BY id DESC";
		$resultado_cache = Db::getInstance()->getRow($sql);
		if(isset($resultado_cache['json']) && !empty($resultado_cache['json'])){
			$cache = json_decode($resultado_cache['json'],true);
			if(isset($cache[$id_servico])){
				$resultado_cache = array('erro'=>false,'resultado'=>$cache,'url'=>$url,'cache'=>true);
				//modo debug
				if(Configuration::get('CORREIOSOFFPRO5_DEBUG')==1){
					$this->salvar_log(''.date('d/m/Y H:i:s').' '.$titulo.' Resultado Cache Debug:');
					$this->salvar_log($resultado_cache);
				}
				return $resultado_cache;
			}
		}
		
		//se rest 
		if($api=='rest'){
			//nova api de calculo
			$token_api = $this->token_de_acesso_correios();
			//debug
			if ( Configuration::get('CORREIOSOFFPRO5_DEBUG')==1 || !isset($token_api['dados']['token']) ) {
				$this->salvar_log( 'Debug Correios Auth API Rest: ' . print_r( $token_api, true ) );
			}
			//token nao ok
			if(!isset($token_api['dados']['token'])){
				return false;
			}else{
				//token rest
				$token = trim($token_api['dados']['token']);
				$codServico = $vars_correios['nCdServico'];
				//dados a calcular 
				$dados = array();
				$dados['psObjeto']=$vars_correios['nVlPeso']*1000;
				$id_contrato_correios = Configuration::get('CORREIOSOFFPRO5_CONTRATO');
				$id_dr_correios = Configuration::get('CORREIOSOFFPRO5_DR');
				if(!empty(trim($id_contrato_correios))){
					$dados['nuContrato'] = trim($id_contrato_correios);
					$dados['nuDR'] = trim($id_dr_correios);
				}
				$dados['cepOrigem']=$vars_correios['sCepOrigem'];
				$dados['cepDestino']=$vars_correios['sCepDestino'];
				$dados['VlDeclarado']=$vars_correios['nVlValorDeclarado'];
				$dados['tpObjeto']=2;
				$dados['comprimento']=$vars_correios['nVlComprimento'];
				$dados['largura']=$vars_correios['nVlLargura'];
				$dados['altura']=$vars_correios['nVlAltura'];
				if($valor_declarado){
					$dados['servicosAdicionais'][] = (isset($this->correios_vd[$codServico])?$this->correios_vd[$codServico]:'019');
				}
				if(Configuration::get('CORREIOSOFFPRO5_AR')==1){
					$dados['servicosAdicionais'][] = '001';
				}
				if(Configuration::get('CORREIOSOFFPRO5_MP')==1){
					$dados['servicosAdicionais'][] = '002';
				}
				$resultado = $this->get_frete_correios($codServico,$dados,$token);
				$resultado_prazo = $this->get_prazo_correios($codServico,$dados,$token);
				$url = $resultado['uri'];
				//debug
				if ( Configuration::get('CORREIOSOFFPRO5_DEBUG')==1 || !isset($resultado['dados']['pcFinal']) ) {
					$this->salvar_log( 'Debug Correios Frete API Rest: ' . print_r( $resultado, true ) );
				}
				//se erro
				if(!isset($resultado['dados']['pcFinal'])){
					$erro_correios_rest_api = isset($resultado['dados']['msgs'][0])?$resultado['dados']['msgs'][0]:'Erro ao calcular frete via Rest API Correios (ver logs)!';
					return array('erro'=>true,'erro_curl'=>$erro_correios_rest_api,'resultado'=>$resultado,'url'=>$resultado['uri']);
				}else{
					//resultado 
					$resultado_frete = $this->tratar_resultado($resultado['dados'],$resultado_prazo['dados'],$codServico);
					//cria o cache
					if(count($resultado_frete) > 0){
						$sql = "INSERT INTO `" . _DB_PREFIX_ . "correios_offline5_cache` SET hash = '".$checksum."', peso = '".$vars_correios['nVlPeso']."', total = '".$vars_correios['nVlValorDeclarado']."', cep_destino = '".$vars_correios['sCepDestino']."', json = '".Db::getInstance()->escape(json_encode($resultado_frete))."', atualizado = NOW()";
						Db::getInstance()->execute($sql);
					}
					//retorna o resultado 
					$resultado_ok = array('erro'=>false,'resultado'=>$resultado_frete,'url'=>$resultado['uri'],'cache'=>false,'data_hora'=>date('d/m/Y H:i'));
					//modo debug
					if(Configuration::get('CORREIOSOFFPRO5_DEBUG')==1){
						$this->salvar_log(''.date('d/m/Y H:i:s').' '.$titulo.' Resultado Online Debug:'.print_r($resultado_ok,true));
					}
					return $resultado_ok;
				}
			}
		}else{
			//webservice
			$ch = curl_init(); 
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_URL, $url); 
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, ($timeut_correios+5));
			curl_setopt($ch, CURLOPT_TIMEOUT, $timeut_correios); 
			if(curl_errno($ch)) {
				//erro de curl 
				$this->salvar_log(''.date('d/m/Y H:i:s').' '.$titulo.' - Ops, calculo online Correios falhou por erro de Curl '.curl_error($ch).'!');
				return array('erro'=>true,'erro_curl'=>curl_error($ch),'resultado'=>array(),'url'=>$url);
			}else{
				$resultado  = curl_exec($ch); 
				$curlCod    = curl_getinfo($ch, CURLINFO_HTTP_CODE);
				curl_close($ch);
				//trata o resultado 
				if($curlCod != 200){
					//erro de http 
					$this->salvar_log(''.date('d/m/Y H:i:s').' '.$titulo.' - Ops, calculo online Correios falhou por erro de HTTP '.$curlCod.'!');
					return array('erro'=>true,'erro_curl'=>$curlCod,'resultado'=>$resultado,'url'=>$url);
				} elseif ( $curlCod == 200 ) {
					libxml_use_internal_errors(true);
					$objeto_xml = simplexml_load_string($resultado);
					//erro de xml
					if ($objeto_xml === false) {
						//erro de http 
						$this->salvar_log(''.date('d/m/Y H:i:s').' '.$titulo.' - Ops, calculo online Correios falhou por erro de XML!');
						return array('erro'=>true,'resultado'=>array(),'url'=>$url);
					}else{
						//resultado 
						$resultado_frete = $this->tratar_resultado($objeto_xml);
						//verifica se retornou todos com erro
						if(isset($resultado_frete['erros']) && 1==$resultado_frete['erros']){
							//retorn o resultado como erro 
							$resultado_com_erro = array('erro'=>true,'resultado'=>$resultado_frete,'url'=>$url,'cache'=>false,'data_hora'=>date('d/m/Y H:i'));
							//modo debug
							if(Configuration::get('CORREIOSOFFPRO5_DEBUG')==1){
								$this->salvar_log(''.date('d/m/Y H:i:s').' '.$titulo.' Resultado Online Debug:'.print_r($resultado_com_erro,true));
							}
							return $resultado_com_erro;
						}else{
							//cria o cache
							if(count($resultado_frete) > 0){
								$sql = "INSERT INTO `" . _DB_PREFIX_ . "correios_offline5_cache` SET hash = '".$checksum."', peso = '".str_replace(',','.',$vars_correios['nVlPeso'])."', total = '".str_replace(',','.',$vars_correios['nVlValorDeclarado'])."', cep_destino = '".$vars_correios['sCepDestino']."', json = '".Db::getInstance()->escape(json_encode($resultado_frete))."', atualizado = NOW()";
								Db::getInstance()->execute($sql);
							}
							//retorna o resultado 
							$resultado_ok = array('erro'=>false,'resultado'=>$resultado_frete,'url'=>$url,'cache'=>false,'data_hora'=>date('d/m/Y H:i'));
							//modo debug
							if(Configuration::get('CORREIOSOFFPRO5_DEBUG')==1){
								$this->salvar_log(''.date('d/m/Y H:i:s').' '.$titulo.' Resultado Online Debug:'.print_r($resultado_ok,true));
							}
							return $resultado_ok;
						}
					}
				}
			}
		}
	}
	
	public function calcular_frete_offline($vars_correios){
		//custom 
		$servicos_correios = explode(',',$vars_correios['nCdServico']);
		$peso = (float)str_replace(',','.',$vars_correios['nVlPeso']);
		if($peso <= 0.30){
			$peso = 0.30;
		}elseif($peso <= 1.00){
			$peso = 1.00;
		}else{
			$peso = number_format(round($peso), 2, '.', '');
		}
		$para = $vars_correios['sCepDestino'];
		$para = substr(str_pad(preg_replace('/\D/', '', $para), 8, "0", STR_PAD_LEFT),0,5);
		//inicio 
		$fretes = array();
		$servicos_total = count($servicos_correios);
		$erro = 0;
		foreach($servicos_correios as $k => $v){
			$sql = "SELECT * FROM `" . _DB_PREFIX_ . "correios_offline5_cotacoes` WHERE id_servico = '".$v."' AND peso = ".$peso." AND erro = 0 AND valor > 0 AND (".(int)$para." BETWEEN `cep_inicio` AND `cep_fim`) ORDER BY custom DESC";
			$resultado = Db::getInstance()->getRow($sql);
			if(!$resultado){
				$erro++;
				$fretes[$v] = array('offline'=>true,'valor'=>0.00,'prazo'=>0,'servico'=>$v,'erro'=>'-999','alerta'=>'Servico '.$v.' sem frete offline cadastrado ao cep '.$para.' e peso '.$peso.'!','servico'=>$this->dados_servico($v));
			}else{
				$linha = $resultado;
				$fretes[$v] = array('offline'=>true,'valor'=>$linha['valor'],'prazo'=>$linha['prazo'],'servico'=>$v,'erro'=>'0','alerta'=>'','servico'=>$this->dados_servico($v),'regra'=>$linha);
			}
		}
		if($erro==$servicos_total){
			$resultado_offline = array('log_offline'=>'Frete Offline indisponível ao CEP '.$para.' e peso '.$peso.'','erro'=>true,'resultado'=>$fretes,'data_hora'=>date('d/m/Y H:i'));
		}else{
			$resultado_offline = array('log_offline'=>'Frete Offline indisponível ao CEP '.$para.' e peso '.$peso.'','erro'=>false,'resultado'=>$fretes,'data_hora'=>date('d/m/Y H:i'));
		}
		//modo debug
		if(Configuration::get('CORREIOSOFFPRO5_DEBUG')==1){
			$this->salvar_log(''.date('d/m/Y H:i:s').' '.$titulo.' Resultado Offline Debug:');
			$this->salvar_log($resultado_offline);
		}
		return $resultado_offline;
	}
	
	public function tratar_resultado($objeto_xml,$resultado_prazo=array(),$servico_rest=''){
		$api = trim(Configuration::get('CORREIOSOFFPRO5_API'));
		$fretes = array();
		if($api=='webservice'){
			$obj = json_decode(json_encode($objeto_xml),true);
			if(isset($obj['cServico'][0]['Codigo'])){
				$erros = 0;
				foreach($obj['cServico'] as $k => $v){
					$valor_frete = (float)str_replace(',','.',str_replace('.','',$v['Valor']));
					if($valor_frete==0){
						$erros++;
					}
					$prazo = $v['PrazoEntrega'];
					$servico = $v['Codigo'];
					$erro = $v['Erro'];
					//$alerta = $v['MsgErro'];
					$alerta = isset($v['obsFim'])?$v['obsFim']:'';
					$fretes[$servico] = array('erros'=>$erros, 'offline'=>false,'valor'=>$valor_frete,'prazo'=>$prazo,'servico'=>$servico,'erro'=>$erro,'alerta'=>$alerta,'servico'=>$this->dados_servico($servico));
				}
			}elseif(isset($obj['cServico']['Codigo']) && !empty($obj['cServico']['Codigo'])){
				$erros = 0;
				$valor_frete = (float)str_replace(',','.',str_replace('.','',$obj['cServico']['Valor']));
				if($valor_frete==0){
					$erros++;
				}
				$prazo = $obj['cServico']['PrazoEntrega'];
				$servico = $obj['cServico']['Codigo'];
				$erro = $obj['cServico']['Erro'];
				//$alerta = $obj['cServico']['MsgErro'];
				$alerta = isset($obj['cServico']['obsFim'])?$obj['cServico']['obsFim']:'';
				$fretes[$servico] = array('erros'=>$erros, 'offline'=>false,'valor'=>$valor_frete,'prazo'=>$prazo,'servico'=>$servico,'erro'=>$erro,'alerta'=>$alerta,'servico'=>$this->dados_servico($servico));
			}else{
				$erro = $obj['cServico']['MsgErro'];
				return array('erros'=>1,'msg'=>$erro);
			}
		}else{
			$prazo = isset($resultado_prazo['prazoEntrega'])?$resultado_prazo['prazoEntrega']:10;
			$erros = 0;
			$erro = '';
			$alerta = '';
			$valor_frete = (float)str_replace(',','.',str_replace('.','',$objeto_xml['pcFinal']));
			$fretes[$servico_rest] = array('erros'=>$erros, 'offline'=>false,'valor'=>$valor_frete,'prazo'=>$prazo,'servico'=>$this->dados_servico($servico_rest),'erro'=>$erro,'alerta'=>$alerta);
		}
		return $fretes;
	}
	
	public function consulta($fonte,$dados){
		//dados do servico ativado
		$ativado = Db::getInstance()->getRow("SELECT * FROM `" . _DB_PREFIX_ . "correios_offline5_servicos_cadastrados` WHERE id_carrier = '".(int)($this->id_carrier)."' AND status > 0 AND removidos = '0'");
		$id_servico = $ativado['id_servico'];
		$titulo = $ativado['titulo'];
		//calculos
		if($fonte==2){
			//offline
			$offline = $this->calcular_frete_offline($dados);
			if($offline['erro']){
				$this->salvar_log(''.date('d/m/Y H:i:s').' '.$titulo.' - Ops, calculo offline Correios falhou ou indisponível no momento, tentativa de frete online realizada!');
				return $this->calcular_frete_online($dados);
			}else{
				return $offline;
			}
		}elseif($fonte==3){
			//offline se webservice falhar
			$online = $this->calcular_frete_online($dados);
			if($online['erro']){
				$offline = $this->calcular_frete_offline($dados);
				$this->salvar_log(''.date('d/m/Y H:i:s').' '.$titulo.' - Ops, calculo online Correios falhou ou indisponível no momento, tentativa de frete offline realizada!');
				return $offline;	
			}else{
				return $online;
			}
		}else{
			//online
			return $this->calcular_frete_online($dados);
		}
	}
	
	public function hookShoppingCart($params)
	{
		//se inativo
		if(Configuration::get('CORREIOSOFFPRO5_STATUS')==0){
			return;
		}
		
		//se simulador do carrinho esta inativo
		if(Configuration::get('CORREIOSOFFPRO5_SIMULADOR_CART')==0){
			return;
		}
		
		//se checkout de uma pagina
		if(Configuration::get('PS_ORDER_PROCESS_TYPE') == 1){
			//return;
		}
		
		//senao exibir carrinho ou itens
		if (!isset($this->context->cart) || $this->context->cart->getProducts() == 0){
			return;	
		}
		
		//layout
		$cep_formatado = '';
		$cep = isset($this->context->cookie->postcode)?$this->context->cookie->postcode:'';
		$cep = preg_replace('/\D/', '', $cep);
		if(strlen($cep)==8){
			$cep_formatado = substr($cep,0,5).'-'.substr($cep,-3);
		}
		$this->context->smarty->assign('custom_css', '');
		$this->context->smarty->assign('delay', true);
		$this->context->smarty->assign('cep_salvo', $cep_formatado);
		$this->context->smarty->assign('base_loja', Tools::getShopDomainSsl(true, true).__PS_BASE_URI__);
        $output = $this->context->smarty->fetch($this->local_path.'views/templates/front/simulador_carrinho.tpl');
		
		return $output;
	}
	
	public function simulador($params)
	{
		//se inativo modulo
		if(Configuration::get('CORREIOSOFFPRO5_STATUS')==0 || !isset($_GET['id_product'])){
			return;
		}
		//se ativo opcao
		if(Configuration::get('CORREIOSOFFPRO5_SIMULADOR')==1){
			//consulta o produto
			$produto = new Product((int)$_GET['id_product']);
			//se produto virtual
			if($produto->is_virtual){
				return;
			}
			//layout
			$cep_formatado = '';
			$cep = isset($this->context->cookie->postcode)?$this->context->cookie->postcode:'';
			$cep = preg_replace('/\D/', '', $cep);
			if(strlen($cep)==8){
				$cep_formatado = substr($cep,0,5).'-'.substr($cep,-3);
			}
			$this->context->smarty->assign('custom_css', '');
			$this->context->smarty->assign('delay', true);
			$this->context->smarty->assign('cep_salvo', $cep_formatado);
			$this->context->smarty->assign('base_loja', Tools::getShopDomainSsl(true, true).__PS_BASE_URI__);
			$output = $this->context->smarty->fetch($this->local_path.'views/templates/front/simulador.tpl');
			return $output;
		}else{
			return;
		}
	}
	
	public function hookDisplayRightColumnProduct($params)
	{
		if(Configuration::get('CORREIOSOFFPRO5_SIMULADOR_HOOK')=='hookDisplayRightColumnProduct'){
			return $this->simulador($params);
		}else{
			return;
		}
	}

	public function hookExtraleft($params)
	{
		if(Configuration::get('CORREIOSOFFPRO5_SIMULADOR_HOOK')=='hookExtraleft'){
			return $this->simulador($params);
		}else{
			return;
		}
	}

	public function hookProductActions($params)
	{
		if(Configuration::get('CORREIOSOFFPRO5_SIMULADOR_HOOK')=='hookProductActions'){
			return $this->simulador($params);
		}else{
			return;
		}
	}
	
	public function hookDisplayAfterCarrier($params)
    {
		return;
	}
	
	public function hookdisplayBeforeCarrier($params) {
		global $cookie, $smarty;
		//salva os prazos em json
		if(isset($this->prazos)){
			$this->context->cookie->__set('prazos', json_encode($this->prazos));
		}
		//exibe prazo custom 1
		$output = '';
		if (isset($smarty->tpl_vars['delivery_option_list'])) {
			$delivery_option_list = $smarty->tpl_vars['delivery_option_list'];
			foreach ($delivery_option_list->value as $option_list) {
				foreach ($option_list as $option) {
					foreach ($option['carrier_list'] as $carrier) {
						if (isset($this->prazos[$carrier['instance']->id])) {
							$prazo = $this->prazos[$carrier['instance']->id];
							if (is_numeric($prazo)) {
								if($prazo==1){
									$carrier['instance']->delay[$cookie->id_lang] = $this->l('em até').' '.$prazo.' '.$this->l('dia util.');
								}else{
									$carrier['instance']->delay[$cookie->id_lang] = $this->l('em até').' '.$prazo.' '.$this->l('dias úteis.');
								}
							} 
						}
					}
				}
			}
		}
		//exibe prazo custom 2
		if (null != $this->context->cart->getDeliveryOptionList()) {
			$delivery_option_list = $this->context->cart->getDeliveryOptionList();
			foreach ($delivery_option_list as $id_address => $carrier_list_raw) {
				foreach ($carrier_list_raw as $key => $carrier_list) {
					foreach ($carrier_list['carrier_list'] as $id_carrier => $carrier) {
						if (isset($this->prazos[$carrier['instance']->id])) {
							$prazo = $this->prazos[$carrier['instance']->id];
							if (is_numeric($prazo)) {
								if($prazo==1){
									$carrier['instance']->delay[$cookie->id_lang] = $this->l('em até').' '.$prazo.' '.$this->l('dia util.');
								}else{
									$carrier['instance']->delay[$cookie->id_lang] = $this->l('em até').' '.$prazo.' '.$this->l('dias úteis.');
								}
							} 
						}
					}
				}
			}
		}
		//exibe o hook com prazos customizados
		if(Configuration::get('CORREIOSOFFPRO5_HOOK')==1 && isset($this->prazos_hook) && count($this->prazos_hook) > 0){
			$this->context->smarty->assign('prazos_correios_pro', $this->prazos_hook);
			$output .= $this->context->smarty->fetch($this->local_path.'views/templates/front/prazos.tpl');
		}
		//exibe o hook com alertas
		if(Configuration::get('CORREIOSOFFPRO5_ALERTAS')==1 && isset($this->alertas) && count($this->alertas) > 0){
			$this->context->smarty->assign('alertas_correios_pro', $this->alertas);
			$output .= $this->context->smarty->fetch($this->local_path.'views/templates/front/alertas.tpl');
		}
		return $output;
    }
	
	public function getPackageShippingCost($params, $shipping_cost, $products) {
		if(isset($_GET['id_order'])){
			$order = new Order((int)($_GET['id_order']));
			return (float)$order->total_shipping;
		}
		return $this->getOrderShippingCost($params, $shipping_cost);
	}
	
	public function getOrderShippingCost($params, $shipping_cost) {
		global $cookie;
		//fix 
		$controler = isset($_REQUEST['controller'])?strtolower($_REQUEST['controller']):'';
		if(!isset($_GET['controller']) && !empty($controler)){
			return false;
		}elseif(substr($controler,0,5)=="admin"){
			return false;
		}elseif($controler=="adminorders"){
			return false;
		}elseif($controler=="cart" && isset($_REQUEST['add'])){
			return false;
		}
		//se o modudlo esta ativadog
		$api = Configuration::get('CORREIOSOFFPRO5_API');
		if(Configuration::get('CORREIOSOFFPRO5_STATUS')==0 || !isset($this->id_carrier) || (int)$this->id_carrier==0){
            return false;
		}
		//init 
		$context = Context::getContext();
		//dados do servico ativado
		$ativado = Db::getInstance()->getRow("SELECT * FROM `" . _DB_PREFIX_ . "correios_offline5_servicos_cadastrados` WHERE id_carrier = '".(int)($this->id_carrier)."' AND status > 0 AND removidos = '0'");
		if(!isset($ativado['id_servico']) || empty($ativado['id_servico'])){
			return false;
		}
		$id_servico = $ativado['id_servico'];
		$status_servico = $ativado['status'];
		$valor_declarado = (bool)isset($ativado['valor_declarado'])?$ativado['valor_declarado']:false;
		//dados de origem e destino
		$address = new Address($params->id_address_delivery);
		if (!Validate::isLoadedObject($address)) {
			$address->id_country = $cookie->id_country;
			$address->id_state = $cookie->id_state;
			$address->postcode = $cookie->postcode;
		}
		$cep_destino = preg_replace('/\D/', '', $address->postcode);
		if(strlen($cep_destino)!=8){
			return false;
		}
		//inicia o calculo
		$produtos_cubados = $this->dados_produtos($params);
		if(count($produtos_cubados) > 0){
			//calcula os limites e cubagem 
			$cubagem = $this->cubagem( $produtos_cubados['alt'], $produtos_cubados['com'], $produtos_cubados['lar'] );
			$peso_cubado = $this->peso_cubado( $cubagem );
			$total_pedido = $total_pedido_real = $this->totalProdutos($params);
			//valida o pacote 
			$valido = $this->validar_pacote($cubagem,$peso_cubado);
			if($valido){
				//peso base
				$peso_real = $produtos_cubados['peso'];
				if($peso_real > $peso_cubado){
					$peso_base = $peso_real;
				}elseif($peso_cubado > $peso_real && $peso_real > 5.00){
					$peso_base = $peso_cubado;
				}else{
					$peso_base = $peso_real;
				}
				$peso_base = ($peso_base > 0)?$peso_base:0.30;
				//regra valor minimo 
				if($total_pedido > 0 && $total_pedido < 23.50){
					$total_pedido = 23.50;
				}elseif($total_pedido > 10000){
					$total_pedido = 10000;
				}
				//medidas 
				$alt = ($cubagem['alt'] >= 1)?$cubagem['alt']:1;
				$com = ($cubagem['com'] >= 15)?$cubagem['com']:15;
				$lar = ($cubagem['lar'] >= 10)?$cubagem['lar']:10;
				//formata de acordo com a versão da api 
				if($api=='rest'){
					$peso_base = number_format($peso_base, 2, '.', '');
					$com = number_format($com, 2, '.', '');
					$alt = number_format($alt, 2, '.', '');
					$lar = number_format($lar, 2, '.', '');
					$total = number_format($total_pedido, 2, '.', '');
				}else{
					$peso_base = number_format($peso_base, 2, ',', '');
					$com = number_format($com, 2, ',', '');
					$alt = number_format($alt, 2, ',', '');
					$lar = number_format($lar, 2, ',', '');
					$total = number_format($total_pedido, 2, ',', '');
				}
				//monta os dados correios
				$cotacoes = $erros = array();

				//dados a calcular nos correios 
				$vars_correios = array(
					'nCdServico'          => $id_servico,
					'nCdEmpresa'          => trim(Configuration::get('CORREIOSOFFPRO5_LOGIN')),
					'sDsSenha'            => trim(Configuration::get('CORREIOSOFFPRO5_SENHA')),
					'sCepDestino'         => $cep_destino,
					'sCepOrigem'          => preg_replace('/\D/', '', Configuration::get('CORREIOSOFFPRO5_CEP')),
					'nVlAltura'           => $alt,
					'nVlLargura'          => $lar,
					'nVlDiametro'         => 0,
					'nVlComprimento'      => $com,
					'nVlPeso'             => $peso_base,
					'nCdFormato'          => 1,
					'sCdMaoPropria'       => ((Configuration::get('CORREIOSOFFPRO5_MP')==1)?'S':'N'),
					'nVlValorDeclarado'   => (($valor_declarado)?$total:'0'),
					'sCdAvisoRecebimento' => ((Configuration::get('CORREIOSOFFPRO5_AR')==1)?'S':'N'),
					'StrRetorno'          => 'xml',
				);
				//se possuir servicos a cobrar forca o valor declarado
				if('40045'==$id_servico || '40126'==$id_servico){
					$vars_correios = array_replace($vars_correios,array('nVlValorDeclarado' => $total));
				}
				//se pac mini e valor declarado ativo 
				if('04227'==$id_servico && $valor_declarado){
					$vars_correios = array_replace($vars_correios,array('nVlValorDeclarado' => '100,00'));					
				}
				//fonte de consulta
				$resultado = $this->consulta($status_servico,$vars_correios);
				//resulado
				if(!isset($resultado['erro']) && $resultado['erro']==false){
					return false;
				}elseif(isset($resultado['resultado'][$id_servico])){
					$cota = $resultado['resultado'][$id_servico];
					if($cota['valor'] > 0){
						//print_r($cota);
						//custom
						$extra = 0;
						$prazo_extra = isset($cota['servico']['prazo_extra'])?$cota['servico']['prazo_extra']:0;
						$valor_extra = isset($cota['servico']['valor_extra'])?$cota['servico']['valor_extra']:0;
						$tipo__extra = isset($cota['servico']['real_porcentagem'])?$cota['servico']['real_porcentagem']:0;
						$total_minim = isset($cota['servico']['total_minimo'])?$cota['servico']['total_minimo']:0;
						$total_minif = isset($cota['servico']['total_minimo_frete'])?$cota['servico']['total_minimo_frete']:0;
						$total_maxim = isset($cota['servico']['total_maximo'])?$cota['servico']['total_maximo']:10000;
						$ceps = isset($cota['servico']['ceps'])?$cota['servico']['ceps']:'';
						$ceps__frete = trim($ceps);
						$ceps_excluir = isset($cota['servico']['ceps_excluir'])?$cota['servico']['ceps_excluir']:'';
						$ceps__exclu = trim($ceps_excluir);
						$titulo      = $cota['servico']['titulo'];
						$peso_maximo = $cota['servico']['peso_maximo'];
						$total_frete = $cota['valor'];
						//calcula o valor extra 
						$valor_extra = abs($valor_extra);
						if($valor_extra > 0 && $tipo__extra == 0){
							$extra = $valor_extra;
							$total_frete = $total_frete+$extra;
						}elseif($valor_extra > 0 && $tipo__extra == 1){
							$extra = ($total_frete/100)*$valor_extra;
							$total_frete = $total_frete+$extra;
						}elseif($valor_extra > 0 && $tipo__extra == 2 && $total_minim > 0 && $total_pedido_real >= $total_minim){
							$extra = ($total_frete/100)*$valor_extra;
							$total_frete = $total_frete-$extra;
						}elseif($valor_extra > 0 && $tipo__extra == 3 && $total_minim > 0 && $total_pedido_real >= $total_minim){
							$total_frete = $total_frete-$valor_extra;
						}
						//regra frete a excluir o calculo 
						$pular_metodo = false;
						if(!empty($ceps__exclu)){
							$remover = $this->cepValidar($cep_destino,$ceps__exclu,$total_pedido_real);
							if($remover){
								return false;
							}
						}
						//regra frete gratuito
						if($total_minif > 0 && $total_pedido_real >= $total_minif){
							if(!empty($ceps__frete)){
								$gratuito = $this->cepValidar($cep_destino,$ceps__frete,$total_pedido_real,$total_minif);
							}else{
								$gratuito = true;
							}
							if($gratuito){
								$total_frete = 0.00;
							}
						}
						
						//prazo custom 
						$this->prazos_hook[$titulo] = (int)$cota['prazo']+$prazo_extra;
						if(isset($cota['alerta']) && is_string($cota['alerta']) && !empty($cota['alerta'])){
							$this->alertas[$titulo] = $cota['alerta'];
						}
						$this->prazos[$this->id_carrier] = (int)$cota['prazo']+$prazo_extra;
						
						//beta salvar prazo em um cookie 
						Context::getContext()->cookie->__set(md5($this->id_carrier),((int)$cota['prazo']+$prazo_extra));
						
						//salva o prazo customizado no banco de dados para o simulador 
						$sql = "REPLACE INTO `" . _DB_PREFIX_ . "prazos_entrega` (`id_carrinho`,`id_transportadora`,`prazo`) VALUES ('".(int)$params->id."', '".$this->id_carrier."', '".((int)$cota['prazo']+$prazo_extra)."');";
						Db::getInstance()->execute($sql);
						//retorna o valor 
						return (float)$total_frete;
					}else{
						return false;
					}
				}else{
					return false;
				}
			}else{
				return false;
			}
		}else{
			return false;
		}
	}
	
	private function cepValidar($cep,$faixas,$total_pedido=0,$total_minimo=0){
        $faixas = trim($faixas);
        $cep_ignorado = false;
        if (!empty($faixas)) {
            $faixas       = explode(PHP_EOL, $faixas);
            foreach ($faixas as $v) {
				$quebra = explode(',', $v);
				if(isset($quebra[2]) && (float)$quebra[2] > 0){
					$total_minimo = (float)$quebra[2];
				}
				if (isset($quebra[0]) && $cep >= preg_replace('/\D/', '', $quebra[0]) && isset($quebra[1]) && $cep <= preg_replace('/\D/', '', $quebra[1]) && $total_pedido >= $total_minimo) {
					$cep_ignorado = true;
					break;
				}
            }
        }
        return $cep_ignorado;
    }
}

