<?php
class AdminPrePostagem5EnviosFinalizadosController extends ModuleAdminController
{
	public function __construct() {
        $this->bootstrap = true;
		parent::__construct();
	}
	
	public function initPageHeaderToolbar(){
        parent::initPageHeaderToolbar();
		if (empty($this->display)) {
			$this->page_header_toolbar_btn['sigep_status_conta'] = array(
				'class' => 'fix_icons',
                'href' => 'javascript:prepostagem5_status_conta()',
                'desc' => $this->l('Status API', null, null, false),
                'icon' => 'fa fa-globe'
            );
        }
    }
	
	public function createTemplate($tpl_name){
        if (file_exists($this->getTemplatePath() . $tpl_name) && $this->viewAccess())
                return $this->context->smarty->createTemplate($this->getTemplatePath() . $tpl_name, $this->context->smarty);
            return parent::createTemplate($tpl_name);
    }
	
	public function initContent() {
        parent::initContent();
		$acao = isset($_REQUEST['acao'])?$_REQUEST['acao']:'pedidos_finalizados';
		if($acao=='pedidos_finalizados'){
			return $this->pedidos_finalizados();
		}elseif($acao=='bloquear_objetos'){
			return $this->bloquear_objetos();
		}
    }
	
	private function bloquear_objetos(){
		//acoes
		if(!isset($_POST['envios']) || count($_POST['envios'])==0){
			die(json_encode(array('erro'=>true,'log'=>'Ops, nenhum objeto selecionado para bloquear!')));
		}else{
			$logs = array();
			$envios = $_POST['envios'];
			foreach($envios AS $k=>$v){
				$envioid = $v['id'];
				$plpid = $v['plp'];
				//dados do pacote
				$enviorow = $this->module->dados_pacote($envioid);
				if($enviorow){
					$envio = $enviorow;
					$objeto = $envio['cod_rastreio_pacote_dv'];
					if($envio['pacote_bloqueado']){
						$logs[$k] = array('erro'=>true,'log'=>$envioid.' - Objeto '.$objeto.': já encontra-se bloqueado!');
					}elseif($envio['pacote_entregue']){
						$logs[$k] = array('erro'=>true,'log'=>$envioid.' - Objeto '.$objeto.' já encontra-se entregue!');
					}elseif(empty($envio['cod_rastreio_pacote_dv'])){
						$logs[$k] = array('erro'=>true,'log'=>$envioid.' - Objeto não localizado!');
					}else{
						//nova api
						$token_api = $this->module->token_de_acesso_correios();
						if(!isset($token_api['dados']['token'])){
							$resultado['erro'] = true;
							$resultado['log'] = ''.$token_api['status'].' - Erro ao obter o token api Correios!';
							if(isset($token_api['dados']['stackTrace'])){
								unset($token_api['dados']['stackTrace']);
							}
							$resultado['raw'] = $token_api;
						}else{
							//end
							if(Configuration::get('PREPOSTAGEM5_AMBIENTE')=='H'){
								$urlweb = 'https://apihom.correios.com.br/srointeratividade/v1/suspensao/'.trim($objeto);
							}else{
								$urlweb = 'https://api.correios.com.br/srointeratividade/v1/suspensao/'.trim($objeto);
							}
							//header
							$headers = array(
								"Authorization: Bearer ".trim($token_api['dados']['token'])."",
								"Content-Type: application/json",
							);
							//request
							$sessao_curl2 = curl_init();
							curl_setopt($sessao_curl2, CURLOPT_URL, $urlweb);
							curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYPEER, false);
							curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYHOST, false);
							curl_setopt($sessao_curl2, CURLOPT_HTTPHEADER, $headers);
							curl_setopt($sessao_curl2, CURLOPT_CUSTOMREQUEST, "POST");
							curl_setopt($sessao_curl2, CURLOPT_CONNECTTIMEOUT, 5);
							curl_setopt($sessao_curl2, CURLOPT_TIMEOUT, 10);
							curl_setopt($sessao_curl2, CURLOPT_RETURNTRANSFER, true);
							$resultados = $original = curl_exec($sessao_curl2);
							$resultados = @json_decode($resultados,true);
							$status    = curl_getinfo($sessao_curl2, CURLINFO_HTTP_CODE);
							curl_close($sessao_curl2);
							if($status==201){
								$resultado['erro'] = false;
								$resultado['raw'] = $resultados;
							}else{
								$resultado['erro'] = true;
								//erro
								$erro = array();
								if(isset($resultados['msgs'])){
									foreach($resultados['msgs'] as $err){
										$erro[] = $err;
									}
								}
								if(isset($resultados['causa'])){
									$erro[] = $resultados['causa'];
								}
								$resultado['mensagem'] = implode(',',$erro);
							}
						}
						//debug 
						if(Configuration::get('PREPOSTAGEM5_STATUS_DEBUG') || $resultado['erro']){
							$this->module->salvar_log('[Pré-Postagem] Debug Bloquear Objeto: '.http_build_query($resultado));
						}
						//erro
						if($resultado['erro']){
							//log
							$this->module->salvar_log('[Pré-Postagem] Erro ao bloquear Objeto: '.$objeto.'');
							$logs[] = array('erro'=>true,'log'=>$envioid.' - Objeto '.$objeto.': '.$resultado['mensagem'].'');
						}else{
							//log
							$this->module->salvar_log('[Pré-Postagem] Objeto bloqueado com sucesso: '.$objeto.'');
							//salva no banco de dados 
							Db::getInstance()->execute("UPDATE `" ._DB_PREFIX_. "prepostagem5_pacotes` SET pacote_bloqueado = 1, log_bloqueio = 'Objeto bloqueado por Administrador' em ".date('d/m/Y H:i:s')." (".$resultado['mensagem'].")' WHERE id_pacote = '".(int)$envioid."'");
							//logs
							$logs[] = array('erro'=>false,'log'=>$envioid.' - Objeto '.$objeto.' bloqueado com sucesso!','resultado'=>$resultado);
						}
					}
				}
			}
			
			//exibe os logs
			die(json_encode($logs));
		}
		exit;
	}
	
	private function pedidos_finalizados(){
		//layout
        $tpl = $this->createTemplate('envios_finalizados.tpl');
		$where = '';
		if(isset($_GET['s']) && !empty($_GET['s'])){
			$where .= " AND (a.id_plp LIKE '%".pSQL($_GET['s'])."%' || a.id_servico_pacote LIKE '%".pSQL($_GET['s'])."%' || a.id_pedido_pacote LIKE '%".pSQL($_GET['s'])."%' || a.nfe_pacote LIKE '%".pSQL($_GET['s'])."%' || a.cod_rastreio_pacote_dv LIKE '%".pSQL($_GET['s'])."%' || b.nome LIKE '%".pSQL($_GET['s'])."%' || b.logradouro LIKE '%".pSQL($_GET['s'])."%' || b.bairro LIKE '%".pSQL($_GET['s'])."%' || b.cidade LIKE '%".pSQL($_GET['s'])."%' || b.uf LIKE '%".pSQL($_GET['s'])."%' || b.cep LIKE '%".pSQL($_GET['s'])."%') ";
		}
		//qtd registros
		$sql = "SELECT COUNT(*) AS total FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes` AS a 
		JOIN `" . _DB_PREFIX_ . "prepostagem5_pedidos` AS b ON(a.id_pacote IN(b.ids_pacotes))
		JOIN `" . _DB_PREFIX_ . "prepostagem5_servicos` AS c ON(a.id_servico_pacote=c.cod_servico)
		WHERE a.pacote_fechado = 1 $where ORDER BY a.id_pacote DESC";
        $row = Db::getInstance()->getRow($sql);
		$total_envios = $row['total'];
		//inicio paginacao 
		$pagina = (int)(isset($_GET['pagina'])?$_GET['pagina']:1);
		$registros = (int)Configuration::get('PREPOSTAGEM5_QTD_PAGINA',30);
		$registros = ($registros==0)?20:$registros;
		$inicio = ($registros*($pagina-1));
		$paginas = ceil( $total_envios / $registros );
		//registros
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes` AS a 
		JOIN `" . _DB_PREFIX_ . "prepostagem5_pedidos` AS b ON(a.id_pacote IN(b.ids_pacotes))
		JOIN `" . _DB_PREFIX_ . "prepostagem5_servicos` AS c ON(a.id_servico_pacote=c.cod_servico)
		WHERE a.pacote_fechado = 1 $where ORDER BY a.id_pacote DESC LIMIT $inicio,$registros";
		$envios = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		//status
		$nomes_status = array();
		foreach($this->module->status_nomes() as $k=>$v){
			$nomes_status[$v['id']]=$v['name'];
		}
		$tpl->assign(array(
			'envios' => $envios,
			'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/prepostagem5',
			'pagina' => $pagina,
			'total_envios' => $total_envios,
			'paginas' => $paginas,
			'lista_status_pagamentos' => $nomes_status,
			'extra'	=> '',
		));
		$this->context->smarty->assign(array('content' => $tpl->fetch()));
	}
}
?>