<?php
class AdminPrePostagem5EnviosRevController extends ModuleAdminController
{
	public function __construct() {
        $this->bootstrap = true;
		parent::__construct();
	}
	
	public function initPageHeaderToolbar(){
        parent::initPageHeaderToolbar();
		if (empty($this->display)) {
			$this->page_header_toolbar_btn['prepostagem5_rev_add_pacote'] = array(
				'class' => 'fix_icons',
                'href' => 'javascript:prepostagem5_add_pacote_rev()',
                'desc' => $this->l('Criar Envio Reverso Avulso', null, null, false),
                'icon' => 'fa fa-plus'
            );
			$this->page_header_toolbar_btn['prepostagem5_rev_status_conta'] = array(
				'class' => 'fix_icons',
                'href' => 'javascript:prepostagem5_status_conta()',
                'desc' => $this->l('Status API', null, null, false),
                'icon' => 'fa fa-globe'
            );
        }
    }
	
	public function createTemplate($tpl_name){
        if (file_exists($this->getTemplatePath() . $tpl_name) && $this->viewAccess())
                return $this->context->smarty->createTemplate($this->getTemplatePath() . $tpl_name, $this->context->smarty);
            return parent::createTemplate($tpl_name);
    }
	
	public function initContent() {
        parent::initContent();
		$acao = isset($_REQUEST['acao'])?$_REQUEST['acao']:'pedidos_rev';
		if($acao=='pedidos_rev'){
			return $this->pedidos_rev();
		}elseif($acao=='remover_envio'){
			return $this->remover_envio();
		}elseif($acao=='adicionar_envios'){
			return $this->adicionar_envios();
		}elseif($acao=='salvar_dados_pacote'){
			return $this->salvar_dados_pacote();
		}
    }

	private function pedidos_rev(){
		//filto 
		$where = '';
		if(isset($_GET['s']) && !empty($_GET['s'])){
			$where .= " AND (a.id_pedido_loja LIKE '%".pSQL($_GET['s'])."%' || a.id_coleta LIKE '%".pSQL($_GET['s'])."%' || a.objeto LIKE '%".pSQL($_GET['s'])."%' || a.status_log LIKE '%".pSQL($_GET['s'])."%' || a.nome LIKE '%".pSQL($_GET['s'])."%' || a.logradouro LIKE '%".pSQL($_GET['s'])."%' || a.bairro LIKE '%".pSQL($_GET['s'])."%' || a.cidade LIKE '%".pSQL($_GET['s'])."%' || a.uf LIKE '%".pSQL($_GET['s'])."%' || a.cpf_cnpj LIKE '%".pSQL($_GET['s'])."%' || a.cep LIKE '%".pSQL($_GET['s'])."%') ";
		}
		if(isset($_GET['pedido'])){
			$where .= ' AND id_pedido = '.(int)$_GET['pedido'].'';
		}
		//layout
        $tpl = $this->createTemplate('envios_rev.tpl');
		//qtd registros
		$sql = "SELECT COUNT(*) AS total FROM `" . _DB_PREFIX_ . "prepostagem5_pedidos_reverso` AS a 
		JOIN `" . _DB_PREFIX_ . "prepostagem5_servicos` AS c ON(a.extra1=c.cod_servico)
		WHERE 1=1 $where ORDER BY a.id_pedido DESC";
        $row = Db::getInstance()->getRow($sql);
		$total_envios = $row['total'];
		//inicio paginacao 
		$pagina = (int)(isset($_GET['pagina'])?$_GET['pagina']:1);
		$registros = (int)Configuration::get('PREPOSTAGEM5_QTD_PAGINA',30);
		$registros = ($registros==0)?20:$registros;
		$inicio = ($registros*($pagina-1));
		$paginas = ceil( $total_envios / $registros );
		//registros
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pedidos_reverso` AS a 
		JOIN `" . _DB_PREFIX_ . "prepostagem5_servicos` AS c ON(a.extra1=c.cod_servico)
		WHERE 1=1 $where ORDER BY a.id_pedido DESC LIMIT $inicio, $registros";
		$envios_bd = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$envios = array();
		//envios
		foreach($envios_bd as $k=>$v){
			$envios[] =$v;
		}
		//status
		$nomes_status = array();
		foreach($this->module->status_nomes() as $k=>$v){
			$nomes_status[$v['id']]=$v['name'];
		}
		$tpl->assign(array(
			'envios' => $envios,
			'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/prepostagem5',
			'pagina' => $pagina,
			'total_envios' => $total_envios,
			'paginas' => $paginas,
			'lista_status_pagamentos' => $nomes_status,
			'extra'	=> '',
			'link_etq' => Context::getContext()->link->getModuleLink('prepostagem5', 'etq_rev', array('ajax'=>'true'), true),
			'link_dec' => Context::getContext()->link->getModuleLink('prepostagem5', 'dec_rev', array('ajax'=>'true'), true),
		));
		$this->context->smarty->assign(array('content' => $tpl->fetch()));
	}
	
	private function adicionar_envios(){
		//se for relacionado a algum envio 
		$id = isset($_GET['envio'])?$_GET['envio']:0;
		$envio = $this->module->dados_pacote((int)$id);
		$itens_envio = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS("SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_itens_dc` WHERE id_pedido = '".(int)$id."'");
		//layout
        $tpl = $this->createTemplate('add_envios_rev.tpl');
		$tpl->assign(array(
			'id' => (int)$id,
			'pacote' => $envio,
			'itens' => $itens_envio,
			'total_itens' => count($itens_envio),
			'vd' => (isset($envio['servico_VD_pacote']) && $envio['servico_VD_pacote']==1?true:false),
			'ar' => (isset($envio['servico_AR_pacote']) && $envio['servico_AR_pacote']==1?true:false),
			'mp' => (isset($envio['servico_MP_pacote']) && $envio['servico_MP_pacote']==1?true:false),
			'padrao_rev' => Configuration::get('PREPOSTAGEM5_REV_SERVICO'),
			'destinatario' => ucwords(Configuration::get('PREPOSTAGEM5_NOME')),
			'logradouro' => ucwords(Configuration::get('PREPOSTAGEM5_LOGRADOURO')),
			'numero' =>Configuration::get('PREPOSTAGEM5_NOME'),
			'bairro' => ucwords(Configuration::get('PREPOSTAGEM5_BAIRRO')),
			'cidade' => ucwords(Configuration::get('PREPOSTAGEM5_CIDADE')),
			'uf' => strtoupper(Configuration::get('PREPOSTAGEM5_UF')),
			'cep' => Configuration::get('PREPOSTAGEM5_CEP'),
			'servicos_correios' => $this->module->servicos_cadastrados(),
			'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'/modules/prepostagem5',
		));
		die($tpl->fetch());
	}
	
	private function salvar_dados_pacote(){
		$ids_envios = array();
		//regras de validacoes
		if(isset($_POST['extras']) && (in_array('019',$_POST['extras']))){
			if($_POST['valor'] < $this->module->total_minimo){
				die('Serviço VD ativado, informe o valor declarado de no minimo '.$this->module->total_minimo.' !');
			}
		}
		if(!isset($_POST['peso']) || $_POST['peso'] > 30){
			die('O peso deverá ser informado e menor que 30kg!');
		}
		if(!isset($_POST['com']) || $_POST['com'] > 105){
			die('O comprimento deverá ser informado e menor que 105cm!');
		}
		if(!isset($_POST['alt']) || $_POST['alt'] > 105){
			die('A altura deverá ser informado e menor que 105cm!');
		}
		if(!isset($_POST['lar']) || $_POST['lar'] > 105){
			die('A largura deverá ser informado e menor que 105cm!');
		}
		if(($_POST['com']+$_POST['alt']+$_POST['lar']) > 200){
			die('A soma dos lados não pode ser maior que 200cm!');
		}
		$servicoMP = $servicoVD = $servicoAR = 0;
		if(isset($_POST['extras']) && (in_array('001',$_POST['extras']))){
			$servicoAR = 1;
		}
		if(isset($_POST['extras']) && (in_array('002',$_POST['extras']))){
			$servicoMP = 1;
		}
		if(isset($_POST['extras']) && (in_array('019',$_POST['extras']))){
			$servicoVD = 1;
		}
		if(empty($_POST['nota_fiscal']) && !isset($_POST['item'])){
			die('Para pré-postagem é obrigatorio informar o número da NFe ou informar os itens para declaração de conteúdo!');
		}
		if(!isset($_POST['servico']) || $_POST['servico']=='0' || $_POST['servico']=='00000'){
			die('Selecione um serviço de entrega válido!');
		}
		//monta o envio
		//dados destinatario
		$i=0;
		$fiscal = preg_replace('/\D/', '', Configuration::get('PREPOSTAGEM5_FISCAL'));
		if(strlen($fiscal)==11 || strlen($fiscal)==13){
			$pre_listas[$i]['destinatario']['cpfCnpj'] = $fiscal;
		}						
		$pre_listas[$i]['destinatario']['nome'] = $this->module->acentos(trim(Configuration::get('PREPOSTAGEM5_NOME')));
		$telefone = preg_replace('/\D/', '', Configuration::get('PREPOSTAGEM5_TEL'));
		if(strlen($telefone) == 10){
			$pre_listas[$i]['destinatario']['dddTelefone'] = substr($telefone,0,2);
			$pre_listas[$i]['destinatario']['telefone'] = substr($telefone,-8);
		}elseif(strlen($telefone) == 11){
			$pre_listas[$i]['destinatario']['dddCelular'] = substr($telefone,0,2);
			$pre_listas[$i]['destinatario']['celular'] = substr($telefone,-9);
		}elseif(strlen($telefone) > 11){
			$telefone = substr($telefone,-11);
			$pre_listas[$i]['destinatario']['dddCelular'] = substr($telefone,0,2);
			$pre_listas[$i]['destinatario']['celular'] = substr($telefone,-9);
		}
		$pre_listas[$i]['destinatario']['email'] = trim(Configuration::get('PREPOSTAGEM5_EMAIL'));
		$pre_listas[$i]['destinatario']['endereco']['cep'] = trim(Configuration::get('PREPOSTAGEM5_CEP'));
		$pre_listas[$i]['destinatario']['endereco']['logradouro'] = $this->module->acentos(trim(Configuration::get('PREPOSTAGEM5_LOGRADOURO')));
		$pre_listas[$i]['destinatario']['endereco']['numero'] = trim(Configuration::get('PREPOSTAGEM5_NUMERO'));
		$pre_listas[$i]['destinatario']['endereco']['complemento'] = $this->module->acentos(trim(Configuration::get('PREPOSTAGEM5_COMPLEMENTO')));
		$pre_listas[$i]['destinatario']['endereco']['bairro'] = $this->module->acentos(trim(Configuration::get('PREPOSTAGEM5_BAIRRO')));
		$pre_listas[$i]['destinatario']['endereco']['cidade'] = $this->module->acentos(trim(Configuration::get('PREPOSTAGEM5_CIDADE')));
		$pre_listas[$i]['destinatario']['endereco']['uf'] = strtoupper(trim(Configuration::get('PREPOSTAGEM5_UF')));
		//remetente
		$pre_listas[$i]['remetente']['cpfCnpj'] = preg_replace('/\D/', '', $_POST['fiscal']);
		$pre_listas[$i]['remetente']['nome'] = $this->module->acentos($_POST['nome']);
		$telefone = preg_replace('/\D/', '', $_POST['telefone']);
		if(strlen($telefone) == 10){
			$pre_listas[$i]['remetente']['dddTelefone'] = substr($telefone,0,2);
			$pre_listas[$i]['remetente']['telefone'] = substr($telefone,-8);
		}elseif(strlen($telefone) == 11){
			$pre_listas[$i]['remetente']['dddCelular'] = substr($telefone,0,2);
			$pre_listas[$i]['remetente']['celular'] = substr($telefone,-9);
		}elseif(strlen($telefone) > 11){
			$telefone = substr($telefone,-11);
			$pre_listas[$i]['remetente']['dddCelular'] = substr($telefone,0,2);
			$pre_listas[$i]['remetente']['celular'] = substr($telefone,-9);
		}
		$pre_listas[$i]['remetente']['email'] = trim($_POST['email']);
		$pre_listas[$i]['remetente']['endereco'] = array(
			'logradouro' => $this->module->acentos(trim($_POST['log'])),
			'numero' => trim($_POST['numero']),
			'complemento' => $this->module->acentos(trim($_POST['comp'])),
			'bairro' => $this->module->acentos(trim($_POST['bairro'])),
			'cep' => preg_replace('/\D/', '', $_POST['cep']),
			'cidade' => $this->module->acentos(trim($_POST['cidade'])),
			'uf' => trim($_POST['uf']),
		);
		//$pre_listas[$i]['codigoObjeto'] = '';
		$pre_listas[$i]['codigoServico'] = trim($_POST['servico']);
		$pre_listas[$i]['pesoInformado'] = (int)($_POST['peso']*1000);
		if((int)$_POST['servico'] > 80000){
			$pre_listas[$i]['codigoFormatoObjetoInformado'] = 1;
		}else{
			$pre_listas[$i]['codigoFormatoObjetoInformado'] = 2;
		}
		$pre_listas[$i]['alturaInformada'] = (int)round($_POST['alt']);
		$pre_listas[$i]['larguraInformada'] = (int)round($_POST['lar']);
		$pre_listas[$i]['comprimentoInformado'] = (int)round($_POST['com']);
		$pre_listas[$i]['cienteObjetoNaoProibido'] = 1;
		$pre_listas[$i]['numeroNotaFiscal'] = trim($_POST['nota_fiscal']);
		$ii=0;
		if(isset($_POST['item']) && count($_POST['item'])>=1){
			foreach($_POST['item'] as $iten){
				$pre_listas[$i]['itensDeclaracaoConteudo'][$ii]['conteudo'] = $this->module->acentos($iten['nome']);
				$pre_listas[$i]['itensDeclaracaoConteudo'][$ii]['quantidade'] = $iten['qtd'];
				$pre_listas[$i]['itensDeclaracaoConteudo'][$ii]['valor'] = $iten['total'];
				$ii++;
			}
		}
		$id_pacote_unico = $this->module->generate_string(10);
		$pre_listas[$i]['sequencial'] = $id_pacote_unico;
		$pre_listas[$i]['solicitarColeta'] = 'N';
		$pre_listas[$i]['logisticaReversa'] = 'S';
		$prazo = date('d/m/Y', strtotime(date('Y-m-d'). ' + '.LOJA5_PRE_POSTAGEM_VALIDADE_LOG_REV.' day'));
		$pre_listas[$i]['dataValidadeLogReversa'] = $prazo;
		//nova api
		$token_api = $this->module->token_de_acesso_correios();
		$id_unic_plp = $this->module->generate_string(10);
		$objetos_sucesso = array();
		$logs_resultados = array();
		if(!isset($token_api['dados']['token'])){
			$mensagem = ''.$token_api['status'].' - Erro ao obter o token api Correios!';
			//erro
			$this->module->salvar_log('[Pré-Postagem] Ocorreu um problema ao obter o token ao criar postagem reversa: '.$mensagem.'');
			die($mensagem);
		}
		//end
		if(Configuration::get('PREPOSTAGEM5_AMBIENTE')=='H'){
			$urlweb = 'https://apihom.correios.com.br/prepostagem/v1/prepostagens';
		}else{
			$urlweb = 'https://api.correios.com.br/prepostagem/v1/prepostagens';
		}
		//header
		$headers = array(
			"Authorization: Bearer ".trim($token_api['dados']['token'])."",
			"Content-Type: application/json",
		);
		//request
		$sessao_curl2 = curl_init();
		curl_setopt($sessao_curl2, CURLOPT_URL, $urlweb);
		curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($sessao_curl2, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($sessao_curl2, CURLOPT_POST, true);
		curl_setopt($sessao_curl2, CURLOPT_POSTFIELDS, json_encode($pre_listas[0]));
		curl_setopt($sessao_curl2, CURLOPT_CONNECTTIMEOUT, 5);
		curl_setopt($sessao_curl2, CURLOPT_TIMEOUT, 10);
		curl_setopt($sessao_curl2, CURLOPT_RETURNTRANSFER, true);
		$resultado = $original = curl_exec($sessao_curl2);
		$resultado = @json_decode($resultado,true);
		$status    = curl_getinfo($sessao_curl2, CURLINFO_HTTP_CODE);
		curl_close($sessao_curl2);
		//debug
		if($status!=200 || Configuration::get('PREPOSTAGEM5_STATUS_DEBUG')){
			$this->module->salvar_log('[Pré-Postagem] Log Rev Resultado: '.print_r($resultado,true));
			$this->module->salvar_log('[Pré-Postagem] Log Rev Envio: '.print_r($pre_listas[0],true));
			$this->module->salvar_log('[Pré-Postagem] Log Rev Status: '.$status);
		}
		//ok
		if(isset($resultado['id'])){
			//objeto de rastreamento 
			$objeto = trim($resultado['codigoObjeto']);
			//cria no bd
			$sql = "INSERT INTO `" . _DB_PREFIX_ . "prepostagem5_pedidos_reverso` (`id_pedido`, `status_pedido_loja`, `id_pedido_loja`, `id_coleta`, `id_objeto`, `objeto`, `status_id`, `status_log`, `prazo`, `ids_pacotes`, `nome`, `logradouro`, `numero`, `complemento`, `bairro`, `cidade`, `uf`, `cep`, `telefone`, `email`, `cpf_cnpj`, `extra1`, `extra2`, `extra3`, `processado`, `entregue`, `cancelado`, `tipo`, `data_pedido`) VALUES (NULL, '', '".(int)$_POST['pedido']."', '0', '0', '".$objeto."', 'criado', '".$resultado['descStatusAtual']."', '".$prazo."', '".(int)$_POST['pacote']."', '".pSQL($_POST['nome'])."', '".pSQL($_POST['log'])."', '".pSQL($_POST['numero'])."', '".pSQL($_POST['comp'])."', '".pSQL($_POST['bairro'])."', '".pSQL($_POST['cidade'])."', '".pSQL($_POST['uf'])."', '".preg_replace('/\D/', '', $_POST['cep'])."', '".pSQL($_POST['telefone'])."', '".pSQL($_POST['email'])."', '".preg_replace('/\D/', '', $_POST['fiscal'])."', '".$_POST['servico']."', '".$resultado['id']."', '".pSQL($_POST['nota_fiscal'])."', '0', '0', '0', 'A', NOW());";
			Db::getInstance()->execute($sql);
			//se pedido atrelado	
			$status_pedido = '';			
			if(isset($_POST['pedido']) && (int)$_POST['pedido'] > 0){
				$order = new Order((int)$_POST['pedido']);
				if($order){
					//status iniciar rev
					$status_fechar = (int)Configuration::get('PREPOSTAGEM5_REV_INI');
					if($status_fechar > 0){
						//variaveis a enviar no email 
						$vars_email = array();
						$vars_email['{link_rastreamento_reverso}'] = Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/prepostagem5/sro.php?objeto='.$objeto.'';
						$vars_email['{objeto_correios_reverso}'] = $objeto;
						$vars_email['{etiqueta_correios_reverso}'] = Context::getContext()->link->getModuleLink('prepostagem5', 'etq_rev', array('ajax'=>'true','envio'=>$resultado['id']), true);
						$vars_email['{declaracao_correios_reverso}'] = Context::getContext()->link->getModuleLink('prepostagem5', 'dec_rev', array('ajax'=>'true','envio'=>$resultado['id']), true);
						//atualiza o pedido
						if($order->getCurrentState()!=$status_fechar){
							$history = new OrderHistory();
							$history->id_order = (int)$order->id;
							$history->id_order_state = (int)$status_fechar;
							$history->addWithemail(true,$vars_email);
							$order->current_state = $history->id_order_state;
							$order->update();
						}
						//cria no bd
						$sql = "UPDATE `" . _DB_PREFIX_ . "prepostagem5_pedidos_reverso` SET `status_pedido_loja` = '".$order->getCurrentState()."' WHERE `objeto` = '".$objeto."';";
						Db::getInstance()->execute($sql);
						//cria um log para o pedido
						$msglog = 'Envio Reverso Correios com Pré-Postagem Iniciado: '.$objeto.' em '.date('d/m/Y H:i').' (limite de postagem de '.LOJA5_PRE_POSTAGEM_VALIDADE_LOG_REV.' dias)';
						$msg = new Message();
						$message = strip_tags($msglog, '<br>');
						if (($message)){
							$msg->message = $message;
							$msg->id_order = intval($order->id);
							$msg->private = 1;
							$msg->add();
						}
					}
				}
			}
			//ok 
			die('true');
		}elseif(isset($resultado['msgs'])){
			//erro
			$erro = array();
			if(isset($resultado['msgs'])){
				foreach($resultado['msgs'] as $err){
					$erro[] = $err;
				}
			}
			if(isset($resultado['causa'])){
				$erro[] = $resultado['causa'];
			}
			$log = ' - Erro ao solicitar devolução: '.implode(',',$erro).'';
			die($log);
		}else{
			$log = ' - Erro desconhecido ao solicitar PLP / '.$status.'';
			die($log);
		}
	}
	
	private function remover_envio(){
		//dados 
		$objeto = isset($_POST['objeto'])?$_POST['objeto']:'';
		$id = isset($_POST['id'])?$_POST['id']:'';
		//consulta o envio
		$query = Db::getInstance()->getRow("SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pedidos_reverso` WHERE id_pedido = '".(int)$id."' AND status_id = 'criado'");
		if(!$query){
			$erro = array('erro'=>true,'log'=>'Ops, envio reverso não encontrado no banco de dados ou já encontra-se processada junto aos Correios!');
		}else{
			//cancelar objeto individual
			if(!empty($objeto) && !empty($id)){
				$resultado = array();
				//nova api
				$token_api = $this->module->token_de_acesso_correios();
				if(!isset($token_api['dados']['token'])){
					$resultado['erro'] = true;
					$resultado['log'] = ''.$token_api['status'].' - Erro ao obter o token api Correios!';
					if(isset($token_api['dados']['stackTrace'])){
						unset($token_api['dados']['stackTrace']);
					}
					$resultado['raw'] = $token_api;
				}else{
					//consulta os serviços do contrato
					if(Configuration::get('PREPOSTAGEM5_AMBIENTE')=='H'){
						$urlweb = 'https://apihom.correios.com.br/prepostagem/v1/prepostagens/objeto/'.trim($objeto);
					}else{
						$urlweb = 'https://api.correios.com.br/prepostagem/v1/prepostagens/objeto/'.trim($objeto);
					}
					//header
					$headers = array(
						"Authorization: Bearer ".trim($token_api['dados']['token'])."",
						"Content-Type: application/json",
					);
					//request
					$sessao_curl2 = curl_init();
					curl_setopt($sessao_curl2, CURLOPT_URL, $urlweb);
					curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYPEER, false);
					curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYHOST, false);
					curl_setopt($sessao_curl2, CURLOPT_HTTPHEADER, $headers);
					curl_setopt($sessao_curl2, CURLOPT_CUSTOMREQUEST, "DELETE");
					curl_setopt($sessao_curl2, CURLOPT_CONNECTTIMEOUT, 5);
					curl_setopt($sessao_curl2, CURLOPT_TIMEOUT, 10);
					curl_setopt($sessao_curl2, CURLOPT_RETURNTRANSFER, true);
					$resultados = $original = curl_exec($sessao_curl2);
					$resultados = @json_decode($resultados,true);
					$status    = curl_getinfo($sessao_curl2, CURLINFO_HTTP_CODE);
					curl_close($sessao_curl2);
					if($status==200 && isset($resultados['resultadoCancelamento'])){
						$resultado['erro'] = false;
						$resultado['dados'] = 1;
						$resultado['raw'] = $resultados;
					}else{
						$resultado['erro'] = true;
						//erro
						$erro = array();
						if(isset($resultados['msgs'])){
							foreach($resultados['msgs'] as $err){
								$erro[] = $err;
							}
						}
						if(isset($resultados['causa'])){
							$erro[] = $resultados['causa'];
						}
						$resultado['mensagem'] = implode(',',$erro);
					}
				}
				//debug 
				if(Configuration::get('PREPOSTAGEM5_STATUS_DEBUG') || $resultado['erro']){
					$this->module->salvar_log('Debug Cancelar Objeto Reverso #'.$id.' - Objeto: '.$objeto.' - '.print_r($resultado,true));
				}
				//trata o resultado
				if($resultado['erro']){
					//log
					$this->module->salvar_log('Erro ao cancelar objeto reverso #'.$id.': '.$objeto.'');
					$erro = array('erro'=>true,'log'=>$resultado['mensagem']);
				}elseif(isset($resultado['dados']) && $resultado['dados']==1){
					//atualiza o envio 
					Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_pedidos_reverso` SET status_id = 'cancelado', status_log = 'Envio reverso cancelado manualmente por Administrador!', log = '', cancelado = 1 WHERE id_pedido = '".$id."'");
					//log
					$this->module->salvar_log('Objeto Reverso'.$id.' cancelado com sucesso por Administrador: '.$objeto.'');
					//mensagem 
					$erro = array('erro'=>false,'log'=>'Objeto '.$objeto.' cancelado com sucesso para o envio reverso selecionado!','objeto'=>$objeto);
				}else{
					$erro = array('erro'=>true,'log'=>'Erro desconhecido ao cancelar objeto do envio reverso! Tente novamente.');
				}
			}else{
				//erro
				$erro = array('erro'=>true,'log'=>'Ops, envio reverso não encontrado!');
			}
		}
		die(json_encode($erro));
		exit;
	}
}
?>