<?php
class AdminPrePostagem5PLPsController extends ModuleAdminController
{
	public function __construct() {
        $this->bootstrap = true;
		parent::__construct();
	}
	
	public function initPageHeaderToolbar(){
        parent::initPageHeaderToolbar();
		if (empty($this->display)) {
			$this->page_header_toolbar_btn['sigep_status_conta'] = array(
				'class' => 'fix_icons',
                'href' => 'javascript:prepostagem5_status_conta()',
                'desc' => $this->l('Status API', null, null, false),
                'icon' => 'fa fa-globe'
            );
        }
    }
	
	public function createTemplate($tpl_name){
        if (file_exists($this->getTemplatePath() . $tpl_name) && $this->viewAccess())
                return $this->context->smarty->createTemplate($this->getTemplatePath() . $tpl_name, $this->context->smarty);
            return parent::createTemplate($tpl_name);
    }
	
	public function initContent() {
        parent::initContent();
		$acao = isset($_REQUEST['acao'])?$_REQUEST['acao']:'plps';
		if($acao=='plps'){
			return $this->plps();
		}elseif($acao=='json'){
			return $this->json();
		}elseif($acao=='ver_envio'){
			return $this->ver_envio();
		}elseif($acao=='cancelar_objeto_plp'){
			return $this->cancelar_objeto_plp();
		}elseif($acao=='cancelar_plp_geral'){
			return $this->cancelar_plp_geral();
		}elseif($acao=='imprimir4'){
			return $this->imprimir4();
		}elseif($acao=='imprimir1'){
			return $this->imprimir1();
		}elseif($acao=='imprimir_ar'){
			return $this->imprimir_ar();
		}elseif($acao=='declaracao'){
			return $this->declaracao();
		}elseif($acao=='romaneio'){
			return $this->romaneio();
		}elseif($acao=='status_sigep'){
			return $this->module->status_sigep();
		}elseif($acao=='detalhes_pedido'){
			return $this->detalhes_pedido();
		}
    }
	
	private function romaneio(){
		//layout
        $tpl = $this->createTemplate('romaneio.tpl');
		$tpl->assign(array(
			'plp' => $this->module->array_itens_plp(),
			'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/prepostagem5',
		));
		die($tpl->fetch());
	}
	
	private function plps(){
		//layout
        $tpl = $this->createTemplate('plps.tpl');
		//filtra a plp 
		$where = '';
		if(isset($_GET['plp'])){
			$where .= ' AND uniq_id_plp = "'.pSQL($_GET['plp']).'" ';
		}
		if(isset($_GET['s']) && !empty($_GET['s'])){
			$where .= " AND (uniq_id_plp LIKE '%".pSQL($_GET['s'])."%' || ids_pacotes LIKE '%".pSQL($_GET['s'])."%' || status_plp LIKE '%".pSQL($_GET['s'])."%' || xml LIKE '%".pSQL($_GET['s'])."%') ";
		}
		//qtd registros
		$sql = "SELECT COUNT(*) AS total FROM `" . _DB_PREFIX_ . "prepostagem5_plps` WHERE 1 = 1 $where ORDER BY id_plp DESC";
        $row = Db::getInstance()->getRow($sql);
		$total_envios = $row['total'];
		//inicio paginacao 
		$pagina = (int)(isset($_GET['pagina'])?$_GET['pagina']:1);
		$registros = (int)Configuration::get('SIGEPPRO5_QTD_PAGINA',30);
		$registros = ($registros==0)?20:$registros;
		$inicio = ($registros*($pagina-1));
		$paginas = ceil( $total_envios / $registros );
		//registros
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_plps` 
		WHERE 1 = 1 $where ORDER BY id_plp DESC LIMIT $inicio,$registros";
		$plps_bd = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		//processa outros dados
		$plps = array();
		foreach($plps_bd as $k=>$v){
			//envios 
			$envios = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS("SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes`
			JOIN `" . _DB_PREFIX_ . "prepostagem5_pedidos` ON(id_pacote IN(ids_pacotes))
			JOIN `" . _DB_PREFIX_ . "prepostagem5_servicos` ON(id_servico_pacote=cod_servico)
			WHERE FIND_IN_SET(id_pacote,'".$v['ids_pacotes']."')");
			//plps
			$v = array_merge($v,array('ids_romaneios'=>$this->envios_com_romameio($envios),'declaracao'=>$this->envios_com_declaracao($envios),'objetos'=>$this->lista_objetos($envios),'envios'=>$envios,'envios_ar'=>$this->envios_com_ar($v['ids_pacotes'])));
			$plps[] = $v;
		}
		$tpl->assign(array(
			'plps' => $plps,
			'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/prepostagem5',
			'pagina' => $pagina,
			'total_plps' => $total_envios,
			'paginas' => $paginas,
			'extra'	=> '',
		));
		$this->context->smarty->assign(array('content' => $tpl->fetch()));
	}
	
	private function json(){
		$envios = $this->module->array_plps_novo();
		echo '<pre>';
		print_r($envios);
		exit;
	}
	
	private function ver_envio(){
		$dados = array();
		$dados['codigoObjeto'] = isset($_GET['objeto'])?$_GET['objeto']:'';
		$plp = $this->module->consulta_objeto($dados);
		echo '<pre>';
		print_r($plp);
		exit;
	}
	
	private function imprimir4(){
		//nova api
		$token_api = $this->module->token_de_acesso_correios();
		if(!isset($token_api['dados']['token'])){
			$resultado['erro'] = true;
			$resultado['log'] = ''.$token_api['status'].' - Erro ao obter o token api Correios!';
			if(isset($token_api['dados']['stackTrace'])){
				unset($token_api['dados']['stackTrace']);
			}
			die($resultado['log']);
		}else{
			//consulta os serviços do contrato
			if(Configuration::get('PREPOSTAGEM5_AMBIENTE')=='H'){
				$urlweb = 'https://apihom.correios.com.br/prepostagem/v1/prepostagens/rotulo/assincrono/pdf';
			}else{
				$urlweb = 'https://api.correios.com.br/prepostagem/v1/prepostagens/rotulo/assincrono/pdf';
			}
			//header
			$headers = array(
				"Authorization: Bearer ".trim($token_api['dados']['token'])."",
				"Content-Type: application/json",
			);
			//request
			$envio = array();
			$envio['idCorreios'] = trim(Configuration::get('PREPOSTAGEM5_USUARIO'));
			$envio['numeroCartaoPostagem'] = trim(Configuration::get('PREPOSTAGEM5_CARTAO'));
			$envio['tipoRotulo'] = LOJA5_PRE_POSTAGEM_TIPO_ROTULO;
			$envio['formatoRotulo'] = LOJA5_PRE_POSTAGEM_FORMATO_ROTULO;
			$envio['imprimeRemetente'] = LOJA5_PRE_POSTAGEM_IMPRIMIR_REMETENTE;
			$envio['layoutImpressao'] = LOJA5_PRE_POSTAGEM_LAY2;
			$plps = $this->module->array_plps_novo();
			foreach($plps as $pre){
				$envio['idsPrePostagem'][] = $pre['id'];
			}
			//verifica se esta no bd senao faz o request
			$hash = md5(serialize($envio));
			$query = Db::getInstance()->getRow("SELECT * FROM `" ._DB_PREFIX_. "prepostagem5_recibos` WHERE hash = '".$hash."'");
			if(!isset($query['recibo'])){
				$sessao_curl2 = curl_init();
				curl_setopt($sessao_curl2, CURLOPT_URL, $urlweb);
				curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYHOST, false);
				curl_setopt($sessao_curl2, CURLOPT_HTTPHEADER, $headers);
				curl_setopt($sessao_curl2, CURLOPT_POST, true);
				curl_setopt($sessao_curl2, CURLOPT_POSTFIELDS, json_encode($envio));
				curl_setopt($sessao_curl2, CURLOPT_CONNECTTIMEOUT, 15);
				curl_setopt($sessao_curl2, CURLOPT_TIMEOUT, 15);
				curl_setopt($sessao_curl2, CURLOPT_RETURNTRANSFER, true);
				$resultados = $original = curl_exec($sessao_curl2);
				$resultados = @json_decode($resultados,true);
				$status    = curl_getinfo($sessao_curl2, CURLINFO_HTTP_CODE);
				curl_close($sessao_curl2);
				if(isset($resultados['idRecibo'])){
					Db::getInstance()->execute("INSERT INTO `"._DB_PREFIX_."prepostagem5_recibos` SET hash = '".$hash."', recibo = '".$resultados['idRecibo']."'");
				}
				sleep(2);
			}else{
				//bd
				$resultados = array();
				$resultados['idRecibo'] = $query['recibo'];
			}
			if(isset($resultados['idRecibo'])){
				//consulta os serviços do contrato
				if(Configuration::get('PREPOSTAGEM5_AMBIENTE')=='H'){
					$urlweb = 'https://apihom.correios.com.br/prepostagem/v1/prepostagens/rotulo/download/assincrono/'.$resultados['idRecibo'];
				}else{
					$urlweb = 'https://api.correios.com.br/prepostagem/v1/prepostagens/rotulo/download/assincrono/'.$resultados['idRecibo'];
				}
				//header
				$headers = array(
					"Authorization: Bearer ".trim($token_api['dados']['token'])."",
					"Content-Type: application/json",
				);
				//download 
				$sessao_curl2 = curl_init();
				curl_setopt($sessao_curl2, CURLOPT_URL, $urlweb);
				curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYHOST, false);
				curl_setopt($sessao_curl2, CURLOPT_HTTPHEADER, $headers);
				curl_setopt($sessao_curl2, CURLOPT_POST, false);
				curl_setopt($sessao_curl2, CURLOPT_CONNECTTIMEOUT, 5);
				curl_setopt($sessao_curl2, CURLOPT_TIMEOUT, 10);
				curl_setopt($sessao_curl2, CURLOPT_RETURNTRANSFER, true);
				$resultados = $original = curl_exec($sessao_curl2);
				$resultados = @json_decode($resultados,true);
				$status    = curl_getinfo($sessao_curl2, CURLINFO_HTTP_CODE);
				curl_close($sessao_curl2);
				if(isset($resultados['dados'])){
					$data = base64_decode($resultados['dados']);
					@header('Content-Type: application/pdf');
					@header('Content-Disposition: inline; filename="'.$resultados['nome'].'.pdf";');
					echo $data;
					exit;
				}else{
					Db::getInstance()->execute("DELETE FROM `"._DB_PREFIX_."prepostagem5_recibos` WHERE hash = '".$hash."'");
					echo '2 - Status: '.$status.' (tente novamente): ';
					print_r($original);
				}
			}else{
				echo '1 - Status: '.$status.' (tente novamente): ';
				print_r($original);
			}
		}
		exit;
	}
	
	private function imprimir1(){
		//nova api
		$token_api = $this->module->token_de_acesso_correios();
		if(!isset($token_api['dados']['token'])){
			$resultado['erro'] = true;
			$resultado['log'] = ''.$token_api['status'].' - Erro ao obter o token api Correios!';
			if(isset($token_api['dados']['stackTrace'])){
				unset($token_api['dados']['stackTrace']);
			}
			die($resultado['log']);
		}else{
			//consulta os serviços do contrato
			if(Configuration::get('PREPOSTAGEM5_AMBIENTE')=='H'){
				$urlweb = 'https://apihom.correios.com.br/prepostagem/v1/prepostagens/rotulo/assincrono/pdf';
			}else{
				$urlweb = 'https://api.correios.com.br/prepostagem/v1/prepostagens/rotulo/assincrono/pdf';
			}
			//header
			$headers = array(
				"Authorization: Bearer ".trim($token_api['dados']['token'])."",
				"Content-Type: application/json",
			);
			//request
			$envio = array();
			$envio['idCorreios'] = trim(Configuration::get('PREPOSTAGEM5_USUARIO'));
			$envio['numeroCartaoPostagem'] = trim(Configuration::get('PREPOSTAGEM5_CARTAO'));
			$envio['tipoRotulo'] = LOJA5_PRE_POSTAGEM_TIPO_ROTULO;
			$envio['formatoRotulo'] = LOJA5_PRE_POSTAGEM_FORMATO_ROTULO;
			$envio['imprimeRemetente'] = LOJA5_PRE_POSTAGEM_IMPRIMIR_REMETENTE;
			$envio['layoutImpressao'] = LOJA5_PRE_POSTAGEM_LAY1;
			$plps = $this->module->array_plps_novo();
			foreach($plps as $pre){
				$envio['idsPrePostagem'][] = $pre['id'];
			}
			//verifica se esta no bd senao faz o request
			$hash = md5(serialize($envio));
			$query = Db::getInstance()->getRow("SELECT * FROM `" ._DB_PREFIX_. "prepostagem5_recibos` WHERE hash = '".$hash."'");
			if(!isset($query['recibo'])){
				$sessao_curl2 = curl_init();
				curl_setopt($sessao_curl2, CURLOPT_URL, $urlweb);
				curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYHOST, false);
				curl_setopt($sessao_curl2, CURLOPT_HTTPHEADER, $headers);
				curl_setopt($sessao_curl2, CURLOPT_POST, true);
				curl_setopt($sessao_curl2, CURLOPT_POSTFIELDS, json_encode($envio));
				curl_setopt($sessao_curl2, CURLOPT_CONNECTTIMEOUT, 15);
				curl_setopt($sessao_curl2, CURLOPT_TIMEOUT, 15);
				curl_setopt($sessao_curl2, CURLOPT_RETURNTRANSFER, true);
				$resultados = $original = curl_exec($sessao_curl2);
				$resultados = @json_decode($resultados,true);
				$status    = curl_getinfo($sessao_curl2, CURLINFO_HTTP_CODE);
				curl_close($sessao_curl2);
				if(isset($resultados['idRecibo'])){
					Db::getInstance()->execute("INSERT INTO `"._DB_PREFIX_."prepostagem5_recibos` SET hash = '".$hash."', recibo = '".$resultados['idRecibo']."'");
				}
				sleep(2);
			}else{
				//bd
				$resultados = array();
				$resultados['idRecibo'] = $query['recibo'];
			}
			if(isset($resultados['idRecibo'])){
				//consulta os serviços do contrato
				if(Configuration::get('PREPOSTAGEM5_AMBIENTE')=='H'){
					$urlweb = 'https://apihom.correios.com.br/prepostagem/v1/prepostagens/rotulo/download/assincrono/'.$resultados['idRecibo'];
				}else{
					$urlweb = 'https://api.correios.com.br/prepostagem/v1/prepostagens/rotulo/download/assincrono/'.$resultados['idRecibo'];
				}
				//header
				$headers = array(
					"Authorization: Bearer ".trim($token_api['dados']['token'])."",
					"Content-Type: application/json",
				);
				//download 
				$sessao_curl2 = curl_init();
				curl_setopt($sessao_curl2, CURLOPT_URL, $urlweb);
				curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYHOST, false);
				curl_setopt($sessao_curl2, CURLOPT_HTTPHEADER, $headers);
				curl_setopt($sessao_curl2, CURLOPT_POST, false);
				curl_setopt($sessao_curl2, CURLOPT_CONNECTTIMEOUT, 5);
				curl_setopt($sessao_curl2, CURLOPT_TIMEOUT, 10);
				curl_setopt($sessao_curl2, CURLOPT_RETURNTRANSFER, true);
				$resultados = $original = curl_exec($sessao_curl2);
				$resultados = @json_decode($resultados,true);
				$status    = curl_getinfo($sessao_curl2, CURLINFO_HTTP_CODE);
				curl_close($sessao_curl2);
				if(isset($resultados['dados'])){
					$data = base64_decode($resultados['dados']);
					@header('Content-Type: application/pdf');
					@header('Content-Disposition: inline; filename="'.$resultados['nome'].'.pdf";');
					echo $data;
					exit;
				}else{
					Db::getInstance()->execute("DELETE FROM `"._DB_PREFIX_."prepostagem5_recibos` WHERE hash = '".$hash."'");
					echo '2 - Status: '.$status.' (tente novamente): ';
					print_r($original);
				}
			}else{
				echo '1 - Status: '.$status.' (tente novamente): ';
				print_r($original);
			}
		}
		exit;
	}
	
	private function imprimir_ar(){
		//nova api
		$token_api = $this->module->token_de_acesso_correios();
		if(!isset($token_api['dados']['token'])){
			$resultado['erro'] = true;
			$resultado['log'] = ''.$token_api['status'].' - Erro ao obter o token api Correios!';
			if(isset($token_api['dados']['stackTrace'])){
				unset($token_api['dados']['stackTrace']);
			}
			die($resultado['log']);
		}else{
			//itens
			$itens = array();
			$plps = $this->module->array_plps_novo();
			foreach($plps as $pre){
				$itens[] = $pre['id'];
			}
			//consulta os serviços do contrato
			if(Configuration::get('PREPOSTAGEM5_AMBIENTE')=='H'){
				$urlweb = 'https://apihom.correios.com.br/prepostagem/v1/prepostagens/avisorecebimento/'.implode(',',$itens);
			}else{
				$urlweb = 'https://api.correios.com.br/prepostagem/v1/prepostagens/avisorecebimento/'.implode(',',$itens);
			}
			//header
			$headers = array(
				"Authorization: Bearer ".trim($token_api['dados']['token'])."",
				"Content-Type: application/json",
			);
			//request
			$sessao_curl2 = curl_init();
			curl_setopt($sessao_curl2, CURLOPT_URL, $urlweb);
			curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($sessao_curl2, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($sessao_curl2, CURLOPT_POST, false);
			curl_setopt($sessao_curl2, CURLOPT_CONNECTTIMEOUT, 15);
			curl_setopt($sessao_curl2, CURLOPT_TIMEOUT, 15);
			curl_setopt($sessao_curl2, CURLOPT_RETURNTRANSFER, true);
			$resultados = $original = curl_exec($sessao_curl2);
			//$resultados = @json_decode($resultados,true);
			$status    = curl_getinfo($sessao_curl2, CURLINFO_HTTP_CODE);
			curl_close($sessao_curl2);
			print_r($resultados);
			exit;
		}
		exit;	
	}
	
	public function declaracao(){
		//nova api
		$token_api = $this->module->token_de_acesso_correios();
		if(!isset($token_api['dados']['token'])){
			$resultado['erro'] = true;
			$resultado['log'] = ''.$token_api['status'].' - Erro ao obter o token api Correios!';
			if(isset($token_api['dados']['stackTrace'])){
				unset($token_api['dados']['stackTrace']);
			}
			die($resultado['log']);
		}else{
			//itens
			$itens = array();
			$plps = $this->module->array_plps_novo();
			foreach($plps as $pre){
				$itens[] = $pre['id'];
			}
			//consulta os serviços do contrato
			if(Configuration::get('PREPOSTAGEM5_AMBIENTE')=='H'){
				$urlweb = 'https://apihom.correios.com.br/prepostagem/v1/prepostagens/declaracaoconteudo/'.implode(',',$itens);
			}else{
				$urlweb = 'https://api.correios.com.br/prepostagem/v1/prepostagens/declaracaoconteudo/'.implode(',',$itens);
			}
			//header
			$headers = array(
				"Authorization: Bearer ".trim($token_api['dados']['token'])."",
				"Content-Type: application/json",
			);
			//request
			$sessao_curl2 = curl_init();
			curl_setopt($sessao_curl2, CURLOPT_URL, $urlweb);
			curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($sessao_curl2, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($sessao_curl2, CURLOPT_POST, false);
			curl_setopt($sessao_curl2, CURLOPT_CONNECTTIMEOUT, 15);
			curl_setopt($sessao_curl2, CURLOPT_TIMEOUT, 15);
			curl_setopt($sessao_curl2, CURLOPT_RETURNTRANSFER, true);
			$resultados = $original = curl_exec($sessao_curl2);
			//$resultados = @json_decode($resultados,true);
			$status    = curl_getinfo($sessao_curl2, CURLINFO_HTTP_CODE);
			curl_close($sessao_curl2);
			print_r($resultados);
			exit;
		}
		exit;
	}
	
	private function cancelar_objeto_plp(){
		//dados 
		$objeto = isset($_POST['objeto'])?$_POST['objeto']:'';
		$plp = isset($_POST['plp'])?$_POST['plp']:'';
		$envio = isset($_POST['envio'])?$_POST['envio']:'';
		//consulta a plp 
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_plps` 
		WHERE uniq_id_plp = '".$plp."' AND status_plp = 'Pendente'";
        $row = Db::getInstance()->getRow($sql);
		if(!$row){
			$erro = array('erro'=>true,'log'=>'Ops, PLP não encontrada no banco de dados ou já encontra-se processada junto aos Correios!');
		}else{
			//cancelar objeto individual
			$atualizar_pagina = false;
			if(!empty($objeto) && !empty($plp) && $envio > 0){
				//verifica se o objeto já está como enviado 
				$dados_obj = $this->module->dados_pacote_objeto($objeto);
				if(isset($dados_obj['pacote_enviado']) && $dados_obj['pacote_enviado']==1){
					die(json_encode(array('erro'=>true,'log'=>'Ops, o objeto '.$objeto.' já foi postado!')));
				}
				//nova api
				$resultado = array();
				$token_api = $this->module->token_de_acesso_correios();
				if(!isset($token_api['dados']['token'])){
					$resultado['erro'] = true;
					$resultado['log'] = ''.$token_api['status'].' - Erro ao obter o token api Correios!';
					if(isset($token_api['dados']['stackTrace'])){
						unset($token_api['dados']['stackTrace']);
					}
					$resultado['raw'] = $token_api;
				}else{
					//consulta os serviços do contrato
					if(Configuration::get('PREPOSTAGEM5_AMBIENTE')=='H'){
						$urlweb = 'https://apihom.correios.com.br/prepostagem/v1/prepostagens/objeto/'.trim($objeto);
					}else{
						$urlweb = 'https://api.correios.com.br/prepostagem/v1/prepostagens/objeto/'.trim($objeto);
					}
					//header
					$headers = array(
						"Authorization: Bearer ".trim($token_api['dados']['token'])."",
						"Content-Type: application/json",
					);
					//request
					$sessao_curl2 = curl_init();
					curl_setopt($sessao_curl2, CURLOPT_URL, $urlweb);
					curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYPEER, false);
					curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYHOST, false);
					curl_setopt($sessao_curl2, CURLOPT_HTTPHEADER, $headers);
					curl_setopt($sessao_curl2, CURLOPT_CUSTOMREQUEST, "DELETE");
					curl_setopt($sessao_curl2, CURLOPT_CONNECTTIMEOUT, 5);
					curl_setopt($sessao_curl2, CURLOPT_TIMEOUT, 10);
					curl_setopt($sessao_curl2, CURLOPT_RETURNTRANSFER, true);
					$resultados = $original = curl_exec($sessao_curl2);
					$resultados = @json_decode($resultados,true);
					$status    = curl_getinfo($sessao_curl2, CURLINFO_HTTP_CODE);
					curl_close($sessao_curl2);
					if($status==200 && isset($resultados['resultadoCancelamento'])){
						$resultado['erro'] = false;
						$resultado['dados'] = 1;
						$resultado['raw'] = $resultados;
					}else{
						$resultado['erro'] = true;
						//erro
						$erro = array();
						if(isset($resultados['msgs'])){
							foreach($resultados['msgs'] as $err){
								$erro[] = $err;
							}
						}
						if(isset($resultados['causa'])){
							$erro[] = $resultados['causa'];
						}
						$resultado['mensagem'] = implode(',',$erro);
					}
				}
				//debug 
				if(Configuration::get('PREPOSTAGEM5_STATUS_DEBUG') || $resultado['erro']){
					$this->module->salvar_log('[Pré-Postagem] Debug Cancelar Objeto: '.http_build_query($resultado));
				}
				//trata o resultado
				if($resultado['erro']){
					//log
					$this->module->salvar_log('Erro ao cancelar objeto da PLP '.$plp.': '.$objeto.'');
					$erro = array('erro'=>true,'log'=>$resultado['mensagem']);
				}elseif(isset($resultado['dados']) && $resultado['dados']==1){
					//remove o pacote da listagem
					$envios = explode(',',$row['ids_pacotes']);
					if (($key = array_search($envio, $envios)) !== false) {
						unset($envios[$key]);
					}
					//atualiza o envio 
					Db::getInstance()->execute("UPDATE `" ._DB_PREFIX_. "prepostagem5_pacotes` SET cod_rastreio_pacote = '', cod_rastreio_pacote_dv = '', dv_rastreio_pacote = 0, pacote_fechado = 0, status_pacote = 0, erro = '', id_plp = '' WHERE cod_rastreio_pacote_dv = '".$objeto."'");
					Db::getInstance()->execute("UPDATE `" ._DB_PREFIX_. "prepostagem5_plps` SET ids_pacotes = '".implode(',',$envios)."' WHERE uniq_id_plp = '".$plp."'");
					//remove no banco de dados a plp
					if(count($envios)==0){
						$atualizar_pagina = true;
						Db::getInstance()->execute("DELETE FROM `" ._DB_PREFIX_. "prepostagem5_plps` WHERE uniq_id_plp = '".$plp."'");
					}
					//log
					$this->module->salvar_log('Objeto da PLP '.$plp.' cancelado com sucesso: '.$objeto.'');
					//mensagem 
					$erro = array('erro'=>false,'atualizar'=>$atualizar_pagina, 'log'=>'Objeto '.$objeto.' cancelado com sucesso na PLP selecionada!','objeto'=>$objeto);
				}else{
					$erro = array('erro'=>true,'log'=>'Erro desconhecido ao cancelar objeto da PLP! Tente novamente.');
				}
			}elseif(empty($objeto) && $plp > 0 && empty($envio)){
				//cancela uma plp completa
					//um dia futuro
				//cancela uma plp completa
			}else{
				//erro
				$erro = array('erro'=>true,'log'=>'Ops, PLP não encontrada!');
			}
		}
		die(json_encode($erro));
		exit;
	}
	
	private function cancelar_plp_geral(){
		return $this->cancelar_objeto_plp();
	}
	
	private function detalhes_pedido(){
		Tools::redirectAdmin($this->context->link->getAdminLink('AdminOrders', true).'&id_order='.(int)$_GET['id'].'&vieworder&order[filters][id_order]='.(int)$_GET['id'].'');
		exit;
	}
	
	public function lista_objetos($envios){
		$obj = array();
		foreach($envios as $envio){
			$obj[] = $envio['cod_rastreio_pacote_dv'];
		}
		return implode(',',$obj);
	}
	
	public function envios_com_declaracao($envios){
		$obj = array();
		foreach($envios as $envio){
			if((int)($envio['nfe_pacote'])==0){
				$obj[] = $envio['id_pacote'];
			}
		}
		return implode(',',$obj);
	}
	
	public function envios_com_romameio($envios){
		$obj = array();
		foreach($envios as $envio){
			if((int)($envio['id_pedido_pacote'])!=0){
				$obj[] = $envio['id_pacote'];
			}
		}
		return implode(',',$obj);
	}
	
	private function envios_com_ar($envios){
		$envios = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS("SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes` WHERE FIND_IN_SET(id_pacote,'".$envios."')");
		$pacotes = array();
		foreach($envios AS $envio){
			if($envio['servico_AR_pacote']){
				$pacotes[]=$envio['id_pacote'];
			}
		}
		return implode(',',$pacotes);
	}
}
?>