<?php 
class PrePostagem5Etq_RevModuleFrontController extends ModuleFrontController
{
	public $ssl = true;
    public $display_column_left = false;
	public $display_column_right = false;
    
	public function initContent()
	{
		//se desativado 
		if(!Configuration::get('PREPOSTAGEM5_STATUS')){
			die('Pré-Postagem - Desativado via Admin!');
		}
		//nova api
		$token_api = $this->module->token_de_acesso_correios();
		if(!isset($token_api['dados']['token'])){
			$resultado['erro'] = true;
			$resultado['log'] = ''.$token_api['status'].' - Erro ao obter o token api Correios!';
			if(isset($token_api['dados']['stackTrace'])){
				unset($token_api['dados']['stackTrace']);
			}
			die($resultado['log']);
		}else{
			//consulta os serviços do contrato
			if(Configuration::get('PREPOSTAGEM5_AMBIENTE')=='H'){
				$urlweb = 'https://apihom.correios.com.br/prepostagem/v1/prepostagens/rotulo/assincrono/pdf';
			}else{
				$urlweb = 'https://api.correios.com.br/prepostagem/v1/prepostagens/rotulo/assincrono/pdf';
			}
			//header
			$headers = array(
				"Authorization: Bearer ".trim($token_api['dados']['token'])."",
				"Content-Type: application/json",
			);
			//request
			$envio = array();
			$envio['idCorreios'] = trim(Configuration::get('PREPOSTAGEM5_USUARIO'));
			$envio['numeroCartaoPostagem'] = trim(Configuration::get('PREPOSTAGEM5_CARTAO'));
			$envio['tipoRotulo'] = LOJA5_PRE_POSTAGEM_TIPO_ROTULO;
			$envio['formatoRotulo'] = LOJA5_PRE_POSTAGEM_FORMATO_ROTULO;
			$envio['imprimeRemetente'] = LOJA5_PRE_POSTAGEM_IMPRIMIR_REMETENTE;
			$envio['layoutImpressao'] = LOJA5_PRE_POSTAGEM_LAY1;
			$envio['idsPrePostagem'][] = isset($_GET['envio'])?$_GET['envio']:'';
			//verifica se esta no bd senao faz o request
			$hash = md5(serialize($envio));
			$query = Db::getInstance()->getRow("SELECT * FROM `" ._DB_PREFIX_. "prepostagem5_recibos` WHERE hash = '".$hash."'");
			if(!isset($query['recibo'])){
				$sessao_curl2 = curl_init();
				curl_setopt($sessao_curl2, CURLOPT_URL, $urlweb);
				curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYHOST, false);
				curl_setopt($sessao_curl2, CURLOPT_HTTPHEADER, $headers);
				curl_setopt($sessao_curl2, CURLOPT_POST, true);
				curl_setopt($sessao_curl2, CURLOPT_POSTFIELDS, json_encode($envio));
				curl_setopt($sessao_curl2, CURLOPT_CONNECTTIMEOUT, 15);
				curl_setopt($sessao_curl2, CURLOPT_TIMEOUT, 15);
				curl_setopt($sessao_curl2, CURLOPT_RETURNTRANSFER, true);
				$resultados = $original = curl_exec($sessao_curl2);
				$resultados = @json_decode($resultados,true);
				$status    = curl_getinfo($sessao_curl2, CURLINFO_HTTP_CODE);
				curl_close($sessao_curl2);
				if(isset($resultados['idRecibo'])){
					Db::getInstance()->execute("INSERT INTO `"._DB_PREFIX_."prepostagem5_recibos` SET hash = '".$hash."', recibo = '".$resultados['idRecibo']."'");
				}
				sleep(2);
			}else{
				//bd
				$resultados = array();
				$resultados['idRecibo'] = $query['recibo'];
			}
			if(isset($resultados['idRecibo'])){
				//consulta os serviços do contrato
				if(Configuration::get('PREPOSTAGEM5_AMBIENTE')=='H'){
					$urlweb = 'https://apihom.correios.com.br/prepostagem/v1/prepostagens/rotulo/download/assincrono/'.$resultados['idRecibo'];
				}else{
					$urlweb = 'https://api.correios.com.br/prepostagem/v1/prepostagens/rotulo/download/assincrono/'.$resultados['idRecibo'];
				}
				//header
				$headers = array(
					"Authorization: Bearer ".trim($token_api['dados']['token'])."",
					"Content-Type: application/json",
				);
				//download 
				$sessao_curl2 = curl_init();
				curl_setopt($sessao_curl2, CURLOPT_URL, $urlweb);
				curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYHOST, false);
				curl_setopt($sessao_curl2, CURLOPT_HTTPHEADER, $headers);
				curl_setopt($sessao_curl2, CURLOPT_POST, false);
				curl_setopt($sessao_curl2, CURLOPT_CONNECTTIMEOUT, 5);
				curl_setopt($sessao_curl2, CURLOPT_TIMEOUT, 10);
				curl_setopt($sessao_curl2, CURLOPT_RETURNTRANSFER, true);
				$resultados = $original = curl_exec($sessao_curl2);
				$resultados = @json_decode($resultados,true);
				$status    = curl_getinfo($sessao_curl2, CURLINFO_HTTP_CODE);
				curl_close($sessao_curl2);
				if(isset($resultados['dados'])){
					$data = base64_decode($resultados['dados']);
					@header('Content-Type: application/pdf');
					@header('Content-Disposition: inline; filename="'.$resultados['nome'].'.pdf";');
					echo $data;
					exit;
				}else{
					Db::getInstance()->execute("DELETE FROM `"._DB_PREFIX_."prepostagem5_recibos` WHERE hash = '".$hash."'");
					echo '2 - Status: '.$status.' (tente novamente): ';
					print_r($original);
				}
			}else{
				echo '1 - Status: '.$status.' (tente novamente): ';
				print_r($original);
			}
		}
		exit;
	}
}
?>