<?php
if (!defined('_PS_VERSION_'))
	exit;

include_once(dirname(__FILE__).'/config.php');
class PrePostagem5 extends Module
{	
	public function __construct(){
		$this->name = 'prepostagem5';
		$this->fator = 6000;
		$this->total_minimo = 23.50;
		$this->tab = 'shipping_logistics';
		$this->version = '1.0';
		$this->author = 'Loja5.com.br';
		$this->need_instance = 0;
		$this->bootstrap = true;
		$this->diretorio = dirname(__FILE__);
		parent::__construct();	
		$this->displayName = $this->l('Pré-Postagem Correios');
		$this->description = $this->l('Sistema de gerenciamento de pré-postagens Correios.');
	}
	
	public function generate_string($length = 10) {
		$characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$charactersLength = strlen($characters);
		$randomString = '';
		for ($i = 0; $i < $length; $i++) {
			$randomString .= $characters[random_int(0, $charactersLength - 1)];
		}
		return $randomString;
	}
	
	public function acentos($str) {
		$replaces = array(
			'S'=>'S', 's'=>'s', 'Z'=>'Z', 'z'=>'z', 'À'=>'A', 'Á'=>'A', 'Â'=>'A', 'Ã'=>'A', 'Ä'=>'A', 'Å'=>'A', 'Æ'=>'A', 'Ç'=>'C', 'È'=>'E', 'É'=>'E',
			'Ê'=>'E', 'Ë'=>'E', 'Ì'=>'I', 'Í'=>'I', 'Î'=>'I', 'Ï'=>'I', 'Ñ'=>'N', 'Ò'=>'O', 'Ó'=>'O', 'Ô'=>'O', 'Õ'=>'O', 'Ö'=>'O', 'Ø'=>'O', 'Ù'=>'U',
			'Ú'=>'U', 'Û'=>'U', 'Ü'=>'U', 'Ý'=>'Y', 'Þ'=>'B', 'ß'=>'Ss', 'à'=>'a', 'á'=>'a', 'â'=>'a', 'ã'=>'a', 'ä'=>'a', 'å'=>'a', 'æ'=>'a', 'ç'=>'c',
			'è'=>'e', 'é'=>'e', 'ê'=>'e', 'ë'=>'e', 'ì'=>'i', 'í'=>'i', 'î'=>'i', 'ï'=>'i', 'ð'=>'o', 'ñ'=>'n', 'ò'=>'o', 'ó'=>'o', 'ô'=>'o', 'õ'=>'o',
			'ö'=>'o', 'ø'=>'o', 'ù'=>'u', 'ú'=>'u', 'û'=>'u', 'ý'=>'y', 'þ'=>'b', 'ÿ'=>'y'
		);
		return ucwords(preg_replace('/[^0-9A-Za-z,.\- ]/', '', strtr(trim($str), $replaces)));
	}
	
	public function hookdisplayAdminAfterHeader(){
		//registros 
		$pacotes_sigep = Db::getInstance()->getRow("SELECT COUNT(*) AS total FROM `"._DB_PREFIX_."prepostagem5_pacotes` WHERE status_pacote =  0 AND data_pacote BETWEEN NOW() - INTERVAL 15 DAY AND NOW()");
		$plps_sigep = Db::getInstance()->getRow("SELECT COUNT(*) AS total FROM `"._DB_PREFIX_."prepostagem5_plps` WHERE status_plp =  'Pendente' AND data_fechamento BETWEEN NOW() - INTERVAL 15 DAY AND NOW()");
		//exibe a mensagem sigep
        if(isset($_GET['controller']) && $_GET['controller']=='AdminDashboard'){
            echo '<div class="alert alert-info"><span style="background: #03A9F4; color: #FFF; border-radius: 2px; padding: 3px;"><b>[Pr&eacute;-Postagem]</b></span> Em sua loja atualmente possui <span  style="background: #ff9800; color: #FFF; border-radius: 2px; padding: 3px;">'.$pacotes_sigep['total'].'</span> <a href="'.$this->context->link->getAdminLink('AdminPrePostagem5Envios', true).'">pacotes/pedidos</a> aguardando o processamento da PLP de postagem e <span style="background: #009688; color: #FFF; border-radius: 2px; padding: 3px;">'.$plps_sigep['total'].'</span> <a href="'.$this->context->link->getAdminLink('AdminPrePostagem5PLPs', true).'">PLPs</a> com o status <span  style="background: #ff5722; color: #FFF; border-radius: 2px; padding: 3px;">Pendente</span> de processamento junto ao Correios nos &uacute;ltimos 15 dias.</div>';
        }
		//exibe a mensagem sigep
        if(isset($_GET['controller']) && $_GET['controller']=='AdminDashboard'){
			//verifica a licença
			$key_string = Configuration::get('PREPOSTAGEM5_SERIAL');
			if(isset($key_string) && !empty($key_string)){
				$validas[] = trim($key_string);
				//curl
				$dados = json_encode($validas);
				$service_url = 'https://www.loja5.com.br/index.php?route=module/iono/buscar';
				$curl = curl_init($service_url);
				curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);  
				curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE); 
				curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 5);
				curl_setopt($curl, CURLOPT_HTTPHEADER, array(
					'Content-Type: application/json',
					'Content-Length: ' .strlen($dados))
				); 
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($curl, CURLOPT_POST, true);
				curl_setopt($curl, CURLOPT_POSTFIELDS, $dados);
				$json = json_decode(curl_exec($curl),true);
				$curlErrno     = curl_errno($curl);
				$curlErr       = curl_error($curl);
				curl_close($curl);
			}
			if(isset($json['atualizados'][0])){
				$up = $json['atualizados'][0];
				echo '<div class="alert alert-info"><span style="background: #03A9F4; color: #FFF; border-radius: 2px; padding: 3px;"><b>[Pr&eacute;-Postagem Loja5]</b></span> O seu m&oacute;dulo <b>'.$up['modulo'].'</b> foi atualizado em <b>Loja5.com.br</b>, <a href="https://www.loja5.com.br/account/download.html" target="_blank">acesse sua conta > downloads</a> e baixe o mesmo at&eacute; <b>'.$up['validade'].'</b>, para instalar siga o guia de instala&ccedil;&atilde;o que encontra-se dentro do anexo baixado.</div>';
			}
        }
    }

	public function install(){
		//sql 
		include(dirname(__FILE__).'/sql/install.php');
		
		//menu principal 
		$parent_tab0 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab0->name[(int)$lang['id_lang']] = $this->l('Pré-Postagem Correios');
        }
		$parent_tab0->class_name = 'AdminPrePostagem5EnviosPadrao';
		$parent_tab0->id_parent = 0;
		$parent_tab0->module = $this->name;
		$parent_tab0->add();
		
		//menu 1
		$parent_tab1 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab1->name[(int)$lang['id_lang']] = $this->l('Envios Pendentes');
        }
		$parent_tab1->class_name = 'AdminPrePostagem5Envios';
		$parent_tab1->id_parent = $parent_tab0->id;
		$parent_tab1->module = $this->name;
		$parent_tab1->add();
		
		//menu 2
		$parent_tab2 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab2->name[(int)$lang['id_lang']] = $this->l('Envios Finalizados');
        }
		$parent_tab2->class_name = 'AdminPrePostagem5EnviosFinalizados';
		$parent_tab2->id_parent = $parent_tab0->id;
		$parent_tab2->module = $this->name;
		$parent_tab2->add();
		
		//menu 3
		$parent_tab3 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab3->name[(int)$lang['id_lang']] = $this->l('Pré-Postagens (PLPs)');
        }
		$parent_tab3->class_name = 'AdminPrePostagem5PLPs';
		$parent_tab3->id_parent = $parent_tab0->id;
		$parent_tab3->module = $this->name;
		$parent_tab3->add();
		
		//menu 4
		$parent_tab5 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab5->name[(int)$lang['id_lang']] = $this->l('Envios Entregues');
        }
		$parent_tab5->class_name = 'AdminPrePostagem5EnviosEntregues';
		$parent_tab5->id_parent = $parent_tab0->id;
		$parent_tab5->module = $this->name;
		$parent_tab5->add();
		
		//menu 4.1
		$parent_tab5 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab5->name[(int)$lang['id_lang']] = $this->l('Logistíca Reversa');
        }
		$parent_tab5->class_name = 'AdminPrePostagem5EnviosRev';
		$parent_tab5->id_parent = $parent_tab0->id;
		$parent_tab5->module = $this->name;
		$parent_tab5->add();
		
		//menu 5
		$parent_tab6 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab6->name[(int)$lang['id_lang']] = $this->l('Configurar');
        }
		$parent_tab6->class_name = 'AdminPrePostagem5Config';
		$parent_tab6->id_parent = $parent_tab0->id;
		$parent_tab6->module = $this->name;
		$parent_tab6->add();
		
		//menu 6
		$parent_tab6 = new Tab();
        foreach(Language::getLanguages(false) as $lang){
            $parent_tab6->name[(int)$lang['id_lang']] = $this->l('Logs');
        }
		$parent_tab6->class_name = 'AdminPrePostagem5Logs';
		$parent_tab6->id_parent = $parent_tab0->id;
		$parent_tab6->module = $this->name;
		$parent_tab6->add();
		
		//ativa os hooks
		if (!parent::install() OR !$this->registerHook('displayAdminAfterHeader') OR !$this->registerHook('newOrder') OR !$this->registerHook('displayAdminOrderContentOrder') OR !$this->registerHook('actionPaymentConfirmation') OR !$this->registerHook('actionOrderStatusUpdate') OR !$this->registerHook('displayOrderDetail') OR !$this->registerHook('updateCarrier') OR !$this->registerHook('displayAdminOrder') OR !$this->registerHook('displayAdminAfterHeader') OR !$this->registerHook('displayAdminOrderTabOrder') OR !$this->registerHook('displayAdminOrderSide') OR !$this->registerHook('displayBackOfficeHeader')){
			return false;
		}
		
		return true;
	}
	
	public function uninstall(){
        // remove os menus
		$moduleTabs = Tab::getCollectionFromModule($this->name);
		if (!empty($moduleTabs)) {
			foreach ($moduleTabs as $moduleTab) {
				$moduleTab->delete();
			}
		}
        return parent::uninstall();
    }
	
	public function lista_servicos_correios(){
		$servicos = $this->servicos_cadastrados();
		$html = '<div class="alert alert-info"><i class="fa fa-info"></i> Lembre-se que sempre que atualizar de ambiente entre homologa&ccedil;&atilde;o e produ&ccedil;&atilde;o os servi&ccedil;os devem ser atualizados novamente, para isso <a onclick="atualizar_servicos_prepostagem5()">clique aqui</a>!</div>';
		$html .= '<table style="border: 1px solid #CCC !important;" class="table table-striped">';
		$html .= '<thead><tr><th>Cod. Servi&ccedil;o</th><th>Servi&ccedil;o</th><th>Data</th><th>Tipo VD</th></tr></thead>';
		$html .= '<tbody>';
		if(count($servicos)==0){
			$html .= '<tr><td colspan="4">Nenhum servi&ccedil;o Correios cadastrado, caso j&aacute; tenha configurado os dados de seu contrato <a onclick="atualizar_servicos_prepostagem5()">clique aqui</a> para atualizar!</td></tr>';
		}else{
			foreach($servicos as $k=>$v){
				$html .= '<tr><td>'.$v['cod_servico'].'</td> <td>'.$v['nome_servico'].'</td> <td>'.$v['fim_contrato_servico'].'</td>
				<td>
				<select name="tipo_vd['.$v['cod_servico'].']" alt="Selecione o tipo de valor declarado correspondente ao serviço Correios!">
						<option value="">Nenhum</option>
						<option value="019"'.(($v['chancela_servico']=='019')?' selected':'').'>019 - Tipo Sedex</option>
						<option value="064"'.(($v['chancela_servico']=='064')?' selected':'').'>064 - Tipo PAC</option>
						<option value="035"'.(($v['chancela_servico']=='035')?' selected':'').'>035 - Tipo Carta</option>
						<option value="065"'.(($v['chancela_servico']=='065')?' selected':'').'>065 - Tipo MiniEnvios</option>
				</select>
				</td>
				</tr>';
			}
		}
		$html .= '</tbody>';
		$html .= '</table>';
		return $html;
	}
	
	public function token_de_acesso_correios(){
		//verifica se existe token já cadastrado 
		$sql = "SELECT * FROM `"._DB_PREFIX_."prepostagem5_tokens` WHERE atualizado > NOW() ORDER BY atualizado DESC";
		$token_offline = Db::getInstance()->getRow($sql);
		if(isset($token_offline['token'])){
			return array('status'=>200,'dados'=>array('token'=>$token_offline['token']),'url'=>'token retornado de base de dados!');
		}
		//dados e ambiente
		$login = trim(Configuration::get('PREPOSTAGEM5_USUARIO'));
		$senha = trim(Configuration::get('PREPOSTAGEM5_SENHA'));
		$cartao = trim(Configuration::get('PREPOSTAGEM5_CARTAO'));
		//header
		$headers = array(
			"Accept: application/json",
			"Content-Type: application/json",
			"Authorization: Basic ".base64_encode(trim($login).':'.trim($senha))."",
		);
		//gera o token
		$dados = array();
		//endpoint
		if(Configuration::get('PREPOSTAGEM5_AMBIENTE')=='H'){
			if(!empty($cartao)){
				$dados['numero'] = $cartao;
				$urlweb = "https://apihom.correios.com.br/token/v1/autentica/cartaopostagem";
			}else{
				$urlweb = "https://apihom.correios.com.br/token/v1/autentica";
			}
		}else{
			if(!empty($cartao)){
				$dados['numero'] = $cartao;
				$urlweb = "https://api.correios.com.br/token/v1/autentica/cartaopostagem";
			}else{
				$urlweb = "https://api.correios.com.br/token/v1/autentica";
			}
		}
		//curl
		$sessao_curl = curl_init($urlweb);
		curl_setopt($sessao_curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($sessao_curl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($sessao_curl, CURLOPT_POST, true);
		curl_setopt($sessao_curl, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($sessao_curl, CURLOPT_POSTFIELDS, json_encode($dados) );
		curl_setopt($sessao_curl, CURLOPT_CONNECTTIMEOUT, 5);
		curl_setopt($sessao_curl, CURLOPT_TIMEOUT, 40);
		curl_setopt($sessao_curl, CURLOPT_RETURNTRANSFER, true);
		$resultado = curl_exec($sessao_curl);
		$status    = curl_getinfo($sessao_curl, CURLINFO_HTTP_CODE);
		curl_close($sessao_curl);
		$token = json_decode($resultado,true);
		//cria o token no bd
		if(isset($token['token'])){		
			$sql = "INSERT INTO `"._DB_PREFIX_."prepostagem5_tokens` (`token`, `atualizado`) VALUES ('".$token['token']."', '".$token['expiraEm']."');";
			Db::getInstance()->execute($sql);
		}
		return array('status'=>$status,'dados'=>$token,'url'=>$urlweb,'original'=>$dados);
	}
	
	public function lista_servicos_correios_nomes(){
		global $cookie;
		$resultado = Db::getInstance()->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'prepostagem5_servicos`');
		$status = array();
		$i=1;
		$status[0]['id'] = 0;
		$status[0]['name'] = 'Nenhum (desativado)';
		foreach($resultado as $k=>$v){
			$status[$i]['id'] = $v['cod_servico'];
			$status[$i]['name'] = $v['cod_servico'].' - '.$v['nome_servico'];
			$i++;
		}
		return $status;
	}
	
	public function mapear_transportadoras(){
		$servicos = $this->servicos_cadastrados();
		$transportadoras = $this->transportadoras_ativadas();
		$html = '<div class="alert alert-info"><i class="fa fa-info"></i> Selecione o servi&ccedil;o de entrega Correios correspondente a modalidade de entrega da transportadora em sua loja, feito todo o relacionamento salve as configura&ccedil;&otilde;es e lembre-se que sempre que instalar um novo m&oacute;dulo de entrega ou atualizar ou editar qualquer transportadora na loja revisar este relacionamento!</div>';
		$html .= '<table style="border: 1px solid #CCC !important;" class="table table-striped">';
		$html .= '<thead><tr><th>Transportadora</th><th>Servi&ccedil;o Correios Correspondente</th></tr></thead>';
		$html .= '<tbody>';
		if(count($transportadoras)==0){
			$html .= '<tr><td colspan="4">Nenhuma transportadora ativada foi encontrada em sua loja, verifique se existe algum m&oacute;dulo de entrega cadastrado!</td></tr>';
		}else{
			foreach($transportadoras as $k=>$v){
				$html .= '<tr><td>'.$v['name'].' '.(!empty($v['external_module_name'])?'('.$v['external_module_name'].')':'').'</td><td><select name="PREPOSTAGEM5_MAPEAR_TRANSPORTADORAS['.$v['id_carrier'].']">';
				$html .= '<option value="0">Nenhuma transportadora relacionada</option>';
				foreach($servicos as $kk=>$vv){
					if($v['cod_servico']==$vv['cod_servico']){
						$html .= '<option value="'.$vv['cod_servico'].'" selected>'.$vv['cod_servico'].' - '.$vv['nome_servico'].'</option>';
					}else{
						$html .= '<option value="'.$vv['cod_servico'].'">'.$vv['cod_servico'].' - '.$vv['nome_servico'].'</option>';
					}						
				}
				$html .= '</select></td></tr>';
			}
		}
		$html .= '</tbody>';
		$html .= '</table>';
		return $html;
	}
	
	public function transportadoras_ativadas() {
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "carrier` 
		LEFT JOIN `" . _DB_PREFIX_ . "prepostagem5_mapear` ON(id_transportadora=id_carrier)
		WHERE deleted = 0 AND active = 1
		ORDER BY name ASC";
		$servicos = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		return $servicos;
	}
	
	public function status_sigep(){
		//sleep
		sleep(1);
		//api antiga
		if(1==1){
			//nova api
			$token_api = $this->token_de_acesso_correios();
			if(!isset($token_api['dados']['token'])){
				echo '<center>';
				echo '<h1 style="color:red">Erro de Acesso Pré-Postagem Correios - Token</h1>';
				echo '<p><b>Erro HTTP:</b> '.$token_api['status'].'</p>';
				echo '<p><b>Aten&ccedil;&atilde;o:</b> <i>Caso o erro reportado seja relacionado a credenciais Correios API acesse as configura&ccedil;&otilde;es do modulo e as corrija, caso seja de conectividade tente novamente mais tarde!</i></p>';
				echo '<p><b>Log:</b> <i>'.print_r($token_api,true).'</i></p>';
				echo '<center>';
			}else{
				//consulta os serviços do contrato
				if(Configuration::get('PREPOSTAGEM5_AMBIENTE')=='H'){
					$urlweb = 'https://apihom.correios.com.br/meucontrato/v1/empresas/'.preg_replace('/\D/', '', Configuration::get('PREPOSTAGEM5_CNPJ')).'/contratos/'.preg_replace('/\D/', '', Configuration::get('PREPOSTAGEM5_CONTRATO')).'/cartoes/'.preg_replace('/\D/', '', Configuration::get('PREPOSTAGEM5_CARTAO')).'/servicos?page=0&size=1000';
				}else{
					$urlweb = 'https://api.correios.com.br/meucontrato/v1/empresas/'.preg_replace('/\D/', '', Configuration::get('PREPOSTAGEM5_CNPJ')).'/contratos/'.preg_replace('/\D/', '', Configuration::get('PREPOSTAGEM5_CONTRATO')).'/cartoes/'.preg_replace('/\D/', '', Configuration::get('PREPOSTAGEM5_CARTAO')).'/servicos?page=0&size=1000';
				}
				//header
				$headers = array(
					"Authorization: Bearer ".trim($token_api['dados']['token'])."",
					"Content-Type: application/json",
				);
				//curl
				$sessao_curl2 = curl_init();
				curl_setopt($sessao_curl2, CURLOPT_URL, $urlweb);
				curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYHOST, false);
				curl_setopt($sessao_curl2, CURLOPT_HTTPHEADER, $headers);
				curl_setopt($sessao_curl2, CURLOPT_POST, false);
				curl_setopt($sessao_curl2, CURLOPT_CONNECTTIMEOUT, 5);
				curl_setopt($sessao_curl2, CURLOPT_TIMEOUT, 10);
				curl_setopt($sessao_curl2, CURLOPT_RETURNTRANSFER, true);
				$resultado = $original = curl_exec($sessao_curl2);
				$resultado = @json_decode($resultado,true);
				$status    = curl_getinfo($sessao_curl2, CURLINFO_HTTP_CODE);
				curl_close($sessao_curl2);
				if(isset($resultado['itens'])){
					//ok
					$lista_servicos = array();
					foreach($resultado['itens'] as $serv){
						if($serv['coSegmento']==3){
							$lista_servicos[] = $serv['codigo'].' - '.$serv['descricao'];
						}
					}
					echo '<center>';
					echo '<h1 style="color:green">Acesso Pré-Postagem Correios OK</h1>';
					echo '<p><b>Servicos:</b> <i>'.implode(', ',$lista_servicos).'</i></p>';
					echo '<center>';
				}else{
					//erro
					$erro = array();
					if(isset($resultado['msgs'])){
						foreach($resultado['msgs'] as $err){
							$erro[] = $err;
						}
					}
					if(isset($resultado['causa'])){
						$erro[] = $resultado['causa'];
					}
					$resultado['end'] = $urlweb;
					echo '<center>';
					echo '<h1 style="color:red">Erro de Acesso Pré-Postagem Correios - Token</h1>';
					echo '<p><b>Erro HTTP:</b> '.$status.'</p>';
					echo '<p><b>Aten&ccedil;&atilde;o:</b> <i>Caso o erro reportado seja relacionado a credenciais Correios API acesse as configura&ccedil;&otilde;es do modulo e as corrija, caso seja de conectividade tente novamente mais tarde!</i></p>';
					echo '<p><b>Log:</b> <i>'.print_r($resultado,true).'</i></p>';
					echo '<center>';
				}
			}
		}
		exit;
	}
	
	public function array_plps_novo(){
		//sem envios 
		if(!isset($_GET['envios'])){
			return false;
		}
		//dados 
		$pre_listas = array();
		$envios = explode(',',$_GET['envios']);
		foreach($envios AS $k=>$envioid){
			//dados do pacote
			$envio_query = Db::getInstance()->getRow("SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes`
			JOIN `" . _DB_PREFIX_ . "prepostagem5_pedidos` ON(id_pacote IN(ids_pacotes))
			JOIN `" . _DB_PREFIX_ . "prepostagem5_servicos` ON(id_servico_pacote=cod_servico)
			WHERE id_pacote = '".(int)$envioid."'");
			if(isset($envio_query['nome'])){
				$envio = $envio_query;
				//id do pacote 
				$i = $envio['id_pacote'];
				//plp
				//dados destinatario
				$fiscal = preg_replace('/\D/', '', $envio['fiscal']);
				if(strlen($fiscal)==11 || strlen($fiscal)==13){
					$pre_listas[$i]['destinatario']['cpfCnpj'] = $fiscal;
				}						
				$pre_listas[$i]['destinatario']['nome'] = $this->acentos($envio['nome']);
				$telefone = preg_replace('/\D/', '', $envio['telefone']);
				if(strlen($telefone) == 10){
					$pre_listas[$i]['destinatario']['dddTelefone'] = substr($telefone,0,2);
					$pre_listas[$i]['destinatario']['telefone'] = substr($telefone,-8);
				}elseif(strlen($telefone) == 11){
					$pre_listas[$i]['destinatario']['dddCelular'] = substr($telefone,0,2);
					$pre_listas[$i]['destinatario']['celular'] = substr($telefone,-9);
				}elseif(strlen($telefone) > 11){
					$telefone = substr($telefone,-11);
					$pre_listas[$i]['destinatario']['dddCelular'] = substr($telefone,0,2);
					$pre_listas[$i]['destinatario']['celular'] = substr($telefone,-9);
				}
				$pre_listas[$i]['destinatario']['email'] = $envio['email'];
				$pre_listas[$i]['destinatario']['endereco']['cep'] = preg_replace('/\D/', '', $envio['cep']);
				$pre_listas[$i]['destinatario']['endereco']['logradouro'] = $this->acentos($envio['logradouro']);
				$pre_listas[$i]['destinatario']['endereco']['numero'] = $envio['numero'];
				$pre_listas[$i]['destinatario']['endereco']['complemento'] = $this->acentos($envio['complemento']);
				$pre_listas[$i]['destinatario']['endereco']['bairro'] = $this->acentos($envio['bairro']);
				$pre_listas[$i]['destinatario']['endereco']['cidade'] = $this->acentos($envio['cidade']);
				$pre_listas[$i]['destinatario']['endereco']['uf'] = strtoupper($envio['uf']);
				//remetente
				$pre_listas[$i]['remetente']['cpfCnpj'] = preg_replace('/\D/', '', Configuration::get('PREPOSTAGEM5_FISCAL'));
				$pre_listas[$i]['remetente']['nome'] =$this->acentos(trim(Configuration::get('PREPOSTAGEM5_NOME')));
				$telefone = preg_replace('/\D/', '', Configuration::get('PREPOSTAGEM5_TEL'));
				if(strlen($telefone) == 10){
					$pre_listas[$i]['remetente']['dddTelefone'] = substr($telefone,0,2);
					$pre_listas[$i]['remetente']['telefone'] = substr($telefone,-8);
				}elseif(strlen($telefone) == 11){
					$pre_listas[$i]['remetente']['dddCelular'] = substr($telefone,0,2);
					$pre_listas[$i]['remetente']['celular'] = substr($telefone,-9);
				}elseif(strlen($telefone) > 11){
					$telefone = substr($telefone,-11);
					$pre_listas[$i]['remetente']['dddCelular'] = substr($telefone,0,2);
					$pre_listas[$i]['remetente']['celular'] = substr($telefone,-9);
				}
				if(!empty(trim(Configuration::get('PREPOSTAGEM5_EMAIL')))){
					$pre_listas[$i]['remetente']['email'] = trim(Configuration::get('PREPOSTAGEM5_EMAIL'));
				}
				$pre_listas[$i]['remetente']['endereco'] = array(
					'logradouro' => $this->acentos(trim(Configuration::get('PREPOSTAGEM5_LOGRADOURO'))),
					'numero' => trim(Configuration::get('PREPOSTAGEM5_NUMERO')),
					'complemento' => $this->acentos(trim(Configuration::get('PREPOSTAGEM5_COMPLEMENTO'))),
					'bairro' => $this->acentos(trim(Configuration::get('PREPOSTAGEM5_BAIRRO'))),
					'cep' => trim(Configuration::get('PREPOSTAGEM5_CEP')),
					'cidade' => $this->acentos(trim(Configuration::get('PREPOSTAGEM5_CIDADE'))),
					'uf' => strtoupper(trim(Configuration::get('PREPOSTAGEM5_UF'))),
				);
				//$pre_listas[$i]['codigoObjeto'] = '';
				$pre_listas[$i]['codigoServico'] = trim($envio['id_servico_pacote']);
				$pre_listas[$i]['pesoInformado'] = ((int)$envio['peso_pacote']==0?300:(int)($envio['peso_pacote']*1000));
				if((int)$envio['id_servico_pacote'] > 80000){
					$pre_listas[$i]['codigoFormatoObjetoInformado'] = 1;
				}else{
					$pre_listas[$i]['codigoFormatoObjetoInformado'] = 2;
				}
				$pre_listas[$i]['alturaInformada'] = (int)round($envio['alt_pacote']);
				$pre_listas[$i]['larguraInformada'] = (int)round($envio['lar_pacote']);
				$pre_listas[$i]['comprimentoInformado'] = (int)round($envio['com_pacote']);
				$pre_listas[$i]['cienteObjetoNaoProibido'] = 1;
				$pre_listas[$i]['numeroNotaFiscal'] = $envio['nfe_pacote'];
				if((int)$envio['id_pedido_pacote'] > 0){
					$pre_listas[$i]['observacao'] = 'Pedido #'.$envio['id_pedido_pacote'];
				}
				$ii=0;
				//itens dc
				$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_itens_dc` WHERE id_pedido = '".(int)$envio['id_pedido']."'";
				$itens = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS( $sql );
				if(count($itens) > 0){
					foreach($itens as $iten){
						$pre_listas[$i]['itensDeclaracaoConteudo'][$ii]['conteudo'] = $this->acentos($iten['nome']);
						$pre_listas[$i]['itensDeclaracaoConteudo'][$ii]['quantidade'] = $iten['qtd'];
						$pre_listas[$i]['itensDeclaracaoConteudo'][$ii]['valor'] = $iten['valor'];
						$ii++;
					}
				}
				if($envio['servico_AR_pacote']){
					$pre_listas[$i]['listaServicoAdicional'][] = array(
						'codigoServicoAdicional' => '001',
					);
				}
				if($envio['servico_MP_pacote']){
					$pre_listas[$i]['listaServicoAdicional'][] = array(
						'codigoServicoAdicional' => '002',
					);
				}
				if($envio['servico_VD_pacote']){
					if(!empty($envio['chancela_servico'])){
						$pre_listas[$i]['listaServicoAdicional'][] = array(
							'codigoServicoAdicional' => str_pad($envio['chancela_servico'], 3, "0", STR_PAD_LEFT),
							'valorDeclarado' => number_format($envio['total_pacote'], 2, '.', '')
						);
					}
				}
				$id_pacote_unico = $envio['id_pacote'];
				$com_string = (7-(int)strlen($id_pacote_unico));
				$id_pacote_unico .= $this->generate_string($com_string);
				$pre_listas[$i]['sequencial'] = $id_pacote_unico;
				if(strlen($envio['num_pacote']) > 1){
					$pre_listas[$i]['id'] = $envio['num_pacote'];
				}
			}
		}
		return $pre_listas;
	}
	
	public function array_itens_plp(){
		global $wpdb;
		//dados 
		$pre_listas = array();
		$envios = explode(',',$_GET['envios']);
		$plp = array();
		$lista = array();
		$produtos_geral_agrupados = array();
		$somatorio_produto = array();
		//plp
		foreach($envios AS $k=>$envioid){
			//dados do pacote
			$envio = Db::getInstance()->getRow("SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes`
			JOIN `" . _DB_PREFIX_ . "prepostagem5_pedidos` ON(id_pacote IN(ids_pacotes))
			JOIN `" . _DB_PREFIX_ . "prepostagem5_servicos` ON(id_servico_pacote=cod_servico)
			WHERE id_pacote = '".(int)$envioid."'");
			if(isset($envio['id_pedido_pacote']) && (int)$envio['id_pedido_pacote'] > 0){
				$order = new Order($envio['id_pedido_pacote']);
				if($order){
					//itens da plp
					$lista[$envio['cod_rastreio_pacote_dv']] = array(
						'id_pedido' => $envio['id_pedido_pacote'],
						'total' => $order->getTotalProductsWithoutTaxes(),
					);
					$lista[$envio['cod_rastreio_pacote_dv']]['destinatario'] = array(
						'nome' => $this->acentos($envio['nome']),
						'endereco' => $this->acentos($envio['logradouro']),
						'numero' => $envio['numero'],
						'complemento' => $this->acentos($envio['complemento']),
						'bairro' => $this->acentos($envio['bairro']),
						'cidade' => $this->acentos($envio['cidade']),
						'uf' => $this->acentos($envio['uf']),
						'cep' => $this->acentos($envio['cep']),
						'fiscal' => $envio['fiscal'],
						'telefone' => $envio['telefone'],
						'email' => $envio['email'],
					);
					foreach ( $order->getProducts() as $item_id => $item ) {
						//produtos individuais por envio
						$lista[$envio['cod_rastreio_pacote_dv']]['itens'][$item_id] = array(
							'id_pedido' => $envio['id_pedido_pacote'],
							'id' => $item['product_id'],
							'nome' => $item['product_name'],
							'qtd' => $item['product_quantity'],
							'total' => $item['unit_price_tax_excl'],
							'metas' => $item
						);
						if(!isset($somatorio_produto[$item['product_id']])){
							$somatorio_produto[$item['product_id']] = $item['product_quantity'];
						}else{
							$somatorio_produto[$item['product_id']] += $item['product_quantity'];
						}
						//produtos agrupados
						$produtos_geral_agrupados[$item['product_id']] = array(
							'id' => $item['product_id'],
							'nome' => $item['product_name'],
							'qtd_total' => (isset($somatorio_produto[$item['product_id']])?$somatorio_produto[$item['product_id']]:0)
						);
					}
				}
			}
			//plp
			$plp = array(
				'id' => (isset($_GET['plp'])?$_GET['plp']:''),
				'itens_agrupados' => $produtos_geral_agrupados,
				'envios_individuais' => $lista
			);
		}
		return $plp;
	}
	
	public function consulta_objeto($dados){
		//nova api
		$token_api = $this->token_de_acesso_correios();
		$resultado = array();
		if(!isset($token_api['dados']['token'])){
			$resultado['erro'] = true;
			$resultado['log'] = ''.$token_api['status'].' - Erro ao obter o token api Correios!';
			if(isset($token_api['dados']['stackTrace'])){
				unset($token_api['dados']['stackTrace']);
			}
			$resultado['raw'] = $token_api;
			return $resultado;
		}else{
			//consulta os serviços do contrato
			if(Configuration::get('PREPOSTAGEM5_AMBIENTE')=='H'){
				$urlweb = 'https://apihom.correios.com.br/prepostagem/v2/prepostagens?';
			}else{
				$urlweb = 'https://api.correios.com.br/prepostagem/v2/prepostagens?';
			}
			$urlweb .= http_build_query($dados);
			//header
			$headers = array(
				"Authorization: Bearer ".trim($token_api['dados']['token'])."",
				"Content-Type: application/json",
			);
			//request
			$sessao_curl2 = curl_init();
			curl_setopt($sessao_curl2, CURLOPT_URL, $urlweb);
			curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($sessao_curl2, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($sessao_curl2, CURLOPT_POST, false);
			curl_setopt($sessao_curl2, CURLOPT_CONNECTTIMEOUT, 5);
			curl_setopt($sessao_curl2, CURLOPT_TIMEOUT, 10);
			curl_setopt($sessao_curl2, CURLOPT_RETURNTRANSFER, true);
			$resultados = $original = curl_exec($sessao_curl2);
			$resultados = @json_decode($resultados,true);
			$status    = curl_getinfo($sessao_curl2, CURLINFO_HTTP_CODE);
			curl_close($sessao_curl2);
			if(isset($resultados['itens'])){
				$resultado['erro'] = false;
				$resultado['resultado'] = $resultados['itens'];
				return $resultado;
			}else{
				$resultado['erro'] = true;
				$resultado['log'] = ''.$status.' - Erro ao consultar objeto junto aos Correios!';
				$resultado['raw'] = $resultados;
				return $resultado;
			}
		}
	}
	
	public function hooknewOrder($order){
		//
	}
	
	public function hookactionPaymentConfirmation($order){
		//
	}
	
	public function hookDisplayAdminOrder($order){
		//
	}
	
	public function rastrear_correios($objetos='',$resultado='T') {
		$token = $this->token_de_acesso_correios();
		if(isset($token['dados']['token'])){
			//header
			$headers = array(
				"Authorization: Bearer ".trim($token['dados']['token'])."",
				"Content-Type: application/json",
			);
			if(Configuration::get('PREPOSTAGEM5_AMBIENTE')=='H'){
				$url = 'https://apihom.correios.com.br/srorastro/v1/objetos/'.$objetos.'?resultado='.$resultado;
			}else{
				$url = 'https://api.correios.com.br/srorastro/v1/objetos/'.$objetos.'?resultado='.$resultado;
			}
			$ch = curl_init(); 
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_URL, $url); 
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
			curl_setopt($ch, CURLOPT_TIMEOUT, 20); 
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($ch, CURLOPT_POST, false); 
			$curlErrno  = curl_errno($ch);
			$curlErr    = curl_error($ch);
			$xml = curl_exec($ch); 
			$info = curl_getinfo($ch);
			curl_close($ch);
			$res = @json_decode($xml,true);
			//print_r($res);
			if(isset($res['objetos'][0]['eventos'][0])){
				$e = array();
				$e['erro'] = false;
				foreach($res['objetos'][0]['eventos'] as $k=>$eve){
					$e['evento'][$k] = array(
						'data' => date('d/m/Y',strtotime($eve['dtHrCriado'])),
						'hora' => date('H:i:s',strtotime($eve['dtHrCriado'])),
						'descricao' => $eve['descricao'],
						'tipo' => $eve['codigo'],
						'status' => (int)$eve['tipo'],
						'unidade' => array(
							'pais' => (isset($eve['unidade']['endereco']['uf'])?false:true),
							'local' => (isset($eve['unidade']['tipo'])?$eve['unidade']['tipo']:''),
							'nome_local' => (isset($eve['unidade']['nome'])?$eve['unidade']['nome']:''),
							'cidade' => (isset($eve['unidade']['endereco']['cidade'])?$eve['unidade']['endereco']['cidade']:''),
							'uf' => (isset($eve['unidade']['endereco']['uf'])?$eve['unidade']['endereco']['uf']:''),
						),
						'destino' => (isset($eve['unidadeDestino']['tipo'])?array(array('local'=>$eve['unidadeDestino']['tipo'],'cidade'=>$eve['unidadeDestino']['endereco']['cidade'],'uf'=>$eve['unidadeDestino']['endereco']['uf'])):array()),
					);
				}
				return $e;
			}elseif(isset($res['objetos'][0]['mensagem'])){
				return array('erro'=>true,'log'=>$res['objetos'][0]['mensagem'],'raw'=>$res);
			}else{
				return array('erro'=>true,'log'=>'Não foi possivel consultar o objeto postado, tente novamente!','raw'=>$res);
			}
		}else{
			return array('erro'=>true,'log'=>'Problema ao obter token auth correios!','raw'=>$token);
		}
	}
	
	public function hookdisplayAdminOrderSide($params){
		//se desativado
        if ($this->active == false)
            return;
		
		//exibe no admin
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes` 
		JOIN `" . _DB_PREFIX_ . "prepostagem5_pedidos` ON(id_pacote IN(ids_pacotes))
		JOIN `" . _DB_PREFIX_ . "prepostagem5_servicos` ON(id_servico_pacote=cod_servico)
		WHERE id_pedido_pacote= ".(int)$params['id_order']."";
        $pacotes_sigep = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$qtd_pacotes = count($pacotes_sigep);
		//devolucoes
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pedidos_reverso` 
		JOIN `" . _DB_PREFIX_ . "prepostagem5_servicos` ON(extra1=cod_servico)
		WHERE status_id!='cancelado' AND id_pedido_loja= ".(int)$params['id_order']."";
        $pacotes_sigep_dev = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$qtd_pacotes_dev = count($pacotes_sigep_dev);
		//layout
		$this->context->smarty->assign(array(
				'qtd' => $qtd_pacotes,
				'qtd_dev' => $qtd_pacotes_dev,
				'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/prepostagem5',
				'pacotes' => $pacotes_sigep,
				'pacotes_dev' => $pacotes_sigep_dev,
				'id_pedido' => (int)$params['id_order'],
				'order' => $params,
				'link_padrao_etq' => Context::getContext()->link->getModuleLink('prepostagem5', 'etq_rev', array('ajax'=>'true'), true),
				'link_padrao_dec' => Context::getContext()->link->getModuleLink('prepostagem5', 'dec_rev', array('ajax'=>'true'), true)
			)
		);
		return $this->context->smarty->fetch($this->local_path.'views/templates/admin/detalhes_side.tpl');
	}
	
	public function hookdisplayAdminOrderTabOrder($params){
		//envios
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes` 
		JOIN `" . _DB_PREFIX_ . "prepostagem5_pedidos` ON(id_pacote IN(ids_pacotes))
		JOIN `" . _DB_PREFIX_ . "prepostagem5_servicos` ON(id_servico_pacote=cod_servico)
		WHERE id_pedido_pacote= ".(int)$params['order']->id."";
        $pacotes_sigep = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$qtd_pacotes = count($pacotes_sigep);
		//devolucoes
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pedidos_reverso` 
		JOIN `" . _DB_PREFIX_ . "prepostagem5_servicos` ON(extra1=cod_servico)
		WHERE status_id!='cancelado' AND id_pedido_loja= ".(int)$params['order']->id."";
        $pacotes_sigep_dev = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$qtd_pacotes_dev = count($pacotes_sigep_dev);
		//lay
		$this->context->smarty->assign(array(
				'qtd' => $qtd_pacotes,
				'qtd_dev' => $qtd_pacotes_dev,
				'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/prepostagem5',
				'pacotes' => $pacotes_sigep,
				'pacotes_dev' => $pacotes_sigep_dev,
				'id_pedido' => $params['order']->id,
				'order' => $params['order'],
			)
		);
		return $this->context->smarty->fetch($this->local_path.'views/templates/admin/detalhes_sigep_tab.tpl');
    }
	
	public function hookDisplayAdminOrderContentOrder($params){
		//envios
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes` 
		JOIN `" . _DB_PREFIX_ . "prepostagem5_pedidos` ON(id_pacote IN(ids_pacotes))
		JOIN `" . _DB_PREFIX_ . "prepostagem5_servicos` ON(id_servico_pacote=cod_servico)
		WHERE id_pedido_pacote= ".(int)$params['order']->id."";
        $pacotes_sigep = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$qtd_pacotes = count($pacotes_sigep);
		//devolucoes
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pedidos_reverso` 
		JOIN `" . _DB_PREFIX_ . "prepostagem5_servicos` ON(extra1=cod_servico)
		WHERE status_id!='cancelado' AND id_pedido_loja= ".(int)$params['order']->id."";
        $pacotes_sigep_dev = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$qtd_pacotes_dev = count($pacotes_sigep_dev);
		//lay
		$this->context->smarty->assign(array(
				'qtd' => $qtd_pacotes,
				'qtd_dev' => $qtd_pacotes_dev,
				'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/prepostagem5',
				'pacotes' => $pacotes_sigep,
				'pacotes_dev' => $pacotes_sigep_dev,
				'id_pedido' => $params['order']->id,
				'order' => $params['order'],
			)
		);
		return $this->context->smarty->fetch($this->local_path.'views/templates/admin/detalhes_sigep_conteudo.tpl');
	}
	
	public function hookdisplayOrderDetail($params){
		//envios
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes` 
		JOIN `" . _DB_PREFIX_ . "prepostagem5_pedidos` ON(id_pacote IN(ids_pacotes))
		JOIN `" . _DB_PREFIX_ . "prepostagem5_servicos` ON(id_servico_pacote=cod_servico)
		WHERE id_pedido_pacote= ".(int)$params['order']->id."";
        $pacotes_sigep = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$qtd_pacotes = count($pacotes_sigep);
		//devolucoes
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pedidos_reverso` 
		JOIN `" . _DB_PREFIX_ . "prepostagem5_servicos` ON(extra1=cod_servico)
		WHERE status_id!='cancelado' AND id_pedido_loja= ".(int)$params['order']->id."";
        $pacotes_sigep_dev = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$qtd_pacotes_dev = count($pacotes_sigep_dev);
		//layout
		$this->context->smarty->assign(array(
				'qtd' => $qtd_pacotes,
				'qtd_dev' => $qtd_pacotes_dev,
				'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/prepostagem5',
				'pacotes' => $pacotes_sigep,
				'pacotes_dev' => $pacotes_sigep_dev,
				'id_pedido' => $params['order']->id,
				'order' => $params['order'],
				'link_padrao_etq' => Context::getContext()->link->getModuleLink('prepostagem5', 'etq_rev', array('ajax'=>'true'), true),
				'link_padrao_dec' => Context::getContext()->link->getModuleLink('prepostagem5', 'dec_rev', array('ajax'=>'true'), true)
			)
		);
		return $this->context->smarty->fetch($this->local_path.'views/templates/front/detalhes_rastreamento.tpl');
	}

	public function hookdisplayBackOfficeHeader(){
		return '<style>
		.icon-AdminPrePostagem5Envios:before {
			content: "\f1b2";
		}
		</style>';
	}
	
	public function hookupdateCarrier($params){
		if ((int)($params['id_carrier']) != (int)($params['carrier']->id)) {
			Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_mapear` SET id_transportadora = ".(int)($params['carrier']->id)." WHERE id_transportadora = ".(int)$params['id_carrier'].";");
		}
	}
	
	public function hookActionOrderStatusUpdate($params) {
		//status do modulo
		$status_modulo = Configuration::get('PREPOSTAGEM5_STATUS');
		//status a criar pacotes
		$status_criar = array(Configuration::get('PREPOSTAGEM5_CRIAR_PACOTES_1'),Configuration::get('PREPOSTAGEM5_CRIAR_PACOTES_2'),Configuration::get('PREPOSTAGEM5_CRIAR_PACOTES_3'));
		//se ativado
		if($status_modulo && isset($params['id_order'])){
			//dados
			$id_order = $params['id_order'];
			//dados do pedido 
			$order = new Order($id_order);
			//se ja existe o pedido
			$sql = "SELECT COUNT(*) AS total FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes` WHERE id_pedido_pacote = '".(int)$id_order."'";
			$row = Db::getInstance()->getRow($sql);
			//regra de criar 
			$criar = false;
			if(isset($params['newOrderStatus']->id)){
				$novo_status = $params['newOrderStatus']->id;
				if($novo_status > 0 && $row['total']==0 && in_array($novo_status,$status_criar)){
					$criar = true;
				}
			}elseif(isset($params['forcar_criar']) || Configuration::get('PREPOSTAGEM5_FORCAR')){
				$criar = true;
				$novo_status = $order->getCurrentState();
			}
			//se status > 0, pedido nao existe e status a criar pacote (criar pacote)
			if($criar){
				$endereco = new Address((int)($order->id_address_delivery));
				$estado = new State((int)($endereco->id_state));
				$cliente = new Customer((int)($endereco->id_customer));
				$array_end = array_merge((array)$cliente,(array)$endereco);
				//dados pacote produtos 
				$dados_produtos = $this->dados_produtos($order);
				//medidas do pacote e pesos 
				$com = ($dados_produtos['medidas']['com'] >= 16)?$dados_produtos['medidas']['com']:16;
				$alt = ($dados_produtos['medidas']['alt'] >= 2)?$dados_produtos['medidas']['alt']:2;
				$lar = ($dados_produtos['medidas']['lar'] >= 11)?$dados_produtos['medidas']['lar']:11;
				$peso_real = $dados_produtos['peso_real'];
				$peso_cubado = $dados_produtos['peso_cubado'];
				//peso base
				if($peso_cubado <= 5.00){
					$peso_base = ($peso_real > 0)?$peso_real:0.3;
				}else{
					$peso_base = ($peso_cubado > 0)?$peso_cubado:0.3;
				}
				//status do pedido 
				$status_pedido = $novo_status;
				//status alocar automaticamente 
				$auto_alocar = 1;
				$alocar = 1;
				//endereço 
				$nfe = '';
				$email = $cliente->email;
				$nome = $endereco->firstname;
				$sobrenome = $endereco->lastname;
				$logradouro = $endereco->address1;
				$bairro = $endereco->address2;
				$cidade = $endereco->city;
				$cep = preg_replace('/\D/', '', $endereco->postcode);
				$estado = $estado->iso_code;
				//complemento
				$complemento = '';
				$compl = explode('.',Configuration::get("PREPOSTAGEM5_ORIGEM_COMPLEMENTO"));
				$ccom = isset($compl[1])?$compl[1]:'complemento';
				if(isset($endereco->compl)){
					$complemento = $endereco->compl;
				}elseif(isset($endereco->complemento)){
					$complemento = $endereco->complemento;
				}elseif(isset($endereco->$ccom) && !empty($endereco->$ccom)){
					$complemento = $endereco->$ccom;
				}
				//captura o numero 
				$limpa_num = '';
				$numero = explode('.',Configuration::get("PREPOSTAGEM5_ORIGEM_NUMERO"));
				$cnum = isset($numero[1])?$numero[1]:'numero';
				if(isset($endereco->numend) && !empty($endereco->numend)){
					$limpa_num = $endereco->numend;
				}elseif(isset($endereco->numero) && !empty($endereco->numero)){
					$limpa_num = $endereco->numero;
				}elseif(isset($endereco->number) && !empty($endereco->number)){
					$limpa_num = $endereco->number;
				}elseif(isset($endereco->$cnum) && !empty($endereco->$cnum)){
					$limpa_num = $endereco->$cnum;
				}else{
					$partes = explode(',',$endereco->address1);
					if(count($partes)==3){
						$logradouro = isset($partes[0])?$partes[0]:$endereco->address1;
						$limpa_num = isset($partes[1])?$partes[1]:'';
						$complemento = isset($partes[2])?$partes[2]:$complemento;
					}elseif(count($partes)==2){
						$logradouro = isset($partes[0])?$partes[0]:$endereco->address1;
						$limpa_num = isset($partes[1])?$partes[1]:'';
					}
				}
				//captura o cpf ou cnpj
				$numero_fiscal = '';
				$campo_fiscal1 = explode('.',Configuration::get("PREPOSTAGEM5_ORIGEM_CPF"));
				$fiscal1 = isset($campo_fiscal1[1])?$campo_fiscal1[1]:'cpf';
				$campo_fiscal2 = explode('.',Configuration::get("PREPOSTAGEM5_ORIGEM_CNPJ"));
				$fiscal2 = isset($campo_fiscal2[1])?$campo_fiscal2[1]:'cnpj';
				$array_cobranca = array_merge((array)$cliente,(array)$endereco);
				if(isset($array_cobranca[$fiscal1]) && !empty($array_cobranca[$fiscal1])){
					$numero_fiscal = preg_replace('/\D/', '', $array_cobranca[$fiscal1]);
				}elseif(isset($array_cobranca[$fiscal2]) && !empty($array_cobranca[$fiscal2])){
					$numero_fiscal = preg_replace('/\D/', '', $array_cobranca[$fiscal2]);
				}
				//valida os tamanhos 
				$limpa_num = (strlen($limpa_num) <= 5)?$limpa_num:'';
				$complemento = substr($complemento,0,30);
				//cod de servico correios 
				$cod_servico = $this->cod_metodo($order->id_carrier);
				if(Configuration::get('PREPOSTAGEM5_FORCAR')){
					if(empty($cod_servico) || $cod_servico==0 || $cod_servico=='00000'){
						$cod_servico = 0;
					}
				}else{
					if(empty($cod_servico)){
						$this->salvar_log('[Pré-Postagem] Pacote #'.$id_order.' não criado de forma automatica pois não foi feito via um serviço correios mapeado.');
						return false;
					}
				}
				//cria o pacote 
				$sql = "INSERT INTO `" . _DB_PREFIX_ . "prepostagem5_pacotes` (`id_pacote`, `num_pacote`, `id_servico_pacote`, `id_pedido_pacote`, `nfe_pacote`, `com_pacote`, `lar_pacote`, `alt_pacote`, `peso_pacote`, `total_pacote`, `cod_rastreio_pacote`, `cod_rastreio_pacote_dv`, `dv_rastreio_pacote`, `servico_MP_pacote`, `servico_VD_pacote`, `servico_AR_pacote`, `pacote_fechado`, `data_pacote`, `status_pacote`, `alocar_cron`) VALUES (NULL, '0', '".$cod_servico."', '".(int)$id_order."', '".$nfe."', '".$com."', '".$lar."', '".$alt."', '".$peso_base."', '".$order->getTotalProductsWithoutTaxes()."', '', '', '', '".Configuration::get("PREPOSTAGEM5_MP")."', '".Configuration::get("PREPOSTAGEM5_VD")."', '".Configuration::get("PREPOSTAGEM5_AR")."', '0', NOW(), '0', '".$alocar."');";
				Db::getInstance()->execute( $sql );
				$id_pacote = Db::getInstance()->Insert_ID();
				$ids_envios = array();
				if($id_pacote){
					//pega o id do pacote 
					$ids_envios[] = $id_pacote;
					//cadastra o endereço de entrega
					$telefone = !empty($endereco->phone)?$endereco->phone:$endereco->phone_mobile;
					$sql = "INSERT INTO `" . _DB_PREFIX_ . "prepostagem5_pedidos` (`id_pedido`, `status_pedido_loja`, `id_pedido_loja`, `ids_pacotes`, `nome`, `logradouro`, `numero`, `complemento`, `bairro`, `cidade`, `uf`, `cep`, `telefone`, `email`, `processado`, `data_pedido`, `fiscal`) VALUES (NULL, '".$status_pedido."', '".(int)$id_order."', '".implode(',',$ids_envios)."', '".pSQL($nome)." ".pSQL($sobrenome)."', '".pSQL($logradouro)."', '".$limpa_num."', '".pSQL($complemento)."', '".pSQL($bairro)."', '".pSQL($cidade)."', '".$estado."', '".preg_replace('/\D/', '', $cep)."', '".$telefone."', '".$email."', '0', NOW(), '".$numero_fiscal."');";
					Db::getInstance()->execute( $sql );
					$id_pedido_pre = Db::getInstance()->Insert_ID();
					//itens
					Db::getInstance()->execute("DELETE FROM `" . _DB_PREFIX_ . "prepostagem5_itens_dc` WHERE id_loja = '".$id_order."';");
					foreach ( $order->getProducts() as $order_item ) {
						$sql = "INSERT INTO `" . _DB_PREFIX_ . "prepostagem5_itens_dc` SET nome = '".pSQL($order_item['product_name'])."', qtd = '".$order_item['product_quantity']."', id_pedido = '".$id_pedido_pre."', id_loja = '".$id_order."', valor = '".$order_item['unit_price_tax_excl']."';";
						Db::getInstance()->execute($sql);
					}
					//log 
					$this->salvar_log('[Pré-Postagem] Pacote Criado Automaticamente para o pedido #'.$id_order.' ('.$status_pedido.')');
					// Inserido debug
					if(Configuration::get('PREPOSTAGEM5_STATUS_DEBUG')){
						$this->salvar_log('Detalhes Pacote #'.$id_order.': '.print_r($dados_produtos,true));
					}
					return true;
				}
			}else{
				$this->salvar_log('[Pré-Postagem] Pacote #'.$id_order.' não criado de forma automatica pois não esta atrelado a nenhuma regra de automação.');
			}
		}
		return false;
	}
	
	public function envio_do_pedido($order){
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "order_carrier` 
		WHERE id_order= ".(int)$order->id." AND id_carrier = ".(int)$order->id_carrier."";
        $row = Db::getInstance()->getRow($sql);
		return $row;
	}
	
	public function verificar_servico_ativo($id){
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_servicos` WHERE cod_servico= '".str_pad($id, 5, 0, STR_PAD_LEFT)."'";
        $row = Db::getInstance()->getRow($sql);
		return $row;
	}
	
	public function dados_pacote($id){
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes` 
		JOIN `" . _DB_PREFIX_ . "prepostagem5_pedidos` ON(id_pacote IN(ids_pacotes))
		WHERE id_pacote= ".(int)$id."";
        $row = Db::getInstance()->getRow($sql);
		return $row;
	}
	
	public function dados_pacote_pedido($id){
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes` 
		JOIN `" . _DB_PREFIX_ . "prepostagem5_pedidos` ON(id_pacote IN(ids_pacotes))
		WHERE id_pedido_pacote= ".(int)$id."";
        $row = Db::getInstance()->getRow($sql);
		return $row;
	}
	
	public function dados_pacote_objeto($objeto){
		return Db::getInstance()->getRow("SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes` AS a
		JOIN `" . _DB_PREFIX_ . "prepostagem5_pedidos` AS b ON(a.id_pacote IN(b.ids_pacotes)) 
		WHERE a.cod_rastreio_pacote_dv = '".$objeto."'");
	}
	
	private function cod_metodo($id_carrier){
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_mapear` WHERE id_transportadora= ".(int)$id_carrier."";
        $row = Db::getInstance()->getRow($sql);
		return isset($row['cod_servico'])?$row['cod_servico']:'';
	}
	
	protected function renderForm(){
        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'setGlobalConfiguration';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );
        return $helper->generateForm(array($this->getConfigForm()));
    }
	
	public function getContent(){
		$output = '';
		if (Tools::isSubmit('setGlobalConfiguration')){
			$this->postProcess();
			$output .= $this->displayConfirmation('Dados salvos com sucesso!');
		}
		if(!is_writable(dirname(__FILE__ ))) {
			$output .= $this->displayError($this->l('O diretorio do módulo "modules/'.$this->name.'/" não possui permissão de escrita, caso tenha problema ao ativar o serial de registro do mesmo aplique permissão ao mesmo compativel com sua hospedagem, lembre-se de aplicar apenas na pasta do módulo e não aplicar permissão nos arquivos do mesmo!'));
		}
		$this->context->smarty->assign('link', $this->context->link);
        $this->context->smarty->assign('module_dir', $this->_path);
		$this->context->smarty->assign('url_envios', $this->context->link->getAdminLink('AdminPrePostagem5Envios', true));
        $output .= $this->context->smarty->fetch($this->local_path.'views/templates/admin/configure.tpl');
		$rodape = $this->context->smarty->fetch($this->local_path.'views/templates/admin/rodape.tpl');

		if(!file_exists(dirname(__FILE__).'/include/licenciamento.php')){
			$file_lic = $this->displayError('<p><strong>Ops:</strong> Existe um problema no arquivo de li&ccedil;enciamento ('.dirname(__FILE__).'/include/licenciamento.php) do seu m&oacute;dulo em sua loja, aparentemente o mesmo n&atilde;o foi enviado ou esta sendo removido por sua hospedagem, <a href="https://loja5.zendesk.com/hc/pt-br/articles/5147862975117-Problema-de-Alerta-de-Arquivos-com-Eval-Base64-no-Wordfence-Sucuri-Cpanel-CPGuard-e-Outros" target="_blank">clique aqui</a> e siga as instru&ccedil;&otilde;es!</p>');
			return $output.$file_lic;
		}else{
			return $output.$this->renderForm().$rodape;
		}
	}

	protected function getConfigForm(){
		if(file_exists(dirname(__FILE__).'/include/licenciamento.php')){
			include_once(dirname(__FILE__).'/include/licenciamento.php');
			return config_prepostagem5_form($this);
		}else{
			return array();
		}
    }

    protected function getConfigFormValues(){
        $inputs = array();
        $form   = $this->getConfigForm();
		if(isset($form['form']['input'])){
			foreach ($form['form']['input'] as $v) {
				$chave          = $v['name'];
				$inputs[$chave] = Configuration::get($chave, '');
			}
		}
        return $inputs;
    }

    protected function postProcess(){
        $form_values = $this->getConfigFormValues();
        foreach (array_keys($form_values) as $key) {
			Configuration::updateValue($key, Tools::getValue($key));
        }
		//salva os relacionamentos
		if(isset($_POST['PREPOSTAGEM5_MAPEAR_TRANSPORTADORAS']) && !empty($_POST['PREPOSTAGEM5_MAPEAR_TRANSPORTADORAS'])){
			//limpa
			Db::getInstance()->execute("DELETE FROM `" . _DB_PREFIX_ . "prepostagem5_mapear`");
			//cadastra novamente
			foreach($_POST['PREPOSTAGEM5_MAPEAR_TRANSPORTADORAS'] as $k=>$v){
				Db::getInstance()->execute("INSERT INTO `" . _DB_PREFIX_ . "prepostagem5_mapear` SET id_transportadora = '".$k."',  cod_servico = '".trim($v)."'");
			}
		}
		//tipo de valores declarados
		if(isset($_POST['tipo_vd']) && !empty($_POST['tipo_vd'])){
			//cadastra novamente
			foreach($_POST['tipo_vd'] as $k=>$v){
				Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_servicos` SET chancela_servico = '".trim($v)."' WHERE cod_servico = '".trim($k)."'");
			}
		}
    }

	private function dados_produtos($params){
		$carrinho = new Cart($params->id_cart);
		$i  = 0;
		$alt = array();
		$com  = array();
		$lar = array();
		$peso = array();
		$total = 0;
		foreach ( $carrinho->getProducts() as $k => $prod ) {
			//custom 
			$profundidade = round((isset($prod['length'])?$prod['length']:$prod['depth']),2);
			$largura = round($prod['width'],2);
			$altura = round($prod['height'],2);
			$pesos = round($prod['weight'],2);
			$quantidade = isset($prod['qtd'])?$prod['qtd']:$prod['quantity'];
			$total += $prod['total'];
			//dados
			$w	 = ($largura > 0)?$largura:16;
  			$h   = ($altura > 0)?$altura:2;
  			$l   = ($profundidade > 0)?$profundidade:11;
			$p   = ($pesos > 0)?$pesos:0.1;
			$qtd = $quantidade;
			//produtos que tenha frete
			if ( $qtd > 0 && $prod['is_virtual']==0 ) {
				//se mais de um produto
				if ( $qtd > 1 ) {
					$n = $i;
					for ( $j = 0; $j < $qtd; $j++ ) {
						$alt[ $n ] = $h;
						$com[ $n ] = $w;
						$lar[ $n ] = $l;
						$peso[ $n ] = $p;
						$n++;
					}
					$i = $n;
				}else{
					//se um produto
					$alt[ $i ]  = $h;
					$com[ $i ]  = $w;
					$lar[ $i ]  = $l;
					$peso[ $i ] = $p;
				}
				$i++;
			}
		}
		$produtos_cubados = array( 'alt' => array_values( $alt ), 'com' => array_values( $com ), 'lar'  => array_values( $lar ), 'peso' => array_sum( $peso ) );
		$medidas = $this->cubagem( $produtos_cubados['alt'], $produtos_cubados['com'], $produtos_cubados['lar'] );
		$peso = $this->peso_cubado( $medidas );
		return array('medidas' => $medidas, 'total' => $total, 'peso_real' => round($produtos_cubados['peso'],2),'peso_cubado'=>round($peso,2));
	}

	private function raiz_cubica( $alt, $com, $lar, $maximos ){
		$cubagem_total = 0;
		$total_items = count( $alt );
		for ( $i = 0; $i < $total_items; $i++ ) {
			$cubagem_total += $alt[ $i ] * $com[ $i ] * $lar[ $i ];
		}
		$raiz = 0;
		$maior = max( $maximos );
		if ( 0 !== $cubagem_total && 0 < $maior ) {
			$fator = $cubagem_total / $maior;
			$raiz = round( sqrt( $fator ), 1 );
		}
		return $raiz;
	}
	
	private function cubagem( $alt, $com, $lar ){
		$cubagem     = array();
		$maximos     = array('alt' => max( $alt ), 'com'  => max( $com ), 'lar' => max( $lar ));
		$raiz        = $this->raiz_cubica( $alt, $com, $lar, $maximos );
		$maior       = array_search( max( $maximos ), $maximos, true );
		switch ( $maior ) {
			case 'alt' :
			$cubagem = array(
				'alt' => max( $alt ),
				'com'  => $raiz,
				'lar' => $raiz,
			);
			break;
			case 'com' :
			$cubagem = array(
				'alt' => $raiz,
				'com'  => max( $com ),
				'lar' => $raiz,
			);
			break;
			case 'lar' :
			$cubagem = array(
				'alt' => $raiz,
				'com'  => $raiz,
				'lar' => max( $lar ),
			);
			break;
			default :
			$cubagem = array(
				'alt' => 0,
				'com'  => 0,
				'lar' => 0,
			);
			break;
		}
		return $cubagem;
	}
	
	private function peso_cubado( $cubagem ){
		return round( ($cubagem['alt'] * $cubagem['com'] * $cubagem['lar']) / $this->fator , 2);
	}
	
	public function salvar_log($dados_log){
		if(!empty($dados_log)){
			$dados_log = is_array($dados_log)?print_r($dados_log,true):$dados_log;
			PrestaShopLogger::addLog($dados_log, 1, $this->name);
		}
		return true;
	}
		
	public function servicos_cadastrados() {
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_servicos` 
		WHERE status_servico = 1
		ORDER BY nome_servico ASC";
		$servicos = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		return $servicos;
	}

	public function status_nomes() {
		global $cookie;
		$resultado = Db::getInstance()->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'order_state` AS a,`'._DB_PREFIX_.'order_state_lang` AS b WHERE b.id_lang = "'.$cookie->id_lang.'" AND a.deleted = "0" AND a.id_order_state=b.id_order_state');
		$status = array();
		$i=1;
		$status[0]['id'] = 0;
		$status[0]['name'] = 'Nenhum (desativado)';
		foreach($resultado as $k=>$v){
			$status[$i]['id'] = $v['id_order_state'];
			$status[$i]['name'] = $v['name'];
			$i++;
		}
		return $status;
	}
	
	public function diretorias() {
		//diretorias
		$diretorias = array();
		$diretorias['ADMINISTRACAO_CENTRAL'] = 1;
		$diretorias['ACRE']                  = 3;
		$diretorias['ALAGOAS']               = 4;
		$diretorias['AMAZONAS']              = 6;
		$diretorias['AMAPA']                 = 5;
		$diretorias['BAHIA']                 = 8;
		$diretorias['BRASILIA']              = 10;
		$diretorias['CEARA']                 = 12;
		$diretorias['ESPIRITO_SANTO']        = 14;
		$diretorias['GOIAS']                 = 16;
		$diretorias['MARANHAO']              = 18;
		$diretorias['MINAS_GERAIS']          = 20;
		$diretorias['MATO_GROSSO_DO_SUL']    = 22;
		$diretorias['MATO_GROSSO']           = 24;
		$diretorias['PARA']                  = 28;
		$diretorias['PARAIBA']               = 30;
		$diretorias['PERNAMBUCO']            = 32;
		$diretorias['PIAUI']                 = 34;
		$diretorias['PARANA']                = 36;
		$diretorias['RIO_DE_JANEIRO']        = 50;
		$diretorias['RIO_GRANDE_DO_NORTE']   = 60;
		$diretorias['RONDONIA']              = 26;
		$diretorias['RORAIMA']               = 65;
		$diretorias['RIO_GRANDE_DO_SUL']     = 64;
		$diretorias['SANTA_CATARINA']        = 68;
		$diretorias['SERGIPE']               = 70;
		$diretorias['SAO_PAULO_INTERIOR']    = 74;
		$diretorias['SAO_PAULO']             = 72;
		$diretorias['TOCANTINS']             = 75;
        foreach($diretorias AS $k=>$v){
            $campos[] = array('id'=>$v,'campo'=>$v.' - '.str_replace('_',' ',$k));
        }
        return $campos;
    }
	
	public function campos_extras(){
        //querys
        $campos[] = array('id'=>'','campo'=>'Campo Padr&atilde;o');
        $clientes = Db::getInstance()->executeS("SHOW COLUMNS FROM `" . _DB_PREFIX_ . "customer`");	
        foreach($clientes AS $k=>$v){
            $input = _DB_PREFIX_.'customer.'.$v['Field'].'';
            $campos[] = array('id'=>$input,'campo'=>$input);
        }
        $enderecos = Db::getInstance()->executeS("SHOW COLUMNS FROM `" . _DB_PREFIX_ . "address`");
        foreach($enderecos AS $k=>$v){
            $input = _DB_PREFIX_.'address.'.$v['Field'].'';
            $campos[] = array('id'=>$input,'campo'=>$input);
        }
        return $campos;
    }

	public function paraarray($dados){
		return json_decode(json_encode($dados),true);
	}
	
	public function validar_endereco($dados){
		if(empty($dados['nfe_pacote'])){
			$query = Db::getInstance()->executeS("SELECT * FROM `"._DB_PREFIX_."prepostagem5_itens_dc` WHERE id_pedido = '".(int)$dados['id_pedido']."'");
			if(count($query)==0){
				return false;
			}
		}
		if(empty($dados['nome'])){
			return false;
		}elseif(empty($dados['logradouro'])){
			return false;
		}elseif(empty($dados['numero'])){
			return false;
		}elseif(strlen($dados['numero']) > 5){
			return false;
		}elseif(strlen($dados['complemento']) > 30){
			return false;
		}elseif(empty($dados['bairro'])){
			return false;
		}elseif(empty($dados['cidade'])){
			return false;
		}elseif(empty($dados['uf'])){
			return false;
		}elseif(empty($dados['cep'])){
			return false;
		}elseif(empty(preg_replace('/\D/', '', $dados['fiscal']))){
			return false;
		}elseif(empty($dados['id_servico_pacote'])){
			return false;
		}else{
			return true;
		}
	}
	
	public function l($a,$specific = false, $locale = NULL){
		return ($a);
	}
}
?>