<?php
class AdminSigepPro5EnviosFinalizadosController extends ModuleAdminController
{
	public function __construct() {
        $this->bootstrap = true;
		parent::__construct();
	}
	
	public function initPageHeaderToolbar(){
        parent::initPageHeaderToolbar();
		if (empty($this->display)) {
			$this->page_header_toolbar_btn['sigep_status_conta'] = array(
				'class' => 'fix_icons',
                'href' => 'javascript:sigep_status_conta()',
                'desc' => $this->l('Status Sigep', null, null, false),
                'icon' => 'fa fa-globe'
            );
        }
    }
	
	public function createTemplate($tpl_name){
        if (file_exists($this->getTemplatePath() . $tpl_name) && $this->viewAccess())
                return $this->context->smarty->createTemplate($this->getTemplatePath() . $tpl_name, $this->context->smarty);
            return parent::createTemplate($tpl_name);
    }
	
	public function initContent() {
        parent::initContent();
		$acao = isset($_REQUEST['acao'])?$_REQUEST['acao']:'pedidos_finalizados';
		if($acao=='pedidos_finalizados'){
			return $this->pedidos_finalizados();
		}elseif($acao=='bloquear_objetos'){
			return $this->bloquear_objetos();
		}
    }
	
	private function bloquear_objetos(){
		//acoes
		if(!isset($_POST['envios']) || count($_POST['envios'])==0){
			die(json_encode(array('erro'=>true,'log'=>'Ops, nenhum objeto selecionado para bloquear!')));
		}else{
			$logs = array();
			$envios = $_POST['envios'];
			foreach($envios AS $k=>$v){
				$envioid = $v['id'];
				$plpid = $v['plp'];
				//dados do pacote
				$enviorow = $this->module->dados_pacote($envioid);
				if($enviorow){
					$envio = $enviorow;
					$objeto = $envio['cod_rastreio_pacote_dv'];
					if($envio['pacote_bloqueado']){
						$logs[$k] = array('erro'=>true,'log'=>$envioid.' - Objeto '.$objeto.': já encontra-se bloqueado!');
					}elseif($envio['pacote_entregue']){
						$logs[$k] = array('erro'=>true,'log'=>$envioid.' - Objeto '.$objeto.' já encontra-se entregue!');
					}elseif(empty($envio['cod_rastreio_pacote_dv'])){
						$logs[$k] = array('erro'=>true,'log'=>$envioid.' - Objeto não localizado!');
					}else{
						//solicita o bloqueio do objeto 
						$dados = array(
							'numeroEtiqueta' => $objeto,
							'idPlp' => $plpid,
							'tipoBloqueio' => 'FRAUDE_BLOQUEIO',
							'acao' => 'DEVOLVIDO_AO_REMETENTE',
							'usuario' => trim(Configuration::get('SIGEPPRO5_USUARIO')),
							'senha' => trim(Configuration::get('SIGEPPRO5_SENHA')),
						);
						$resultado = $this->module->ponte('bloquearObjeto',$dados);
						//erro 
						if($resultado['erro']==1){
							//logs
							$logs[$k] = array('erro'=>true,'log'=>$envioid.' - Objeto '.$objeto.': '.$resultado['mensagem'].'','resultado'=>$resultado);
							//salva o log 
							$this->module->salvar_log('[Sigep Bloquear Objeto] '.$logs[$k]['log']);
						}else{
							//salva no banco de dados 
							Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "sigep5_pacotes` SET pacote_bloqueado = 1, log_bloqueio = 'Objeto bloqueado por Admin em ".date('d/m/Y H:i:s')." (".$resultado['mensagem'].")' WHERE id_pacote = '".(int)$envioid."'");
							//logs
							$logs[$k] = array('erro'=>false,'log'=>$envioid.' - Objeto '.$objeto.' bloqueado com sucesso por ADMIN!','resultado'=>$resultado);
							//salva o log 
							$this->module->salvar_log('[Sigep Bloquear Objeto] '.$logs[$k]['log']);
						}
					}
				}
			}
			
			//exibe os logs
			die(json_encode($logs));
		}
		exit;
	}
	
	private function pedidos_finalizados(){
		//layout
        $tpl = $this->createTemplate('envios_finalizados.tpl');
		//qtd registros
		$sql = "SELECT COUNT(*) AS total FROM `" . _DB_PREFIX_ . "sigep5_pacotes` WHERE pacote_fechado = 1 ORDER BY id_pacote DESC";
        $row = Db::getInstance()->getRow($sql);
		$total_envios = $row['total'];
		//inicio paginacao 
		$pagina = (int)(isset($_GET['pagina'])?$_GET['pagina']:1);
		$registros = (int)Configuration::get('SIGEPPRO5_QTD_PAGINA');
		$registros = ($registros==0)?20:$registros;
		$inicio = ($registros*($pagina-1));
		$paginas = ceil( $total_envios / $registros );
		//registros
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "sigep5_pacotes` 
		LEFT JOIN `" . _DB_PREFIX_ . "sigep5_pedidos` ON(id_pacote IN(ids_pacotes))
		LEFT JOIN `" . _DB_PREFIX_ . "sigep5_servicos` ON(id_servico_pacote=cod_servico)
		WHERE pacote_fechado = 1 ORDER BY id_pacote DESC LIMIT $inicio,$registros";
		$envios = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		//status
		$nomes_status = array();
		foreach($this->module->status_nomes() as $k=>$v){
			$nomes_status[$v['id']]=$v['name'];
		}
		$tpl->assign(array(
			'envios' => $envios,
			'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/sigeppro5',
			'pagina' => $pagina,
			'total_envios' => $total_envios,
			'paginas' => $paginas,
			'lista_status_pagamentos' => $nomes_status,
			'extra'	=> '',
		));
		$this->context->smarty->assign(array('content' => $tpl->fetch()));
	}
}
?>