<?php
$sql = array();

$sql[] = "CREATE TABLE IF NOT EXISTS `" . _DB_PREFIX_ . "sigep5_mapear` (
	`id_unico` INT(15) NOT NULL AUTO_INCREMENT,
	`id_transportadora` INT(15) NULL DEFAULT NULL,
	`cod_servico` CHAR(5) NULL DEFAULT NULL,
	PRIMARY KEY (`id_unico`)
)
COLLATE='latin1_swedish_ci'
ENGINE=InnoDB
AUTO_INCREMENT=1;";

$sql[] = "CREATE TABLE IF NOT EXISTS `" . _DB_PREFIX_ . "sigep5_pacotes` (
	`id_pacote` INT(15) NOT NULL AUTO_INCREMENT,
	`num_pacote` INT(15) NOT NULL,
	`id_servico_pacote` VARCHAR(20) NOT NULL,
	`id_pedido_pacote` INT(15) NOT NULL,
	`id_plp` INT(15) NOT NULL,
	`nfe_pacote` CHAR(50) NOT NULL,
	`com_pacote` FLOAT(10,2) NOT NULL,
	`lar_pacote` FLOAT(10,2) NOT NULL,
	`alt_pacote` FLOAT(10,2) NOT NULL,
	`peso_pacote` FLOAT(10,2) NOT NULL,
	`total_pacote` FLOAT(10,2) NOT NULL,
	`valor_cobrado` FLOAT(10,2) NOT NULL,
	`cod_rastreio_pacote` VARCHAR(13) NOT NULL,
	`cod_rastreio_pacote_dv` VARCHAR(14) NOT NULL,
	`dv_rastreio_pacote` INT(1) NOT NULL,
	`servico_MP_pacote` INT(1) NOT NULL,
	`servico_VD_pacote` INT(1) NOT NULL,
	`servico_AR_pacote` INT(1) NOT NULL,
	`data_pacote` DATETIME NOT NULL,
	`status_pacote` TINYINT(1) NOT NULL DEFAULT '0',
	`pacote_fechado` TINYINT(1) NOT NULL DEFAULT '0',
	`pacote_bloqueado` TINYINT(1) NOT NULL DEFAULT '0',
	`pacote_entregue` TINYINT(1) NOT NULL DEFAULT '0',
	`pacote_enviado` TINYINT(1) NOT NULL DEFAULT '0',
	`alocar_cron` TINYINT(1) NOT NULL DEFAULT '0',
	`log_bloqueio` VARCHAR(255) NOT NULL,
	`erro` VARCHAR(255) NOT NULL,
	PRIMARY KEY (`id_pacote`)
)
COLLATE='latin1_swedish_ci'
ENGINE=InnoDB
AUTO_INCREMENT=1;";

$sql[] = "CREATE TABLE IF NOT EXISTS `" . _DB_PREFIX_ . "sigep5_pedidos` (
	`id_pedido` INT(15) NOT NULL AUTO_INCREMENT,
	`status_pedido_loja` INT(15) NOT NULL,
	`id_pedido_loja` INT(15) NOT NULL,
	`ids_pacotes` VARCHAR(255) NOT NULL,
	`nome` VARCHAR(80) NOT NULL,
	`logradouro` VARCHAR(100) NOT NULL,
	`numero` VARCHAR(15) NOT NULL,
	`complemento` VARCHAR(40) NOT NULL,
	`bairro` VARCHAR(60) NOT NULL,
	`cidade` VARCHAR(60) NOT NULL,
	`uf` VARCHAR(2) NOT NULL,
	`cep` VARCHAR(9) NOT NULL,
	`telefone` VARCHAR(14) NOT NULL,
	`email` VARCHAR(80) NOT NULL,
	`processado` TINYINT(1) NOT NULL,
	`clique_retira` TINYINT(1) NOT NULL DEFAULT '0',
	`data_pedido` DATETIME NOT NULL,
	PRIMARY KEY (`id_pedido`)
)
COLLATE='latin1_swedish_ci'
ENGINE=InnoDB
AUTO_INCREMENT=1;";

$sql[] = "CREATE TABLE IF NOT EXISTS `" . _DB_PREFIX_ . "sigep5_plps` (
	`id_plp` INT(15) NOT NULL AUTO_INCREMENT,
	`uniq_id_plp` VARCHAR(45) NOT NULL,
	`ids_pacotes` TEXT NOT NULL,
	`data_fechamento` DATETIME NOT NULL,
	`data_atualizacao` DATETIME NOT NULL,
	`valor_postagem` FLOAT(10,2) NOT NULL,
	`status_plp` VARCHAR(50) NULL DEFAULT NULL,
	`local_postagem` VARCHAR(80) NULL DEFAULT NULL,
	`xml` TEXT NULL,
	PRIMARY KEY (`id_plp`)
)
COLLATE='latin1_swedish_ci'
ENGINE=InnoDB
AUTO_INCREMENT=1;";

$sql[] = "CREATE TABLE IF NOT EXISTS `" . _DB_PREFIX_ . "sigep5_servicos` (
	`id_servico` INT(15) NOT NULL AUTO_INCREMENT,
	`cod_servico` VARCHAR(6) NOT NULL,
	`cod_sigep_servico` INT(15) NOT NULL,
	`nome_servico` VARCHAR(40) NOT NULL,
	`ultima_atualizacao_servico` DATE NOT NULL,
	`status_servico` TINYINT(1) NOT NULL DEFAULT '1',
	`fim_contrato_servico` DATE NOT NULL,
	`chancela_servico` BLOB NULL,
	PRIMARY KEY (`id_servico`),
	UNIQUE INDEX `servicosUnicos` (`cod_servico`, `cod_sigep_servico`)
)
COLLATE='latin1_swedish_ci'
ENGINE=InnoDB
AUTO_INCREMENT=1;";

foreach ($sql as $query) {
    if (Db::getInstance()->execute($query) == false) {
        return false;
    }
}
