<?php
/**
* Override of CartRuleCore by Kijam.com
*
* @author    Kijam
* @copyright 2016 Kijam
* @license   Commercial use allowed (Non-assignable & non-transferable), can modify source-code but cannot distribute
*            modifications (derivative works).
*/
class Cart extends CartCore
{
    /**
     * Add a CartRule to the Cart.
     *
     * @param int $id_cart_rule CartRule ID
     * @param bool $useOrderPrices
     *
     * @return bool Whether the CartRule has been successfully added
     */
    /*
    * module: cartrulefirstorder
    * date: 2022-09-21 14:16:34
    * version: 1.0.2
    */
    public function addCartRule($id_cart_rule, bool $useOrderPrices = false)
    {
        
        $instance = Module::getInstanceByName('cartrulefirstorder');
        if ($instance && $instance->active && !$instance->checkAddCartRule($this, $id_cart_rule)) {
            return false;
        }
        if (version_compare(_PS_VERSION_, '1.7.7.5') < 0) {
            return CartCore::addCartRule($id_cart_rule);
        }
        return CartCore::addCartRule($id_cart_rule, $useOrderPrices);
    }
}