<?php
class SigepPro5Cron_CriarModuleFrontController extends ModuleFrontController
{
	public $ssl = true;
    public $display_column_left = false;
	public $display_column_right = false;
    
	public function initContent()
	{
		parent::initContent();
		//se desativado 
		if(!Configuration::get('SIGEPPRO5_STATUS')){
			die('Sigep Desativado via Admin!');
		}
		//registros dos pacotes pendentes de processamento
		$query = "SELECT * FROM `" . _DB_PREFIX_ . "sigep5_pacotes` 
		LEFT JOIN `" . _DB_PREFIX_ . "sigep5_pedidos` ON(id_pacote IN(ids_pacotes))
		LEFT JOIN `" . _DB_PREFIX_ . "sigep5_servicos` ON(id_servico_pacote=cod_servico)
		WHERE pacote_fechado = '0' AND status_pacote = '0' AND alocar_cron = '1' AND data_pacote BETWEEN NOW() - INTERVAL 30 DAY AND NOW() ORDER BY id_pacote DESC";
		$pacotes = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);
		if(count($pacotes)==0){
			die('Nenhum pedido a processar!');
		}
		//processa os pacotes de envios para atrelar o cod de rastreio
		foreach($pacotes as $k=>$v){
			//se pedido existir na loja
			$id_unico = $v['id_pacote'];
			$pacotes_pedido = $this->module->dados_pacote($id_unico);
			//valida o endereco
			$endereco_valido = $this->module->validar_endereco($pacotes_pedido);		
			//se pedido loja
			$pedido_loja = (int)$pacotes_pedido['id_pedido_loja'];
			if($pedido_loja > 0){
				$order = new Order($pedido_loja);
				if($order){
					$status_pedido = $order->getCurrentState();
					$sql = "UPDATE `" . _DB_PREFIX_ . "sigep5_pedidos` SET `status_pedido_loja` = '".$status_pedido."' WHERE id_pedido_loja = '".$pedido_loja."';";
					Db::getInstance()->execute($sql);
				}
			}else{
				$order = null;	
			}
			//valida o endereco
			if(!$endereco_valido){
				//json
				$json[$k] = array('erro'=>true,'log'=>$id_unico.' - O endereço ou dados do pacote estão invalidos ou incorretos, edite o pacote via admin e o corrija (cron)!');
				//salva o log 
				$this->module->salvar_log('[Criar Objeto] '.$json[$k]['log']);
			//pacote ainda aberto
			}elseif($pacotes_pedido['pacote_fechado']==0){
				//solicitar etiquetas se servico ativo e valido
				$servico_ativo = $this->module->verificar_servico_ativo($pacotes_pedido['id_servico_pacote']);
				if(isset($servico_ativo['status_servico']) && $servico_ativo['status_servico']==1){
					//solicita a etiqueta
					$accessData = $this->module->login_sigep();
					try {
						$params = new \PhpSigep\Model\SolicitaEtiquetas();
						$params->setQtdEtiquetas(1);
						$params->setServicoDePostagem($pacotes_pedido['id_servico_pacote']);
						$params->setAccessData($accessData);
						$phpSigep = new PhpSigep\Services\SoapClient\Real();
						$result = $phpSigep->solicitaEtiquetas($params);
						if (!$result->hasError()) {
							//resultado
							$etiquetas = $result->getResult();
							//atualiza o sql
							$sql = "UPDATE `" . _DB_PREFIX_ . "sigep5_pacotes` SET `cod_rastreio_pacote` = '".$etiquetas[0]->getEtiquetaSemDv()."', `cod_rastreio_pacote_dv` = '".$etiquetas[0]->getEtiquetaComDv()."', `dv_rastreio_pacote` = '".$etiquetas[0]->getDv()."', `status_pacote` = 1 WHERE id_pacote = ".(int)$pacotes_pedido['id_pacote'].";";
							Db::getInstance()->execute($sql);
							//json
							$json[$k] = array('erro'=>false,'log'=>$id_unico.' - Etiqueta alocada com sucesso: '.$etiquetas[0]->getEtiquetaComDv().' (cron)!');
							//salva o log 
							$this->module->salvar_log('[Criar Objeto] '.$json[$k]['log']);
						} else {
							//erro
							$erro = $result->getErrorMsg();
							$erro .= ' Verifique se os dados de contrato e ambiente estão corretos e se o serviço selecionado esta disponivel ao mesmo!';
							//json
							$json[$k] = array('erro'=>true,'log'=>$id_unico.' - Ocorreu um problema ao alocar a etiqueta: '.$erro.' (cron)!');
							//salva o log 
							$this->module->salvar_log('[Criar Objeto] '.$json[$k]['log']);
						
						}
					} catch (\Exception $ex) {
						//erro
						$erro = $ex->getMessage();
						//json
						$json[$k] = array('erro'=>true,'log'=>$id_unico.' - Ocorreu um problema ao alocar a etiqueta: '.$erro.' (cron)!');
						//salva o log 
						$this->module->salvar_log('[Criar Objeto] '.$json[$k]['log']);
					}
					
				}else{
					//erro
					$json[$k] = array('erro'=>true,'log'=>$id_unico.' - O serviço selecionado para este envio encontra-se inativo, edite ou substitua o metodo de envio (cron)!');
					//salva o log 
					$this->module->salvar_log('[Criar Objeto] '.$json[$k]['log']);
				}
				
			}else{
				//erro
				$json[$k] = array('erro'=>true,'log'=>$id_unico.' - Este pacote já encontra-se fechado (cron)!');
				//salva o log 
				$this->module->salvar_log('[Criar Objeto] '.$json[$k]['log']);
			}
		}
		//exibe
		foreach($json as $k=>$v){
			echo $v['log'].'<br>';
		}
		exit;
	}
}
?>