{*
 * 2015-2021 Bonpresta
 *
 * Bonpresta Text Banner with Carousel
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the General Public License (GPL 2.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/GPL-2.0
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade the module to newer
 * versions in the future.
 *
 *  @author    Bonpresta
 *  @copyright 2015-2021 Bonpresta
 *  @license   http://opensource.org/licenses/GPL-2.0 General Public License (GPL 2.0)
*}

{if isset($items) && $items}
    <section id="bontextslider">
        <ul class="{if !$display_carousel}row {else}slick-carousel-bontextslider {/if}"
            data-animation="fadeInUp">
            {foreach from=$items item=item name=item}
                {if $smarty.foreach.item.iteration <= $limit}
                    <li class="col-12 col-xs-12 bontextslider-item"
                        style="background-color: {$bon_textslider_background|escape:'htmlall':'UTF-8'};">
                        {if isset($item.description) && $item.description}
                            <div class="box-bontextslider">                              
                                {if isset($item.url) && $item.url}
                                    <a class="link-bontextslider" href="{$item.url|escape:'htmlall':'UTF-8'}"
                                        style="color: {$bon_textslider_color|escape:'htmlall':'UTF-8'}; font-size: {$bon_textslider_font_size|escape:'htmlall':'UTF-8'}px;">
                                        {$item.description nofilter}
                                    </a>
                                {/if}                               
                            </div>
                        {/if}
                    </li>
                {/if}
            {/foreach}
        </ul>
        <span id="bontextslider-close" class="bontextslider-close-button"></span>
    </section>
{/if}