<?php
class CieloApiPro5Cartao_CreditoModuleFrontController extends ModuleFrontController{

	public $ssl = true;

	public function initContent() {
		
		$this->display_column_left = false;
		$this->display_column_higt = false;
		
		parent::initContent();
        
        //bandeiras ativas
        $lista_op_credito = array(
            'visa' => 'Visa',
            'mastercard' => 'Mastercard',
            'elo' => 'Elo',
            'diners' => 'Diners',
            'discover' => 'Discover',
            'amex' => 'Amex',
            'jcb' => 'JCB',
            'aura' => 'Aura',
			'hiper' => 'Hiper',
			'hipercard' => 'Hipercard',
        );
        $arr_cc = array();
        foreach($lista_op_credito AS $op_id => $op_name){
            $ativa = Configuration::get('CIELOAPIPRO5_OP_'.$op_id.'');
            if($ativa){
                $arr_cc[] = $op_id; 
            }
        }
		
		//pega os dados
		$dados['randon'] = rand(1,9999999);
		$dados['ano'] = date('Y');
		
		//faz o parcelamento
		$total = $this->context->cart->getOrderTotal(true, Cart::BOTH);
		
		$this->context->smarty->assign(array(
		    'dados_cielows' => $dados,
            'arr_cc' => $arr_cc,
			'google_captcha' => (isset($this->module->google_captcha)?$this->module->google_captcha:false),
			'google_captcha_id' => (isset($this->module->google_captcha_id)?$this->module->google_captcha_id:''),
			'total' => number_format($total, 2, '.', ''),
			'totalhash' => md5(sha1(md5(number_format($total, 2, '.', '')))),
			'cartid' => $this->context->cart->id,
			'this_path' => $this->module->getPathUri(),
			'link_loja' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'',
			'this_path_ssl' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->module->name.'/'
		));
		$this->setTemplate('cartao_credito.tpl');
	}


}
