<?php
class CieloApiPro5ParcelasModuleFrontController extends ModuleFrontController{

	public $ssl = true;
	public $display_column_left = false;
	public $display_column_higt = false;
    
    public function CalcularJurosCielo($valorTotal, $taxa, $nParcelas){
        $taxa = $taxa/100;
        $cadaParcela = ($valorTotal*$taxa)/(1-(1/pow(1+$taxa, $nParcelas)));
        return round($cadaParcela, 2);
    }

	public function initContent() {
		parent::initContent();
		
		@header('Content-Type: application/json');
		
		//valida a bandeira
		$linhas = array();
		if($_GET['id']=='null'){
			$linhas[''] = "Clique no cartão qual deseja usar!";
			echo json_encode($linhas);
			exit;
		}
        
        //carinho
        $cart = new Cart($this->context->cart->id);
        $total_pedido = $cart->getOrderTotal(true, Cart::BOTH);
        $frete = $cart->getOrderTotal(true, 5);  
        
        $enviar_total_com_juros = true;

        //pega os dados e vars
        $minimo = (float)Configuration::get('CIELOAPIPRO5_MINIMO');
        if($minimo <= 0){
            $minimo = 5;
        }
        $desconto = 0;
        $divmax = (int)Configuration::get('CIELOAPIPRO5_DIV');
        $divsem =(int)Configuration::get('CIELOAPIPRO5_SEM');
        $juros  = (float)Configuration::get('CIELOAPIPRO5_JUROS');

        $total = $total_puro  = number_format($total_pedido, 2, '.', '');

        //corrije bug erro etapa2
        $total = number_format($total, 2, '.', '');

        //calcula os minimos
        $split = (int)$total/$minimo;
        if($split>=$divmax){
            $div = (int)$divmax;
        }elseif($split<$divmax){
            $div = (int)$split;
        }elseif($total<=$minimo){
            $div = 1;
        }

        //seleta o tipo de parcelamento
        if(Configuration::get('CIELOAPIPRO5_TIPO_PAR')=='loja'){
            $pcom = 2;
            $psem = 2;
        }elseif(Configuration::get('CIELOAPIPRO5_TIPO_PAR')=='operadora'){
            $pcom = 2;
            $psem = 3;
        }

        //inicio
        $linhas[''] = "Selecione a condição de pagamento desejada";

        //avista
        if($desconto>0){
            $desconto_valor = ($total/100)*$desconto;
            $linhas[base64_encode('1|1|'.number_format(($total-$desconto_valor), 2, '.', '').'|'.base64_encode($_GET['id']).'|'.base64_encode($total).'|'.md5(($total-$desconto_valor)))] = "&Agrave; vista por ".Tools::displayPrice(number_format(($total-$desconto_valor), 2, '.', ''))." (j&aacute; com ".$desconto."% off)";
        }else{
            $linhas[base64_encode('1|1|'.number_format(($total), 2, '.', '').'|'.base64_encode($_GET['id']).'|'.base64_encode($total).'|'.md5($total))] = "&Agrave; vista por ".Tools::displayPrice(number_format(($total), 2, '.', ''))."";
        }

        //se tiver parcelado
        if($_GET['id']!='discover' && $_GET['id']!='electron' && $_GET['id']!='maestro'){
            if($div>=2){
                for($i=1;$i<=$div;$i++){
                    if($i>1){
                        if($i<=$divsem){
                            $linhas[base64_encode(''.$i.'|'.$psem.'|'.number_format(($total), 2, '.', '').'|'.base64_encode($_GET['id']).'|'.base64_encode($total).'|'.md5($total))] = $i."x de ".Tools::displayPrice(number_format(($total/$i), 2, '.', ''))." sem juros";
                        }else{
                            $parcela_com_juros = $this->CalcularJurosCielo($total_puro, $juros, $i);
                            if($enviar_total_com_juros){
                                $total = number_format(($parcela_com_juros*$i), 2, '.', '');
                            }
                            $linhas[base64_encode(''.$i.'|'.$pcom.'|'.number_format(($total), 2, '.', '').'|'.base64_encode($_GET['id']).'|'.base64_encode($total).'|'.md5($total))] = $i."x de ".Tools::displayPrice(number_format(($parcela_com_juros), 2, '.', ''))." com juros";
                        }
                    }
                }
            }
        }

        echo json_encode($linhas);
		exit;
	}
}
