<?php
class CieloApiPro5Validar_BoletoModuleFrontController extends ModuleFrontController{

	public $ssl = true;
    
    public function aplicarDesconto($cart)
	{
		if(!$cart->id || $cart->id==0){
			return false;
		}
		$total = (float)abs(Configuration::get("CIELOAPIPRO5_DESC_BOL"));
		if($total > 0){
			if(CartRule::cartRuleExists('DESBOL'.$cart->id)){
				return false;
			}
			$rule = 'V0C'.(int)($cart->id_customer).'O'.(int)($cart->id);
			if(CartRule::cartRuleExists($rule)){
				return false;
			}
			$name='DESBOL'.$cart->id;
			$languages=Language::getLanguages();
			foreach ($languages as $key => $language) {
				$arrayName[$language['id_lang']]= $rule;
			}
			$voucher=new CartRule();
			$voucher->description =(string)($name);
			$voucher->reduction_amount = 0;
			$voucher->reduction_percent = $total;
			$voucher->name=$arrayName;
			$voucher->id_customer=(int)($cart->id_customer);
			$voucher->id_currency=(int)($cart->id_currency);
			$voucher->quantity=1;
			$voucher->quantity_per_user=1;
			$voucher->cumulable=0;
			$voucher->cumulable_reduction=0;
			$voucher->minimum_amount=0;
			$voucher->active=1;
			$now=time();
			$voucher->date_from=date("Y-m-d H:i:s",$now);
			$voucher->date_to=date("Y-m-d H:i:s",$now+(3600*24));
			$voucher->code='V'.(int)($voucher->id).'C'.(int)($cart->id_customer).'O'.$cart->id;
			if($voucher->add()){
				$cart->addCartRule((int)$voucher->id);
			}
		}
	}
	
	public function initContent() {
		
		$this->display_column_left = false;
		$this->display_column_higt = false;
		
		parent::initContent();
		
		//valida o carrinho 
		if($this->context->cart->getOrderTotal(true, Cart::BOTH) <= 0){
			die('Ops, valor do carrinho invalido!');
		}
		
		//aplica o desconto caso tenha
		$this->aplicarDesconto($this->context->cart);
		
		//chama o carrinho
		$cart = new Cart($this->context->cart->id);
		$cliente = new Customer($cart->id_customer);
		$obj = $this->module;
        $qual_pedido = $cart->id;
        
        //dados entrega
        $entrega = new Address(($cart->id_address_delivery==0)?$cart->id_address_invoice:$cart->id_address_delivery);
		$estadoe = new State((int)($entrega->id_state));
		
		//dados de cobrança
		$cobrar = new Address((int)($cart->id_address_invoice));
		$estadoc = new State((int)($cobrar->id_state));
		$obj = $this->module;
        $qual_pedido = $cart->id;
        
        //url de ipn 
        $ipn = Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->module->name.'/ipn.php?cart_id='.$cart->id;
		
		//custom numero cobrar
		$limpa_num = '';
		$numeroc = explode('.',Configuration::get("CIELOAPIPRO5_NUMERO"));
		$cnum = isset($numeroc[1])?$numeroc[1]:'numero';
		if(isset($cobrar->numend) && !empty($cobrar->numend)){
			$limpa_num = $cobrar->numend;
		}elseif(isset($cobrar->numero) && !empty($cobrar->numero)){
			$limpa_num = $cobrar->numero;
		}elseif(isset($cobrar->number) && !empty($cobrar->number)){
			$limpa_num = $cobrar->number;
		}elseif(isset($cobrar->$cnum) && !empty($cobrar->$cnum)){
			$limpa_num = $cobrar->$cnum;
		}
		$logradouroc = $cobrar->address1;
		$complementoc = '';
		if(empty($limpa_num)){
			$partesc = explode(',',$cobrar->address1);
			$limpa_num = isset($partesc[1])?$partesc[1]:'';
			$logradouroc = isset($partesc[0])?$partesc[0]:$cobrar->address1;
			$complementoc = isset($partesc[2])?$partesc[2]:'';
		}
		$numero = $limpa_num;
		
		//custom fiscal
        if(!isset($_POST['cpf_cliente'])){
            $_POST['cpf_cliente'] = '11111111111';
        }
        $fiscal_valor = $fiscal = preg_replace('/\D/', '', $_POST['cpf_cliente']);
        
        //ambiente
        $MID = trim(Configuration::get('CIELOAPIPRO5_ID'));
        $KEY = trim(Configuration::get('CIELOAPIPRO5_SECRET'));
        if(Configuration::get('CIELOAPIPRO5_TESTE')){
            $MID = 'daaec334-ac85-4c63-9564-f4a31be7b19b';
            $KEY = 'LTFYLLACRDYCIKMHTXBRVKGQYGDHOOVTCKGZUKRK';
            $provider = 'Simulado';
            $urlweb = "https://apisandbox.cieloecommerce.cielo.com.br/1/";
        }else{
            $provider = 'Cielo';
            $urlweb = "https://api.cieloecommerce.cielo.com.br/1/";
        }
        
        //processo
        $objResposta = array();
        $headers = array(
            "Content-Type" => "application/json",
            "Accept" => "application/json",
            "MerchantId" => $MID,
            "MerchantKey" => $KEY,
            "RequestId" => "",
        );
        
        //dados a enviar
        $dados = array();
		$dados['MerchantOrderId'] = $cart->id;
        $dados['Customer'] = array(
            'Name'=>$cliente->firstname.' '.$cliente->lastname,
            "Identity" => $fiscal_valor,
            "IdentityType" => (strlen($fiscal_valor)==11?'CPF':'CNPJ'),
            'Address'=>array(
                'Street'=> $logradouroc,
                'Number'=>(!empty($numero)?$numero:'s/n'),
                'District'=>(!empty($cobrar->address2)?$cobrar->address2:'Centro'),
				'Complement' => $complementoc,
                'ZipCode'=>preg_replace('/\D/', '', $cobrar->postcode),
                'City'=>$cobrar->city,
                'State'=>$estadoc->iso_code,
                'Country'=>'BR',
            )
        );

		$dataVenda = strtotime($cart->date_upd);
		$dataExtra = (int)(60*60*24*Configuration::get('CIELOAPIPRO5_VALIDADE'));
        
        $total_pedido = $this->context->cart->getOrderTotal(true, Cart::BOTH);
        
		$dados['Payment'] = array(
			'Type' => 'Boleto',
			'Amount' => number_format($total_pedido, 2, '', ''),
			'Country' => 'BRA',
            'Provider' => Configuration::get('CIELOAPIPRO5_BC'),
			'Address'=>'',
			'BoletoNumber'=> $qual_pedido,
			'Assignor'=> Configuration::get('CIELOAPIPRO5_CED'),
			'Demonstrative'=> Configuration::get('CIELOAPIPRO5_DEMO'),
			'ExpirationDate'=>date('Y-m-d',($dataVenda+$dataExtra)),
			'Identification'=>'',
			'Instructions'=>Configuration::get('CIELOAPIPRO5_IN'),
		);
		
		//print_r($dados);
		//exit;
        
        include_once(dirname(__FILE__).'/../../classes/restclient.php' );
        $api = new RestClient(array(
            'base_url' => $urlweb, 
            'headers' => $headers,           
        ));

        $response = $api->post("sales", json_encode($dados));
        $dados_pedido = @json_decode($response->response,true);
		
		//print_r($dados_pedido);
		//exit;
        
		$erro = false;
		$cod = $response->status;
        if(($response->status==200 || $response->status==201) && isset($dados_pedido['Payment']['Status'])){
			
            //cria o pedido de acordo com o status moip
            $qual_pedido = $cart->id;
            $total_pedido = $this->context->cart->getOrderTotal(true, Cart::BOTH);
			
			//vars
			$link_boleto = isset($dados_pedido['Url'])?$dados_pedido['Url']:'';
			$extraVars = array(
				'{segunda_via}' => $link_boleto,
				'link_boleto'    => $link_boleto,
			);
            
            $obj->validateOrder((int)$cart->id, Configuration::get('CIELOAPIPRO5_INICIADA'), $total_pedido, 'Cielo - Boleto', null, array(), null, false, $cliente->secure_key);
			
			//log
			$msglog = '[API] Transação Cielo via Boleto no total de R$'.number_format($total_pedido, 2, '.', '').'';
			$msglog .= ' / CPF/CNPJ: '.preg_replace('/\D/', '', $_POST['cpf_cliente']).'';
			
			//cria um log para o pedido
			$order = new Order($obj->currentOrder);
			$msg = new Message();
			$message = strip_tags($msglog, '<br>');
			if (($message)){
				$msg->message = $message;
				$msg->id_order = intval($order->id);
				$msg->private = 1;
				$msg->add();
			}
            
            //sql dados cielo
            $ip = Tools::getRemoteAddr();
            $sql = "INSERT INTO `"._DB_PREFIX_."cielo_webservice` (`id`, `pedido`, `valor`, `parcela`, `produto`, `tid`, `nome`, `cpf`, `telefone`, `ip`, `lr`, `pan`, `cc`, `bin`) VALUES (NULL, '".$obj->currentOrder."', '".number_format($total_pedido, 2, '.', '')."', '1', 'boleto', '".$dados_pedido['Payment']['BoletoNumber']."', '".$cliente->firstname." ".$cliente->lastname."', '".$fiscal."', '', '".$ip."', '0', '".$dados_pedido['Payment']['PaymentId']."', '', '');";
            Db::getInstance()->Execute($sql);
			
			if(isset($dados_pedido['Payment']['Url'])){
				$sql = "INSERT INTO `"._DB_PREFIX_."cielo_webservice_links` (`id`, `pedido`, `tipo`, `link`) VALUES (NULL, '".$obj->currentOrder."', 'Boleto', '".$dados_pedido['Payment']['Url']."');";
				Db::getInstance()->Execute($sql);
			}
            
            Tools::redirect('index.php?controller=order-confirmation&id_cart='.(int)($qual_pedido).'&id_module='.(int)($obj->id).'&id_order='.$obj->currentOrder.'&key='.$cliente->secure_key.'&boleto='.$dados_pedido['Payment']['BoletoNumber'].'&hash='.$dados_pedido['Payment']['PaymentId'].'');
            exit;
			
		}elseif(isset($dados_pedido['ReturnMessage'])){
        
			$erro = true;
			$msg = "Erro no pedido cielo de cod: ".$dados_pedido['ReturnCode']." - ".$dados_pedido['ReturnMessage'];
			
		}elseif(isset($dados_pedido['Message'])){
        
			$erro = true;
			$msg = "Erro no pedido cielo de cod: ".$dados_pedido['Code']." - ".$dados_pedido['Message'];
			
		}elseif(isset($dados_pedido[0]['Message'])){
			
			$erro = true;
			$msg = "Erro no pedido cielo de cod: ".$dados_pedido[0]['Code']." - ".$dados_pedido[0]['Message'];
        
        }else{
            
			$erro = true;
			$msg = "Erro desconhecido cielo, verificar credenciais, ambiente e versao do curl do servidor!";
			$msg .= print_r($dados_pedido,true);
        
        }
		
        if($erro=true){
			PrestaShopLogger::addLog($msg, 2);
			PrestaShopLogger::addLog('Enviado: '.json_encode($dados), 2);
			PrestaShopLogger::addLog('Resposta: '.$response->response, 2);
            $this->context->smarty->assign(array(
                'msgerro' => $cod.' - '.$msg,
                'this_path' => $this->module->getPathUri(),
                'link_loja' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'/',
                'this_path_ssl' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->module->name.'/'
            ));
            $this->setTemplate('erro.tpl');
		}
	}
}
?>