<?php
class CieloApiPro5Validar_CreditoModuleFrontController extends ModuleFrontController{

	public $ssl = true;
    
    public function CartaoLoja5($bandeira,$tipo_parcela,$debito=false){
        $bandeira = strtoupper($bandeira);
        switch($bandeira){

        case 'VISA':
        $op = 'visa';
        $autorizar = 3;
        $parcela = $tipo_parcela;
        break;

        case 'ELECTRON':
        case 'VISAELECTRON':
        $op = 'visa';
        $autorizar = 2;
        $parcela = 'A';
        break;

        case 'ELODEBITO':
        $op = 'elo';
        $autorizar = 2;
        $parcela = 'A';
        break;

        case 'MASTERCARD':
        $op = 'mastercard';
        $autorizar = 3;
        $parcela = $tipo_parcela;
        break;

        case 'MAESTRO':
        $op = 'mastercard';
        $autorizar = 2;
        $parcela = 'A';
        break;

        case 'ELO':
        $op = 'elo';
        $autorizar = 3;
        $parcela = $tipo_parcela;
        break;

        case 'DINERS':
        $op = 'diners';
        $autorizar = 3;
        $parcela = $tipo_parcela;
        break;

        case 'DISCOVER':
        $op = 'discover';
        $autorizar = 3;
        $parcela = $tipo_parcela;
        break;

        case 'AMEX':
        $op = 'amex';
        $autorizar = 3;
        $parcela = $tipo_parcela;
        break;

        case 'AURA':
        $op = 'aura';
        $autorizar = 3;
        $parcela = $tipo_parcela;
        break;

        case 'JCB':
        $op = 'jcb';
        $autorizar = 3;
        $parcela = $tipo_parcela;
        break;
		
		case 'HIPER':
        $op = 'hiper';
        $autorizar = 3;
        $parcela = $tipo_parcela;
        break;
		
		case 'HIPERCARD':
        $op = 'hipercard';
        $autorizar = 3;
        $parcela = $tipo_parcela;
        break;

        }
        return array('cc'=>$op,'au'=>$autorizar,'tp'=>$parcela);
    }
	
	public function initContent() {
		
		$this->display_column_left = false;
		$this->display_column_higt = false;
		
		parent::initContent();
		
		//valida o carrinho 
		if($this->context->cart->getOrderTotal(true, Cart::BOTH) <= 0){
			die('Ops, valor do carrinho invalido!');
		}
		
		//se bandeira vazia
		if(empty($_POST["bandeira"]) || $_POST["bandeira"]=='null'){
			die('Ops, bandeira vazia! volte e tente novamente.');
		}
		
		//google captchar
		$google_captcha = (isset($this->module->google_captcha)?$this->module->google_captcha:false);
		$google_captcha_id = (isset($this->module->google_captcha_id)?$this->module->google_captcha_id:'');
		$google_captcha_key = (isset($this->module->google_captcha_key)?$this->module->google_captcha_key:'');
		if($google_captcha){
			if(!isset($_POST['g-recaptcha-response']) && empty($_POST['g-recaptcha-response'])){
				die('Ops, você é humano ou um robô?');
			}
			$cid =  $_POST['g-recaptcha-response'];
			$post_data = http_build_query(
				array(
					'secret' => trim($google_captcha_key),
					'response' => $cid,
					'remoteip' => (isset($_SERVER['REMOTE_ADDR'])?$_SERVER['REMOTE_ADDR']:'127.0.0.1')
				)
			);
			$opts = array('http' =>
				array(
					'method'  => 'POST',
					'header'  => 'Content-type: application/x-www-form-urlencoded',
					'content' => $post_data
				)
			);
			$context  = stream_context_create($opts);
			$response = file_get_contents('https://www.google.com/recaptcha/api/siteverify', false, $context);
			$result = json_decode($response);
			if (!$result->success) {
				die('Ops, você não é humano :( ou seu request foi negado!');
			}
		}
		
		//chama o carrinho
		$cart = new Cart($this->context->cart->id);
		$cliente = new Customer($cart->id_customer);
        
        //dados entrega
        $entrega = new Address(($cart->id_address_delivery==0)?$cart->id_address_invoice:$cart->id_address_delivery);
		$estadoe = new State((int)($entrega->id_state));
		
		//dados de cobrança
		$cobrar = new Address((int)($cart->id_address_invoice));
		$estadoc = new State((int)($cobrar->id_state));
		$obj = $this->module;
        $qual_pedido = $cart->id;
        
        //url de ipn 
        $ipn = Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->module->name.'/ipn.php?cart_id='.$cart->id;

        //ambiente
        $MID = trim(Configuration::get('CIELOAPIPRO5_ID'));
        $KEY = trim(Configuration::get('CIELOAPIPRO5_SECRET'));
        if(Configuration::get('CIELOAPIPRO5_TESTE')){
            $_POST['numero_cc'] = '1234123412341231';
            $MID = 'daaec334-ac85-4c63-9564-f4a31be7b19b';
            $KEY = 'LTFYLLACRDYCIKMHTXBRVKGQYGDHOOVTCKGZUKRK';
            $provider = 'Simulado';
            $urlweb = "https://apisandbox.cieloecommerce.cielo.com.br/1/";
        }else{
            $provider = 'Cielo';
            $urlweb = "https://api.cieloecommerce.cielo.com.br/1/";
        }
        
        //trata a parcela
        $dados_parcela = explode('|',base64_decode($_POST['parcela']));
        $parcela = $dados_parcela[0];
        $tipo_parcela = $dados_parcela[1];
        $total = $dados_parcela[2];
        $bandeira = base64_decode($dados_parcela[3]);
        $regras_cc = $this->CartaoLoja5($bandeira,$tipo_parcela);
        
        //processo
        $objResposta = array();
        $bandeira = $_POST["bandeira"];
        if($bandeira=='Mastercard' || $bandeira=='mastercard'){
            $bandeira = 'Master';
        }
        $headers = array(
            "Content-Type" => "application/json",
            "Accept" => "application/json",
            "MerchantId" => $MID,
            "MerchantKey" => $KEY,
            "RequestId" => "",
        );
        $anti_fraude = Configuration::get('CIELOAPIPRO5_FRAUDE');
        $dados = array();
        if($anti_fraude=='false'){
            $dados['MerchantOrderId'] = $cart->id;
            $dados['Customer'] = array(
                'Name' => $cliente->firstname.' '.$cliente->lastname,
                'Email' => $cliente->email,
            );
            $dados['Payment'] = array(
                'Type' => 'CreditCard',
                'Amount' => number_format($total, 2, '', ''),
                'Currency' => 'BRL',
                'Country' => 'BRA',
                'Provider' => $provider,
                'ServiceTaxAmount' => 0,
                'Installments' => $parcela,
                'Interest' => ((Configuration::get('CIELOAPIPRO5_TIPO_PAR')=='loja')?'ByMerchant':'ByIssuer'),
                'Capture' =>  ((Configuration::get('CIELOAPIPRO5_CAP')=='automatica')?'true':'false'),
                'Authenticate' => 'false',    
                'Recurrent' => 'false',
                'SoftDescriptor' => Configuration::get('CIELOAPIPRO5_SOFT'),
                'CreditCard' => array(  
                     "CardNumber" => preg_replace('/\D/', '', $_POST['numero_cc']),
                     "Holder" => trim($_POST['nome_cliente']),
                     "ExpirationDate" => trim($_POST['mes_cc'].'/'.$_POST['ano_cc']),
                     "SecurityCode" => trim($_POST['codigo_cc']),
                     "SaveCard" => "false",
                     "Brand" => ucfirst($bandeira)
                )
            );
        }else{
            $onumber = Configuration::get('CIELOAPIPRO5_NUMERO');
            $numero = $numeroe = '';
            if(isset($cobrar->$onumber) && !empty($cobrar->$onumber)){
                $numero = $cobrar->$onumber;
            }
            if(isset($entrega->$onumber) && !empty($entrega->$onumber)){
                $numeroe = $entrega->$onumber;
            }
            $fiscal_valor = preg_replace('/\D/', '', $_POST['cpf_cliente']);
            $dados['MerchantOrderId'] = $cart->id;
            $dados['Customer'] = array(
                'Name'=>$cliente->firstname.' '.$cliente->lastname,
                'Email'=>$cliente->email,
                "Identity" => $fiscal_valor,
                "IdentityType" => (strlen($fiscal_valor)==11?'CPF':'CNPJ'),
                'Address'=>array(
                    'Street'=>$cobrar->address1,
                    'Number'=>(!empty($numero)?$numero:'*'),
                    'District'=>(!empty($cobrar->address2)?$cobrar->address2:'Centro'),
					'Complement' => '',
                    'ZipCode'=>preg_replace('/\D/', '', $cobrar->postcode),
                    'City'=>$cobrar->city,
                    'State'=>$estadoc->iso_code,
                    'Country'=>'BR',
                ),
                'DeliveryAddress'=>array(
                    'Street'=>$entrega->address1,
                    'Number'=>(!empty($numeroe)?$numeroe:'*'),
                    'District'=>(empty($entrega->address2)?'Centro':$entrega->address2),
					'Complement' => '',
                    'City'=>$entrega->city,
                    'State'=>$estadoe->iso_code,
                    'Country'=>'BR',
                )
            );
            
            $produtos = array();
            foreach($cart->getProducts() as $produto){
                $produtos[] = array(
                    'GiftCategory' => 'No',
                    'HostHedge' => 'Normal',
                    'NonSensicalHedge' => 'Normal',
                    'ObscenitiesHedge' => 'Normal',
                    'PhoneHedge' => 'Normal',
                    'Type' => 'Default',
                    'Name' => $produto['name'],
                    'Quantity' => $produto['cart_quantity'],
                    'Sku' => $produto['id_product'],
                    "TimeHedge" => "Normal",
                    'UnitPrice' => number_format($produto['price_wt'], 2, '', ''),
                    'Risk' => 'Normal',
                );
            }
            
            $dados['Payment'] = array(
                'Type' => 'CreditCard',
                'Amount' => number_format($total, 2, '', ''),
                'Currency' => 'BRL',
                'Country' => 'BRA',
                'Provider' => $provider,
                'ServiceTaxAmount' => 0,
                'Installments' => $parcela,
                'Interest' => ((Configuration::get('CIELOAPIPRO5_TIPO_PAR')=='loja')?'ByMerchant':'ByIssuer'),
                'Capture' =>  ((Configuration::get('CIELOAPIPRO5_CAP')=='automatica')?'true':'false'),
                'Authenticate' => 'false',    
                'Recurrent' => 'false',
                'SoftDescriptor' => Configuration::get('CIELOAPIPRO5_SOFT'),
                'CreditCard' => array(  
                     "CardNumber" => preg_replace('/\D/', '', $_POST['numero_cc']),
                     "Holder" => trim($_POST['nome_cliente']),
                     "ExpirationDate" => trim($_POST['mes_cc'].'/'.$_POST['ano_cc']),
                     "SecurityCode" => trim($_POST['codigo_cc']),
                     "SaveCard" => "false",
                     "Brand" => ucfirst($bandeira)
                ),
                'FraudAnalysis' => array(
					"Provider" => "cybersource",
                    "Sequence" => "AuthorizeFirst",
                    "SequenceCriteria" => "Always",
					"CaptureOnLowRisk" => 'true',
					"VoidOnHighRisk" => 'true',
					"TotalOrderAmount" => number_format($total, 2, '', ''),
                    "FingerPrintId" => md5($cart->id),
                    "Browser" => array(
                        "CookiesAccepted" => 'true',
                        "Email" => $cliente->email,
                        "IpAddress" => (isset($_SERVER['REMOTE_ADDR'])?$_SERVER['REMOTE_ADDR']:'127.0.0.1'),
                        "Type" => substr($_SERVER['HTTP_USER_AGENT'],0,39)
                    ),
                    'Cart' => array(
                        'IsGift' => 'false',
                        'ReturnsAccepted' => 'true',
                        'Items' => $produtos,
                    )
                )
            );
        }
		
		//print_r($dados);
		//exit;
        
        include_once(dirname(__FILE__).'/../../classes/restclient.php' );
        $api = new RestClient(array(
            'base_url' => $urlweb, 
            'headers' => $headers,           
        ));

        $response = $api->post("sales", json_encode($dados));
        $dados_pedido = @json_decode($response->response,true);
		//print_r($dados_pedido);

		$cod = $response->status;
        if(($response->status==200 || $response->status==201) && isset($dados_pedido['Payment']['Status'])){
            $objResposta['tid'] = $dados_pedido['Payment']['Tid'];
            $objResposta['status'] = $dados_pedido['Payment']['Status'];
            $objResposta['autorizacao']['lr'] = $dados_pedido['Payment']['ReturnCode'];
            $objResposta['pan'] = $dados_pedido['Payment']['PaymentId'];
            $hash = $objResposta['pan'];
        }
        
        //se a requisicao for com sucesso
        if(isset($objResposta['tid']) && !empty($objResposta['tid'])){
            $erro = false;
            
            //status
            switch($objResposta['status']){
                case 2:
                $status_mudar = Configuration::get('CIELOAPIPRO5_PAGO');
                break;
                case 1:
                $status_mudar = Configuration::get('CIELOAPIPRO5_AU');
                break;
                case 3:
                $status_mudar = Configuration::get('CIELOAPIPRO5_NAO_PAGA');
                break;
                case 10:
                case 13:
                $status_mudar = Configuration::get('CIELOAPIPRO5_CANCELADA');
                break;
                default:
                $status_mudar = Configuration::get('CIELOAPIPRO5_INICIADA');
            }
			
			//print_r($objResposta);
			//exit;
            
            //define o meio
            $meio = 'Cielo - '.ucfirst($_POST["bandeira"]).' Crédito em '.$parcela.'x';
            
            //cria o pedido de acordo com o status moip
            $qual_pedido = $cart->id;
            $total_pedido = $this->context->cart->getOrderTotal(true, Cart::BOTH);
            $obj->validateOrder((int)$cart->id, $status_mudar, $total_pedido, $meio, null, array(), null, false, $cliente->secure_key);
            
            //se autenticada
            $requer_autenticar = false;
            if(isset($dados_pedido['Payment']['AuthenticationUrl'])){
                $requer_autenticar = true;
                $url_autenticar_cielo = $dados_pedido['Payment']['AuthenticationUrl'];
            }
			$nsu = isset($dados_pedido['Payment']['ProofOfSale'])?$dados_pedido['Payment']['ProofOfSale']:'';
			
			//log
			$msglog = '[API] Transação Cielo TID: '.$objResposta['tid'].' via Cartão de Crédito '.ucfirst($_POST["bandeira"]).' em '.$parcela.'x no total de R$'.number_format($total, 2, '.', '').'';
			$msglog .= ' / CPF/CNPJ: '.preg_replace('/\D/', '', $_POST['cpf_cliente']).'';
			if(!empty($nsu)){
				$msglog .= ' NSU: '.$nsu.'';
			}
			
			//cria um log para o pedido
			$order = new Order($obj->currentOrder);
			$msg = new Message();
			$message = strip_tags($msglog, '<br>');
			if (($message)){
				$msg->message = $message;
				$msg->id_order = intval($order->id);
				$msg->private = 1;
				$msg->add();
			}
            
            //sql dados cielo
            $ip = Tools::getRemoteAddr();
            $sql = "INSERT INTO `"._DB_PREFIX_."cielo_webservice` (`id`, `pedido`, `valor`, `parcela`, `produto`, `tid`, `nome`, `cpf`, `telefone`, `ip`, `lr`, `pan`, `cc`, `bin`, `nsu`) VALUES (NULL, '".$obj->currentOrder."', '".number_format($total, 2, '.', '')."', '".$parcela."', '".$_POST['tipo']."', '".$objResposta['tid']."', '".$_POST['nome_cliente']."', '".$_POST['cpf_cliente']."', '', '".$ip."', '".(isset($objResposta['autorizacao']['lr'])?$objResposta['autorizacao']['lr']:'')."', '".(isset($objResposta['pan'])?$objResposta['pan']:'')."', '".$regras_cc["cc"]."', '".substr($_POST['numero_cc'],0,6)."******".substr($_POST['numero_cc'],-4)."', '".$nsu."');";
            Db::getInstance()->Execute($sql);
            
            //se precisar autenticar no banco
            if($requer_autenticar){
                Tools::redirect($url_autenticar_cielo);
                exit;
            }else{
                Tools::redirect('index.php?controller=order-confirmation&id_cart='.(int)($qual_pedido).'&id_module='.(int)($obj->id).'&id_order='.$obj->currentOrder.'&key='.$cliente->secure_key.'&tid='.$objResposta['tid'].'&hash='.$hash.'');
                exit;
            }
            
        
        }elseif(isset($dados_pedido['Message'])){
        
			$erro = true;
			$msg = "Erro no pedido cielo de cod: ".$dados_pedido['Code']." - ".$dados_pedido['Message'];
			
		}elseif(isset($dados_pedido['ReturnMessage'])){
        
			$erro = true;
			$msg = "Erro no pedido cielo de cod: ".$dados_pedido['ReturnCode']." - ".$dados_pedido['ReturnMessage'];
			
		}elseif(isset($dados_pedido[0]['Message'])){
			
			$erro = true;
			$msg = "Erro no pedido cielo de cod: ".$dados_pedido[0]['Code']." - ".$dados_pedido[0]['Message'];
        
        }else{
            
			$erro = true;
			$msg = "Erro desconhecido cielo, verificar credenciais, ambiente e versao do curl do servidor!";
			$msg .= print_r($dados_pedido,true);
        
        }
        
        //se tem erro 
        if($erro==true){
			PrestaShopLogger::addLog($msg, 2);
            $this->context->smarty->assign(array(
                'msgerro' => $cod.' - '.$msg,
                'this_path' => $this->module->getPathUri(),
                'link_loja' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'/',
                'this_path_ssl' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->module->name.'/'
            ));
            $this->setTemplate('erro.tpl');
		}
        
	}
}
?>