<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.11/css/dataTables.bootstrap.css" />
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.11/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.11/js/dataTables.bootstrap.min.js"></script>
<link rel="stylesheet" href="//cdn.datatables.net/plug-ins/1.10.12/integration/font-awesome/dataTables.fontAwesome.css" />

<style>
.fix_icons {
	width:30px !important;
	height:30px !important;
	font-size:24px !important;
}
</style>

<div class="alert alert-info">Selecione abaixo os pedidos qual deseja imprimir a etiqueta de postagem simples junto aos Correios (N&atilde;o &eacute; SIGEP).</div>

<div class="panel panel-default">
<div class="panel-body">

<table data-page-length='25' style="width:100%" class="tabelas table table-striped"> 
<thead>
<tr>
<th class="no-sort" style="width:50px;"><input type="checkbox" onclick="$('input[name*=\'selected\']').prop('checked', this.checked);" /></th> 
<th>ID</th> 
<th>Refer&ecirc;ncia</th>
<th>Cliente</th>
<th>Total</th>
<th>Transportadora</th>
<th>Frete</th>
<th>Status</th>
<th>Data</th>
</tr>
</thead> 
<tbody> 
{foreach $pedidos as $item}
	<tr>
	<td><input type="checkbox" name="selected" value="{$item['id_order']}" /></td>
	<td>{$item['id_order']}</td>
	<td>{$item['reference']}</td></td>
	<td>{$item['firstname']} {$item['lastname']}</td>
	<td>{number_format($item['total_paid'], 2, '.', '')}</td>
	<td>{$item['transportadora']}</td>
	<td>{number_format($item['total_shipping'], 2, '.', '')}</td>
	<td><span class="label" style="background-color:{$item['color']};color:#000;">{$item['status']}</span></td>
	<td>{date('d/m/Y',strtotime($item['date_add']))}</td>
	</tr>
{/foreach}
</tbody> 
</table>

</div>
</div>

<script>
var url_imprimir = "{$link->getAdminLink('AdminCorreiosOffPro5Etiquetas', true)}&acao=etiquetas&ajax=true";
{literal}
$(document).ready(function(){
    $('.tabelas').DataTable({
        stateSave: true,
		pageLength: 25,
		aoColumnDefs: [{
			'bSortable' : false,
			'aTargets' : [ 0 ]
		}],
        "order": [[ 1, "desc" ]],
        "language": {
            "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Portuguese.json"
        }
    });
});
function popupwindow(url, title, w, h) {
  var left = (screen.width/2)-(w/2);
  var top = (screen.height/2)-(h/2);
  return window.open(url, title, 'toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=no, copyhistory=no, width='+w+', height='+h+', top='+top+', left='+left);
}
function imprimirEtiquetasCorreiosPro(){
	var checkedVals = $('input[name^=\'selected\']:checked').map(function() {
    return this.value;
	}).get();
	if(!checkedVals || checkedVals==''){
		alert('Selecione no minimo um pedido!');
		return false;
	}
	var selecionados = checkedVals.join(",");
	console.log(selecionados);
	return popupwindow(url_imprimir+'&pedidos='+selecionados, 'Imprimir Etiquetas', 700, 800);
}
{/literal}
</script>