<?php 
class PrePostagem5Cron_RevModuleFrontController extends ModuleFrontController
{
	public $ssl = true;
    public $display_column_left = false;
	public $display_column_right = false;
    
	public function initContent()
	{
		parent::initContent();
		//se desativado 
		if(!Configuration::get('PREPOSTAGEM5_STATUS')){
			die('Pré-Postagem - Desativado via Admin!');
		}
		//nova api
		$token_api = $this->module->token_de_acesso_correios();
		if(!isset($token_api['dados']['token'])){
			$erro = ''.$token_api['status'].' - Erro ao obter o token api Correios!';
			die($erro);
		}
		//registros das plps
		$query = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pedidos_reverso` 
		WHERE entregue = '0' AND cancelado = '0' AND data_pedido BETWEEN NOW() - INTERVAL 45 DAY AND NOW() ORDER BY id_pedido DESC";
		$plps = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);
		if(count($plps)==0){
			die('Nenhuma envio reverso a processar!');
		}
		//processa os pacotes de envios reversos
		$log = '';
		foreach($plps as $k=>$v){
			if(strlen($v['objeto'])==13){
				//consulta
				$dados['codigoObjeto'] = trim($v['objeto']);
				$resultados = $this->module->consulta_objeto($dados);
				//log
				if(Configuration::get('PREPOSTAGEM5_STATUS_DEBUG')){
					$this->module->salvar_log('[Pré-Postagem] Cron Rev: '.print_r($resultados,true));
				}
				//ok
				if(isset($resultados['resultado'][0]['id'])){
					if($v['processado']==0 && $resultados['resultado'][0]['statusAtual']==3){
						//postado nos correios
						$total_postagem = isset($resultados['resultado'][0]['precoPrePostagem'])?(float)$resultados['resultado'][0]['precoPrePostagem']:0;
						//log da postagem 
						$log_objeto = 'Objeto Reverso Postado / Valor da Pré-Postagem: '.$total_postagem.' ';
						if(isset($resultados['resultado'][0]['pesoPreAfericao'])){
							$log_objeto.= ' / Peso: '.$resultados['resultado'][0]['pesoPreAfericao'].'';
						}
						if(isset($resultados['resultado'][0]['comprimentoPreAfericao'])){
							$log_objeto.= ' / Com: '.$resultados['resultado'][0]['comprimentoPreAfericao'].'';
						}
						if(isset($resultados['resultado'][0]['alturaPreAfericao'])){
							$log_objeto.= ' / Alt: '.$resultados['resultado'][0]['alturaPreAfericao'].'';
						}
						if(isset($resultados['resultado'][0]['larguraPreAfericao'])){
							$log_objeto.= ' / Lar: '.$resultados['resultado'][0]['larguraPreAfericao'].'';
						}
						if(isset($resultados['resultado'][0]['statusAtual'])){
							$log_objeto.= ' / Status: '.$resultados['resultado'][0]['statusAtual'].'';
						}
						//mysql
						Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_pedidos_reverso` SET processado = '1', log = '".$log_objeto."' WHERE id_pedido = '".$v['id_pedido']."'");
						//se atualiza o pedido na loja
						$order = null;
						if((int)$v['id_pedido_loja'] > 0){
							//pedidos que existe na loja
							$order = new Order((int)$v['id_pedido_loja']);
							if($order){
								//variaveis a enviar no email 
								$vars_email = array();
								$vars_email['{link_rastreamento}'] = Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/prepostagem5/sro.php?objeto='.$v['objeto'].'';
								$vars_email['{objeto_correios}'] = $v['objeto'];
								//atualiza o pedido para enviado 
								if(Configuration::get('PREPOSTAGEM5_REV_ENV') > 0){
									if($order->getCurrentState()!=Configuration::get('PREPOSTAGEM5_REV_ENV')){
										$history = new OrderHistory();
										$history->id_order = (int)$order->id;
										$history->id_order_state = (int)Configuration::get('PREPOSTAGEM5_REV_ENV');
										$history->addWithemail(true,$vars_email);
										$order->current_state = $history->id_order_state;
										$order->update();
									}
								}
								//cria um log para o pedido
								$msglog = 'Objeto reverso '.$v['objeto'].' postado junto aos Correios em '.date('d/m/Y H:i').'';
								$msg = new Message();
								$message = strip_tags($msglog, '<br>');
								if (($message)){
									$msg->message = $message;
									$msg->id_order = intval($order->id);
									$msg->private = 1;
									$msg->add();
								}
								//atualiza o status no banco de dados
								$status_pedido = $order->getCurrentState();
								$sql = "UPDATE `" . _DB_PREFIX_ . "prepostagem5_pedidos_reverso` SET `status_pedido_loja` = '".$status_pedido."' WHERE id_pedido = '".$v['id_pedido']."';";
								Db::getInstance()->execute($sql);
							}
						}
						//log 
						$log .= 'Envio Reverso: '.$v['id_pedido'].' / Objeto: '.trim($v['objeto']).' - '.$log_objeto.'!<br>';
					}elseif($v['processado']==1 && $v['cancelado']==0 && $v['entregue']==0){
						//processa se o objeto foi entregue/devolvido
						$rastreio = $this->module->rastrear_correios($v['objeto'],'U');
						if(isset($rastreio['evento'][0])){
							$status = isset($rastreio['evento'][0]['status'])?$rastreio['evento'][0]['status']:'';
							$tipo = isset($rastreio['evento'][0]['tipo'])?$rastreio['evento'][0]['tipo']:'';
							//atualiza no bd para entregue
							if(in_array($tipo,array('BDE','BDI','BDR')) && in_array($status,array('0','1'))){
								//atualiza o pedido no banco de dados
								Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_pedidos_reverso` SET entregue = '1', data_pedido = NOW() WHERE id_pedido = '".$v['id_pedido']."'");
								//atualiza o status do pedido 
								if((int)$v['id_pedido_loja'] > 0){
									//pedidos que existe na loja
									$order = new Order((int)$v['id_pedido_loja']);
									if($order){
										//variaveis a enviar no email 
										$vars_email = array();
										$vars_email['{link_rastreamento}'] = Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/prepostagem5/sro.php?objeto='.$v['objeto'].'';
										$vars_email['{objeto_correios}'] = $v['objeto'];
										//atualiza o pedido para enviado 
										if(Configuration::get('PREPOSTAGEM5_REV_FIN') > 0){
											if($order->getCurrentState()!=Configuration::get('PREPOSTAGEM5_REV_FIN')){
												$history = new OrderHistory();
												$history->id_order = (int)$order->id;
												$history->id_order_state = (int)Configuration::get('PREPOSTAGEM5_REV_FIN');
												$history->addWithemail(true,$vars_email);
												$order->current_state = $history->id_order_state;
												$order->update();
											}
										}
										//cria um log para o pedido
										$msglog = 'Objeto reverso '.$v['objeto'].' postado junto aos Correios em '.date('d/m/Y H:i').'';
										$msg = new Message();
										$message = strip_tags($msglog, '<br>');
										if (($message)){
											$msg->message = $message;
											$msg->id_order = intval($order->id);
											$msg->private = 1;
											$msg->add();
										}
										//atualiza o status no banco de dados
										$status_pedido = $order->getCurrentState();
										$sql = "UPDATE `" . _DB_PREFIX_ . "prepostagem5_pedidos_reverso` SET `status_pedido_loja` = '".$status_pedido."' WHERE id_pedido = '".$v['id_pedido']."';";
										Db::getInstance()->execute($sql);
									}
								}
								//log geral
								$log .= 'Envio Reverso: '.$v['id_pedido'].' / Objeto: '.trim($v['objeto']).' - Devolvido a loja via Correios!<br>';
							}
						}else{
							//log geral
							$log .= 'Envio Reverso: '.$v['id_pedido'].' / Objeto: '.trim($v['objeto']).' - Problema ao realizar rastreamento!<br>';
						}
					}elseif($v['cancelado']==0 && ($resultados['resultado'][0]['statusAtual']==4 || $resultados['resultado'][0]['statusAtual']==5 || $resultados['resultado'][0]['statusAtual']==6)){
						//log
						$log_objeto = 'Objeto Cancelado/Expirado';
						if(isset($resultados['resultado'][0]['statusAtual'])){
							$log_objeto.= ' / Status: '.$resultados['resultado'][0]['statusAtual'].'';
						}
						//cancelado expirado
						Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_pedidos_reverso` SET processado = '1', cancelado = '1', log = '".$log_objeto."' WHERE id_pedido = '".$v['id_pedido']."'");
						//log geral
						$log .= 'Envio Reverso: '.$v['id_pedido'].' / Objeto: '.trim($v['objeto']).' - '.$log_objeto.'!<br>';
					}else{
						//pendente
						$log_objeto = 'Objeto Pendente de Postagem ('.date('d/m/Y H:i').')';
						if(isset($resultados['resultado'][0]['statusAtual'])){
							$log_objeto.= ' / Status: '.$resultados['resultado'][0]['statusAtual'].'';
						}
						Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_pedidos_reverso` SET log = '".$log_objeto."' WHERE id_pedido = '".$v['id_pedido']."'");
						//log geral
						$log .= 'Envio Reverso: '.$v['id_pedido'].' / Objeto: '.trim($v['objeto']).' - '.$log_objeto.'!<br>';
					}
				}else{
					//erro
					$erro = array();
					if(isset($resultados['resultado'][0]['msgs'])){
						foreach($resultados['resultado'][0]['msgs'] as $err){
							$erro[] = $err;
						}
					}
					if(isset($resultados['resultado'][0]['causa'])){
						$erro[] = $resultados['resultado'][0]['causa'];
					}
					if(isset($resultados['log'])){
						$erro[] = $resultados['log'];
					}
					//log geral
					$log .= 'Envio Reverso: '.$v['id_pedido'].' / Objeto: '.trim($v['objeto']).' - '.implode(',',$erro).'!<br>';
				}
			}
		}
		die($log);
	}
}
?>