{*
* 2007-2016 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2016 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

{capture name=path}{l s='Order confirmation'}{/capture}

<h1 class="page-heading">{l s='Order confirmation'}</h1>

{assign var='current_step' value='payment'}
{include file="$tpl_dir./order-steps.tpl"}

{include file="$tpl_dir./errors.tpl"}

{$HOOK_ORDER_CONFIRMATION}
{$HOOK_PAYMENT_RETURN}
{if $is_guest}
	<p>{l s='Your order ID is:'} <span class="bold">{$id_order_formatted}</span> . {l s='Your order ID has been sent via email.'}</p>
    <p class="cart_navigation exclusive">
	<a class="button-exclusive btn btn-default" href="{$link->getPageLink('guest-tracking', true, NULL, "id_order={$reference_order|urlencode}&email={$email|urlencode}")|escape:'html':'UTF-8'}" title="{l s='Follow my order'}"><i class="icon-chevron-left"></i>{l s='Follow my order'}</a>
    </p>
{else}
<p class="cart_navigation exclusive">
	<a class="button-exclusive btn btn-default" href="{$link->getPageLink('history', true)|escape:'html':'UTF-8'}" title="{l s='Go to your order history page'}"><i class="icon-chevron-left"></i>{l s='View your order history'}</a>
</p>
{/if}

{literal}
<!-- Event snippet for Compra conversion page --> 
<script> 
	gtag('event', 'conversion', { 'send_to': 'AW-434292552/Sv7yCKqvnvUBEMiOi88B', 'transaction_id': '{/literal}{$smarty.get.id_order}{literal}', 'value': '{/literal}{$total|string_format:"%.2f"}{literal}', 'currency': 'BRL' }); 
</script> 
{/literal}

{literal}
<script type="text/javascript">	
	$(document).ready(function(){
		
		gtag('event', 'purchase', {
			"transaction_id" : "{/literal}{$smarty.get.id_order}{literal}",
			"affiliation": "Maria Chic",
			"value": '{/literal}{$total|string_format:"%.2f"}{literal}',
			"currency": "BRL",
			"tax": 0,
			"shipping": '{/literal}{$order->total_shipping|string_format:"%.2f"}{literal}',
			  "items": [
				{/literal}
				{foreach from=$order_products item=product}
					{if isset($product.id_category_default)}
					{assign var='catname' value=CategoryCore::getCategoryInformations(array($product.id_category_default))}        
					{/if}		
				{literal}
				{
				  "id": "{/literal}{$product.product_id}{literal}",
				  "name": "{/literal}{$product.product_name}{literal}",
				  "list_name": "Checkout",
				  "brand": "Maria Chic",
				  "category": "{/literal}{$catname[$product.id_category_default].name}{literal}",
				  "variant": "",
				  "list_position": 1,
				  "quantity": {/literal}{$product.product_quantity}{literal},
				  "price": '{/literal}{$product.product_price}{literal}'
				},	
				{/literal}
				{/foreach}{literal}	
			  ]
		});	

		fbq('track', 'Purchase', {value: {/literal}{$total|string_format:"%.2f"}{literal}, currency: 'BRL'});
	});
</script>
{/literal}