<?php
/**
Loja5.com.br - todos os direitos reservados
Módulo Comercial
*/

if (!defined('_PS_VERSION_')) {
    exit;
}

class Cieloapipro5 extends PaymentModule
{
    protected $config_form = false;
	public $google_captcha = false;
	public $google_captcha_id = '';
	public $google_captcha_key = '';

    public function __construct()
    {
        $this->name = 'cieloapipro5';
        $this->tab = 'payments_gateways';
        $this->version = '1.0.0';
        $this->author = 'Loja5.com.br';
        $this->need_instance = 0;

        /**
         * Set $this->bootstrap to true if your module is compliant with bootstrap (PrestaShop 1.6)
         */
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Cielo API PRO');
        $this->description = $this->l('Integração aos meios de pagamento Cielo API');

        $this->limited_currencies = array('BRL');

        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
    }

    /**
     * Don't forget to create update methods if needed:
     * http://doc.prestashop.com/display/PS16/Enabling+the+Auto-Update
     */
    public function install()
    {
        include(dirname(__FILE__).'/sql/install.php');
        if (extension_loaded('curl') == false)
        {
            $this->_errors[] = $this->l('O módulo exige que o Curl esteja ativado em seu servidor!');
            return false;
        }

        return parent::install() &&
            $this->registerHook('header') &&
            $this->registerHook('backOfficeHeader') &&
            $this->registerHook('payment') &&
            $this->registerHook('paymentReturn') &&
            $this->registerHook('displayAdminOrder') &&
            $this->registerHook('displayOrderDetail') &&
            $this->registerHook('actionPaymentConfirmation') &&
            $this->registerHook('displayPayment') &&
            $this->registerHook('displayPaymentReturn');
    }

    public function uninstall()
    {
        include(dirname(__FILE__).'/sql/uninstall.php');

        return parent::uninstall();
    }
	
	public function Aprovar($tid){
		//return false;
        $MID = trim(Configuration::get('CIELOAPIPRO5_ID'));
        $KEY = trim(Configuration::get('CIELOAPIPRO5_SECRET'));
        if(Configuration::get('CIELOAPIPRO5_TESTE')){
            $MID = 'daaec334-ac85-4c63-9564-f4a31be7b19b';
            $KEY = 'LTFYLLACRDYCIKMHTXBRVKGQYGDHOOVTCKGZUKRK';
            $urlweb = "https://apisandbox.cieloecommerce.cielo.com.br/1/";
        }else{
            $urlweb = "https://api.cieloecommerce.cielo.com.br/1/";
        }
        $headers = array(
            "Content-Type" => "application/json",
            "Accept" => "application/json",
            "MerchantId" => $MID,
            "MerchantKey" => $KEY,
            "RequestId" => "",
        );
        include_once(dirname(__FILE__).'/classes/restclient.php' );
        $api = new RestClient(array(
            'base_url' => $urlweb, 
            'headers' => $headers, 
        ));
		$dados = array();
		$dados['amount'] = $_GET['amount'];
		$response = $api->put("sales/".$tid."/capture",json_encode($dados));
		$dados_pedido = @json_decode($response->response,true);
		//print_r($dados_pedido);
		//exit;
		if($response->status==200 || $response->status==201){
			return $dados_pedido;
		}else{
			return $dados_pedido;
		}
    }
	
	public function Cancelar($tid){
		//return false;
        $MID = trim(Configuration::get('CIELOAPIPRO5_ID'));
        $KEY = trim(Configuration::get('CIELOAPIPRO5_SECRET'));
        if(Configuration::get('CIELOAPIPRO5_TESTE')){
            $MID = 'daaec334-ac85-4c63-9564-f4a31be7b19b';
            $KEY = 'LTFYLLACRDYCIKMHTXBRVKGQYGDHOOVTCKGZUKRK';
            $urlweb = "https://apisandbox.cieloecommerce.cielo.com.br/1/";
        }else{
            $urlweb = "https://api.cieloecommerce.cielo.com.br/1/";
        }
        $headers = array(
            "Content-Type" => "application/json",
            "Accept" => "application/json",
            "MerchantId" => $MID,
            "MerchantKey" => $KEY,
            "RequestId" => "",
        );
		include_once(dirname(__FILE__).'/classes/restclient.php' );
		$api = new RestClient(array(
			'base_url' => $urlweb, 
			'headers' => $headers, 
		));
		$dados = array();
		$dados['amount'] = $_GET['amount'];
		$response = $api->put("sales/".$tid."/void",json_encode($dados));
		$dados_pedido = @json_decode($response->response,true);
		//print_r($dados_pedido);
		if($response->status==200 || $response->status==201){
			return $dados_pedido;
		}else{
			return $dados_pedido;
		}
    }
	
	public function hookdisplayOrderDetail($params){
		$order = new Order($params['order']->id);
		if($order->module=='cieloapipro5'){
			$sql = "SELECT * FROM `"._DB_PREFIX_."cielo_webservice` WHERE pedido = '".(int)$params['order']->id."'";
			$dados = Db::getInstance()->getRow($sql);
			$html = '';
			if($dados){
				$html .= '<div class="box">';
				$html .= 'Transa&ccedil;&atilde;o paga via <b>'.ucfirst($dados['produto']).'</b> no total de <b>R$'.$dados['valor'].'</b>';
				if($dados['produto']=='debito' || $dados['produto']=='credito'){
					$html .= '<br>TID: <b>'.$dados['tid'].'</b><br>';
					$html .= 'Pago via cart&atilde;o <b>'.ucfirst($dados['cc']).' ('.$dados['bin'].')</b> em <b>'.$dados['parcela'].'x</b> (LR: '.(!empty($dados['lr'])?$dados['lr']:'').')<br>';
				}
				//segunda via
				$sql = "SELECT * FROM `"._DB_PREFIX_."cielo_webservice_links` WHERE pedido = '".(int)$params['order']->id."'";
				$boleto = Db::getInstance()->getRow($sql);
				if(isset($boleto['link']) && !empty($boleto['link'])){
					$html .= '<br>Para acessar a segunda via do link de pagamento da transa&ccedil;&atilde;o <a href="'.$boleto['link'].'" target="_blank"><b>clique aqui</b></a>.';
				}
				$html .= '</div>';
			}
			return $html;
		}
    }
	
	public function hookdisplayAdminOrder($params){
		global $cookie;
		$order = new Order($params['id_order']);
		if($order->module=='cieloapipro5'){
			
			$actual_link = 'index.php?tab=AdminOrders&id_order='.Tools::getValue('id_order').'&vieworder&token='.Tools::getAdminToken('AdminOrders'.(int)(Tab::getIdFromClassName('AdminOrders')).(int)($cookie->id_employee)).'';
			
			$sql = "SELECT * FROM `"._DB_PREFIX_."cielo_webservice` WHERE pedido = '".(int)$params['id_order']."'";
			$dados = Db::getInstance()->getRow($sql);
			$html = '';
			
			//cancelar 
			if(isset($_GET['cancelar']) && isset($dados['pan'])){
				$cap = $this->Cancelar($dados['pan']);
				if(isset($cap['Status']) && $cap['Status']==10){
					if($order->getCurrentState()!=Configuration::get('CIELOAPIPRO5_CANCELADA')){
					
						//log
						$msglog = '[CANCELAR] Transação cancelada manualmente por o admin em '.date('d/m/Y H:i:s').'.';

						//cria um log para o pedido
						$msg = new Message();
						$message = strip_tags($msglog, '<br>');
						if (($message)){
							$msg->message = $message;
							$msg->id_order = intval($order->id);
							$msg->private = 1;
							$msg->add();
						}
						
						$history = new OrderHistory();
						$history->id_order = (int)$order->id;
						$history->id_order_state = (int)Configuration::get('CIELOAPIPRO5_CANCELADA');
						$history->add();
						$order->current_state = $history->id_order_state;
						$order->update();
						$order->setInvoice();
						
						//recarrega os dados
						echo "<script>window.location.href='".$actual_link."';</script>";
						exit;
					
					}
				}elseif(isset($cap['ReturnCode'])){
					$html .= '<div class="alert alert-danger">Ops, ocorreu um problema ao cancelar a transa&ccedil;&atilde;o: '.$cap['ReturnCode'].' - '.$cap['ReturnMessage'].'!</div>';
				}elseif(isset($cap['Code'])){
					$html .= '<div class="alert alert-danger">Ops, ocorreu um problema ao cancelar a transa&ccedil;&atilde;o: '.$cap['ReturnCode'].' - '.$cap['Message'].'!</div>';
				}else{
					$html .= '<div class="alert alert-danger">Ops, ocorreu um problema ao cancelar a transa&ccedil;&atilde;o! '.print_r($cap,true).'</div>';
				}
			}
			
			//capturar 
			if(isset($_GET['capturar']) && isset($dados['pan'])){
				$cap = $this->Aprovar($dados['pan']);
				if(isset($cap['Status']) && $cap['Status']==2){
					if($order->getCurrentState()!=Configuration::get('CIELOAPIPRO5_PAGO')){
					
						//log
						$msglog = '[CAPTURA] Transação capturada manual por o admin em '.date('d/m/Y H:i:s').'.';

						//cria um log para o pedido
						$msg = new Message();
						$message = strip_tags($msglog, '<br>');
						if (($message)){
							$msg->message = $message;
							$msg->id_order = intval($order->id);
							$msg->private = 1;
							$msg->add();
						}
						
						$history = new OrderHistory();
						$history->id_order = (int)$order->id;
						$history->id_order_state = (int)Configuration::get('CIELOAPIPRO5_PAGO');
						$history->add();
						$order->current_state = $history->id_order_state;
						$order->update();
						$order->setInvoice();
						
						//recarrega os dados
						echo "<script>window.location.href='".$actual_link."';</script>";
						exit;
					
					}
				}elseif(isset($cap['ReturnCode'])){
					$html .= '<div class="alert alert-danger">Ops, ocorreu um problema ao capturar a transa&ccedil;&atilde;o: '.$cap['ReturnCode'].' - '.$cap['ReturnMessage'].'!</div>';
				}elseif(isset($cap['Code'])){
					$html .= '<div class="alert alert-danger">Ops, ocorreu um problema ao capturar a transa&ccedil;&atilde;o: '.$cap['ReturnCode'].' - '.$cap['Message'].'!</div>';
				}else{
					$html .= '<div class="alert alert-danger">Ops, ocorreu um problema ao capturar a transa&ccedil;&atilde;o! '.print_r($cap,true).'</div>';
				}
			}
			
			//monta a exibicao
			if($dados){
				$html .= 'Transa&ccedil;&atilde;o Cielo <b><a onclick="window.open(\'../modules/cieloapipro5/consultar.php?hash='.$dados['pan'].'\',\'page\',\'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=no,width=800,height=800\');">'.$dados['pan'].'</a></b> via <b>'.ucfirst($dados['produto']).'</b> no total de <b>R$'.$dados['valor'].'</b><br>';
				$html .= 'Pagador: <b>'.$dados['nome'].'</b><br>';
				$html .= 'CPF/CNPJ: <b>'.$dados['cpf'].'</b><br>';
				$html .= 'IP: <b>'.$dados['ip'].'</b><br>';
				if($dados['produto']=='debito' || $dados['produto']=='credito'){
					$html .= 'TID: <b>'.$dados['tid'].'</b><br>';
					$html .= 'NSU: <b>'.$dados['nsu'].'</b><br>';
					$html .= 'Pago via cart&atilde;o <b>'.ucfirst($dados['cc']).' ('.$dados['bin'].')</b> em <b>'.$dados['parcela'].'x</b> (LR: '.(!empty($dados['lr'])?$dados['lr']:'').')<br>';
				}
				//se precisa capturar exibe
				$status_au = Configuration::get('CIELOAPIPRO5_AU');
				$status_pg = Configuration::get('CIELOAPIPRO5_PAGO');
				if($order->getCurrentState()==$status_au && $dados['produto']=='credito'){
					$html .= 'Transa&ccedil;&atilde;o apenas autorizada, para capturar a mesma clique em <b><a class="btn btn-info" href="'.$actual_link.'&capturar=true&amount='.$dados['valor'].'">CAPTURAR</a></b><br>';
				}
				if(($order->getCurrentState()==$status_au || $order->getCurrentState()==$status_pg) && $dados['produto']=='credito'){
					$html .= 'Para cancelar esta transa&ccedil;&atilde;o clique em <b><a onclick="return confirm(\'Confirma cancelar o pedido? Lembrando que ao confirma o mesmo nao podera mas ser desfeito o cancelamento!\');" class="btn btn-danger" href="'.$actual_link.'&cancelar=true&amount='.$dados['valor'].'">CANCELAR</a></b><br>';
				}
			}
			
			//segunda via
			$sql = "SELECT * FROM `"._DB_PREFIX_."cielo_webservice_links` WHERE pedido = '".(int)$params['id_order']."'";
			$boleto = Db::getInstance()->getRow($sql);
			if(isset($boleto['link']) && !empty($boleto['link'])){
				$html .= 'Para acessar a segunda via do link de pagamento da transa&ccedil;&atilde;o <a href="'.$boleto['link'].'" target="_blank"><b>clique aqui</b></a>';
			}
			if(!empty($html)){
				return '<div class="panel">'.$html.'</div>';
			}else{
				return '';
			}
		}
	}

    /**
     * Load the configuration form
     */
    public function getContent()
    {
        /**
         * If values have been submitted in the form, process.
         */
        if (((bool)Tools::isSubmit('submitCieloapipro5Module')) == true) {
            $this->postProcess();
        }

        $this->context->smarty->assign('module_dir', $this->_path);

        $output = $this->context->smarty->fetch($this->local_path.'views/templates/admin/configure.tpl');

        return $output.$this->renderForm();
    }

    /**
     * Create the form that will be displayed in the configuration of your module.
     */
    protected function renderForm()
    {
        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitCieloapipro5Module';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(), /* Add values for your inputs */
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm(array($this->getConfigForm()));
    }

    /**
     * Create the structure of your form.
     */
    protected function getConfigForm()
    {
    /*
	Modulo comercial desenvolvido por Loja5.com.br
	*/
	${"\x47\x4c\x4f\x42A\x4c\x53"}["\x78\x74iy\x65qhv\x6ewl\x68"]="\x63\x61\x6d\x70o\x73";${"\x47\x4c\x4fB\x41\x4c\x53"}["\x6c\x6c\x77\x66h\x78\x64\x64l"]="\x62\x61\x6e\x63\x6f\x73\x74\x65\x66";${"GLO\x42\x41LS"}["ub\x79s\x62\x79\x6c\x73\x72"]="\x62\x61\x6eco\x73";${"GLO\x42\x41\x4c\x53"}["\x73\x64\x65\x75l\x67ve"]="\x6fp\x62\x5f\x6ea\x6d\x65";${"G\x4cOBA\x4cS"}["\x65b\x68\x61\x79o\x72e\x68"]="\x6c\x69\x73\x74a_\x62\x61\x6ec\x6fs";${"\x47L\x4fB\x41LS"}["yl\x67\x61\x73\x6e\x6d"]="op_i\x64";${"G\x4c\x4f\x42\x41\x4cS"}["\x72\x6e\x76\x76rism\x7ao\x71"]="o\x70\x5f\x6e\x61me";${"\x47L\x4f\x42ALS"}["\x79\x75\x62uo\x7a"]="\x6c\x69\x73\x74a_op\x5f\x64\x65\x62\x69\x74\x6f";${"G\x4c\x4fB\x41L\x53"}["\x71b\x74zi\x77"]="\x6c\x69s\x74\x61\x5fop\x5fcr\x65\x64\x69to";${"\x47\x4cOB\x41\x4c\x53"}["\x6d\x6b\x6a\x65h\x69\x6f\x79\x67\x73"]="\x62a\x6e\x63\x6f\x74\x65\x66";${"G\x4c\x4fBA\x4c\x53"}["\x77h\x6eb\x6b\x63k\x70"]="b\x61\x6ede\x69r\x61s\x63\x72\x65\x64\x69\x74\x6f";${"\x47\x4c\x4f\x42\x41L\x53"}["qo\x6dlp\x66\x73et"]="\x69d\x50a\x67a\x6de\x6e\x74\x6f";${"\x47\x4c\x4f\x42\x41\x4c\x53"}["\x68j\x68x\x75\x67"]="\x6bey\x5f\x61ge";${"\x47L\x4f\x42\x41\x4cS"}["\x78\x63cz\x6cqv\x75r\x6a"]="\x6b\x65y\x5f\x6c\x6fca\x74\x69\x6f\x6e";${"\x47\x4c\x4f\x42\x41LS"}["m\x6ekd\x65\x6eo\x67"]="\x72em\x6fte_aut\x68";${"\x47\x4c\x4f\x42\x41\x4c\x53"}["\x64r\x62g\x73\x71\x79\x6e\x75\x78i"]="\x6b\x65\x79_\x73\x74\x72\x69\x6e\x67";${"\x47L\x4f\x42\x41L\x53"}["tf\x70gmjq\x6a\x6ay\x6e"]="\x65x\x74\x72\x61s";require_once(dirname(__FILE__)."/c\x6cass\x65\x73/\x63\x6cas\x73\x2el\x6fja\x35\x2ep\x68p");${${"\x47\x4c\x4fB\x41\x4cS"}["t\x66\x70\x67m\x6a\x71\x6a\x6a\x79\x6e"]}=$this->campos_extras();${${"G\x4cO\x42\x41L\x53"}["dr\x62\x67\x73\x71\x79n\x75\x78i"]}=Configuration::get("\x43\x49E\x4c\x4f\x41\x50\x49P\x52O5\x5f\x53ERI\x41L");${${"\x47LOB\x41L\x53"}["mn\x6b\x64\x65\x6eo\x67"]}="df\x308ac\x62a4e\x63\x33";$lrznsbxbcuy="key\x5f\x6c\x6f\x63\x61\x74\x69\x6f\x6e";${${"\x47L\x4fB\x41\x4c\x53"}["x\x63c\x7alq\x76\x75\x72j"]}=dirname(__FILE__)."/\x6bey\x2e\x70\x68p";${"G\x4c\x4f\x42AL\x53"}["sxd\x79\x6ds\x78jm"]="\x72\x65su\x6c\x74\x61do";$qtihikkddsob="i\x64Paga\x6d\x65n\x74\x6f";$hrewbufmqp="\x6be\x79_a\x67\x65";${$hrewbufmqp}=1296000;${${"\x47\x4c\x4f\x42\x41L\x53"}["\x73\x78\x64\x79\x6d\x73\x78\x6a\x6d"]}=new validar_loja5(${${"GLO\x42\x41\x4c\x53"}["\x64\x72\x62\x67\x73q\x79\x6e\x75\x78\x69"]},${${"GL\x4f\x42\x41\x4c\x53"}["\x6dn\x6b\x64en\x6f\x67"]},${$lrznsbxbcuy},${${"G\x4c\x4fBA\x4c\x53"}["\x68\x6ah\x78u\x67"]});${${"G\x4c\x4fB\x41\x4cS"}["\x71om\x6c\x70\x66\x73\x65t"]}=($resultado->result);if(${$qtihikkddsob}==1){$btvxuwnh="b\x61\x6e\x64e\x69\x72\x61\x73d\x65\x62\x69\x74\x6f";${"G\x4c\x4f\x42\x41L\x53"}["t\x79\x76\x6a\x6a\x67\x69"]="\x62\x61\x6e\x63os";${"GLO\x42\x41L\x53"}["\x65xrwu\x68re\x75\x6d"]="\x6f\x70\x5f\x6e\x61me";${"\x47L\x4fBA\x4c\x53"}["\x66za\x61\x6d\x61"]="\x63\x61\x6dpo\x73";${"\x47\x4cO\x42A\x4c\x53"}["\x68\x6f\x78\x66\x6b\x69\x69u\x6dk\x79\x78"]="\x6f\x70\x5f\x69\x64";${"G\x4cO\x42\x41\x4c\x53"}["\x77r\x6b\x76gb\x6c\x71\x77\x73\x67\x70"]="\x63\x61m\x70o\x73";$bdtgusgko="\x6f\x70b\x5f\x6e\x61\x6de";$nbjzzcuq="\x6f\x70\x62_\x69\x64";$duwpgfnhgx="o\x70_i\x64";$htjgrubypy="ex\x74\x72a\x73";${"\x47\x4c\x4f\x42AL\x53"}["\x6d\x6depf\x63\x73\x72f\x6d"]="\x6f\x70b_\x69d";$pkrmufunojz="o\x70\x5f\x69\x64";${${"\x47\x4cO\x42A\x4cS"}["\x77\x68n\x62\x6b\x63\x6bp"]}=${$btvxuwnh}=${${"\x47L\x4f\x42\x41\x4c\x53"}["m\x6bj\x65\x68\x69o\x79\x67\x73"]}=${${"\x47LO\x42\x41L\x53"}["\x74\x79\x76\x6aj\x67\x69"]}=array();$mxunseqmlekw="lis\x74\x61\x5f\x6f\x70\x5fd\x65\x62\x69\x74\x6f";${${"G\x4c\x4f\x42AL\x53"}["q\x62\x74\x7ai\x77"]}=array("v\x69\x73a"=>"\x56i\x73\x61","ma\x73t\x65rcar\x64"=>"\x4dasterc\x61rd","\x65\x6co"=>"\x45l\x6f","\x64\x69ner\x73"=>"Di\x6e\x65\x72\x73","disc\x6f\x76e\x72"=>"\x44i\x73c\x6fv\x65r","\x61me\x78"=>"Ame\x78","\x6a\x63\x62"=>"\x4aC\x42","aur\x61"=>"\x41\x75\x72a","hiper"=>"Hiper","hipercard"=>"Hipercard");$feqxmy="\x63\x61m\x70os";${${"\x47L\x4f\x42\x41L\x53"}["\x79\x75\x62\x75oz"]}=array("vi\x73\x61"=>"Vi\x73\x61\x20\x45\x6c\x65\x63tr\x6fn","m\x61stercar\x64"=>"M\x61estr\x6f","elodebito"=>"Elo",);foreach(${$mxunseqmlekw} AS${$duwpgfnhgx}=>${${"\x47\x4cO\x42A\x4c\x53"}["rn\x76\x76\x72\x69\x73\x6d\x7a\x6f\x71"]}){$nqnfhb="b\x61\x6e\x64ei\x72\x61s\x64\x65\x62i\x74\x6f";${$nqnfhb}[]=array("id"=>${${"\x47\x4c\x4fB\x41\x4c\x53"}["\x79\x6cg\x61\x73\x6em"]},"n\x61\x6d\x65"=>${${"\x47\x4c\x4f\x42\x41\x4c\x53"}["r\x6ev\x76\x72\x69\x73\x6d\x7a\x6f\x71"]});}${${"\x47L\x4fBA\x4cS"}["\x65\x62h\x61\x79o\x72eh"]}=array("\x42r\x61\x64\x65\x73\x63\x6f"=>"Brad\x65sco (\x73em \x72eg\x69st\x72o)","B\x72ad\x65sco2"=>"Bra\x64e\x73co\x20(c\x6fm r\x65g\x69\x73\x74\x72\x6f)","B\x61\x6e\x63od\x6fBr\x61\x73i\x6c"=>"\x42B (s\x65m \x72e\x67\x69\x73\x74ro)","\x42a\x6e\x63\x6fdo\x42rasil2"=>"B\x42\x20(com\x20\x72e\x67i\x73tr\x6f)",);foreach(${${"\x47\x4cO\x42\x41\x4cS"}["eb\x68a\x79o\x72eh"]} AS${$nbjzzcuq}=>${${"\x47L\x4f\x42A\x4cS"}["s\x64\x65u\x6c\x67\x76\x65"]}){${"\x47\x4c\x4f\x42A\x4c\x53"}["\x67\x6b\x69\x75\x6a\x6b\x6fwr\x6f"]="o\x70\x62_\x69\x64";$yvsevbc="o\x70\x62_\x6e\x61me";${${"\x47\x4c\x4f\x42\x41\x4cS"}["ub\x79\x73byl\x73\x72"]}[]=array("i\x64"=>${${"G\x4c\x4fB\x41\x4c\x53"}["g\x6b\x69\x75\x6a\x6b\x6f\x77ro"]},"\x6e\x61\x6d\x65"=>${$yvsevbc});}${${"G\x4c\x4f\x42\x41\x4c\x53"}["e\x62\x68a\x79\x6f\x72\x65\x68"]}=array("\x42\x72\x61de\x73\x63o"=>"Brad\x65s\x63o","\x42\x61\x6ecodo\x42r\x61\x73\x69l"=>"\x42B",);foreach(${${"\x47\x4c\x4fB\x41\x4c\x53"}["\x65\x62\x68\x61y\x6fr\x65h"]} AS${${"\x47\x4c\x4fBAL\x53"}["mmep\x66\x63s\x72\x66\x6d"]}=>${$bdtgusgko}){${"\x47L\x4f\x42\x41\x4c\x53"}["\x75\x72\x77\x71pc\x79y\x77\x62f"]="\x6f\x70b\x5f\x69d";${${"G\x4c\x4f\x42\x41\x4c\x53"}["ll\x77\x66\x68\x78\x64d\x6c"]}[]=array("i\x64"=>${${"GL\x4f\x42A\x4c\x53"}["\x75r\x77\x71\x70\x63\x79yw\x62\x66"]},"n\x61\x6d\x65"=>${${"G\x4c\x4f\x42\x41\x4c\x53"}["\x73\x64\x65\x75\x6cg\x76\x65"]});}${"G\x4c\x4f\x42\x41\x4c\x53"}["\x6b\x77\x74\x79\x6euy"]="\x63a\x6d\x70o\x73";${${"\x47\x4c\x4fBAL\x53"}["\x78ti\x79\x65\x71\x68v\x6ew\x6ch"]}=array();${"\x47\x4c\x4f\x42A\x4c\x53"}["\x73\x74\x6e\x64s\x6b\x6b"]="\x63\x61\x6d\x70\x6f\x73";${${"\x47\x4cO\x42A\x4c\x53"}["\x6b\x77\x74\x79\x6e\x75\x79"]}[]=array("\x63o\x6c"=>6,"\x74\x79\x70\x65"=>"te\x78t","\x64\x65s\x63"=>$this->l("Se\x72i\x61l \x64\x65\x20\x52eg\x69\x73\x74r\x6f\x20\x70\x61\x72a o\x20módu\x6c\x6f\x2e"),"\x6eame"=>"\x43IEL\x4fA\x50IP\x52\x4f\x35_SE\x52I\x41L","la\x62\x65\x6c"=>$this->l("S\x65\x72\x69\x61\x6c\x20de Re\x67\x69\x73\x74r\x6f"),);${${"\x47\x4c\x4f\x42\x41\x4c\x53"}["xt\x69ye\x71h\x76n\x77lh"]}[]=array("ty\x70\x65"=>"\x73\x77\x69\x74ch","la\x62e\x6c"=>$this->l("M\x6fd\x6f \x54es\x74e"),"\x6e\x61m\x65"=>"C\x49\x45\x4c\x4f\x41P\x49PRO\x35\x5fTEST\x45","is\x5fb\x6fo\x6c"=>true,"\x64e\x73\x63"=>$this->l("\x4c\x65\x6d\x62\x72\x61n\x64o \x71ue\x20\x74r\x61\x6e\x73\x61çã\x6f\x20\x65m \x6dod\x6f \x64e\x20\x74es\x74\x65 nã\x6f são\x20valida\x73."),"\x76a\x6c\x75es"=>array(array("id"=>"a\x63\x74iv\x65\x5fon","\x76\x61\x6c\x75\x65"=>true,"\x6cabel"=>$this->l("\x41tiv\x6f")),array("\x69\x64"=>"a\x63t\x69v\x65_off","valu\x65"=>false,"\x6cab\x65l"=>$this->l("In\x61\x74ivo"))),);${${"\x47\x4cOB\x41\x4c\x53"}["\x78t\x69ye\x71h\x76\x6e\x77lh"]}[]=array("col"=>6,"\x74y\x70\x65"=>"\x74ex\x74","\x64es\x63"=>$this->l("In\x66or\x6d\x65\x20\x6f \x4d\x65r\x63\x68\x61\x6et\x5f\x49\x44\x2e"),"n\x61m\x65"=>"CIE\x4cOAP\x49PRO\x35\x5fID","l\x61\x62\x65l"=>$this->l("\x4d\x65r\x63ha\x6e\x74\x5fI\x44"),);$kccxwtwhw="c\x61\x6dp\x6f\x73";${${"\x47\x4c\x4f\x42\x41L\x53"}["\x78\x74iy\x65q\x68vn\x77\x6ch"]}[]=array("co\x6c"=>6,"\x74\x79p\x65"=>"te\x78t","desc"=>$this->l("\x49n\x66\x6f\x72m\x65\x20o\x20M\x65r\x63\x68\x61nt_Key."),"\x6e\x61\x6de"=>"\x43\x49\x45L\x4f\x41\x50\x49P\x52O\x35\x5fSECRE\x54","l\x61bel"=>$this->l("Me\x72chan\x74\x5f\x4be\x79"),);$mprufxwf="\x63am\x70o\x73";${${"\x47\x4cO\x42\x41L\x53"}["\x78\x74iy\x65qh\x76\x6ew\x6c\x68"]}[]=array("\x74ype"=>"\x73\x65le\x63\x74","\x6e\x61\x6d\x65"=>"C\x49\x45LOAPIPR\x4f5_\x46I\x53CAL","\x64\x65\x73\x63"=>$this->l("C\x61\x6dp\x6f \x63u\x73\x74\x6fm\x69\x7a\x61\x64\x6f qu\x61l \x6f\x20\x43\x50F/CN\x50\x4a é\x20s\x61\x6c\x76\x6f na\x20l\x6f\x6a\x61\x21"),"l\x61\x62\x65\x6c"=>$this->l("\x4fr\x69g\x65\x6d CP\x46/\x43NPJ"),"op\x74i\x6fn\x73"=>array("q\x75e\x72\x79"=>${$htjgrubypy},"i\x64"=>"i\x64","\x6e\x61\x6de"=>"c\x61\x6d\x70o"));${"\x47L\x4fB\x41\x4c\x53"}["\x77\x74y\x62\x73j\x78"]="op\x5f\x6e\x61m\x65";${${"\x47LOB\x41\x4c\x53"}["\x78\x74i\x79\x65\x71hv\x6ew\x6c\x68"]}[]=array("\x74\x79\x70\x65"=>"\x73\x65\x6cec\x74","n\x61me"=>"\x43\x49E\x4cO\x41\x50\x49P\x52\x4f5_N\x55M\x45\x52\x4f","\x64esc"=>$this->l("C\x61\x6d\x70o\x20\x63us\x74om\x69z\x61\x64\x6f\x20qua\x6c o\x20Nú\x6de\x72\x6f d\x6f\x20\x65\x6e\x64ereç\x6f\x20é \x73\x61lv\x6f na\x20\x6c\x6f\x6a\x61\x21"),"l\x61\x62\x65l"=>$this->l("Or\x69g\x65m \x4eú\x6de\x72o\x20\x64o\x20\x65n\x64\x65\x72\x65ç\x6f"),"op\x74ion\x73"=>array("\x71\x75e\x72\x79"=>${${"\x47\x4cO\x42A\x4c\x53"}["\x74\x66\x70g\x6d\x6a\x71\x6ajy\x6e"]},"\x69\x64"=>"\x69d","nam\x65"=>"\x63a\x6d\x70o"));${"G\x4c\x4f\x42\x41\x4cS"}["\x6f\x62\x65m\x75\x6ax\x75"]="c\x61\x6d\x70\x6fs";${${"\x47\x4cOB\x41LS"}["\x78\x74\x69\x79\x65\x71hv\x6e\x77lh"]}[]=array("ty\x70e"=>"s\x77\x69\x74\x63h","\x6ca\x62\x65\x6c"=>$this->l("At\x69\x76\x61\x72 C\x61\x72\x74ã\x6f d\x65 C\x72édi\x74o"),"n\x61me"=>"CIELO\x41PIPRO\x35\x5f\x43ARTAO","i\x73\x5fb\x6fo\x6c"=>true,"\x64es\x63"=>$this->l("A\x74\x69var\x20Ca\x72\x74ão\x20\x64\x65\x20\x43\x72é\x64\x69\x74o"),"\x76\x61lu\x65\x73"=>array(array("\x69d"=>"\x61\x63tive_o\x6e","valu\x65"=>true,"lab\x65\x6c"=>$this->l("A\x74\x69vo")),array("\x69\x64"=>"a\x63\x74\x69v\x65_\x6f\x66\x66","v\x61l\x75\x65"=>false,"la\x62\x65l"=>$this->l("In\x61ti\x76\x6f"))),);${"GLO\x42\x41\x4c\x53"}["\x68\x6fm\x68\x71\x6d\x76o"]="\x63\x61mp\x6fs";foreach(${${"\x47L\x4f\x42\x41LS"}["\x71\x62\x74zi\x77"]} AS${$pkrmufunojz}=>${${"\x47\x4cO\x42\x41L\x53"}["wt\x79\x62\x73j\x78"]}){$olovfjgsjip="\x6f\x70\x5f\x69\x64";${${"\x47LO\x42\x41\x4cS"}["\x78\x74\x69y\x65\x71\x68v\x6e\x77l\x68"]}[]=array("t\x79\x70e"=>"\x72ad\x69\x6f","\x6eam\x65"=>"\x43\x49\x45\x4cO\x41P\x49P\x52\x4f5\x5f\x4fP\x5f".${$olovfjgsjip}."","l\x61b\x65l"=>$this->l(${${"\x47\x4cO\x42A\x4cS"}["\x72\x6e\x76\x76\x72\x69s\x6dz\x6f\x71"]}),"\x69\x73_\x62\x6fol"=>true,"va\x6cu\x65\x73"=>array(array("\x69d"=>"\x61\x63t\x69\x76\x65\x5f\x6f\x6e","v\x61\x6c\x75\x65"=>1,"\x6c\x61b\x65\x6c"=>$this->l("\x41\x74\x69\x76o")),array("\x69d"=>"\x61\x63tiv\x65_of\x66","\x76a\x6cu\x65"=>0,"labe\x6c"=>$this->l("\x49\x6e\x61t\x69\x76o"))),);}${"\x47\x4c\x4fB\x41L\x53"}["m\x64nx\x77\x6a"]="ca\x6d\x70os";${$feqxmy}[]=array("\x63\x6fl"=>3,"t\x79pe"=>"\x74ex\x74","\x63\x6c\x61\x73s"=>"d\x69\x6e\x68e\x69r\x6f","\x64\x65\x66\x61ul\x74"=>5.00,"\x64es\x63"=>$this->l("V\x61lor m\x69nim\x6f\x20da \x70a\x72\x63el\x61."),"n\x61\x6de"=>"\x43IE\x4c\x4f\x41PIP\x52O5\x5fM\x49\x4eI\x4dO","l\x61b\x65\x6c"=>$this->l("P\x61rc\x65\x6c\x61\x20Mi\x6ei\x6da (R\$)"),);$woivucwgxwk="\x63\x61\x6d\x70\x6f\x73";${$woivucwgxwk}[]=array("\x63o\x6c"=>2,"\x74y\x70\x65"=>"t\x65\x78\x74","def\x61\x75lt"=>6,"\x64e\x73\x63"=>$this->l("\x44i\x76i\x64\x69\x72 em qual\x20\x6eu\x6de\x72\x6f\x20\x64\x65\x20\x70ar\x63e\x6ca\x73\x2e"),"n\x61\x6de"=>"\x43\x49EL\x4fAP\x49\x50R\x4f\x35\x5f\x44\x49V","l\x61b\x65l"=>$this->l("\x44iv\x69\x64\x69\x72 \x65\x6d"),);${${"\x47\x4c\x4fB\x41L\x53"}["\x78\x74\x69\x79\x65\x71h\x76n\x77l\x68"]}[]=array("\x63ol"=>2,"t\x79\x70e"=>"\x74\x65\x78t","\x64e\x66\x61ult"=>6,"d\x65\x73c"=>$this->l("Div\x69dir\x20\x73\x65\x6d\x20ju\x72\x6fs \x61té\x20qual\x20\x70a\x72\x63\x65\x6c\x61."),"\x6e\x61me"=>"\x43\x49\x45LOAPIP\x52O\x35\x5f\x53EM","l\x61b\x65\x6c"=>$this->l("\x53\x65m \x6a\x75\x72\x6fs\x20a\x74é"),);${${"\x47\x4c\x4f\x42\x41\x4c\x53"}["\x78\x74\x69y\x65\x71\x68vnw\x6c\x68"]}[]=array("\x63\x6fl"=>3,"\x74ype"=>"t\x65\x78t","cl\x61\x73s"=>"dinhe\x69r\x6f","de\x66\x61ult"=>0.00,"des\x63"=>$this->l("Taxa d\x65 \x6auros."),"\x6ea\x6d\x65"=>"C\x49EL\x4fAP\x49PR\x4f5_\x4a\x55\x52O\x53","la\x62e\x6c"=>$this->l("\x54ax\x61 \x64\x65 juro\x73\x20(%)"),);$egsxhamyz="\x63\x61\x6d\x70os";${${"\x47L\x4f\x42\x41\x4c\x53"}["x\x74\x69y\x65\x71\x68vnw\x6c\x68"]}[]=array("\x74yp\x65"=>"s\x65\x6cec\x74","\x6e\x61m\x65"=>"CIEL\x4fAPIP\x52\x4f5\x5fTI\x50O_\x50A\x52","\x64e\x73\x63"=>$this->l("T\x69po\x20de \x70\x61r\x63e\x6cament\x6f c\x6f\x6d\x20ju\x72\x6fs\x21"),"label"=>$this->l("Pa\x72cel\x61m\x65\x6e\x74\x6f\x20c\x6fm J\x75\x72\x6f\x73"),"\x6f\x70ti\x6f\x6es"=>array("quer\x79"=>array(array("id"=>"\x6c\x6fj\x61","\x6e\x61\x6d\x65"=>"Parc\x65l\x61d\x6f\x20pe\x6co \x65\x73\x74\x61\x62\x65l\x65\x63\x69\x6d\x65n\x74o"),array("\x69d"=>"o\x70\x65r\x61\x64o\x72a","n\x61me"=>"\x50\x61\x72\x63el\x61\x64\x6f\x20\x70\x65\x6ca \x6fperad\x6f\x72\x61")),"id"=>"\x69\x64","n\x61m\x65"=>"\x6ea\x6de"));$zqqnsuu="c\x61m\x70\x6fs";$vuispxqskzd="c\x61m\x70\x6f\x73";${${"\x47\x4c\x4f\x42A\x4c\x53"}["x\x74\x69ye\x71\x68\x76\x6e\x77\x6c\x68"]}[]=array("typ\x65"=>"sele\x63\x74","na\x6d\x65"=>"\x43\x49E\x4cOA\x50\x49PR\x4f\x35_\x43A\x50","\x64es\x63"=>$this->l("C\x61pt\x75\x72\x61 \x70o\x73\x74er\x69\x6fs\x20\x74odo\x20\x70\x65di\x64o\x20de\x76\x65rá s\x65\x72 capt\x75ramen\x74o\x20\x6d\x61\x6eu\x61\x6cm\x65nt\x65\x21"),"\x6ca\x62\x65l"=>$this->l("\x54\x69\x70o\x20d\x65\x20\x43\x61p\x74ur\x61"),"\x6fp\x74\x69o\x6es"=>array("\x71ue\x72\x79"=>array(array("\x69\x64"=>"a\x75\x74o\x6d\x61ti\x63a","na\x6de"=>"Aut\x6fma\x74i\x63\x61\x20(v\x65nd\x61)"),array("i\x64"=>"p\x6f\x73\x74\x65\x72i\x6fr","\x6eam\x65"=>"\x50\x6fst\x65rior\x20(\x61u\x74\x6fr\x69\x7a\x65)")),"i\x64"=>"id","na\x6d\x65"=>"n\x61me"));${$egsxhamyz}[]=array("\x63\x6fl"=>6,"ty\x70\x65"=>"t\x65xt","\x64esc"=>$this->l("Nome\x20\x61\x20ex\x69bir \x6e\x61\x20\x66\x61tu\x72a\x20\x64e\x20\x61\x74é \x313 \x64ig\x69\x74\x6fs."),"\x6e\x61\x6d\x65"=>"C\x49\x45L\x4f\x41\x50\x49\x50\x52\x4f\x35_SOF\x54","\x6c\x61\x62el"=>$this->l("S\x6f\x66tD\x65sc\x72i\x70tor"),);${${"GLO\x42\x41\x4c\x53"}["o\x62\x65m\x75j\x78\x75"]}[]=array("\x74y\x70\x65"=>"se\x6cec\x74","\x6eam\x65"=>"C\x49\x45L\x4f\x41PI\x50R\x4f\x35\x5fFRAU\x44E","d\x65sc"=>$this->l("S\x65rv\x69ç\x6f \x63o\x6e\x74r\x61\x74a\x64o\x20a\x20parte jun\x74\x6f\x20a\x20\x63i\x65\x6c\x6f,\x20só\x20\x61\x74iv\x65\x20\x73\x65\x20\x63ontrat\x61to"),"\x6ca\x62el"=>$this->l("\x41n\x74\x69-fra\x75\x64\x65"),"op\x74i\x6f\x6e\x73"=>array("\x71uer\x79"=>array(array("\x69\x64"=>"\x66a\x6c\x73e","\x6eam\x65"=>"\x4eão \x61t\x69\x76\x61r"),array("id"=>"\x74\x72ue","\x6e\x61\x6de"=>"\x41\x74\x69\x76\x61\x72")),"\x69d"=>"i\x64","\x6e\x61\x6d\x65"=>"\x6e\x61\x6de"));${${"G\x4c\x4f\x42A\x4c\x53"}["x\x74\x69\x79eq\x68\x76\x6e\x77l\x68"]}[]=array("t\x79p\x65"=>"s\x77\x69tc\x68","l\x61\x62e\x6c"=>$this->l("\x41\x74iva\x72\x20\x43a\x72tão\x20\x64\x65 \x44éb\x69\x74o"),"na\x6de"=>"\x43\x49\x45\x4cO\x41\x50IPRO5_CARTAO_\x44\x45B\x49\x54\x4f","is\x5fbo\x6f\x6c"=>true,"desc"=>$this->l("\x41\x74iva\x72 Car\x74ã\x6f \x64e \x44éb\x69\x74\x6f"),"\x76\x61lu\x65\x73"=>array(array("i\x64"=>"\x61\x63tive\x5fon","v\x61\x6c\x75e"=>true,"l\x61b\x65l"=>$this->l("\x41\x74\x69\x76\x6f")),array("\x69\x64"=>"ac\x74ive\x5f\x6f\x66f","va\x6c\x75e"=>false,"\x6cab\x65\x6c"=>$this->l("\x49\x6e\x61ti\x76\x6f"))),);foreach(${${"\x47\x4c\x4f\x42A\x4c\x53"}["y\x75\x62\x75\x6fz"]} AS${${"\x47\x4cO\x42\x41LS"}["\x68ox\x66ki\x69\x75mky\x78"]}=>${${"GLO\x42A\x4c\x53"}["e\x78\x72\x77\x75\x68r\x65\x75\x6d"]}){$vlrxqsrmhcty="\x63\x61\x6dp\x6fs";${"G\x4c\x4f\x42\x41\x4c\x53"}["\x70p\x67b\x7a\x6a\x65\x62\x75"]="\x6fp_\x6e\x61m\x65";${$vlrxqsrmhcty}[]=array("typ\x65"=>"r\x61\x64i\x6f","n\x61\x6de"=>"C\x49\x45L\x4fAP\x49\x50\x52\x4f\x35\x5f\x4f\x50\x5fDE\x42\x49T\x4f\x5f".${${"GLO\x42\x41LS"}["\x79\x6cg\x61\x73n\x6d"]}."","\x6c\x61b\x65\x6c"=>$this->l(${${"G\x4c\x4f\x42\x41\x4c\x53"}["\x70\x70\x67bz\x6aebu"]}),"is\x5fboo\x6c"=>true,"\x76\x61l\x75\x65s"=>array(array("\x69\x64"=>"\x61ct\x69\x76e_\x6f\x6e","\x76a\x6c\x75\x65"=>1,"lab\x65\x6c"=>$this->l("\x41tiv\x6f")),array("i\x64"=>"ac\x74\x69ve\x5f\x6ff\x66","\x76a\x6c\x75\x65"=>0,"\x6ca\x62\x65l"=>$this->l("I\x6e\x61t\x69v\x6f"))),);}${${"\x47LO\x42AL\x53"}["\x78t\x69\x79e\x71hvn\x77lh"]}[]=array("c\x6fl"=>3,"ty\x70e"=>"\x74e\x78\x74","class"=>"d\x69nhei\x72o","\x64\x65\x73c"=>$this->l("\x44esc\x6f\x6et\x6f\x20\x70\x61\x72\x61\x20\x70agam\x65\x6et\x6f\x20p\x6fr\x20\x64é\x62i\x74o."),"na\x6de"=>"C\x49E\x4c\x4f\x41\x50\x49P\x52\x4f\x35\x5f\x44\x45S\x43_DE\x42","\x6c\x61bel"=>$this->l("D\x65sco\x6eto p\x61r\x61\x20Dé\x62\x69t\x6f (\x25)"),);${${"\x47\x4cO\x42\x41L\x53"}["\x78\x74\x69yeqh\x76n\x77l\x68"]}[]=array("t\x79\x70e"=>"s\x77itch","la\x62el"=>$this->l("A\x74iva\x72 \x42\x6f\x6ceto \x42ancário"),"\x6eam\x65"=>"CIE\x4c\x4f\x41P\x49P\x52\x4f\x35\x5fB\x4fL\x45\x54\x4f","i\x73\x5fb\x6fol"=>true,"\x64e\x73c"=>$this->l("Ati\x76ar B\x6f\x6ce\x74\x6f B\x61\x6e\x63á\x72\x69\x6f"),"\x76a\x6c\x75\x65s"=>array(array("\x69\x64"=>"act\x69\x76\x65_on","v\x61l\x75e"=>true,"\x6c\x61bel"=>$this->l("Ativ\x6f")),array("id"=>"\x61\x63\x74i\x76\x65_\x6fff","\x76\x61\x6c\x75\x65"=>false,"l\x61\x62el"=>$this->l("\x49n\x61\x74i\x76o"))),);$kfacgzmcgbrz="\x63\x61m\x70\x6f\x73";${${"GL\x4f\x42\x41\x4c\x53"}["\x73tn\x64\x73\x6bk"]}[]=array("\x74y\x70\x65"=>"s\x65\x6c\x65ct","n\x61me"=>"CIE\x4cOAPIPRO\x35_\x42\x43","d\x65\x73\x63"=>$this->l("\x53el\x65\x63\x69\x6f\x6e\x65 \x6f\x20\x42\x61nco!"),"l\x61\x62\x65\x6c"=>$this->l("\x42\x61n\x63o"),"o\x70t\x69o\x6e\x73"=>array("\x71uer\x79"=>${${"G\x4c\x4fB\x41\x4c\x53"}["u\x62\x79s\x62\x79\x6csr"]},"\x69\x64"=>"\x69d","\x6eame"=>"na\x6d\x65"));${$zqqnsuu}[]=array("c\x6f\x6c"=>6,"\x74\x79p\x65"=>"t\x65x\x74","\x64es\x63"=>$this->l("N\x6f\x6de do\x20ce\x64en\x74\x65\x20\x61\x20e\x78\x69bi\x72\x20\x6eo bol\x65t\x6f."),"na\x6de"=>"\x43I\x45\x4c\x4f\x41PIP\x52O5\x5f\x43E\x44","l\x61\x62el"=>$this->l("C\x65\x64e\x6ete"),);${${"\x47\x4cOB\x41\x4c\x53"}["x\x74\x69y\x65\x71h\x76\x6e\x77\x6c\x68"]}[]=array("\x63o\x6c"=>6,"\x74\x79pe"=>"te\x78t","\x64\x65\x73\x63"=>$this->l("Demos\x74r\x61\x74\x69\x76\x6f a e\x78i\x62\x69r\x20\x6e\x6f\x20bo\x6cet\x6f."),"\x6e\x61\x6d\x65"=>"C\x49ELO\x41\x50\x49\x50\x52O\x35_DE\x4d\x4f","\x6cabel"=>$this->l("D\x65\x6do\x6est\x72\x61\x74i\x76\x6f"),);$ofbavzd="\x62anc\x6fste\x66";${$mprufxwf}[]=array("c\x6f\x6c"=>6,"\x74yp\x65"=>"t\x65\x78t","\x64\x65\x73c"=>$this->l("\x49n\x73\x74ruções \x61\x20e\x78ibir\x20n\x6f b\x6f\x6c\x65t\x6f\x2e"),"na\x6d\x65"=>"\x43\x49ELO\x41PI\x50\x52\x4f\x35_IN","\x6c\x61be\x6c"=>$this->l("I\x6est\x72\x75ções"),);${$kfacgzmcgbrz}[]=array("\x63\x6f\x6c"=>2,"type"=>"te\x78t","d\x65f\x61\x75\x6ct"=>5,"\x64e\x73c"=>$this->l("\x50r\x61zo d\x65\x20val\x69d\x61de e\x6d d\x69a\x73 p\x61\x72\x61\x20\x6f\x20\x42ol\x65\x74\x6f\x2e"),"n\x61m\x65"=>"\x43I\x45\x4c\x4f\x41\x50I\x50\x52O\x35\x5fV\x41L\x49\x44\x41\x44E","\x6cabel"=>$this->l("Vali\x64ad\x65\x20\x65\x6d\x20D\x69\x61\x73"),);${${"GLOBAL\x53"}["x\x74\x69y\x65qh\x76\x6e\x77\x6c\x68"]}[]=array("col"=>3,"t\x79p\x65"=>"tex\x74","\x63las\x73"=>"\x64in\x68\x65i\x72o","\x64\x65sc"=>$this->l("\x44\x65\x73cont\x6f para pa\x67\x61\x6dento\x20p\x6fr \x62\x6fle\x74o."),"\x6e\x61m\x65"=>"\x43IE\x4c\x4fA\x50IPRO5_D\x45\x53C\x5fB\x4f\x4c","\x6c\x61\x62\x65\x6c"=>$this->l("\x44es\x63o\x6et\x6f p\x61\x72a\x20Bo\x6c\x65to\x20(%)"),);$jikixvwh="\x63\x61\x6d\x70\x6fs";${${"GL\x4f\x42\x41\x4c\x53"}["m\x64\x6e\x78w\x6a"]}[]=array("\x74ype"=>"\x73\x77i\x74c\x68","\x6c\x61\x62\x65\x6c"=>$this->l("At\x69v\x61r TE\x46"),"na\x6de"=>"\x43\x49\x45L\x4f\x41\x50IPRO\x35_\x54E\x46","\x69\x73_\x62oo\x6c"=>true,"de\x73c"=>$this->l("\x41\x74\x69\x76\x61r\x20\x54\x45\x46"),"\x76\x61\x6cue\x73"=>array(array("id"=>"\x61c\x74iv\x65\x5f\x6f\x6e","\x76\x61\x6cue"=>true,"l\x61b\x65\x6c"=>$this->l("At\x69\x76o")),array("\x69\x64"=>"\x61ct\x69ve\x5fof\x66","\x76alue"=>false,"\x6c\x61\x62el"=>$this->l("\x49n\x61ti\x76o"))),);${${"\x47\x4c\x4fB\x41\x4cS"}["\x78\x74\x69y\x65\x71\x68vn\x77l\x68"]}[]=array("ty\x70e"=>"s\x65l\x65ct","nam\x65"=>"C\x49\x45LOA\x50I\x50R\x4f5_BC\x5fTE\x46","des\x63"=>$this->l("Se\x6cecio\x6e\x65 o\x20B\x61\x6e\x63\x6f\x21"),"l\x61b\x65\x6c"=>$this->l("\x42\x61\x6eco"),"\x6fp\x74\x69\x6f\x6e\x73"=>array("q\x75e\x72y"=>${$ofbavzd},"i\x64"=>"id","\x6eam\x65"=>"n\x61\x6de"));${$kccxwtwhw}[]=array("c\x6fl"=>3,"t\x79p\x65"=>"t\x65x\x74","\x63\x6c\x61\x73\x73"=>"\x64\x69nheiro","de\x73\x63"=>$this->l("\x44e\x73\x63o\x6et\x6f\x20\x70\x61r\x61\x20pag\x61m\x65n\x74o \x70or\x20\x74ef."),"n\x61me"=>"CIELOA\x50\x49PRO5\x5fDE\x53C_\x54\x45\x46","l\x61\x62el"=>$this->l("\x44e\x73c\x6fn\x74o pa\x72a\x20TEF (%)"),);${${"G\x4cO\x42A\x4c\x53"}["f\x7a\x61a\x6d\x61"]}[]=array("t\x79p\x65"=>"\x73\x65\x6c\x65\x63\x74","na\x6de"=>"CIE\x4c\x4fA\x50I\x50\x52O\x35\x5fI\x4eIC\x49A\x44\x41","de\x73c"=>$this->l("S\x74\x61tu\x73 cu\x73\x74om\x69\x7a\x61do ou\x20\x6aá \x65x\x69\x73\x74e\x6et\x65\x21"),"\x6c\x61\x62el"=>$this->l("\x53\x74\x61\x74\x75s \x41\x67u\x61\x72\x64\x61\x6e\x64\x6f \x50aga\x6de\x6eto"),"\x6f\x70t\x69on\x73"=>array("\x71u\x65\x72y"=>$this->GetStatusNomes(),"\x69\x64"=>"id\x5f\x6f\x72\x64er\x5fs\x74at\x65","n\x61m\x65"=>"n\x61\x6d\x65"));${$vuispxqskzd}[]=array("\x74y\x70\x65"=>"s\x65lec\x74","na\x6de"=>"CI\x45\x4cO\x41P\x49\x50\x52\x4f\x35\x5fPA\x47O","des\x63"=>$this->l("S\x74\x61\x74\x75s \x63ustom\x69zad\x6f\x20\x6fu \x6aá e\x78\x69\x73tent\x65\x21"),"lab\x65l"=>$this->l("\x53ta\x74\x75s\x20P\x61\x67\x6f"),"o\x70tio\x6es"=>array("query"=>$this->GetStatusNomes(),"\x69\x64"=>"\x69\x64\x5fo\x72d\x65r_st\x61te","n\x61m\x65"=>"\x6ea\x6de"));${${"G\x4cO\x42AL\x53"}["w\x72\x6b\x76gb\x6c\x71w\x73\x67\x70"]}[]=array("ty\x70\x65"=>"\x73ele\x63t","\x6e\x61m\x65"=>"CIE\x4cOA\x50\x49\x50R\x4f\x35\x5fA\x55","des\x63"=>$this->l("St\x61\x74us c\x75st\x6f\x6diza\x64o\x20o\x75 \x6aá\x20ex\x69\x73\x74ente!"),"\x6c\x61b\x65\x6c"=>$this->l("S\x74\x61\x74\x75\x73 \x41\x75\x74o\x72i\x7aado"),"op\x74\x69o\x6e\x73"=>array("\x71\x75e\x72y"=>$this->GetStatusNomes(),"\x69\x64"=>"i\x64\x5for\x64e\x72\x5fs\x74\x61t\x65","nam\x65"=>"\x6ea\x6d\x65"));${$jikixvwh}[]=array("\x74y\x70e"=>"s\x65l\x65\x63t","na\x6de"=>"\x43IEL\x4fAPI\x50R\x4f5_\x4e\x41O\x5fP\x41G\x41","\x64\x65\x73c"=>$this->l("Sta\x74us c\x75s\x74om\x69\x7a\x61d\x6f \x6fu\x20\x6aá \x65\x78\x69\x73\x74\x65\x6e\x74e!"),"\x6ca\x62el"=>$this->l("Stat\x75s\x20\x4eã\x6f\x20Au\x74\x6fri\x7aa\x64\x6f"),"\x6f\x70t\x69\x6fn\x73"=>array("quer\x79"=>$this->GetStatusNomes(),"\x69\x64"=>"\x69d\x5f\x6f\x72d\x65r_s\x74\x61\x74e","n\x61\x6de"=>"n\x61m\x65"));${${"G\x4cO\x42\x41\x4c\x53"}["\x78\x74\x69\x79\x65\x71h\x76\x6ew\x6c\x68"]}[]=array("ty\x70\x65"=>"se\x6c\x65c\x74","n\x61\x6de"=>"\x43\x49E\x4c\x4fAP\x49P\x52\x4f\x35\x5f\x43A\x4e\x43EL\x41\x44A","de\x73c"=>$this->l("\x53t\x61\x74u\x73 \x63\x75st\x6fm\x69\x7aad\x6f ou \x6aá \x65\x78\x69\x73\x74en\x74\x65!"),"label"=>$this->l("St\x61\x74\x75\x73 C\x61\x6ece\x6cad\x6f"),"o\x70tion\x73"=>array("\x71u\x65\x72y"=>$this->GetStatusNomes(),"\x69\x64"=>"i\x64_\x6fr\x64\x65\x72_\x73tate","\x6e\x61m\x65"=>"\x6ea\x6d\x65"));return array("\x66or\x6d"=>array("\x6c\x65g\x65n\x64"=>array("\x74\x69t\x6ce"=>$this->l("C\x6f\x6e\x66\x69g\x75r\x61çõe\x73"),"\x69con"=>"\x69c\x6f\x6e-\x63\x6fg\x73",),"\x69np\x75\x74"=>${${"GL\x4f\x42AL\x53"}["\x68\x6f\x6dhqm\x76\x6f"]},"submit"=>array("t\x69t\x6c\x65"=>$this->l("Salva\x72"),),),);}else{$zdkeamp="\x69\x64\x50\x61g\x61\x6d\x65n\x74\x6f";return array("fo\x72\x6d"=>array("\x6ce\x67\x65\x6ed"=>array("\x74\x69t\x6ce"=>$this->l("Ati\x76a\x72\x20Mó\x64ul\x6f (".${$zdkeamp}.")"),"\x69con"=>"i\x63\x6f\x6e-\x63o\x67s",),"i\x6e\x70\x75\x74"=>array(array("co\x6c"=>6,"\x74ype"=>"te\x78t","\x64\x65s\x63"=>$this->l("S\x65ri\x61\x6c\x20de R\x65\x67i\x73\x74\x72o\x20\x70\x61\x72a\x20o\x20mód\x75\x6co\x20\x65\x6d\x20\x68t\x74p://w\x77\x77\x2e\x6c\x6f\x6a\x615\x2e\x63\x6f\x6d\x2e\x62\x72"),"na\x6d\x65"=>"C\x49\x45LO\x41P\x49\x50R\x4f5\x5f\x53ER\x49\x41\x4c","la\x62\x65l"=>$this->l("S\x65r\x69al\x20\x64e\x20\x52egi\x73\x74r\x6f"),),),"\x73\x75\x62mit"=>array("tit\x6c\x65"=>$this->l("S\x61\x6c\x76a\x72"),),),);}
    }
    
    private function campos_extras()
    {
        //querys
        $campos[] = array('id'=>'','campo'=>'Cliente informa manual');
        $clientes = Db::getInstance()->executeS("SHOW COLUMNS FROM `" . _DB_PREFIX_ . "customer`");	
        foreach($clientes AS $k=>$v){
            $input = _DB_PREFIX_.'customer.'.$v['Field'].'';
            $campos[] = array('id'=>$input,'campo'=>$input);
        }
        $enderecos = Db::getInstance()->executeS("SHOW COLUMNS FROM `" . _DB_PREFIX_ . "address`");
        foreach($enderecos AS $k=>$v){
            $input = _DB_PREFIX_.'address.'.$v['Field'].'';
            $campos[] = array('id'=>$input,'campo'=>$input);
        }
        return $campos;
    }
    
    public function GetStatusNomes() 
    {
		global $cookie;
		return Db::getInstance()->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'order_state` AS a,`'._DB_PREFIX_.'order_state_lang` AS b WHERE b.id_lang = "'.$cookie->id_lang.'" AND a.deleted = "0" AND a.id_order_state=b.id_order_state');
	}

    /**
     * Set values for the inputs.
     */
    protected function getConfigFormValues()
    {
        $inputs = array();
        $form   = $this->getConfigForm();
        foreach ($form['form']['input'] as $v) {
            $chave          = $v['name'];
            $inputs[$chave] = Configuration::get($chave, '');
        }
        return $inputs;
    }

    /**
     * Save form data.
     */
    protected function postProcess()
    {
        $form_values = $this->getConfigFormValues();

        foreach (array_keys($form_values) as $key) {
            Configuration::updateValue($key, Tools::getValue($key));
        }
    }

    /**
    * Add the CSS & JavaScript files you want to be loaded in the BO.
    */
    public function hookBackOfficeHeader()
    {
        if (Tools::getValue('module_name') == $this->name) {
            $this->context->controller->addJS($this->_path.'views/js/back.js');
            $this->context->controller->addCSS($this->_path.'views/css/back.css');
        }
    }

    /**
     * Add the CSS & JavaScript files you want to be added on the FO.
     */
    public function hookHeader()
    {
        $this->context->controller->addJS($this->_path.'/views/js/front.js');
        $this->context->controller->addCSS($this->_path.'/views/css/front.css');
    }

    /**
     * This method is used to render the payment button,
     * Take care if the button should be displayed or not.
     */
    public function hookPayment($params)
    {
        if (!$this->active)
			return;
        
        $currency_id = $params['cart']->id_currency;
        $currency = new Currency((int)$currency_id);

        if (in_array($currency->iso_code, $this->limited_currencies) == false)
            return false;
        
        //ver o limite de parcelamento
		$cart = new Cart($params['cart']->id);
		$total_pedido = $cart->getOrderTotal(true, Cart::BOTH);
		$div = (int)Configuration::get('CIELOAPIPRO5_DIV');
		$dividir = ($div==0)?'1':$div;
		$minima = (float)Configuration::get('CIELOAPIPRO5_MINIMO');
        if($minima <= 0){
            $minima = 5;
        }
		$div_max = (int)($total_pedido/$minima);
		if($div_max>$div){
            $par = $div;
		}else{
            $par = $div_max;
		}
		if($total_pedido<=$minima){
            $par = 1;
		}

        //vars
		$this->smarty->assign(array(
			'this_path' => $this->_path,
			'par' =>$par,
            'cartao_credito' => Configuration::get('CIELOAPIPRO5_CARTAO'),
			'cartao_debito' => Configuration::get('CIELOAPIPRO5_CARTAO_DEBITO'),
            'cartao_debito_desconto' => (int)Configuration::get('CIELOAPIPRO5_DESC_DEB'),
            'boleto' => Configuration::get('CIELOAPIPRO5_BOLETO'),
            'boleto_desconto' => (int)Configuration::get('CIELOAPIPRO5_DESC_BOL'),
            'tef' => Configuration::get('CIELOAPIPRO5_TEF'),
            'tef_desconto' => (int)Configuration::get('CIELOAPIPRO5_DESC_TEF'),
			'banco_tef' => Configuration::get('CIELOAPIPRO5_BC_TEF'),
			'this_path_ssl' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->name.'/'
		));

        return $this->display(__FILE__, 'views/templates/hook/payment.tpl');
    }

    /**
     * This hook is used to display the order confirmation page.
     */
    public function hookPaymentReturn($params)
    {
        if ($this->active == false)
            return;

        $order = $params['objOrder'];
		
		$sql = 'SELECT * FROM `'._DB_PREFIX_.'cielo_webservice` WHERE pedido = "'.(int)$order->id.'"';
        $dados = Db::getInstance()->getRow($sql);
        
        $objResposta = array();
        $MID = trim(Configuration::get('CIELOAPIPRO5_ID'));
        $KEY = trim(Configuration::get('CIELOAPIPRO5_SECRET'));
        if(Configuration::get('CIELOAPIPRO5_TESTE')){
            $MID = 'daaec334-ac85-4c63-9564-f4a31be7b19b';
            $KEY = 'LTFYLLACRDYCIKMHTXBRVKGQYGDHOOVTCKGZUKRK';
            $urlweb = "https://apiquerysandbox.cieloecommerce.cielo.com.br/1/";
        }else{
            $urlweb = "https://apiquery.cieloecommerce.cielo.com.br/1/";
        }
        $headers = array(
            "Content-Type" => "application/json",
            "Accept" => "application/json",
            "MerchantId" => $MID,
            "MerchantKey" => $KEY,
            "RequestId" => "",
        );
        include_once(dirname(__FILE__).'/classes/restclient.php' );
        $api = new RestClient(array(
            'base_url' => $urlweb, 
            'headers' => $headers, 
        ));
        $response = $api->get("sales/".$dados['pan']."");
        $dados_pedido = @json_decode($response->response,true);
        
        //debug
        if(isset($_GET['debug'])){   
            print_r($dados_pedido);
        }
        
        if($response->status==200 || $response->status==201){
            
            $cod = $dados_pedido['Payment']['Type'];
            
            $sql = 'SELECT * FROM `'._DB_PREFIX_.'cielo_webservice_links` WHERE pedido = "'.(int)$order->id.'"';
            $links = Db::getInstance()->getRow($sql);
            
            $this->smarty->assign(array(
                    'erro' => false,
                    'links' => $links,
                    'this_path' => $this->getPathUri(),
                    'dados' => $dados_pedido['Payment'],
                    'tipo' => $this->TipoPagamento($cod),
                    'status' => $this->status_nome($dados_pedido['Payment']['Status']),
                    'link_loja' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'/',
                    'total' => Tools::displayPrice($params['total_to_pay'], $params['currencyObj'], false),
                    'this_path_ssl' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->name.'/'
            ));
            return $this->display(__FILE__, 'views/templates/hook/cupom.tpl');
            
        }else{
            $cod = '';
            $cod .= isset($dados_pedido['Payment']['ReasonCode'])?$dados_pedido['Payment']['ReasonCode']:'999';
            $cod .= ' - '.(isset($dados_pedido['Payment']['ReasonMessage'])?$dados_pedido['Payment']['ReasonMessage']:'Erro desconhecido ou ambiente cielo offline! (atualize a p&aacute;gina) Se o problema continuar entre em contato com a loja informando numero de seu pedido #'.$order->id.'');
            
            $this->smarty->assign(array(
                    'erro' => true,
                    'log' => $cod,
                    'this_path' => $this->getPathUri(),
                    'link_loja' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'/',
                    'total' => Tools::displayPrice($params['total_to_pay'], $params['currencyObj'], false),
                    'this_path_ssl' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->name.'/'
            ));

            return $this->display(__FILE__, 'views/templates/hook/cupom.tpl');
            
        }

    }
    
    public function TipoPagamento($cod){
        switch($cod){
            case "EletronicTransfer": $status = "Transfer&ecirc;ncia Online";
            break;
            case "Boleto": $status = "Boleto Banc&aacute;rio";
            break;
            case "CreditCard": $status = "Cart&atilde;o de Cr&eacute;dito";
            break;
            case "DebitCard": $status = "Cart&atilde;o de D&eacute;bito";
            break;
            default: $status = "Cielo API";
            break;
        }
		return $status;
	}
    
    public function status_nome($cod){
        switch($cod){
            case "0": $status = "Aguardando o Pagamento";
            break;
            case "1": $status = "Autorizado";
            break;
            case "2": $status = "Aprovado";
            break;
            case "3": $status = "Não aprovado";
            break;
            case "10": $status = "Cancelado";
            break;
            case "12": $status = "Pendente";
            break;
            case "12": $status = "Abortado";
            break;
            default: $status = "Desconhecido";
            break;
        }
		return $status;
	}
}
