<?php
class CieloApiPro5CronModuleFrontController extends ModuleFrontController{

	public $display_column_left = false;
	public $display_column_higt = false;
    public $display_header = false;
    public $display_header_javascript = false;
    public $display_footer = false;
    public $ssl = true;

	public function initContent() {
		
		$this->display_column_left = false;
		$this->display_column_higt = false;
		
		parent::initContent();
		
		//ambiente
        $MID = trim(Configuration::get('CIELOAPIPRO5_ID'));
        $KEY = trim(Configuration::get('CIELOAPIPRO5_SECRET'));
        if(Configuration::get('CIELOAPIPRO5_TESTE')){
            $MID = 'daaec334-ac85-4c63-9564-f4a31be7b19b';
            $KEY = 'LTFYLLACRDYCIKMHTXBRVKGQYGDHOOVTCKGZUKRK';
            $urlweb = "https://apiquerysandbox.cieloecommerce.cielo.com.br/1/";
        }else{
            $urlweb = "https://apiquery.cieloecommerce.cielo.com.br/1/";
        }
        $headers = array(
            "Content-Type" => "application/json",
            "Accept" => "application/json",
            "MerchantId" => $MID,
            "MerchantKey" => $KEY,
            "RequestId" => "",
        );
        include_once(dirname(__FILE__).'/../../classes/restclient.php' );
        $api = new RestClient(array(
            'base_url' => $urlweb, 
            'headers' => $headers, 
        ));
        
		//pega dados do pedido shopline
		$sql = 'SELECT * FROM `'._DB_PREFIX_.'orders` WHERE module = "cieloapipro5" AND (current_state = "'.Configuration::get('CIELOAPIPRO5_INICIADA').'")';
		$res = Db::getInstance()->ExecuteS($sql);
		foreach ($res AS $key => $val){
			$sql_invoice = 'SELECT * FROM `'._DB_PREFIX_.'cielo_webservice` WHERE `pedido` = "'.$val['id_order'].'"';
			$dados_invoice = Db::getInstance()->getRow($sql_invoice);
			if($dados_invoice){
				
				echo 'Consultar transacao '.$dados_invoice['pan'].' via '.$dados_invoice['produto'].' junto a cielo!<br>';
				
				$response = $api->get("sales/".$dados_invoice['pan']."");
				$dados_pedido = @json_decode($response->response,true);
				if($response->status==200 || $response->status==201){
					//print_r($dados_pedido);
					
					//status
					$status_mudar = false;
					switch($dados_pedido['Payment']['Status']){
						case 2:
						$nome_status = 'Pago';
						$status_mudar = Configuration::get('CIELOAPIPRO5_PAGO');
						break;
						case 1:
						$nome_status = 'Autorizado';
						$status_mudar = Configuration::get('CIELOAPIPRO5_AU');
						break;
						case 3:
						$nome_status = 'Negado';
						$status_mudar = Configuration::get('CIELOAPIPRO5_NAO_PAGA');
						break;
						case 10:
						case 13:
						$nome_status = 'Cancelado';
						$status_mudar = Configuration::get('CIELOAPIPRO5_CANCELADA');
						break;
					}
					
					//atualizar
					if($status_mudar){
						
						//pedido
						$order = new Order($val['id_order']);	
						if($order->getCurrentState()!=$status_mudar){
						
							//log
							$msglog = '[CRON] Atualização de transação para "'.$nome_status.'".';

							//cria um log para o pedido
							$msg = new Message();
							$message = strip_tags($msglog, '<br>');
							if (($message)){
								$msg->message = $message;
								$msg->id_order = intval($order->id);
								$msg->private = 1;
								$msg->add();
							}
							
							$history = new OrderHistory();
							$history->id_order = (int)$order->id;
							$history->id_order_state = (int)$status_mudar;
							$history->add();
							$order->current_state = $history->id_order_state;
							$order->update();
							$order->setInvoice();
						
						}
					}
				
				}
			}
		}
		
	}


}
