<?php
class CieloApiPro5ParcelasDModuleFrontController extends ModuleFrontController{

	public $ssl = true;
	public $display_column_left = false;
	public $display_column_higt = false;

	public function initContent() {
		parent::initContent();
		
		@header('Content-Type: application/json');
		
		//valida a bandeira
		$linhas = array();
		if($_GET['id']=='null'){
			$linhas[''] = "Clique no cartão qual deseja usar!";
			echo json_encode($linhas);
			exit;
		}

        //carinho
        $cart = new Cart($this->context->cart->id);
        $total_pedido = $cart->getOrderTotal(true, Cart::BOTH);
        $frete = $cart->getOrderTotal(true, 5);      
        
        //pega os dados e vars
        $desconto = (float)Configuration::get('CIELOAPIPRO5_DESC_DEB');

        $total = $total_puro  = number_format($total_pedido, 2, '.', '');

        //corrije bug erro etapa2
        $total = number_format($total, 2, '.', '');

        //avista
        if($desconto>0){
            $desconto_valor = (($total-$frete)/100)*$desconto;
            $linhas[base64_encode('1|1|'.number_format(($total-$desconto_valor), 2, '.', '').'|'.base64_encode($_GET['id']).'|'.base64_encode($total).'|'.md5(($total-$desconto_valor)))] = "&Agrave; vista por ".Tools::displayPrice(number_format(($total-$desconto_valor), 2, '.', ''))." (j&aacute; com ".$desconto."% off)";
        }else{
            $linhas[base64_encode('1|1|'.number_format(($total), 2, '.', '').'|'.base64_encode($_GET['id']).'|'.base64_encode($total).'|'.md5($total))] = "&Agrave; vista por ".Tools::displayPrice(number_format(($total), 2, '.', ''))."";
        }

        echo json_encode($linhas);
		exit;
	}
}
