<?php
/* SSL Management */
$useSSL = true;

require_once(dirname(__FILE__).'/../../config/config.inc.php');
require_once(dirname(__FILE__).'/../../init.php');
require_once(dirname(__FILE__).'/correiosoffpro5.php');

//tabela customizada
Db::getInstance()->execute("CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."prazos_entrega` (
	`id` INT(11) NOT NULL AUTO_INCREMENT,
	`id_carrinho` INT(11) NULL DEFAULT '0',
	`id_transportadora` INT(11) NULL DEFAULT '0',
	`prazo` CHAR(50) NULL DEFAULT '0',
	UNIQUE INDEX `id_carrinho_id_transportadora` (`id_carrinho`, `id_transportadora`),
	INDEX `id` (`id`)
)
ENGINE=InnoDB
AUTO_INCREMENT=9;");
 
//init
$context = Context::getContext();

//valida 
if(!isset($_POST['cep'])){
	die('Ops, acesso negado!');
}

//dados 
$cep = preg_replace('/\D/', '', $_POST['cep']);
$cliente_id = (int)(isset($context->customer->id)?$context->customer->id:0);

//salva o cep no cookie 
$context->cookie->__set('postcode',$cep);

//endereco temporario do cliente
$addr_temp = new Address();
$addr_temp->id_customer = $cliente_id;
$addr_temp->id_country = Configuration::get('PS_COUNTRY_DEFAULT');
$addr_temp->id_state = 0;
$addr_temp->postcode = $cep;
$addr_temp->firstname = ".";
$addr_temp->lastname = ".";
$addr_temp->address1 = ".";
$addr_temp->address2 = ".";
$addr_temp->city = ".";
$addr_temp->numend = ".";
$addr_temp->number = ".";
$addr_temp->numero = ".";
$addr_temp->compl = ".";
$addr_temp->complemento = ".";
$addr_temp->phone = ".";
$addr_temp->phone_mobile = ".";
$addr_temp->dni = ".";
$addr_temp->vat_number = ".";
$addr_temp->other = ".";
$addr_temp->alias = "TEMPORARY_ADDRESS_TO_DELETE";
$addr_temp->save();
$endereco_temp = $addr_temp;

//cria um novo carrinho sempre
$cart = new Cart();
$cart->id_lang = (int)Configuration::get('PS_LANG_DEFAULT');
$cart->id_currency = (int)Configuration::get('PS_CURRENCY_DEFAULT');
$cart->id_customer = $cliente_id;
$cart->id_address_delivery = $addr_temp->id;
$cart->add();

//add o produto
$products = $context->cart->getProducts();
foreach ($products as $key => $product) {
	$cart->updateQty($product['quantity'], $product['id_product'], $product['id_product_attribute']);
}
$cart_temp = $cart;

//simula o frete
$transportadoras = $cart->simulateCarriersOutput();

//remove o endereço temporario
$addr_temp->delete();

//remove o carrinho temporario
$cart->delete();

//processa as transportadoras 
$transportadoras_modificadas = array();
foreach($transportadoras as $k => $v){
	//pega prazo custom 
	$sql = "SELECT * FROM `" . _DB_PREFIX_ . "carrier` AS a 
	LEFT JOIN `" . _DB_PREFIX_ . "prazos_entrega` AS b ON(a.id_carrier = b.id_transportadora AND b.id_carrinho = '".(int)$cart_temp->id."')
	WHERE a.active = 1 AND a.deleted = 0 AND a.name = '".($v['name'])."'";
	$custom = Db::getInstance()->getRow($sql);
	if(isset($custom['prazo']) && !empty($custom['prazo'])){
		if($custom['prazo'] > 1){
			$prazo = 'Em at&eacute; '.$custom['prazo'].' dias &uacute;teis';
		}else{
			$prazo = 'Em at&eacute; '.$custom['prazo'].' dia util';
		}
		$transportadoras_modificadas[$k] = array_merge($v,array('delay'=>$prazo,'custom'=>$custom));
	}else{
		$transportadoras_modificadas[$k] = array_merge($v,array('custom'=>$custom));
	}
}

//retorna os dados do hook
if(Configuration::get('CORREIOSOFFPRO5_HOOK')==1){
	$obj = new CorreiosOffPro5();
	$hook = Hook::exec('displayBeforeCarrier', array(), $obj->id);
}else{
	$hook = '';
}

$json = array('endereco_temp'=>$endereco_temp,'cart'=>$cart_temp,'hook'=>$hook,'fretes'=>$transportadoras_modificadas);

echo json_encode($json);
exit;
?>