<?php
class AdminCorreiosOffPro5TabelasController extends ModuleAdminController
{
	public function __construct()
	{
        $this->bootstrap = true;
		parent::__construct();
	}
	
	public function initPageHeaderToolbar()
    {
        parent::initPageHeaderToolbar();
		if (empty($this->display)) {
			$this->page_header_toolbar_btn['configurar_correios'] = array(
				'class' => 'fix_icons',
                'href' => $this->context->link->getAdminLink('AdminCorreiosOffPro5Config', true),
                'desc' => $this->l('Configurar', null, null, false),
                'icon' => 'icon-gear'
            );
        }
    }
    
    public function createTemplate($tpl_name) 
    {
        if (file_exists($this->getTemplatePath() . $tpl_name) && $this->viewAccess())
                return $this->context->smarty->createTemplate($this->getTemplatePath() . $tpl_name, $this->context->smarty);
            return parent::createTemplate($tpl_name);
    }
	
	public function total_ceps_base($servico=null)
	{
        $sql = "SELECT COUNT(*) as total FROM `" . _DB_PREFIX_ . "correios_offline5_base` ORDER BY base_cep ASC"; 
		$dados = Db::getInstance()->getRow($sql);
		return $dados['total'];
    }
	
	public function pegar_ceps_base($servico=null)
	{
        $sql = "SELECT * FROM `" . _DB_PREFIX_ . "correios_offline5_base` ORDER BY base_cep ASC"; 
		return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
    }
	
	public function index()
    {
        $tpl = $this->createTemplate('metodos.tpl');
		$sql = "SELECT *,(SELECT COUNT(*) FROM `" . _DB_PREFIX_ . "correios_offline5_cotacoes` AS c
        WHERE c.id_servico = a.id_servico AND c.erro = 0) AS registros,(SELECT COUNT(*) FROM `" . _DB_PREFIX_ . "correios_offline5_base` AS d) AS registros_totais FROM `" . _DB_PREFIX_ . "correios_offline5_servicos` AS a 
        JOIN `" . _DB_PREFIX_ . "correios_offline5_servicos_cadastrados` AS b ON(a.id_servico=b.id_servico AND b.removidos=0) 
		WHERE a.suporte_offline = 1
        ORDER BY a.nome ASC";
		$metodos = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$tpl->assign(array(
			'metodos' => $metodos,
			'url' => $this->context->link->getAdminLink('AdminCorreiosOffPro5Tabelas', true),
		));
		$this->context->smarty->assign(array('content' => $tpl->fetch()));
    }
	
	public function atualizar()
	{
		$tpl = $this->createTemplate('atualizar.tpl');
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "correios_offline5_servicos` AS a
        JOIN `" . _DB_PREFIX_ . "correios_offline5_servicos_cadastrados` AS b ON(a.id_servico=b.id_servico AND b.removidos=0) 
        WHERE a.id_servico = '".$_GET['id_servico']."'";
		$detalhes = Db::getInstance()->getRow($sql);
		$ceps_base = $this->pegar_ceps_base($detalhes['id_servico']);
        $pulo = 100/$this->total_ceps_base($detalhes['id_servico']);
		$tpl->assign(array(
			'detalhes' => $detalhes,
			'ceps_base' => $ceps_base,
			'login' => trim(Configuration::get('CORREIOSOFFPRO5_LOGIN')),
			'senha' => trim(Configuration::get('CORREIOSOFFPRO5_SENHA')),
			'pulo' => $pulo,
			'url' => $this->context->link->getAdminLink('AdminCorreiosOffPro5Tabelas', true),
		));
		$this->context->smarty->assign(array('content' => $tpl->fetch()));
	}
	
	public function api()
	{
		$api = trim(Configuration::get('CORREIOSOFFPRO5_API'));
		$json = array();
        $meio = str_pad($_POST['servico'], 5, "0", STR_PAD_LEFT);
        $para = str_pad($_POST['cep'], 8, "0", STR_PAD_LEFT);
        $inicio = (int)$_POST['de'];
        $fim = (int)$_POST['para'];
		$custom = (int)$_POST['faixa_custom'];
		$erros = array();
		$array_pesos = array(0.3,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30);
        foreach($array_pesos as $key => $i){
            $cod_erro = 99;
            $frete = $prazo = 0;
            $acao = $this->verificar_se_atualizado($meio,$i,$para);
            $dias = isset($acao['dias'])?$acao['dias']:0;
            if($acao['acao']=='criar'){
				if($api=='webservice'){
					$resultado = $this->calcular($para,$i,$meio); 
				}else{
					$resultado = $this->calcular_rest($para,$i,$meio); 
				}
				if(isset($resultado['cServico']['Erro'])){
					$frete = (float)str_replace(',', '.', str_replace('.', '', $resultado['cServico']['Valor']));
					$cod_erro = isset($resultado['cServico']['Erro'])?$resultado['cServico']['Erro']:'';
					$log_erro = is_string($resultado['cServico']['MsgErro'])?$resultado['cServico']['MsgErro']:'';
					$prazo = $resultado['cServico']['PrazoEntrega'];
					$url_correios = isset($resultado['url_correios'])?$resultado['url_correios']:'';
					//cria a cotacao
					$sql = "INSERT INTO `" . _DB_PREFIX_ . "correios_offline5_cotacoes` (`id_servico`, `erro`, `log_erro`, `valor`, `peso`, `prazo`, `cep_base`, `cep_inicio`, `cep_fim`, `atualizado`, `custom`, `url`) VALUES ('".$meio."', '".(($frete>0)?'0':$cod_erro)."', '".$log_erro."', '".$frete."', '".$i."', '".$prazo."', '".$para."', '".$inicio."', '".$fim."', NOW(), '".$custom."', '".$url_correios."');";
					Db::getInstance()->execute($sql);
					//atualiza 
					$sql = "UPDATE `" . _DB_PREFIX_ . "correios_offline5_servicos` SET atualizado = NOW() WHERE id_servico = '".$meio."'";
					Db::getInstance()->execute($sql);
				}else{
					$erros[$para][$i] = $resultado;
				}
            }elseif($acao['acao']=='atualizar'){
                if($api=='webservice'){
					$resultado = $this->calcular($para,$i,$meio); 
				}else{
					$resultado = $this->calcular_rest($para,$i,$meio); 
				}
                if(isset($resultado['cServico']['Erro'])){
					$frete = (float)str_replace(',', '.', str_replace('.', '', $resultado['cServico']['Valor']));
					$cod_erro = $resultado['cServico']['Erro'];
					$log_erro = is_string($resultado['cServico']['MsgErro'])?$resultado['cServico']['MsgErro']:'';
					$prazo = $resultado['cServico']['PrazoEntrega'];
					$url_correios = isset($resultado['url_correios'])?$resultado['url_correios']:'';
					//atualiza a cotacao
					$sql = "UPDATE `" . _DB_PREFIX_ . "correios_offline5_cotacoes` SET `erro` = '".(($frete>0)?'0':$cod_erro)."', `log_erro` = '".$log_erro."', `valor` = '".$frete."', `prazo` = '".$prazo."', `cep_base` = '".$para."', `cep_inicio` = '".$inicio."', `cep_fim` = '".$fim."', `atualizado` = NOW(), `custom` = '".$custom."', url = '".$url_correios."' WHERE id = '".$acao['id']."'";
					Db::getInstance()->execute($sql);
					//atualiza 
					$sql = "UPDATE `" . _DB_PREFIX_ . "correios_offline5_servicos` SET atualizado = NOW() WHERE id_servico = '".$meio."'";
					Db::getInstance()->execute($sql);

                }else{
					$erros[$para][$i] = $resultado;
				}
            }else{
                $cod_erro = 0;
                $frete = $prazo = 'atualizado';
            }
            $json[$para][$i] = array('dias'=>$dias,'erro'=>$cod_erro,'frete'=>$frete,'prazo'=>$prazo,'erros'=>$erros);
        }
        echo json_encode($json);
	}
	
	public function conectar_curl($url) 
	{
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FAILONERROR, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, Configuration::get('CORREIOSOFFPRO5_TIME_OUT'));
        $result = curl_exec($ch);
        curl_close($ch);
        libxml_use_internal_errors(true);
        $xml = @simplexml_load_string($result);
        if(!$xml){
            return false;
        }
        if(!is_object($xml)) {
            return false;
        }
        $resultado = json_decode(json_encode($xml),true);
		return array_merge($resultado,array('url_correios'=>$url));
    }
	
	public function calcular($para,$peso,$meio)
	{
		$meio = str_pad($meio, 5, "0", STR_PAD_LEFT);
        $de = preg_replace('/\D/', '', Configuration::get('CORREIOSOFFPRO5_CEP'));
        $para = preg_replace('/\D/', '', $para);
        $lados = round(sqrt($peso),2);
        $alt = ($lados>=2)?$lados:2;
        $larg = ($lados>=11)?$lados:11;
        $comp = ($lados>=16)?$lados:16;
        $url = "http://ws.correios.com.br/calculador/CalcPrecoPrazo.aspx?";
        $url .=	"nCdEmpresa=".trim(Configuration::get('CORREIOSOFFPRO5_LOGIN'));
        $url .=	"&sDsSenha=".trim(Configuration::get('CORREIOSOFFPRO5_SENHA'));
        $url .=	"&sCepOrigem=".$de;
        $url .=	"&sCepDestino=".$para;
        $url .=	"&nVlPeso=".number_format($peso, 2, ',', '');
        $url .=	"&nCdFormato=1";
        $url .=	"&nVlComprimento=".number_format($comp, 2, ',', '');
        $url .=	"&nVlLargura=".number_format($larg, 2, ',', '');
        $url .=	"&nVlAltura=".number_format($alt, 2, ',', '');
        $url .=	"&sCdMaoPropria=n";
        $url .=	"&nVlValorDeclarado=0";
        $url .=	"&sCdAvisoRecebimento=n";
        $url .=	"&nCdServico=".$meio;
        $url .=	"&nVlDiametro=0";
        $url .=	"&StrRetorno=xml";
        return $this->conectar_curl($url);
    }
	
	public function calcular_rest($para,$peso,$meio)
	{
		//token nao ok
		$token_api = $this->module->token_de_acesso_correios();
		if(!isset($token_api['dados']['token'])){
			return array('erro'=>true,'log'=>$token_api);
		}else{
			//dados 
			$meio = str_pad($meio, 5, "0", STR_PAD_LEFT);
			$para = preg_replace('/\D/', '', $para);
			$lados = round(sqrt($peso),2);
			$alt = ($lados>=2)?$lados:2;
			$larg = ($lados>=11)?$lados:11;
			$comp = ($lados>=16)?$lados:16;
			//token rest
			$token = trim($token_api['dados']['token']);
			$codServico = $meio;
			//dados a calcular 
			$dados = array();
			$dados['psObjeto']=$peso*1000;
			$id_contrato_correios = Configuration::get('CORREIOSOFFPRO5_CONTRATO');
			$id_dr_correios = Configuration::get('CORREIOSOFFPRO5_DR');
			if(!empty(trim($id_contrato_correios))){
				$dados['nuContrato'] = trim($id_contrato_correios);
				$dados['nuDR'] = trim($id_dr_correios);
			}
			$dados['cepOrigem']=preg_replace('/\D/', '', Configuration::get('CORREIOSOFFPRO5_CEP'));
			$dados['cepDestino']=$para;
			$dados['VlDeclarado']=0.00;
			$dados['tpObjeto']=2;
			$dados['comprimento']=$comp;
			$dados['largura']=$larg;
			$dados['altura']=$alt;
			$resultado = $this->module->get_frete_correios($codServico,$dados,$token);
			$resultado_prazo = $this->module->get_prazo_correios($codServico,$dados,$token);
			if(isset($resultado['dados']['pcFinal'])){
				return array(
					'cServico' => array(
						'Erro' => 0,
						'PrazoEntrega' => (isset($resultado_prazo['dados']['prazoEntrega'])?$resultado_prazo['dados']['prazoEntrega']:10),
						'MsgErro' => '',
						'Valor' => $resultado['dados']['pcFinal']
					)
				);
			}else{
				return array('erro'=>true,'calculo'=>array_merge(array('original'=>$dados),array('preco'=>$resultado),array('prazo'=>$resultado_prazo)));
			}
		}
    }

	public function verificar_se_atualizado($servico,$peso,$para)
	{
        $sql = "SELECT *,DATEDIFF(atualizado,NOW()) AS dias_atualizado FROM `" . _DB_PREFIX_ . "correios_offline5_cotacoes` WHERE id_servico = '".$servico."' AND peso = ".number_format($peso, 2, '.', '')." AND cep_base = '".$para."'";
		$row = Db::getInstance()->getRow($sql);
        if(!$row || count($row)==0){
            return array('acao'=>'criar');
        }elseif($row['erro'] <> 0 || $row['dias_atualizado'] > 30){
            return array('id'=>$row['id'],'dias'=>$row['dias_atualizado'],'acao'=>'atualizar');
        }else{
            return array('dias'=>$row['dias_atualizado'],'acao'=>'atualizado');
        }
    }

	public function initContent()
    {
        parent::initContent();
        $acao = isset($_GET['acao'])?$_GET['acao']:'';
        switch($acao){
			case 'api':
			$this->api();
			break;
			case 'atualizar':
			$this->atualizar();
			break;
			case 'valores':
			$this->valores();
			break;
			case 'limpar':
			$this->limpar();
			break;
            default:
            $this->index();
        }
    }
	
	public function limpar()
	{
		Db::getInstance()->execute("DELETE FROM `" . _DB_PREFIX_ . "correios_offline5_cotacoes` WHERE id_servico = '".$_GET['id_servico']."'");
		$this->index();
	}
	
	public function valores()
    {
        $tpl = $this->createTemplate('valores.tpl');
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "correios_offline5_cotacoes` AS a 
		JOIN `" . _DB_PREFIX_ . "correios_offline5_servicos_cadastrados` AS b ON(a.id_servico=b.id_servico AND b.removidos=0) 
		WHERE a.id_servico = '".$_GET['id_servico']."' ORDER BY a.cep_base ASC, a.peso ASC";
		$valores = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$tpl->assign(array(
			'valores' => $valores,
			'url' => $this->context->link->getAdminLink('AdminCorreiosOffPro5Tabelas', true),
		));
		$this->context->smarty->assign(array('content' => $tpl->fetch()));
    }

}
