<?php
class CorreiosOffPro5RastrearModuleFrontController extends ModuleFrontController
{
	public $ssl = true;
    public $display_column_left = false;
	public $display_column_right = false;
    public $tipo_rastreio = 0;
    
	public function initContent()
	{
		$this->display_column_left = true;
		$this->display_column_right = true;
		parent::initContent();

		@header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
		@header("Cache-Control: post-check=0, pre-check=0", false);
		@header("Pragma: no-cache");

		$headers = array(
			"Content-Type: application/json",
		);
		$obj = isset($_GET['obj'])?$_GET['obj']:'XXXXXXXXXXXX';
		
		$nova = 'https://www.meusenvios.com.br/rastreamento-correios.php?objeto='.$obj.'';
		Tools::redirectLink($nova);
		exit;
		
		$url = 'https://api.melhorrastreio.com.br/api/v1/trackings/'.$obj.'';
		$ch = curl_init(); 
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_URL, $url); 
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
		curl_setopt($ch, CURLOPT_TIMEOUT, 20); 
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_POST, false); 
		$curlErrno  = curl_errno($ch);
		$curlErr    = curl_error($ch);
		$xml = curl_exec($ch); 
		$info = curl_getinfo($ch);
		curl_close($ch);
		$p = @json_decode($xml,true);
	
		$html_obj = '';
		if(isset($p['data']['events'])){
			$html_obj .= '<table class="table table-striped"><thead><tr><th width="15%">Data</th><th>Local/Situa&ccedil;&atilde;o</th></tr></thead>';     
			foreach($p['data']['events'] AS $evento){
				$html_obj .= '<tr>
					<td>'.date('d/m/Y',strtotime($evento['date'])).' '.date('H:i:s',strtotime($evento['date'])).'</td>
					<td>'.(!empty($evento['city'])?$evento['city'].'/'.$evento['uf']:'').' '.(!empty($evento['local'])?'('.$evento['local'].')':'').'<br><i>'.$evento['events'].' '.(!empty($evento['destination_city'])?' para '.$evento['destination_city'].'/'.$evento['destination_uf']:'').' '.(!empty($evento['destination_local'])?'('.$evento['destination_local'].')':'').'</i></td>
					</tr>';
			}
			$html_obj .= '</table>';
		}else{
			$html_obj .= 'Problema ao conectar-se ao sistema correios, o objeto informado nao existe, objeto postado recentemente ou servidor fora do ar! Tente novamente mais tarde.';
		}
		
		$this->context->smarty->assign(array(
			'html' => $html_obj,
			'this_path' => $this->module->getPathUri(),
			'this_path_ssl' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->module->name.'/'
		));
		$this->setTemplate('module:correiosoffpro5/views/templates/front/rastrear6.tpl');
	}
}
?>