
processar = 'sim';

$(document).ready(function(){

    if (processar == 'sim') {
        processar = 'nao';

        var valor = 0;

        if ($("#our_price_display").length ){
            valor = $('#our_price_display').text();
        }

        procParcelamento(valor);
    }

    $('#our_price_display').change(function(){
        var valor = $(this).text();
        procParcelamento(valor);
    })

});

function procParcelamento(valor) {

    // Recupera url Funcoes
    var urlFuncoes = decodeURIComponent(readCookie('fkparcg2_url_funcoes'));

    $.post(urlFuncoes, {func: '1', valor: valor}, function(retorno) {

        if (retorno.length > 1) {

            retorno = retorno.trim();

            if (retorno.substring(0,1) == '{') {

                var arRet = JSON.parse(retorno);

                // Processa Parcelamento 1
                var html = criaHtml(arRet.parcelamento1, '1');

                if (html != '') {
                    $("#fkparcg2_table_1").remove();
                    $("#fkparcg2_parcelas_1").append(html);
                    $("#fkparcg2_parcelamento_1").css("display", "block");
                }else {
                    $("#fkparcg2_msg_1").html('Parcelamento não disponível para o produto.');
                    $("#fkparcg2_msg_1").css("display", "block");
                }

                // Processa Parcelamento 2
                var html = criaHtml(arRet.parcelamento2, '2');

                if (html != '') {
                    $("#fkparcg2_table_2").remove();
                    $("#fkparcg2_parcelas_2").append(html);
                    $("#fkparcg2_parcelamento_2").css("display", "block");
                }else {
                    $("#fkparcg2_msg_2").html('Parcelamento não disponível para o produto.');
                    $("#fkparcg2_msg_2").css("display", "block");
                }

                // Processa Parcelamento legenda
                var html = criaHtmlLegenda(arRet.parcelamento1, '1');

                if (html != '') {
                    $("#fkparcelamento_tln").html(html);
                }else {
                   
                }

            }else {
                $("#fkparcg2_msg_2").html('Ooops! Ocorreu algum erro. Tente recarregar a página ou entre em contato com o Atendimentos ao Cliente.');
                $("#fkparcg2_msg_2").css("display", "block");
            }
        }else {
            $("#fkparcg2_msg_2").html('Ooops! Ocorreu algum erro. Tente recarregar a página ou entre em contato com o Atendimentos ao Cliente.');
            $("#fkparcg2_msg_2").css("display", "block");
        }

    });

}

function criaHtmlLegenda(parcelamento, id) {

    var parcelas = parcelamento.length;
    var html = '';

    if (parcelas > 0) {
        parcelas -= 1;
        total_sem_juros = parcelamento[parcelas].total_sem_juros - 1;
    }

    //if(($total_sem_juros > 0) || ($totalParcelas_1 > 0)) {
    if(parcelas > 0) {
        //html  += '<span id="fkparcelamento_tln">';
        if(parcelas > total_sem_juros){
            
            html += '<span class="parcelamento_sem_juros" style="display:block">Até '+parcelamento[total_sem_juros].parcela+'x de <strong>R$ '+parcelamento[total_sem_juros].valor+'</strong> sem juros</span>';
            html += '<span class="parcelamento_com_juros" style="display:block">ou '+parcelamento[parcelas].parcela+'x de <strong>R$ '+parcelamento[parcelas].valor+'</strong> com juros</span>';
        } else {
            html += '<span class="parcelamento_sem_juros" style="display:block">Até '+parcelamento[parcelas].parcela+'x de <strong>R$ '+parcelamento[parcelas].valor+'</strong> sem juros</span>';
        }
        //html += '</span>';
        
        return html;
    } else {
        return html;
    }
}

function criaHtml(parcelamento, id) {

    var parcelas = parcelamento.length;
    var html = '';

    if (parcelas > 1) {

        html += '<table id="fkparcg2_table_' + id + '">';

        for (i = 0; i < parcelas; i=i+2){
            html += '<tr class="fkparcg2-tr">';
            html += '<td class="fkparcg2-td fkparcg2-td-parcela">' + parcelamento[i].parcela + '</td>';
            html += '<td class="fkparcg2-td fkparcg2-td-x">x</td>';
            html += '<td class="fkparcg2-td fkparcg2-td-valor">R$ ' + parcelamento[i].valor + '</td>';

            if ((i+1) < parcelas) {
                html += '<td class="fkparcg2-td fkparcg2-td-sep"></td>';
                html += '<td class="fkparcg2-td fkparcg2-td-parcela">' + parcelamento[i+1].parcela + '</td>';
                html += '<td class="fkparcg2-td fkparcg2-td-x">x</td>';
                html += '<td class="fkparcg2-td fkparcg2-td-valor"> R$ ' + parcelamento[i+1].valor + '</td>';
            }

            html += '</tr>'
        }

        html += '</table>'
    }

    return html;
}