<?php
class AdminPrePostagem5EnviosController extends ModuleAdminController
{
	public function __construct() {
        $this->bootstrap = true;
		parent::__construct();
	}
	
	public function initPageHeaderToolbar(){
        parent::initPageHeaderToolbar();
		if (empty($this->display)) {
			$this->page_header_toolbar_btn['prepostagem5_add_pacote'] = array(
				'class' => 'fix_icons',
                'href' => 'javascript:prepostagem5_add_pacote()',
                'desc' => $this->l('Criar Envio Avulso', null, null, false),
                'icon' => 'fa fa-plus'
            );
			$this->page_header_toolbar_btn['prepostagem5_fechar_plps'] = array(
				'class' => 'fix_icons',
                'href' => 'javascript:prepostagem5_fechar_plps()',
                'desc' => $this->l('Pré-Postagem', null, null, false),
                'icon' => 'fa fa-cubes'
            );
			$this->page_header_toolbar_btn['prepostagem5_status_conta'] = array(
				'class' => 'fix_icons',
                'href' => 'javascript:prepostagem5_status_conta()',
                'desc' => $this->l('Status API', null, null, false),
                'icon' => 'fa fa-globe'
            );
        }
    }
	
	public function createTemplate($tpl_name){
        if (file_exists($this->getTemplatePath() . $tpl_name) && $this->viewAccess())
                return $this->context->smarty->createTemplate($this->getTemplatePath() . $tpl_name, $this->context->smarty);
            return parent::createTemplate($tpl_name);
    }
	
	public function initContent() {
        parent::initContent();
		$acao = isset($_REQUEST['acao'])?$_REQUEST['acao']:'pedidos_pendentes';
		if($acao=='atualizar_servicos'){
			return $this->atualizar_servicos();
		}elseif($acao=='pedidos_pendentes'){
			return $this->pedidos_pendentes();
		}elseif($acao=='editar_envios'){
			return $this->editar_envios();
		}elseif($acao=='salvar_editar_pacote'){
			return $this->salvar_editar_pacote();
		}elseif($acao=='remover_envio'){
			return $this->remover_envio();
		}elseif($acao=='adicionar_envios'){
			return $this->adicionar_envios();
		}elseif($acao=='salvar_dados_pacote'){
			return $this->salvar_dados_pacote();
		}elseif($acao=='fechar_plps'){
			return $this->fechar_plps();
		}elseif($acao=='criar_pedido_loja'){
			return $this->criar_pedido_loja();
		}
    }
	
	private function atualizar_servicos(){
		//nova api
		$token_api = $this->module->token_de_acesso_correios();
		if(!isset($token_api['dados']['token'])){
			$json['erro'] = true;
			$json['log'] = ''.$token_api['status'].' - Erro ao obter o token api Correios!';
			if(isset($token_api['dados']['stackTrace'])){
				unset($token_api['dados']['stackTrace']);
			}
			$json['original'] = $token_api;
		}else{
			//consulta os serviços do contrato
			if(Configuration::get('PREPOSTAGEM5_AMBIENTE')=='H'){
				$urlweb = 'https://apihom.correios.com.br/meucontrato/v1/empresas/'.preg_replace('/\D/', '', Configuration::get('PREPOSTAGEM5_CNPJ')).'/contratos/'.preg_replace('/\D/', '', Configuration::get('PREPOSTAGEM5_CONTRATO')).'/cartoes/'.preg_replace('/\D/', '', Configuration::get('PREPOSTAGEM5_CARTAO')).'/servicos?page=0&size=1000';
			}else{
				$urlweb = 'https://api.correios.com.br/meucontrato/v1/empresas/'.preg_replace('/\D/', '', Configuration::get('PREPOSTAGEM5_CNPJ')).'/contratos/'.preg_replace('/\D/', '', Configuration::get('PREPOSTAGEM5_CONTRATO')).'/cartoes/'.preg_replace('/\D/', '', Configuration::get('PREPOSTAGEM5_CARTAO')).'/servicos?page=0&size=1000';
			}
			//header
			$headers = array(
				"Authorization: Bearer ".trim($token_api['dados']['token'])."",
				"Content-Type: application/json",
			);
			//curl
			$sessao_curl2 = curl_init();
			curl_setopt($sessao_curl2, CURLOPT_URL, $urlweb);
			curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($sessao_curl2, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($sessao_curl2, CURLOPT_POST, false);
			curl_setopt($sessao_curl2, CURLOPT_CONNECTTIMEOUT, 5);
			curl_setopt($sessao_curl2, CURLOPT_TIMEOUT, 10);
			curl_setopt($sessao_curl2, CURLOPT_RETURNTRANSFER, true);
			$resultado = $original = curl_exec($sessao_curl2);
			$resultado = @json_decode($resultado,true);
			$status    = curl_getinfo($sessao_curl2, CURLINFO_HTTP_CODE);
			curl_close($sessao_curl2);
			if(isset($resultado['itens'])){
				//remover servicos
				Db::getInstance()->execute("DELETE FROM `"._DB_PREFIX_."prepostagem5_servicos`;");
				//criar servico padrao sem relacionamento
				$sql = "INSERT INTO `"._DB_PREFIX_."prepostagem5_servicos` (cod_servico,cod_sigep_servico,nome_servico,ultima_atualizacao_servico,status_servico,fim_contrato_servico,chancela_servico) VALUES('0', '0', 'SEM SERVIÇO (ATUALIZE)', '".date('Y-m-d H:i:s')."','1','".date('Y-m-d H:i:s')."', '');";	
				Db::getInstance()->execute($sql);
				foreach($resultado['itens'] as $serv){
					if($serv['coSegmento']==3){
						//criar
						$sql = "INSERT INTO `"._DB_PREFIX_."prepostagem5_servicos` (cod_servico,cod_sigep_servico,nome_servico,ultima_atualizacao_servico,status_servico,fim_contrato_servico,chancela_servico) VALUES('".$serv['codigo']."', '".$serv['codigo']."', '".$serv['descricao']."', '".date('Y-m-d H:i:s')."','1','".date('Y-m-d H:i:s')."', '');";
						Db::getInstance()->execute($sql);
					}
				}
				$json['erro'] = false;
				$json['log'] = 'Serviços do contrato atualizados com sucesso!';
			}else{
				//erro
				$erro = array();
				if(isset($resultado['msgs'])){
					foreach($resultado['msgs'] as $err){
						$erro[] = $err;
					}
				}
				if(isset($resultado['causa'])){
					$erro[] = $resultado['causa'];
				}
				$json['erro'] = true;
				$json['log'] = ''.$status.' - Erro ao obter serviços Correios: '.implode(',',$erro).'!';
				if(isset($resultado['stackTrace'])){
					unset($resultado['stackTrace']);
				}
				$json['original'] = $resultado;
				$json['url'] = $urlweb;
			}
		}
		
		//debug
		if(Configuration::get('PREPOSTAGEM5_STATUS_DEBUG')){
			$this->module->salvar_log('[Pré-Postagem] Debug Atualizar Serviços em '.date('d/m/Y H:i:s').': '.http_build_query($json) );
		}
		
		die(json_encode($json));
	}
	
	private function pedidos_pendentes(){
		//filto 
		$where = '';
		if(isset($_GET['pacote'])){
			$where .= ' AND a.id_pacote = '.(int)$_GET['pacote'].' ';
		}
		$where = '';
		if(isset($_GET['s']) && !empty($_GET['s'])){
			$where .= " AND (a.id_plp LIKE '%".pSQL($_GET['s'])."%' || a.id_servico_pacote LIKE '%".pSQL($_GET['s'])."%' || a.id_pedido_pacote LIKE '%".pSQL($_GET['s'])."%' || a.nfe_pacote LIKE '%".pSQL($_GET['s'])."%' || a.cod_rastreio_pacote_dv LIKE '%".pSQL($_GET['s'])."%' || b.nome LIKE '%".pSQL($_GET['s'])."%' || b.logradouro LIKE '%".pSQL($_GET['s'])."%' || b.bairro LIKE '%".pSQL($_GET['s'])."%' || b.cidade LIKE '%".pSQL($_GET['s'])."%' || b.uf LIKE '%".pSQL($_GET['s'])."%' || b.cep LIKE '%".pSQL($_GET['s'])."%') ";
		}
		//layout
        $tpl = $this->createTemplate('envios_pendentes.tpl');
		//qtd registros
		$sql = "SELECT COUNT(*) AS total FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes` AS a 
		JOIN `" . _DB_PREFIX_ . "prepostagem5_pedidos` AS b ON(a.id_pacote IN(b.ids_pacotes))
		JOIN `" . _DB_PREFIX_ . "prepostagem5_servicos` AS c ON(a.id_servico_pacote=c.cod_servico)
		WHERE a.pacote_fechado = 0 $where ORDER BY a.id_pacote DESC";
        $row = Db::getInstance()->getRow($sql);
		$total_envios = $row['total'];
		//inicio paginacao 
		$pagina = (int)(isset($_GET['pagina'])?$_GET['pagina']:1);
		$registros = (int)Configuration::get('PREPOSTAGEM5_QTD_PAGINA',30);
		$registros = ($registros==0)?20:$registros;
		$inicio = ($registros*($pagina-1));
		$paginas = ceil( $total_envios / $registros );
		//registros
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes` AS a 
		JOIN `" . _DB_PREFIX_ . "prepostagem5_pedidos` AS b ON(a.id_pacote IN(b.ids_pacotes))
		JOIN `" . _DB_PREFIX_ . "prepostagem5_servicos` AS c ON(a.id_servico_pacote=c.cod_servico)
		WHERE a.pacote_fechado = 0 $where ORDER BY a.id_pacote DESC LIMIT $inicio,$registros";
		$envios_bd = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$envios = array();
		//envios
		foreach($envios_bd as $k=>$v){
			$envios[] = array_merge($v,array('endereco_valido'=>$this->module->validar_endereco($v)));
		}
		//status
		$nomes_status = array();
		foreach($this->module->status_nomes() as $k=>$v){
			$nomes_status[$v['id']]=$v['name'];
		}
		$tpl->assign(array(
			'envios' => $envios,
			'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/prepostagem5',
			'pagina' => $pagina,
			'total_envios' => $total_envios,
			'paginas' => $paginas,
			'lista_status_pagamentos' => $nomes_status,
			'extra'	=> '',
		));
		$this->context->smarty->assign(array('content' => $tpl->fetch()));
	}
	
	private function adicionar_envios(){
		//layout
        $tpl = $this->createTemplate('add_envios.tpl');
		$tpl->assign(array(
			'pacote' => null,
			'vd' => Configuration::get('PREPOSTAGEM5_VD'),
			'ar' => Configuration::get('PREPOSTAGEM5_AR'),
			'mp' => Configuration::get('PREPOSTAGEM5_MP'),
			'servicos_correios' => $this->module->servicos_cadastrados(),
			'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'/modules/prepostagem5',
		));
		die($tpl->fetch());
	}
	
	private function salvar_dados_pacote(){
		$ids_envios = array();
		//regras de validacoes
		if(isset($_POST['extras']) && (in_array('019',$_POST['extras']))){
			if($_POST['valor'] < $this->module->total_minimo){
				die('Serviço VD ativado, informe o valor declarado de no minimo '.$this->module->total_minimo.' !');
			}
		}
		if(!isset($_POST['peso']) || $_POST['peso'] > 30){
			die('O peso deverá ser informado e menor que 30kg!');
		}
		if(!isset($_POST['com']) || $_POST['com'] > 105){
			die('O comprimento deverá ser informado e menor que 105cm!');
		}
		if(!isset($_POST['alt']) || $_POST['alt'] > 105){
			die('A altura deverá ser informado e menor que 105cm!');
		}
		if(!isset($_POST['lar']) || $_POST['lar'] > 105){
			die('A largura deverá ser informado e menor que 105cm!');
		}
		if(($_POST['com']+$_POST['alt']+$_POST['lar']) > 200){
			die('A soma dos lados não pode ser maior que 200cm!');
		}
		$servicoMP = $servicoVD = $servicoAR = 0;
		if(isset($_POST['extras']) && (in_array('001',$_POST['extras']))){
			$servicoAR = 1;
		}
		if(isset($_POST['extras']) && (in_array('002',$_POST['extras']))){
			$servicoMP = 1;
		}
		if(isset($_POST['extras']) && (in_array('019',$_POST['extras']))){
			$servicoVD = 1;
		}
		if(empty($_POST['nota_fiscal']) && !isset($_POST['item'])){
			die('Para pré-postagem é obrigatorio informar o número da NFe ou informar os itens para declaração de conteúdo!');
		}
		if(!isset($_POST['servico']) || $_POST['servico']=='0' || $_POST['servico']=='00000'){
			die('Selecione um serviço de entrega válido!');
		}
		//cria o pacote
		Db::getInstance()->execute("INSERT INTO `" . _DB_PREFIX_ . "prepostagem5_pacotes` SET id_servico_pacote = '".pSQL($_POST['servico'])."', id_pedido_pacote = '".pSQL($_POST['pedido'])."', nfe_pacote = '".pSQL($_POST['nota_fiscal'])."', com_pacote = '".pSQL($_POST['com'])."', alt_pacote = '".pSQL($_POST['alt'])."', lar_pacote = '".pSQL($_POST['lar'])."', peso_pacote = '".pSQL($_POST['peso'])."', total_pacote = '".pSQL($_POST['valor'])."', servico_MP_pacote = '".pSQL($servicoMP)."', servico_VD_pacote = '".pSQL($servicoVD)."', servico_AR_pacote = '".pSQL($servicoAR)."', data_pacote = NOW()");
		$id_pacote = Db::getInstance()->Insert_ID();
		//cria o pedido
		$ids_envios = array();
		$ids_envios[] = $id_pacote;
		Db::getInstance()->execute("INSERT INTO `" . _DB_PREFIX_ . "prepostagem5_pedidos` SET nome = '".pSQL($_POST['nome'])."', logradouro = '".pSQL($_POST['log'])."', numero = '".pSQL($_POST['numero'])."', complemento = '".pSQL($_POST['comp'])."', bairro = '".pSQL($_POST['bairro'])."', cidade = '".pSQL($_POST['cidade'])."', uf = '".pSQL($_POST['uf'])."', cep = '".preg_replace('/\D/', '', $_POST['cep'])."', fiscal = '".preg_replace('/\D/', '', $_POST['fiscal'])."', telefone = '".pSQL($_POST['telefone'])."', email = '".pSQL($_POST['email'])."', ids_pacotes = '".implode(',',$ids_envios)."', data_pedido = NOW()");
		$id_pedido_sigep = Db::getInstance()->Insert_ID();
		//itens 
		if(isset($_POST['item']) && is_array($_POST['item'])){
			foreach($_POST['item'] as $item){
				if(!empty($item['nome'])){
					$sql = "INSERT INTO `" ._DB_PREFIX_. "prepostagem5_itens_dc` SET nome = '".pSQL($item['nome'])."', qtd = '".(int)$item['qtd']."', id_pedido = '".$id_pedido_sigep."', id_loja = '".(int)$_POST['pedido']."', valor = '".(float)$item['total']."';";
					Db::getInstance()->execute($sql);
				}
			}
		}
		echo 'true';
		exit;
	}
	
	private function editar_envios(){
		//registro
		$sql = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes` 
		JOIN `" . _DB_PREFIX_ . "prepostagem5_pedidos` ON(id_pacote IN(ids_pacotes))
		JOIN `" . _DB_PREFIX_ . "prepostagem5_servicos` ON(id_servico_pacote=cod_servico)
		WHERE pacote_fechado = 0 AND id_pacote = '".(int)$_GET['id']."'";
		$pacote = Db::getInstance()->getRow($sql);
		//itens 
		$itens = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS("SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_itens_dc` WHERE id_pedido = '".(int)$pacote['id_pedido']."'");
		//layout
        $tpl = $this->createTemplate('editar_envios.tpl');
		$tpl->assign(array(
			'pacote' => $pacote,
			'itens' => $itens,
			'total_itens' => count($itens),
			'servicos_correios' => $this->module->servicos_cadastrados(),
			'link_modulo' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'/modules/prepostagem5',
		));
		die($tpl->fetch());
	}
	
	private function salvar_editar_pacote(){
		$ids_envios = array();
		//regras de validacoes
		if(isset($_POST['extras']) && (in_array('019',$_POST['extras']))){
			if($_POST['valor'] < $this->module->total_minimo){
				die('Serviço VD ativado, informe o valor declarado de no minimo '.$this->module->total_minimo.'!');
			}
		}
		if(!isset($_POST['peso']) || $_POST['peso'] > 30){
			die('O peso deverá ser informado e menor que 30kg!');
		}
		if(!isset($_POST['com']) || $_POST['com'] > 105){
			die('O comprimento deverá ser informado e menor que 105cm!');
		}
		if(!isset($_POST['alt']) || $_POST['alt'] > 105){
			die('A altura deverá ser informado e menor que 105cm!');
		}
		if(!isset($_POST['lar']) || $_POST['lar'] > 105){
			die('A largura deverá ser informado e menor que 105cm!');
		}
		if(($_POST['com']+$_POST['alt']+$_POST['lar']) > 200){
			die('A soma dos lados não pode ser maior que 200cm!');
		}
		$servicoMP = $servicoVD = $servicoAR = 0;
		if(isset($_POST['extras']) && (in_array('001',$_POST['extras']))){
			$servicoAR = 1;
		}
		if(isset($_POST['extras']) && (in_array('002',$_POST['extras']))){
			$servicoMP = 1;
		}
		if(isset($_POST['extras']) && (in_array('019',$_POST['extras']))){
			$servicoVD = 1;
		}
		if(empty($_POST['nota_fiscal']) && !isset($_POST['item'])){
			die('Para pré-postagem é obrigatorio informar o número da NFe ou informar os itens para declaração de conteúdo!');
		}
		if(!isset($_POST['servico']) || $_POST['servico']=='0' || $_POST['servico']=='00000'){
			die('Selecione um serviço de entrega válido!');
		}
		//atualiza o pedido
		if(isset($_POST['id'])){
			Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_pedidos` SET nome = '".pSQL($_POST['nome'])."', logradouro = '".pSQL($_POST['log'])."', numero = '".pSQL($_POST['numero'])."', complemento = '".pSQL($_POST['comp'])."', bairro = '".pSQL($_POST['bairro'])."', cidade = '".pSQL($_POST['cidade'])."', uf = '".pSQL($_POST['uf'])."', cep = '".preg_replace('/\D/', '', $_POST['cep'])."', telefone = '".pSQL($_POST['telefone'])."', email = '".pSQL($_POST['email'])."', fiscal = '".preg_replace('/\D/', '', $_POST['fiscal'])."'  WHERE id_pedido = '".(int)$_POST['id']."' LIMIT 1");
		}
		//atualiza o pacote 
		if(isset($_POST['pacotes'])){
			Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_pacotes` SET id_servico_pacote = '".pSQL($_POST['servico'])."', id_pedido_pacote = '".pSQL($_POST['pedido'])."', nfe_pacote = '".pSQL($_POST['nota_fiscal'])."', com_pacote = '".pSQL($_POST['com'])."', alt_pacote = '".pSQL($_POST['alt'])."', lar_pacote = '".pSQL($_POST['lar'])."', peso_pacote = '".pSQL($_POST['peso'])."', total_pacote = '".pSQL($_POST['valor'])."', servico_MP_pacote = '".pSQL($servicoMP)."', servico_VD_pacote = '".pSQL($servicoVD)."', servico_AR_pacote = '".pSQL($servicoAR)."' WHERE FIND_IN_SET(id_pacote,'".$_POST['pacotes']."') LIMIT 1");
		}
		//atualiza os itens
		if(isset($_POST['item']) && is_array($_POST['item'])){
			$sql = "DELETE FROM `" ._DB_PREFIX_. "prepostagem5_itens_dc` WHERE id_pedido = '".(int)$_POST['id']."';";
			Db::getInstance()->execute($sql);
			foreach($_POST['item'] as $item){
				if(!empty($item['nome'])){
					$sql = "INSERT INTO `" ._DB_PREFIX_. "prepostagem5_itens_dc` SET nome = '".pSQL($item['nome'])."', qtd = '".(int)$item['qtd']."', id_pedido = '".(int)$_POST['id']."', id_loja = '".(int)$_POST['pedido']."', valor = '".(float)$item['total']."';";
					Db::getInstance()->execute($sql);
				}
			}
		}
		echo 'true';
		exit;
	}
	
	private function remover_envio(){
		if(isset($_POST['id'])){
			//remove
			Db::getInstance()->execute("DELETE FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes` WHERE id_pacote = '".(int)$_POST['id']."'");
			Db::getInstance()->execute("DELETE FROM `" . _DB_PREFIX_ . "prepostagem5_pedidos` WHERE ".(int)$_POST['id']." IN(ids_pacotes)");
			//log 
			$this->module->salvar_log('Pacote '.(int)$_POST['id'].' removido manualmente por Admin em '.date('d/m/Y H:i').'!');
		}
		echo 'OK';
		exit;
	}
	
	private function fechar_plps(){
		if(!isset($_GET['envios'])){
			die(json_encode(array('erro'=>true,'log'=>'Sem envios!')));
			exit;
		}
		$json = array();
		$envios = $this->module->array_plps_novo();
		//nova api
		$token_api = $this->module->token_de_acesso_correios();
		$id_unic_plp = $this->module->generate_string(10);
		$objetos_sucesso = array();
		$logs_resultados = array();
		if(!isset($token_api['dados']['token'])){
			$json['erro'] = true;
			$json['log'] = ''.$token_api['status'].' - Erro ao obter o token api Correios!';
			if(isset($token_api['dados']['stackTrace'])){
				unset($token_api['dados']['stackTrace']);
			}
			$json['original'] = $token_api;
		}elseif(is_array($envios) && !empty($envios)){
			//consulta os serviços do contrato
			if(Configuration::get('PREPOSTAGEM5_AMBIENTE')=='H'){
				$urlweb = 'https://apihom.correios.com.br/prepostagem/v1/prepostagens';
			}else{
				$urlweb = 'https://api.correios.com.br/prepostagem/v1/prepostagens';
			}
			//header
			$headers = array(
				"Authorization: Bearer ".trim($token_api['dados']['token'])."",
				"Content-Type: application/json",
			);
			//processa cada envio um a um 
			foreach($envios as $pedido=>$envio){
				//id do pacote 
				$id_pacote_unico = (int)preg_replace('/\D/', '', $envio['sequencial']);
				//request
				$sessao_curl2 = curl_init();
				curl_setopt($sessao_curl2, CURLOPT_URL, $urlweb);
				curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($sessao_curl2, CURLOPT_SSL_VERIFYHOST, false);
				curl_setopt($sessao_curl2, CURLOPT_HTTPHEADER, $headers);
				curl_setopt($sessao_curl2, CURLOPT_POST, true);
				curl_setopt($sessao_curl2, CURLOPT_POSTFIELDS, json_encode($envio));
				curl_setopt($sessao_curl2, CURLOPT_CONNECTTIMEOUT, 5);
				curl_setopt($sessao_curl2, CURLOPT_TIMEOUT, 10);
				curl_setopt($sessao_curl2, CURLOPT_RETURNTRANSFER, true);
				$resultado = $original = curl_exec($sessao_curl2);
				$resultado = @json_decode($resultado,true);
				$status    = curl_getinfo($sessao_curl2, CURLINFO_HTTP_CODE);
				curl_close($sessao_curl2);
				//debug
				if($status!=200 || Configuration::get('PREPOSTAGEM5_STATUS_DEBUG')){
					$this->module->salvar_log('[Pré-Postagem] Fechar PLP '.$envio['sequencial'].' Envio: '.print_r($envio,true));
					$this->module->salvar_log('[Pré-Postagem] Fechar PLP '.$envio['sequencial'].' Resultado: '.print_r($resultado,true));
					$this->module->salvar_log('[Pré-Postagem] Fechar PLP '.$envio['sequencial'].' Status: '.$status);
				}
				//ok
				if(isset($resultado['id'])){
					//objeto de rastreamento 
					$objeto = trim($resultado['codigoObjeto']);
					$id_plp_correios = trim($id_unic_plp);
					//atualiza a plp no banco de dados
					Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_pacotes` SET pacote_fechado = 1, `status_pacote` = 1, id_plp = '".trim($id_unic_plp)."' WHERE id_pacote = '".$id_pacote_unico."'");
					//atualiza o pacote 
					$log = ''.$id_pacote_unico.' - PLP '.$id_unic_plp.' solicitada com sucesso ('.$resultado['descStatusAtual'].')';
					Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_pacotes` SET num_pacote = '".$resultado['id']."', cod_rastreio_pacote_dv = '".$objeto."', erro = '".$log."' WHERE id_pacote = '".$id_pacote_unico."'");
					//se atrelado a um pedido valido
					$dados_pacote = $this->module->dados_pacote((int)$id_pacote_unico);					
					//se atrelado a um pedido valido 
					if((int)$dados_pacote['id_pedido_pacote'] > 0){
						$order = new Order($dados_pacote['id_pedido_pacote']);
						if($order){
							//status a fechar plps 
							$status_fechar = (int)Configuration::get('PREPOSTAGEM5_STATUS_FECHAR');
							if($status_fechar > 0){
								//variaveis a enviar no email 
								$vars_email = array();
								$vars_email['{link_rastreamento}'] = Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/prepostagem5/sro.php?objeto='.$dados_pacote['cod_rastreio_pacote_dv'].'';
								$vars_email['{objeto_correios}'] = $dados_pacote['cod_rastreio_pacote_dv'];
								$vars_email['{id_plp}'] = $id_plp_correios;
								//atualiza o pedido
								if($order->getCurrentState()!=$status_fechar){
									$history = new OrderHistory();
									$history->id_order = (int)$order->id;
									$history->id_order_state = (int)$status_fechar;
									$history->addWithemail(true,$vars_email);
									$order->current_state = $history->id_order_state;
									$order->shipping_number = $dados_pacote['cod_rastreio_pacote_dv'];
									$order->update();
								}else{
									$order->shipping_number = $dados_pacote['cod_rastreio_pacote_dv'];
									$order->update();
								}
								//atualiza o order carrier
								$envio_pedido = $this->module->envio_do_pedido($order);
								if(class_exists('OrderCarrier') && $envio_pedido){
									$order_carrier = new OrderCarrier($envio_pedido['id_order_carrier']);
									$order_carrier->tracking_number = $dados_pacote['cod_rastreio_pacote_dv'];
									$order_carrier->update();
								}
								//cria um log para o pedido
								$msglog = 'Envio Correios com Pré-Postagem PLP Fechada: '.$id_plp_correios.' e Objeto: '.$dados_pacote['cod_rastreio_pacote_dv'].' em '.date('d/m/Y H:i').'';
								$msg = new Message();
								$message = strip_tags($msglog, '<br>');
								if (($message)){
									$msg->message = $message;
									$msg->id_order = intval($order->id);
									$msg->private = 1;
									$msg->add();
								}
								//atualiza no banco de dados
								$status_pedido = $order->getCurrentState();
								$sql = "UPDATE `" . _DB_PREFIX_ . "prepostagem5_pedidos` SET `status_pedido_loja` = '".$status_pedido."' WHERE id_pedido_loja = '".$dados_pacote['id_pedido_pacote']."';";
								Db::getInstance()->execute($sql);
							}
						}
					}
					//ok
					$logs_resultados[$id_pacote_unico] = array('erro'=>false,'log'=>$log);
					$objetos_sucesso[] = $id_pacote_unico;
				}elseif(isset($resultado['msgs'])){
					//erro
					$erro = array();
					if(isset($resultado['msgs'])){
						foreach($resultado['msgs'] as $err){
							$erro[] = $err;
						}
					}
					if(isset($resultado['causa'])){
						$erro[] = $resultado['causa'];
					}
					$log = ''.$id_pacote_unico.' - Erro ao solicitar PLP: '.implode(',',$erro).'';
					Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_pacotes` SET erro = '".$log."' WHERE id_pacote = '".$id_pacote_unico."'");
					$logs_resultados[$id_pacote_unico] = array('erro'=>true,'log'=>$log);
				}else{
					$log = ''.$id_pacote_unico.' - Erro desconhecido ao solicitar PLP / '.$status.'';
					Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_pacotes` SET erro = '".$log."' WHERE id_pacote = '".$id_pacote_unico."'");
					$logs_resultados[$id_pacote_unico] = array('erro'=>true,'log'=>$log);
				}
			}
			$json['erro'] = false;
			$json['resultados'] = $logs_resultados;
		}else{
			$json['erro'] = true;
			$json['log'] = 'Nenhum request Json encontrado para pré-postagem!';
		}
		
		//cria a plp se tiver objetos com sucesso 
		if(count($objetos_sucesso) > 0){
			$sql = "INSERT INTO `" . _DB_PREFIX_ . "prepostagem5_plps` (`id_plp`, `uniq_id_plp`, `ids_pacotes`, `data_fechamento`, `status_plp`, `xml`) VALUES (NULL, '".$id_unic_plp."', '".implode(',',$objetos_sucesso)."', NOW(), 'Pendente', '".pSQL(json_encode($logs_resultados))."');";
			Db::getInstance()->execute($sql);
		}

		//debug
		if($json['erro']==true || Configuration::get('PREPOSTAGEM5_STATUS_DEBUG')){
			$this->module->salvar_log('[Pré-Postagem] Debug Fechar PLPs em '.date('d/m/Y H:i:s').': '.http_build_query($json) );
		}
		
		//retorna o json
		die(json_encode($json));
		exit;
	}
	
	private function criar_pedido_loja(){
		if(isset($_GET['pedido'])){
			$this->module->hookActionOrderStatusUpdate(array('id_order'=>(int)$_GET['pedido'],'forcar_criar'=>true));
		}
		Tools::redirectAdmin($this->context->link->getAdminLink('AdminPrePostagem5Envios', true));
		exit;
	}
}
?>