<?php 
class PrePostagem5Cron_SaraModuleFrontController extends ModuleFrontController
{
	public $ssl = true;
    public $display_column_left = false;
	public $display_column_right = false;
    
	public function initContent()
	{
		parent::initContent();
		//se desativado 
		if(!Configuration::get('PREPOSTAGEM5_STATUS')){
			die('Pré-Postagem - Desativado via Admin!');
		}
		//nova api
		$token_api = $this->module->token_de_acesso_correios();
		if(!isset($token_api['dados']['token'])){
			$erro = ''.$token_api['status'].' - Erro ao obter o token api Correios!';
			die($erro);
		}
		//registros das plps
		$query = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_plps` WHERE status_plp = 'Pendente' AND data_fechamento BETWEEN NOW() - INTERVAL 15 DAY AND NOW()";
		$plps = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);
		if(count($plps)==0){
			die('Nenhuma PLP a processar!');
		}
		//processa as plps
		$titulo_loja = Configuration::get('PS_SHOP_NAME');
		$log = '';
		$res = array();
		foreach($plps as $k=>$v){
			$pacotes = explode(',',$v['ids_pacotes']);
			$total_objetos = count($pacotes);
			$objetos_processados = 0;
			$total_plp = 0;
			foreach($pacotes as $kk=>$vv){
				//dados do pacote 
				$pac = $this->module->dados_pacote((int)$vv);
				if(!isset($pac['cod_rastreio_pacote_dv'])){
					continue;
				}
				//se ja finalizado
				if($pac['pacote_enviado']==1 || $pac['pacote_cancelado']==1 || $pac['pacote_entregue']==1){
					$objetos_processados++;
					continue;
				}
				//consulta
				$dados['codigoObjeto'] = trim($pac['cod_rastreio_pacote_dv']);
				$resultados = $this->module->consulta_objeto($dados);
				//log
				if(Configuration::get('PREPOSTAGEM5_STATUS_DEBUG')){
					$this->module->salvar_log('[Pré-Postagem] Status PLPs: '.print_r($resultados,true));
				}
				//ok
				if(isset($resultados['resultado'][0]['id'])){
					if(isset($pac['pacote_enviado']) && $pac['pacote_enviado']==0 && $pac['pacote_cancelado']==0 && $resultados['resultado'][0]['statusAtual']==3){
						//marca o objeto como enviado
						$res[] = $resultados['resultado'][0];
						$objetos_processados++;
						$total_postagem = isset($resultados['resultado'][0]['precoPrePostagem'])?(float)$resultados['resultado'][0]['precoPrePostagem']:0;
						$total_plp += $total_postagem;
						//log da postagem 
						$log_objeto = 'Objeto Postado / Valor da Pré-Postagem: '.$total_postagem.' ';
						if(isset($resultados['resultado'][0]['pesoPreAfericao'])){
							$log_objeto.= ' / Peso: '.$resultados['resultado'][0]['pesoPreAfericao'].'';
						}
						if(isset($resultados['resultado'][0]['comprimentoPreAfericao'])){
							$log_objeto.= ' / Com: '.$resultados['resultado'][0]['comprimentoPreAfericao'].'';
						}
						if(isset($resultados['resultado'][0]['alturaPreAfericao'])){
							$log_objeto.= ' / Alt: '.$resultados['resultado'][0]['alturaPreAfericao'].'';
						}
						if(isset($resultados['resultado'][0]['larguraPreAfericao'])){
							$log_objeto.= ' / Lar: '.$resultados['resultado'][0]['larguraPreAfericao'].'';
						}
						if(isset($resultados['resultado'][0]['statusAtual'])){
							$log_objeto.= ' / Status: '.$resultados['resultado'][0]['statusAtual'].'';
						}
						//mysql
						Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_pacotes` SET pacote_enviado = '1', valor_cobrado = '".$total_postagem."', erro = '".$log_objeto."' WHERE id_plp = '".$v['uniq_id_plp']."' AND cod_rastreio_pacote_dv = '".trim($pac['cod_rastreio_pacote_dv'])."'");
						//se atualiza o pedido na loja
						$order = null;
						if((int)$pac['id_pedido_pacote'] > 0){
							//pedidos que existe na loja
							$order = new Order((int)$pac['id_pedido_pacote']);
							if($order){
								//variaveis a enviar no email 
								$vars_email = array();
								$vars_email['{link_rastreamento}'] = Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/prepostagem5/sro.php?objeto='.$pac['cod_rastreio_pacote_dv'].'';
								$vars_email['{objeto_correios}'] = $pac['cod_rastreio_pacote_dv'];
								$vars_email['{id_plp}'] = $v['uniq_id_plp'];
								//atualiza o pedido para enviado 
								if(Configuration::get('PREPOSTAGEM5_STATUS_POSTAR') > 0){
									if($order->getCurrentState()!=Configuration::get('PREPOSTAGEM5_STATUS_POSTAR')){
										$history = new OrderHistory();
										$history->id_order = (int)$order->id;
										$history->id_order_state = (int)Configuration::get('PREPOSTAGEM5_STATUS_POSTAR');
										$history->addWithemail(true,$vars_email);
										$order->current_state = $history->id_order_state;
										$order->update();
									}
								}
								//cria um log para o pedido
								$msglog = 'Objeto '.$pac['cod_rastreio_pacote_dv'].' postado junto aos Correios em '.date('d/m/Y H:i').'';
								$msg = new Message();
								$message = strip_tags($msglog, '<br>');
								if (($message)){
									$msg->message = $message;
									$msg->id_order = intval($order->id);
									$msg->private = 1;
									$msg->add();
								}
								//atualiza o status no banco de dados
								$status_pedido = $order->getCurrentState();
								$sql = "UPDATE `" . _DB_PREFIX_ . "prepostagem5_pedidos` SET `status_pedido_loja` = '".$status_pedido."' WHERE id_pedido_loja = '".(int)$pac['id_pedido_pacote']."';";
								Db::getInstance()->execute($sql);
								//salva o envio no campo nativo prestashop
								Db::getInstance()->execute("UPDATE `" ._DB_PREFIX_. "order_carrier` SET `tracking_number` = '".trim($pac['cod_rastreio_pacote_dv'])."' WHERE id_order = '".(int)$order->id."'");
							}
						}
						//log geral
						$log .= 'PLP: '.$v['uniq_id_plp'].' / Objeto: '.trim($pac['cod_rastreio_pacote_dv']).' - '.$log_objeto.'!<br>';
					}elseif(isset($pac['pacote_enviado']) && $pac['pacote_enviado']==0 && $pac['pacote_cancelado']==0 && ($resultados['resultado'][0]['statusAtual']==4 || $resultados['resultado'][0]['statusAtual']==5 || $resultados['resultado'][0]['statusAtual']==6)){
						//cancelado
						$res[] = $resultados['resultado'][0];
						$objetos_processados++;
						//mysql
						$log_objeto = 'Objeto Cancelado';
						if(isset($resultados['resultado'][0]['statusAtual'])){
							$log_objeto.= ' / Status: '.$resultados['resultado'][0]['statusAtual'].'';
						}
						Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_pacotes` SET pacote_enviado = '0', valor_cobrado = '0', pacote_cancelado = 1, erro = '".$log_objeto."' WHERE id_plp = '".$v['uniq_id_plp']."' AND cod_rastreio_pacote_dv = '".trim($pac['cod_rastreio_pacote_dv'])."'");
						//log geral
						$log .= 'PLP: '.$v['uniq_id_plp'].' / Objeto: '.trim($pac['cod_rastreio_pacote_dv']).' - '.$log_objeto.'!<br>';
					}else{
						//log 
						$log_objeto = 'Objeto Pendente de Postagem ('.date('d/m/Y H:i').')';
						if(isset($resultados['resultado'][0]['statusAtual'])){
							$log_objeto.= ' / Status: '.$resultados['resultado'][0]['statusAtual'].'';
						}
						Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_pacotes` SET erro = '".$log_objeto."' WHERE id_plp = '".$v['uniq_id_plp']."' AND cod_rastreio_pacote_dv = '".trim($pac['cod_rastreio_pacote_dv'])."'");
						//log geral
						$log .= 'PLP: '.$v['uniq_id_plp'].' / Objeto: '.trim($pac['cod_rastreio_pacote_dv']).' - '.$log_objeto.'!<br>';
					}
				}else{
					//erro
					$erro = array();
					if(isset($resultados['resultado'][0]['msgs'])){
						foreach($resultados['resultado'][0]['msgs'] as $err){
							$erro[] = $err;
						}
					}
					if(isset($resultados['resultado'][0]['causa'])){
						$erro[] = $resultados['resultado'][0]['causa'];
					}
					if(isset($resultados['log'])){
						$erro[] = $resultados['log'];
					}
					//log geral
					$log .= 'PLP: '.$v['uniq_id_plp'].' / Objeto: '.trim($pac['cod_rastreio_pacote_dv']).' - '.implode(',',$erro).'!<br>';
				}
			}
			//atualiza a plp se o numero de objetos corresponde ao numero de processados
			if($objetos_processados >= $total_objetos){
				Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_plps` SET data_atualizacao = NOW(), valor_postagem = '".$total_plp."', local_postagem = '', xml = '".pSQL(json_encode($res))."', status_plp = 'Postado' WHERE uniq_id_plp = '".$v['uniq_id_plp']."'");
			}
		}
		die($log);
	}
}
?>