<?php 
class PrePostagem5Cron_StatusModuleFrontController extends ModuleFrontController
{
	public $ssl = true;
    public $display_column_left = false;
	public $display_column_right = false;
    
	public function initContent()
	{
		//se desativado 
		if(!Configuration::get('PREPOSTAGEM5_STATUS')){
			die('Pré-Postagem - Desativado via Admin!');
		}
		//registros dos pacotes pendentes de processamento
		$query = "SELECT * FROM `" . _DB_PREFIX_ . "prepostagem5_pacotes` 
		LEFT JOIN `" . _DB_PREFIX_ . "prepostagem5_pedidos` ON(id_pacote IN(ids_pacotes))
		WHERE pacote_fechado = '1' AND pacote_enviado = '1' AND pacote_entregue = '0' AND data_pacote BETWEEN NOW() - INTERVAL 30 DAY AND NOW()";
		$pacotes = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);
		if(count($pacotes)==0){
			die('Nenhum objeto de envio a processar!');
		}
		//processa os pacotes
		$log = array();
		foreach($pacotes as $k=>$v){
			//consulta o objeto
			if(strlen($v['cod_rastreio_pacote_dv'])==13){
				$rastreio = $this->module->rastrear_correios($v['cod_rastreio_pacote_dv'],'U');
				if(isset($rastreio['evento'][0])){
					//rastreamento ok
					$log[$k] = ''.$v['id_pacote'].' - Objeto "'.$v['cod_rastreio_pacote_dv'].'" rastreado com sucesso ['.(isset($rastreio['evento'][0]['descricao'])?$rastreio['evento'][0]['descricao']:'').'] (cron)!';
					$status = isset($rastreio['evento'][0]['status'])?$rastreio['evento'][0]['status']:'';
					$tipo = isset($rastreio['evento'][0]['tipo'])?$rastreio['evento'][0]['tipo']:'';
					$descricao = isset($rastreio['evento'][0]['descricao'])?$rastreio['evento'][0]['descricao']:'';
					//atualiza no bd para entregue
					if(in_array($tipo,array('BDE','BDI','BDR')) && in_array($status,array('0','1'))){
						//atualiza o pedido no banco de dados
						Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_pacotes` SET pacote_entregue = '1', erro = 'Objeto entregue ao cliente por os Correios (".date('d/m/Y H:i').")' WHERE cod_rastreio_pacote_dv = '".$v['cod_rastreio_pacote_dv']."'");
						//log
						$log[$k] = 'Objeto: '.$v['cod_rastreio_pacote_dv'].' entregue ao cliente via Correios em '.date('d/m/Y').' (cron)!';
						//salva o resultado 
						$this->module->salvar_log($log[$k]);
						//atualiza o status do pedido 
						if((int)$v['id_pedido_loja'] > 0){
							//pedidos que existe na loja
							$order = new Order((int)$v['id_pedido_pacote']);
							if($order){
								//variaveis a enviar no email 
								$vars_email = array();
								$vars_email['{link_rastreamento}'] = Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/prepostagem5/sro.php?objeto='.$v['cod_rastreio_pacote_dv'].'';
								$vars_email['{objeto_correios}'] = $v['cod_rastreio_pacote_dv'];
								$vars_email['{status_atual_correios}'] = $descricao;
								//atualiza o status do pedido para entregue 
								if(Configuration::get('PREPOSTAGEM5_STATUS_ENTREGUE') > 0){
									if($order->getCurrentState()!=Configuration::get('PREPOSTAGEM5_STATUS_ENTREGUE')){
										$history = new OrderHistory();
										$history->id_order = (int)$order->id;
										$history->id_order_state = (int)Configuration::get('PREPOSTAGEM5_STATUS_ENTREGUE');
										$history->addWithemail(true,$vars_email);
										$order->current_state = $history->id_order_state;
										$order->update();
									}
								}
								//cria um log para o pedido
								$msglog = 'Objeto '.$v['cod_rastreio_pacote_dv'].' entregue ao cliente via Correios em '.date('d/m/Y').'';
								$msg = new Message();
								$message = strip_tags($msglog, '<br>');
								if (($message)){
									$msg->message = $message;
									$msg->id_order = intval($order->id);
									$msg->private = 1;
									$msg->add();
								}
								//atualiza o status no banco de dados
								$status_pedido = $order->getCurrentState();
								$sql = "UPDATE `" . _DB_PREFIX_ . "prepostagem5_pedidos` SET `status_pedido_loja` = '".$status_pedido."' WHERE id_pedido_loja = '".(int)$v['id_pedido_loja']."';";
								Db::getInstance()->execute($sql);
							}
						}
					}
					//aguardando retirada junto aos correios 
					if(in_array($tipo,array('LDI')) && in_array($status,array('0','1','3','14'))){
						//log
						$log[$k] = 'Objeto: '.$v['cod_rastreio_pacote_dv'].' aguarando retirada junto aos Correios em '.date('d/m/Y').' (cron)!';
						//atualiza o pedido no banco de dados
						Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_pacotes` SET erro = 'Objeto aguardando retirada junto aos Correios (".date('d/m/Y H:i').")' WHERE cod_rastreio_pacote_dv = '".$v['cod_rastreio_pacote_dv']."'");
						//salva o resultado 
						$this->module->salvar_log($log[$k]);
						//atualiza o status do pedido 
						if((int)$v['id_pedido_loja'] > 0){
							//pedidos que existe na loja
							$order = new Order((int)$v['id_pedido_pacote']);
							if($order){
								//variaveis a enviar no email 
								$vars_email = array();
								$vars_email['{link_rastreamento}'] = Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/prepostagem5/sro.php?objeto='.$v['cod_rastreio_pacote_dv'].'';
								$vars_email['{objeto_correios}'] = $v['cod_rastreio_pacote_dv'];
								$vars_email['{status_atual_correios}'] = $descricao;
								//atualiza o status do pedido para entregue 
								if(Configuration::get('PREPOSTAGEM5_STATUS_RETIRAR') > 0){
									if($order->getCurrentState()!=Configuration::get('PREPOSTAGEM5_STATUS_RETIRAR')){
										$history = new OrderHistory();
										$history->id_order = (int)$order->id;
										$history->id_order_state = (int)Configuration::get('PREPOSTAGEM5_STATUS_RETIRAR');
										$history->addWithemail(true,$vars_email);
										$order->current_state = $history->id_order_state;
										$order->update();
									}
								}
							}
						}
					}
					//devolvido ao remetente
					if(in_array($tipo,array('BDE','BDI','BDR')) && in_array($status,array('4','5','6','7','8','21','26','36','48','89'))){
						//log
						$log[$k] = 'Objeto: '.$v['cod_rastreio_pacote_dv'].' devolvido ao remetente em '.date('d/m/Y').' (cron)!';
						//atualiza o pedido no banco de dados
						Db::getInstance()->execute("UPDATE `" . _DB_PREFIX_ . "prepostagem5_pacotes` SET erro = 'Objeto devolvido ao remetente via Correios (".date('d/m/Y H:i').")' WHERE cod_rastreio_pacote_dv = '".$v['cod_rastreio_pacote_dv']."'");
						//salva o resultado 
						$this->module->salvar_log($log[$k]);
						//atualiza o status do pedido 
						if((int)$v['id_pedido_loja'] > 0){
							//pedidos que existe na loja
							$order = new Order((int)$v['id_pedido_pacote']);
							if($order){
								//variaveis a enviar no email 
								$vars_email = array();
								$vars_email['{link_rastreamento}'] = Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/prepostagem5/sro.php?objeto='.$v['cod_rastreio_pacote_dv'].'';
								$vars_email['{objeto_correios}'] = $v['cod_rastreio_pacote_dv'];
								$vars_email['{status_atual_correios}'] = $descricao;
								//atualiza o status do pedido para entregue 
								if(Configuration::get('PREPOSTAGEM5_STATUS_DEVOLVIDO') > 0){
									if($order->getCurrentState()!=Configuration::get('PREPOSTAGEM5_STATUS_DEVOLVIDO')){
										$history = new OrderHistory();
										$history->id_order = (int)$order->id;
										$history->id_order_state = (int)Configuration::get('PREPOSTAGEM5_STATUS_DEVOLVIDO');
										$history->addWithemail(true,$vars_email);
										$order->current_state = $history->id_order_state;
										$order->update();
									}
								}
							}
						}
					}
				}else{
					//erro de rastreamento
					if(isset($rastreio['categoria'])){
						$log[$k] = ''.$v['id_pacote'].' - Objeto "'.$v['cod_rastreio_pacote_dv'].'" est&aacute; com erro de rastreamento: '.$rastreio['categoria'].' (cron)!';
					}elseif(isset($rastreio['log']) && !empty($rastreio['log'])){
						$log[$k] = ''.$v['id_pacote'].' - Objeto "'.$v['cod_rastreio_pacote_dv'].'" est&aacute; com erro de rastreamento: '.$rastreio['log'].' (cron)!';
					}else{
						$log[$k] = ''.$v['id_pacote'].' - Objeto "'.$v['cod_rastreio_pacote_dv'].'" n&atilde;o pode ser rastreado, provavelmente o servi&ccedil;o esta fora do ar (cron)!';
					}
				}
			}
		}
		//exibe
		foreach($log as $k=>$v){
			echo $v.'<br>';
		}
		exit;
	}
}
?>