<?php 
if(!function_exists('rastrear_correios_loja5_sigep')){
	//rastrear_correios_loja5_sigep
	function gerar_token_de_acesso_correios_sigep(){
		//dados e ambiente
		$login = trim(Configuration::get('SIGEPPRO5_USUARIO_ID'));
		$senha = trim(Configuration::get('SIGEPPRO5_SENHA_ID'));
		$cartao = trim(Configuration::get('SIGEPPRO5_CARTAO'));
		//header
		$headers = array(
			"Accept: application/json",
			"Content-Type: application/json",
			"Authorization: Basic ".base64_encode(trim($login).':'.trim($senha))."",
		);
		//gera o token
		$dados = array();
		//endpoint
		if(!empty($cartao)){
			$dados['numero'] = $cartao;
			$urlweb = "https://api.correios.com.br/token/v1/autentica/cartaopostagem";
		}else{
			$urlweb = "https://api.correios.com.br/token/v1/autentica";
		}
		//curl
		$sessao_curl = curl_init($urlweb);
		curl_setopt($sessao_curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($sessao_curl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($sessao_curl, CURLOPT_POST, true);
		curl_setopt($sessao_curl, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($sessao_curl, CURLOPT_POSTFIELDS, json_encode($dados) );
		curl_setopt($sessao_curl, CURLOPT_CONNECTTIMEOUT, 10);
		curl_setopt($sessao_curl, CURLOPT_TIMEOUT, 40);
		curl_setopt($sessao_curl, CURLOPT_RETURNTRANSFER, true);
		$resultado = curl_exec($sessao_curl);
		$status    = curl_getinfo($sessao_curl, CURLINFO_HTTP_CODE);
		curl_close($sessao_curl);
		$token = json_decode($resultado,true);
		return array('status'=>$status,'dados'=>$token,'url'=>$urlweb,'original'=>$dados,'raw'=>$resultado);
	}
	function rastrear_correios_loja5_sigep_prestashop($objetos='',$resultado='T') {
		$token = gerar_token_de_acesso_correios_sigep();
		if(isset($token['dados']['token'])){
			//header
			$headers = array(
				"Authorization: Bearer ".trim($token['dados']['token'])."",
				"Content-Type: application/json",
			);
				
			$url = 'https://api.correios.com.br/srorastro/v1/objetos/'.$objetos.'?resultado='.$resultado;
			$ch = curl_init(); 
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_URL, $url); 
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
			curl_setopt($ch, CURLOPT_TIMEOUT, 20); 
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($ch, CURLOPT_POST, false); 
			$curlErrno  = curl_errno($ch);
			$curlErr    = curl_error($ch);
			$xml = curl_exec($ch); 
			$info = curl_getinfo($ch);
			curl_close($ch);
			$res = @json_decode($xml,true);
			//print_r($res);
			if(isset($res['objetos'][0]['eventos'][0])){
				$e = array();
				foreach($res['objetos'][0]['eventos'] as $k=>$eve){
					$e['evento'][$k] = array(
						'data' => date('d/m/Y',strtotime($eve['dtHrCriado'])),
						'hora' => date('H:i:s',strtotime($eve['dtHrCriado'])),
						'descricao' => $eve['descricao'],
						'tipo' => $eve['codigo'],
						'status' => (int)$eve['tipo'],
						'unidade' => array(
							'local' => (isset($eve['unidade']['tipo'])?$eve['unidade']['tipo']:''),
							'cidade' => (isset($eve['unidade']['endereco']['cidade'])?$eve['unidade']['endereco']['cidade']:''),
							'uf' => (isset($eve['unidade']['endereco']['uf'])?$eve['unidade']['endereco']['uf']:''),
						),
						'destino' => (isset($eve['unidadeDestino']['tipo'])?array(array('local'=>$eve['unidadeDestino']['tipo'],'cidade'=>$eve['unidadeDestino']['endereco']['cidade'],'uf'=>$eve['unidadeDestino']['endereco']['uf'])):array()),
					);
				}
				return $e;
			}else{
				return array('erro'=>'Objeto não encontrado ou postado recentemente!','log'=>$res);
			}
		}else{
			return array('erro'=>'Problema ao obter token auth correios!','log'=>$token);
		}
	}
}
?>