<?php

namespace PhpSigep\Model;

/**
 * @author : Stavarengo
 * @modify Jonathan Célio da Silva <jonathan.clio@hotmail.com>
 */
class ServicoDePostagem extends AbstractModel
{
    const SERVICE_PAC_41068 = '41068';
    const SERVICE_PAC_04510 = '04510';
    //const SERVICE_PAC_CONTRATO_10065 = '10065';
    const SERVICE_PAC_GRANDES_FORMATOS = '41300';
    const SERVICE_PAC_CONTRATO_GRANDES_FORMATOS = '04693';
    const SERVICE_PAC_CONTRATO_UO = '04812';

    const SERVICE_SEDEX_41556 = '41556';
    const SERVICE_SEDEX_12 = '40169';
    const SERVICE_SEDEX_10 = '40215';
    const SERVICE_SEDEX_10_PACOTE = '40886';
    const SERVICE_SEDEX_HOJE_40290 = '40290';
    const SERVICE_SEDEX_HOJE_40878 = '40878';
    const SERVICE_SEDEX_A_VISTA = '04014';
    const SERVICE_SEDEX_VAREJO_A_COBRAR = '40045';
    const SERVICE_SEDEX_AGRUPADO = '41009';
    const SERVICE_SEDEX_REVERSO = '40380';
    const SERVICE_SEDEX_PAGAMENTO_NA_ENTREGA = '04189';
    const SERVICE_SEDEX_CONTRATO_UO = '04316';
    const SERVICE_PAC_PAGAMENTO_NA_ENTREGA = '04685';
    const SERVICE_CARTA_COMERCIAL_A_FATURAR = '10065';
    const SERVICE_CARTA_REGISTRADA = '10014';
    const SERVICE_SEDEX_CONTRATO_AGENCIA = '04162';
    const SERVICE_PAC_CONTRATO_AGENCIA = '04669';
    const SERVICE_SEDEX_REVERSO_CONTRATO_AGENCIA = '04170';
    const SERVICE_PAC_REVERSO_CONTRATO_AGENCIA = '04677';
    const SERVICE_CARTA_COM_A_FATURAR_SELO_E_SE = '12556';
    const SERVICE_CARTA_COMERCIAL_REGISTRADA_CTR_EP_MAQ_FRAN = '10707';

    // CODIGOS REFERENTES A LIMINAR ABCOMM
    const SERVICE_SEDEX_CONTRATO_GRANDES_FORMATOS_LM = '04146';
    const SERVICE_SEDEX_CONTRATO_AGENCIA_LM = '04154';
    const SERVICE_SEDEX_REVERSO_LM = '04243';
    const SERVICE_SEDEX_CONTRATO_UO_LM = '04278';

    const SERVICE_PAC_CONTRATO_GRANDES_FORMATOS_LM = '04883';
    const SERVICE_PAC_CONTRATO_AGENCIA_LM = '04367';
    const SERVICE_PAC_REVERSO_LM = '04375';
    const SERVICE_PAC_CONTRATO_UO_LM = '04332';

    const SERVICE_SEDEX_CONTRATO_AGENCIA_PAGAMENTO_NA_ENTREGA_LM = '04151';
    const SERVICE_PAC_CONTRATO_AGENCIA_PAGAMENTO_NA_ENTREGA_LM = '04308';

    const SERVICE_SEDEX_CONTRATO_AGENCIA_TA = '04553';
    const SERVICE_PAC_CONTRATO_AGENCIA_TA = '04596';

	//const SERVICE_CARTA_REGISTRADA           = '10138';

	//novos serviços correios 2020
    const SERVICE_03298 = '03298';
    const SERVICE_03220 = '03220';
    const SERVICE_03085 = '03085';
    const SERVICE_03050 = '03050';
	const SERVICE_03140 = '03140';
    const SERVICE_03158 = '03158';
    const SERVICE_03204 = '03204';
	const SERVICE_03212 = '03212';
	const SERVICE_03328 = '03328';
	
	//mini envios
	const SERVICE_04227 = '04227';
	const SERVICE_04235 = '04235';
	const SERVICE_04391 = '04391';
	
	//cartas
	const SERVICE_80292 = '80292';
	const SERVICE_80276 = '80276';
	const SERVICE_80284 = '80284';
	const SERVICE_80250 = '80250';
	const SERVICE_80160 = '80160';
	const SERVICE_80152 = '80152';
	
	const SERVICE_80357 = '80357';
	const SERVICE_80365 = '80365';
	const SERVICE_80373 = '80373';
	const SERVICE_80381 = '80381';
	const SERVICE_80390 = '80390';
	const SERVICE_80403 = '80403';
	
	const SERVICE_80411 = '80411';
	const SERVICE_80420 = '80420';
	const SERVICE_80446 = '80446';
	const SERVICE_80454 = '80454';
	const SERVICE_80470 = '80470';
	const SERVICE_80489 = '80489';
	
	const SERVICE_80497 = '80497';
	const SERVICE_80500 = '80500';
	const SERVICE_80519 = '80519';
	const SERVICE_80527 = '80527';
	const SERVICE_80543 = '80543';
	const SERVICE_80560 = '80560';
	
	const SERVICE_80586 = '80586';
	const SERVICE_80640 = '80640';
	const SERVICE_80659 = '80659';
	const SERVICE_80675 = '80675';
	const SERVICE_80691 = '80691';
	const SERVICE_80705 = '80705';

    protected static $services
        = array(
            self::SERVICE_PAC_41068                                  => array('Pac 41068', 109819),
            self::SERVICE_PAC_04510                                  => array('Pac 04510', 124887),
            //self::SERVICE_PAC_CONTRATO_10065                         => array('Pac 10065', 109480),
            self::SERVICE_PAC_GRANDES_FORMATOS                       => array('Pac Grandes Formatos', 120366),
            self::SERVICE_PAC_CONTRATO_GRANDES_FORMATOS              => array('Pac Contrato Grandes Formatos', 125248),
            self::SERVICE_PAC_CONTRATO_UO                            => array('Pac Contrato - UO', 124899),
            self::SERVICE_SEDEX_41556                                => array('Sedex 41556', 121877),
            self::SERVICE_SEDEX_12                                   => array('Sedex 12', 115218),
            self::SERVICE_SEDEX_10                                   => array('Sedex 10', 104707),
            self::SERVICE_SEDEX_10_PACOTE                            => array('Sedex 10 Pacote', null),
            self::SERVICE_SEDEX_HOJE_40290                           => array('Sedex Hoje 40290', 108934),
            self::SERVICE_SEDEX_HOJE_40878                           => array('Sedex Hoje 40878', null),
            self::SERVICE_SEDEX_A_VISTA                              => array('Sedex a vista', 104295),
            self::SERVICE_SEDEX_VAREJO_A_COBRAR                      => array('Sedex Varejo a Cobrar', null),
            self::SERVICE_SEDEX_AGRUPADO                             => array('Sedex Agrupado', 119461),
            self::SERVICE_SEDEX_REVERSO                              => array('Sedex Reverso', 109806),
            self::SERVICE_SEDEX_PAGAMENTO_NA_ENTREGA                 => array('Sedex Pagamento na Entrega', 114976),
            self::SERVICE_SEDEX_CONTRATO_UO                          => array('Sedex Contrato - UO', 124900),
            self::SERVICE_PAC_PAGAMENTO_NA_ENTREGA                   => array('PAC Pagamento na Entrega', 114976),
            self::SERVICE_CARTA_COMERCIAL_A_FATURAR                  => array('Carta Comercial a Faturar', 109480),
            self::SERVICE_CARTA_REGISTRADA                           => array('Carta Registrada', 116985),
            self::SERVICE_CARTA_COM_A_FATURAR_SELO_E_SE              => array(
                'Carta Comerical Registrada a Faturar',
                160104
            ),
            self::SERVICE_CARTA_COMERCIAL_REGISTRADA_CTR_EP_MAQ_FRAN => array(
                'Carta Comercial Registrada CTR EP MÁQ FRAN',
                120072
            ),
            self::SERVICE_SEDEX_CONTRATO_AGENCIA                     => array('SEDEX Contrato Agência', 124849),
            self::SERVICE_PAC_CONTRATO_AGENCIA                       => array('PAC Contrato Agência', 124884),
            self::SERVICE_SEDEX_REVERSO_CONTRATO_AGENCIA             => array('SEDEX Reverso Contrato Agência', 124849),
            self::SERVICE_PAC_REVERSO_CONTRATO_AGENCIA               => array('PAC Reverso Contrato Agência', 124884),
            self::SERVICE_SEDEX_CONTRATO_GRANDES_FORMATOS_LM         => array(
                'SEDEX Contrato Grandes Formatos (Liminar ABCOMM)',
                null
            ),
            self::SERVICE_SEDEX_CONTRATO_AGENCIA_LM                  => array(
                'SEDEX Contrato Agência (Liminar ABCOMM)',
                160126
            ),
            self::SERVICE_SEDEX_REVERSO_LM                           => array('SEDEX Reverso (Liminar ABCOMM)', null),
            self::SERVICE_SEDEX_CONTRATO_UO_LM                       => array(
                'SEDEX Contrato UO (Liminar ABCOMM)',
                null
            ),

            self::SERVICE_PAC_CONTRATO_GRANDES_FORMATOS_LM => array(
                'PAC Contrato Grandes Formatos (Liminar ABCOMM)',
                null
            ),
            self::SERVICE_PAC_CONTRATO_AGENCIA_LM          => array('PAC Contrato Agência (Liminar ABCOMM)', 160123),
            self::SERVICE_PAC_REVERSO_LM                   => array('PAC Reverso (Liminar ABCOMM)', null),
            self::SERVICE_PAC_CONTRATO_UO_LM               => array('PAC Contrato UO (Liminar ABCOMM)', null),

            self::SERVICE_SEDEX_CONTRATO_AGENCIA_PAGAMENTO_NA_ENTREGA_LM => array(
                'SEDEX Contrato Agencia Pagamento na Entrega (Liminar ABCOMM)',
                null
            ),
            self::SERVICE_PAC_CONTRATO_AGENCIA_PAGAMENTO_NA_ENTREGA_LM   => array(
                'PAC Contrato Agencia Pagamento na Entrega (Liminar ABCOMM)',
                null
            ),

            self::SERVICE_SEDEX_CONTRATO_AGENCIA_TA => array('SEDEX Contrato Agencia TA', 161274),
            self::SERVICE_PAC_CONTRATO_AGENCIA_TA   => array('PAC Contrato Agencia TA', 161277),
			
			//novos serviços correios 2020
            self::SERVICE_03298 => array('Pac 03298', 162026),
            self::SERVICE_03220 => array('Sedex 03220', 162022),
            self::SERVICE_03085 => array('Pac 03085', 162011),
            self::SERVICE_03050 => array('Sedex 03050', 162008),
			self::SERVICE_03140 => array('Sedex 12 03140', 162015),
            self::SERVICE_03158 => array('Sedex 10 03158', 162016),
            self::SERVICE_03204 => array('Sedex Hoje 03204', 162020),
			self::SERVICE_04227 => array('Pac Mini Contrato 04227', 159982),
            self::SERVICE_03212 => array('Sedex Grandes FO 03158', 162021),
            self::SERVICE_03328 => array('Pac Grandes FO 03328', 162029),
			
			//cartas
            self::SERVICE_80292 => array('Carta 80292', 162145),
			self::SERVICE_80276 => array('Carta 80276', 162143),
			self::SERVICE_80284 => array('Carta 80284', 162026),
			self::SERVICE_80250 => array('Carta 80250', 162144),
			self::SERVICE_80160 => array('Carta 80160', 162135),
			self::SERVICE_80152 => array('Carta 80152', 162134),
			
			self::SERVICE_80357 => array('Carta 80357', 162146),
			self::SERVICE_80365 => array('Carta 80365', 162147),
			self::SERVICE_80373 => array('Carta 80373', 162148),
			self::SERVICE_80381 => array('Carta 80381', 162149),
			self::SERVICE_80390 => array('Carta 80390', 162150),
			self::SERVICE_80403 => array('Carta 80403', 162151),
			
			self::SERVICE_80411 => array('Carta 80411', 162152),
			self::SERVICE_80420 => array('Carta 80420', 162153),
			self::SERVICE_80446 => array('Carta 80446', 162154),
			self::SERVICE_80454 => array('Carta 80454', 162155),
			self::SERVICE_80470 => array('Carta 80470', 162156),
			self::SERVICE_80489 => array('Carta 80489', 162157),
			
			self::SERVICE_80497 => array('Carta 80497', 162158),
			self::SERVICE_80500 => array('Carta 80500', 162159),
			self::SERVICE_80519 => array('Carta 80519', 162160),
			self::SERVICE_80527 => array('Carta 80527', 162161),
			self::SERVICE_80543 => array('Carta 80543', 162162),
			self::SERVICE_80560 => array('Carta 80560', 162163),
			
			self::SERVICE_80586 => array('Carta 80586', 162164),
			self::SERVICE_80640 => array('Carta 80640', 162165),
			self::SERVICE_80659 => array('Carta 80659', 162166),
			self::SERVICE_80675 => array('Carta 80675', 162167),
			self::SERVICE_80691 => array('Carta 80691', 162168),
			self::SERVICE_80705 => array('Carta 80705', 162169),
        );

    /**
     * @var string
     */
    protected $codigo;
    /**
     * @var int
     */
    protected $idServico;
    /**
     * @var string
     */
    protected $nome;

    /**
     * @param int $serviceCode
     *        One of the constants {@link ServicoDePostagem}::SERVICE_*
     *
     * @throws Exception
     */
    public function __construct($serviceCode)
    {
        $normalizedServiceCode = sprintf("%'05s", $serviceCode);

        if (!isset(self::$services[$normalizedServiceCode])) {
            throw new Exception('There is no service with the code "' . $serviceCode . '".');
        }

        $service = self::$services[$normalizedServiceCode];
        parent::__construct(
            array(
                'codigo'    => $normalizedServiceCode,
                'nome'      => $service[0],
                'idServico' => $service[1],
            )
        );
    }

    /**
     * @return ServicoDePostagem[]
     */
    public static function getAll()
    {
        $r = array();
        foreach (self::$services as $serviceCode => $serviceDetails) {
            $r[] = new self($serviceCode);
        }

        return $r;
    }

    /**
     * @param int $serviceCode
     *        One of the constants {@link ServicoDePostagem}::SERVICE_*
     *
     * @return bool
     */
    public function is($serviceCode)
    {
        return $this->getCodigo() == $serviceCode;
    }

    /**
     * @return string
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * @param int $codigo
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;
    }

    /**
     * @return int
     */
    public function getIdServico()
    {
        return $this->idServico;
    }

    /**
     * @param int $idServico
     */
    public function setIdServico($idServico)
    {
        $this->idServico = $idServico;
    }

    /**
     * @return string
     */
    public function getNome()
    {
        return $this->nome;
    }

    /**
     * @param string $nome
     */
    public function setNome($nome)
    {
        $this->nome = $nome;
    }

}
