//fix modal
jQuery(document).bind('PgwModal::Close', function() {
    jQuery('#pgwModalBackdrop').remove();
	jQuery('#pgwModal').remove();
});
//mascaras javascript pura
function mascara(o,f){
    v_obj=o
    v_fun=f
    setTimeout("execmascara()",1)
}
function execmascara(){
	if(v_fun=='telefone')
   	 v_obj.value=telefone(v_obj.value);
  	if(v_fun=='cep')
   	 v_obj.value=cep(v_obj.value);
}
function telefone(v){
    v=v.replace(/\D/g,"")
    v=v.replace(/^(\d\d)(\d)/g,"($1)$2")
    return v
}
function cep(v){
	v=v.replace(/[^1234567890-]/g,"");
    v=v.replace(/^(\d{5})(\d)/,"$1-$2")
    return v
}
//funcoes
function sigep_editar_envio(envio){
	$.pgwModal({
		url: url_envios+'&acao=editar_envios&ajax=true&id='+envio,
		loadingContent: '<center><span style="text-align:center">Aguarde o processamento...</span></center>',
		closable: true,
		title: 'Editar Dados do Envio #'+envio,
		closeOnBackgroundClick : false,
		maxWidth: 800
	});	
	$.pgwModal('reposition');
}

function getEndereco() {
	var cep = jQuery("#cep").val();
	var s = (cep).replace(/\D/g,'');
	var tam=(s).length;
	if(tam==8){
		jQuery.getScript(url_modulo+"/api_cep.php?formato=javascript&cep="+cep, function(){
			if(resultadoCEP["resultado"] != 0){
				console.log(resultadoCEP);
				jQuery("#log").val(unescape(resultadoCEP["tipo_logradouro"]).toUpperCase()+""+unescape(resultadoCEP["logradouro"]).toUpperCase());
				jQuery("#bairro").val(unescape(resultadoCEP["bairro"]).toUpperCase());
				jQuery("#cidade").val(unescape(resultadoCEP["cidade"]).toUpperCase());
				jQuery("#uf").val(resultadoCEP["uf"]);
			}
		});
	}
}

function sigep_bloquear_tela(){
	//bloqueia a tela
	jQuery.blockUI({ 
		message: '<br><center><b>Aguarde o processamento...</b></center><br>', 
		css: { border: '2px solid #CCC', 'border-radius': '5px' } 
	});
}

function atualizar_dados_pacote_sigep(){
	//valida o envio avulso
    jQuery("#dados_pacote").validate({
		onclick: false,
		onkeyup: false,
		onfocusout: false,
		showErrors: function(errorMap, errorList) {
			jQuery("#lista-erros").remove();
			if(jQuery.isEmptyObject(errorList)==false && errorList.length > 0){
				console.log(errorList);
				jQuery.each(errorList, function( index, value ){
					jQuery("#dados_erro").html( "<div id='lista-erros' class='alert alert-danger'><p>"+value.message+"</p></div>" );
					jQuery(value.element).focus();
					return false;
				});
			}
		},
    });
	if(jQuery("#dados_pacote").valid()){
		var dados = jQuery('#dados_pacote').serialize();
		jQuery.ajax({
			type: "POST",
			url: url_envios+'&acao=salvar_editar_pacote&ajax=true',
			data: dados
		}).done(function( dados ) {
			console.log(dados);
			if(dados=='true'){
				jQuery.pgwModal('close');
				sigep_bloquear_tela();
				setTimeout(function(){ window.location.reload(); }, 2000);
			}else{
				jQuery("#dados_erro").html( "<div id='lista-erros' class='alert alert-danger'><p>"+dados+"</p></div>" );
			}
		});
	}
}

function sigep_remover_envio(id){
	if(confirm('Confirma remover o envio selecionado?')){
		sigep_bloquear_tela();
		jQuery.ajax({
			method: "POST",
			url: url_envios+'&acao=remover_envio&ajax=true',
			data: {id: id}
		}).done(function(dados) {
			setTimeout(function(){ window.location.reload(); }, 2000);
		});
	}
	return false;
}

function sigep_add_pacote(){
	jQuery.pgwModal({
		url: url_envios+'&acao=adicionar_envios&ajax=true',
		loadingContent: '<center><span style="text-align:center">Aguarde o processamento...</span></center>',
		closable: true,
		title: 'Adicionar Envio Avulso',
		closeOnBackgroundClick : false,
		maxWidth: 800
	});	
	jQuery.pgwModal('reposition');
}

function simular_frete_rapido(metodo){
	jQuery('#botao-salvar-envio').removeAttr('disabled');
	jQuery("#lista-erros").remove();
	var cep = jQuery("#cep").val();
	var s = (cep).replace(/\D/g,'');
	var tam=(s).length;
	if(tam==8 && metodo.length==5){
		jQuery('#resultado_frete_rapido').html('Calculando...');
		var dados = jQuery('#dados_pacote').serialize();
		jQuery.ajax({
			type: "POST",
			url: url_envios+'&acao=frete_rapido&ajax=true',
			data: dados,
		}).done(function( dados ) {
			jQuery("#resultado_frete_rapido").html( "<div class='alert alert-info'>"+dados+"</div>" );
			console.log(dados);
		});
	}
}

function salvar_dados_pacote_sigep(){
	//valida o envio avulso
    jQuery("#dados_pacote").validate({
		onclick: false,
		onkeyup: false,
		onfocusout: false,
		showErrors: function(errorMap, errorList) {
			jQuery("#lista-erros").remove();
			if(jQuery.isEmptyObject(errorList)==false && errorList.length > 0){
				console.log(errorList);
				jQuery.each(errorList, function( index, value ){
					jQuery("#dados_erro").html( "<div id='lista-erros' class='alert alert-danger'><p>"+value.message+"</p></div>" );
					jQuery(value.element).focus();
					return false;
				});
			}
		},
    });
	if(jQuery("#dados_pacote").valid()){
		var dados = jQuery('#dados_pacote').serialize();
		jQuery.ajax({
			type: "POST",
			url: url_envios+'&acao=salvar_dados_pacote&ajax=true',
			data: dados
		}).done(function( dados ) {
			console.log(dados);
			if(dados=='true'){
				jQuery.pgwModal('close');
				sigep_bloquear_tela();
				setTimeout(function(){ window.location.reload(); }, 2000);
			}else{
				jQuery("#dados_erro").html( "<div id='lista-erros' class='alert alert-danger'><p>"+dados+"</p></div>" );
			}
		});
	}
}

function sigep_criar_objetos(){
	var selected = [];
	jQuery('input[name="envios_ids"]:checked').each(function() {
		var fechado = jQuery(this).data("fechado");
		var alocado = jQuery(this).data("alocado");
		var pedido = jQuery(this).data("pedido");
		if(fechado==0 && alocado==0){
			selected.push({id: jQuery(this).val(), pedido: pedido});	
		}
	});
	console.log(selected);
	if(selected.length==0){
		alert('Nenhum envio selecionado ou não é possivel alocar etiquetas para os quais selecionou, verifique se os mesmos já não estão alocados!');
		return false;
	}else{
		if(confirm('Confirma alocar o(s) pedido(s) selecionado(s)?')){
			sigep_bloquear_tela();
			jQuery.ajax({
				method: "POST",
				dataType: "JSON",
				url: url_envios+'&acao=criar_objetos&ajax=true',
				data: {ids: selected}
			}).done(function(dados) {
				console.log(dados);
				jQuery.each( dados, function( key, value ) {
					if(value.erro==true){
						toastr.error(value.log);
					}else{
						toastr.success(value.log);
					}
				});
				setTimeout(function(){ window.location.reload(); }, 2000);
			});
			return true;
		}else{
			return false;
		}
	}
}

function sigep_fechar_plps(){
	var selected = [];
	jQuery('input[name="envios_ids"]:checked').each(function() {
		var fechado = jQuery(this).data("fechado");
		var alocado = jQuery(this).data("alocado");
		if(fechado==0 && alocado==1){
			selected.push(jQuery(this).val());	
		}
	});
	console.log(selected);
	if(selected.length==0){
		alert('Nenhum envio selecionado ou os envios selecionados não é possivel fechar a PLP, verifique se os mesmos já encontram-se com os códigos de rastreamento devidamente alocado(s) para os envios qual selecionou!');
		return false;
	}else{
		if(confirm('Confirma fechar a PLP o(s) envio(s) selecionado(s)?')){
			sigep_bloquear_tela();
			var ids = selected.join(',');
			jQuery.ajax({
				method: "GET",
				dataType: "JSON",
				url: url_envios+'&acao=fechar_plps&ajax=true&envios='+ids,
			}).done(function(dados) {
				console.log(dados);
				if(dados.erro==true){
					toastr.error(dados.log);
					jQuery.unblockUI();
				}else{
					toastr.success(dados.log);
					setTimeout(function(){ window.location.reload(); }, 2000);
				}
			});
		}
	}
}

function sigep_bloquear_objetos(id,plp){
	var selected = [];
	selected.push({id: id, plp: plp});	
	console.log(selected);
	if(selected.length==0){
		alert('Ops, selecione no minimo um objeto para bloquear o envio do mesmo, lembre-se que ao realizar o bloqueio de um objeto o mesmo não poderá ser desbloqueado onde o envio/entrega será suspensa junto aos Correios!');
		return false;
	}else{
		if(confirm('Confirma bloquear o objeto para o envio #'+id+' e PLP '+plp+' selecionado? Lembre-se que ao confirmar e o mesmo ser bloqueado esta ação não poderá ser desfeita onde o envio/entrega será suspensa junto aos Correios retornando o objeto ao remetente e fique atento para verificar se esta bloqueado o objeto correto!')){
			sigep_bloquear_tela();
			jQuery.ajax({
				method: "POST",
				dataType: "JSON",
				data: {envios: selected},
				url: url_envios+'&acao=bloquear_objetos&ajax=true',
			}).done(function(dados) {
				console.log(dados);
				jQuery.each( dados, function( key, value ) {
					if(value.erro==true){
						toastr.error(value.log);
					}else{
						toastr.success(value.log);
					}
				});
				setTimeout(function(){ window.location.reload(); }, 2000);
			});
		}
	}
}

function sigep_cancelar_plp(plp,objeto,envio){
	if(objeto==''){
		var frase = 'Confirma cancelar todos os objetos da PLP '+plp+' selecionada?';
	}else{
		var frase = 'Confirma cancelar o objeto '+objeto+' da PLP '+plp+' selecionada?';
	}
	if(confirm(frase)){
		sigep_bloquear_tela();
		jQuery.ajax({
			method: "POST",
			dataType: "JSON",
			url: url_plps+'&acao=cancelar_objeto_plp&ajax=true',
			data: {plp:plp,objeto:objeto,envio:envio}
		}).done(function(dados) {
			console.log(dados);
			if(dados.erro){
				jQuery.unblockUI();
				toastr.error(dados.log);
			}else{
				toastr.success(dados.log);
				jQuery('#objeto-'+dados.objeto+'').remove();
				if(dados.atualizar){
					setTimeout(function(){ window.location.reload(); }, 2000);
				}else{
					jQuery.unblockUI();
				}
			}
		});
	}
}

function ver_xml_plp(id){
	jQuery.pgwModal({
		url: url_plps+'&acao=ver_xml_plp&ajax=true&plp='+id,
		loadingContent: '<center><span style="text-align:center">Aguarde o processamento, caso demore mais de 60 segundos atualize a pagina e teste novamente...</span></center>',
		closable: true,
		title: 'XML da PLP #'+id,
		maxWidth: 700
	});	
	jQuery.pgwModal('reposition');
}

function sigep_status_conta(){
	jQuery.pgwModal({
		url: url_plps+'&acao=status_sigep&ajax=true',
		loadingContent: '<center><span style="text-align:center">Aguarde o processamento, caso demore mais de 60 segundos atualize a pagina e teste novamente...</span></center>',
		closable: true,
		title: 'Teste do Webservice Sigep',
		maxWidth: 600
	});
	jQuery.pgwModal('reposition');
}

function detalhes_pedido(id){
	location.href = url_plps+'&acao=detalhes_pedido&id='+id;
}