<?php
/**
* Override of CartRuleCore by Kijam.com
*
* @author    Kijam
* @copyright 2016 Kijam
* @license   Commercial use allowed (Non-assignable & non-transferable), can modify source-code but cannot distribute
*            modifications (derivative works).
*/
class CartRule extends CartRuleCore
{
    /**
    * Check if this CartRule can be applied
    *
    * @param Context $context Context instance
    * @param bool $alreadyInCart Check if the voucher is already on the cart
    * @param bool $display_error Display error
    *
    * @return bool|mixed|string
    */
    /*
    * module: cartrulefirstorder
    * date: 2022-09-21 14:16:35
    * version: 1.0.2
    */
    public function checkValidity(
        Context $context,
        $alreadyInCart = false,
        $display_error = true,
        $check_carrier = true,
        $useOrderPrices = true
    ) {
        if (version_compare(_PS_VERSION_, '1.6.0.11') < 0) {
            $result = CartRuleCore::checkValidity($context, $alreadyInCart, $display_error);
        } elseif (version_compare(_PS_VERSION_, '1.7.7.5') < 0) {
            $result = CartRuleCore::checkValidity($context, $alreadyInCart, $display_error, $check_carrier);
        } else {
            $result = CartRuleCore::checkValidity($context, $alreadyInCart, $display_error, $check_carrier, $useOrderPrices);
        }
        $instance = Module::getInstanceByName('cartrulefirstorder');
        if (!$instance || !$instance->active) {
            return $result;
        }
        return $instance->overrideCheckValidity(
            $context,
            $alreadyInCart,
            $display_error,
            $check_carrier,
            $this->id,
            $result
        );
    }
    /*
    * module: cartrulefirstorder
    * date: 2022-09-21 14:16:35
    * version: 1.0.2
    */
    public function add($autodate = true, $null_values = false)
    {
        $result = CartRuleCore::add($autodate, $null_values);
        if ($result) {
            $instance = Module::getInstanceByName('cartrulefirstorder');
            if ($instance && $instance->active) {
                $instance->checkUpdate($this->id);
            }
        }
        return $result;
    }
    /*
    * module: cartrulefirstorder
    * date: 2022-09-21 14:16:35
    * version: 1.0.2
    */
    public function update($null_values = false)
    {
        $result = CartRuleCore::update($null_values);
        if ($result) {
            $instance = Module::getInstanceByName('cartrulefirstorder');
            if ($instance && $instance->active) {
                $instance->checkUpdate($this->id);
            }
        }
        return $result;
    }
}
